



//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                   BAT.WDL Version 1.1
//      
//    Author: Volkmar Webeck                    
//    written: 18.09.2000
//       
//    -INCLUDE the Bat.wdl into your WDL script.
//
//    -Place the Bat model under the ceiling of a bigger room. The frame in WED is not the frame, seen in the game,
//     so you must try a little for for a proper placement.
//
//    -Add the bat ACTION to the bat model.
//     If the Model flys against a wall and stucks there, you must rotate the Model a little in WED.
//
//    This code is programmed modular. It uses only Model-Skills, beginning with bat_. There are no routines of 
//    other WDL templates used, so they can`t disturb each other, when modifications are done. 
//    
//
//    The TRIGGER_RANGE of the player has to be set on a value greater than zero.
//    When the Player or another Entity with set TRIGGER_RANGE (for example another bat) passes the bat, 
//    it will be alarmed and starts to fly.
//
//    After a certain flight time, defined in the BAT_FLIGHT_TIME Skill, the bat
//    returns to its starting place.
//    There it waits until the BAT_ALARM_TIME is over. Then it can be wakened again.
//
//    The bat model was createt with MED. Animation was done with Milkshape 3D. The 8 bit skin was painted with
//    ProMotion 4.2  
//    
//    Feel free to use the Model and WDL Code for non commercial purposes.
//    For commercial use, pleas ask me.
//
//    I know, this code is not perfect. Please mail your problems and suggestions to:
//    volkmar.webeck@t-online.de
//    
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


SOUND bat_squeak1,<b_sque_1.wav>;
SOUND bat_squeak2,<b_sque_2.wav>;
SOUND bat_wing1,<b_wing_1.wav>;




DEFINE BAT_SPEED,SKILL1;  
DEFINE BAT_SPEED.X,SKILL1;
DEFINE BAT_SPEED.Y,SKILL2;
DEFINE BAT_SPEED.Z,SKILL3;




DEFINE BAT_SHOOTRANGE,SKILL7;



DEFINE BAT_MODE,SKILL9;

DEFINE BAT_SQUEAK_TIMER,SKILL10;
DEFINE BAT_FLIGHT_TIMER,SKILL11;

DEFINE BAT_STARTPOS.X,SKILL12;
DEFINE BAT_STARTPOS.Y,SKILL13;
DEFINE BAT_STARTPOS.Z,SKILL14;

DEFINE BAT_ALARM_TIMER,SKILL15;
DEFINE BAT_ROLL_SPEED,SKILL16;
DEFINE BAT_TILT_SPEED,SKILL17;

DEFINE BAT_START_SPEED,SKILL18;
DEFINE BAT_ANIMATE_SPEED,SKILL19;
DEFINE BAT_ALARM_TIME,SKILL20;
DEFINE BAT_FLIGHT_TIME,SKILL21;

DEFINE BAT_TEMP,SKILL22;
DEFINE BAT_TEMP.X,SKILL22;
DEFINE BAT_TEMP.Y,SKILL23;
DEFINE BAT_TEMP.Z,SKILL24;
DEFINE BAT_TEMP.PAN,SKILL22;
DEFINE BAT_TEMP.TILT,SKILL23;
DEFINE BAT_TEMP.ROLL,SKILL24;

DEFINE BAT_ANGLE,SKILL25;
DEFINE BAT_ANGLE.PAN,SKILL25;
DEFINE BAT_ANGLE.TILT,SKILL26;
DEFINE BAT_ANGLE.ROLL,SKILL27;


DEFINE BAT_SLEEPING = 0;
DEFINE BAT_STARTING =1;
DEFINE BAT_FLYING = 2;
DEFINE BAT_SEARCHING = 3;
DEFINE BAT_LANDING = 4;



function bat_init(){


//////////////////////////////////////////////////////////////////////////////////////////////////////////////////
///Change the following values, to adjust the bat's flight behavior to your game
//
//
MY.TRIGGER_RANGE = 200;          //alarming range
MY.BAT_START_SPEED = 2;          //Speed at starting from the ceiling
MY.BAT_SPEED.X = 6;              //flight speed
MY.BAT_SHOOTRANGE = 100;         //Range for detecting obstacles.
MY.BAT_ROLL_SPEED = 4;           
MY.BAT_TILT_SPEED = 4;
MY.BAT_ANIMATE_SPEED = 5;        //Speed of frame animation.
MY.BAT_ALARM_TIME = 200;         //Time until the next Alarm is possible.
MY.BAT_FLIGHT_TIME = 200;        //Flight duration until the bat is looking for it's landing place.
//
//
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
}

function BAT_EVENT() {

IF (EVENT_TYPE == EVENT_BLOCK){bat_turn();}
IF (EVENT_TYPE == EVENT_STUCK) {bat_turn();}
IF (EVENT_TYPE == EVENT_ENTITY) {bat_turn();}
IF (EVENT_TYPE == EVENT_IMPACT) {bat_turn();}
IF (EVENT_TYPE == EVENT_PUSH) {bat_turn();}
IF ((EVENT_TYPE == EVENT_TRIGGER)&&(MY.BAT_MODE == BAT_SLEEPING)){bat_start();}

END;


}



function bat_start(){

        IF (MY.BAT_MODE == BAT_SLEEPING)
            {
            MY.BAT_MODE = BAT_STARTING; 
            PLAY_ENTSOUND MY,bat_squeak1,100;
            MY.PASSABLE = ON;                //No Rotations when colliding with the ceiling
            MY.ENABLE_BLOCK = OFF;
            MY.ENABLE_STUCK = OFF;
            }

     IF (MY.BAT_MODE == BAT_STARTING)
        {
        MY.BAT_TEMP.X = MY.BAT_START_SPEED*TIME;
        MY.BAT_TEMP.Y = 0;
        MY.BAT_TEMP.Z = 0;
        MOVE ME,MY.BAT_TEMP,nullvector;

        MY.FRAME += 2*TIME;
        IF(MY.FRAME >= 9) {MY.BAT_MODE = BAT_FLYING;}
        ELSE
        {MY.NEXT_FRAME = 0;}
        }
                     
}




function bat_sleep(){

MY.FRAME = 2;
      IF (MY.ENABLE_TRIGGER == OFF)
          {
          MY.BAT_ALARM_TIMER +=1*TIME;

             IF (MY.BAT_ALARM_TIMER >= MY.BAT_ALARM_TIME)
             {
             MY.ENABLE_TRIGGER = ON;
             MY.BAT_ALARM_TIMER = 0;
             }
          }
}


function bat_landing() {

    MY.PASSABLE = OFF;
    MY.FRAME -= TIME;

    IF(MY.FRAME <= 2) 
       {
       MY.FRAME = 2; 
       MY.BAT_MODE = BAT_SLEEPING; 
       MY.ENABLE_TRIGGER = OFF;
       }
       ELSE
       {MY.NEXT_FRAME = MY.NEXT_FRAME-1;}

}

function bat_search() {

MY.PASSABLE = ON;              

MY.BAT_TEMP.X = MY.BAT_STARTPOS.X-MY.X;
MY.BAT_TEMP.Y = MY.BAT_STARTPOS.Y-MY.Y;
MY.BAT_TEMP.Z = MY.BAT_STARTPOS.Z-MY.Z;

IF((abs(MY.BAT_TEMP.X < 2))&&(abs(MY.BAT_TEMP.Y < 2))&&(abs(MY.BAT_TEMP.Z < 2))) //If landing place was found....
  {
  MY.BAT_MODE = BAT_LANDING;

  MY.X = MY.BAT_STARTPOS.X;
  MY.Y = MY.BAT_STARTPOS.Y;
  MY.Z = MY.BAT_STARTPOS.Z;

  MY.TILT = 270;
  GOTO bat_stop_searching;

  }

    TO_ANGLE MY.BAT_ANGLE,MY.BAT_TEMP;         //Looking at the direction of the starting/landing place
    MY.PAN = MY.BAT_ANGLE.PAN;
    MY.TILT = MY.BAT_ANGLE.TILT;
    //MY.ROLL = MY.BAT_ANGLE.ROLL;


    MY.FRAME += MY.BAT_ANIMATE_SPEED*TIME;
    IF(MY.FRAME > 33) {MY.NEXT_FRAME = 9;}
    ELSE
    {MY.NEXT_FRAME = 0;}
    IF(MY.FRAME >=34) {MY.FRAME = 9;PLAY_ENTSOUND MY,bat_wing1,50;}


  MY.BAT_TEMP.X = MY.BAT_SPEED.X * TIME;
  MOVE ME,MY.BAT_SPEED,nullvector;
  bat_bearing();
  bat_centering();

bat_stop_searching:
END;
}



function bat_flight(){

   MY.PASSABLE = OFF;                   //Collision Detection now allowed
   MY.ENABLE_BLOCK = ON;
   MY.ENABLE_STUCK = ON;


   MY.BAT_FLIGHT_TIMER +=1*TIME;

IF (MY.BAT_FLIGHT_TIMER >= MY.BAT_FLIGHT_TIME)  // If flying around is enough
   {
   MY.BAT_FLIGHT_TIMER = 0;
   MY.BAT_MODE = BAT_SEARCHING;                //look for a landing place
   }

  MY.FRAME += MY.BAT_ANIMATE_SPEED*TIME;

    IF(MY.FRAME > 33) {MY.NEXT_FRAME = 9;}
    ELSE
    {MY.NEXT_FRAME = 0;}
    IF(MY.FRAME >=34) {MY.FRAME = 9;PLAY_ENTSOUND MY,bat_wing1,50;}

  MY.BAT_SQUEAK_TIMER+=1*TIME;

  IF (MY.BAT_SQUEAK_TIMER >= 20)
     {
     MY.BAT_SQUEAK_TIMER = 0;
     PLAY_ENTSOUND MY,bat_squeak2,100;
     }

   MY.BAT_TEMP.X = MY.BAT_SPEED.X * TIME;

   MOVE ME,MY.BAT_SPEED,nullvector;
   bat_bearing();
   bat_centering();

}


function bat_turn(){



MY.BAT_TEMP.PAN = MY.PAN;
MY.BAT_TEMP.TILT = MY. TILT;
MY.BAT_TEMP.ROLL = MY.ROLL;


VECROTATE MY.BAT_TEMP,NORMAL;   //Blickrichtung um  NORMAL gedreht.

MY.BAT_ANGLE.PAN = MY.PAN;
MY.BAT_ANGLE.TILT = MY.TILT;
MY.BAT_ANGLE.ROLL = MY.ROLL;

vec_add (MY.BAT_TEMP,MY.BAT_ANGLE); //Neue Blickrichtung zur eigenen Blickrichtung addiert
                         //Die Resultierende liegt irgendwo dazwischen.

ROTATE MY,MY.BAT_TEMP,nullvector;  //Meine Blickrichtung um den Betrag der Resultierenden gedreht.


}


function bat_bearing(){


MY.BAT_TEMP.X = MY.BAT_SHOOTRANGE;
MY.BAT_TEMP.Y = 0;
MY.BAT_TEMP.Z = 0;

MY.BAT_ANGLE.PAN = MY.PAN;
MY.BAT_ANGLE.TILT = MY.TILT;
MY.BAT_ANGLE.ROLL = MY.ROLL;

VECROTATE MY.BAT_TEMP,MY.BAT_ANGLE;

vec_add(MY.BAT_TEMP,MY.POS);





//SHOOT MY.POS,MY.BAT_TEMP;        //For older A4-Versions than 1.21

trace_mode = IGNORE_ME + IGNORE_PASSABLE + ACTIVATE_SHOOT;
trace (MY.POS,MY.BAT_TEMP);

IF (RESULT)
   {bat_turn();}
   

}


function bat_centering() {


IF(MY.ROLL<0){

   MY.BAT_TEMP.PAN = 0;
   MY.BAT_TEMP.TILT = 0;
   MY.BAT_TEMP.ROLL = MY.BAT_ROLL_SPEED*TIME;
   ROTATE MY ,MY.BAT_TEMP,nullvector;
   }

IF(MY.ROLL >0){

  MY.BAT_TEMP.PAN = 0;
  MY.BAT_TEMP.TILT = 0;
  MY.BAT_TEMP.ROLL = -MY.BAT_ROLL_SPEED*TIME;
  ROTATE MY ,MY.BAT_TEMP,nullvector;
  }




IF(MY.TILT<0){

   MY.BAT_TEMP.PAN = 0;
   MY.BAT_TEMP.TILT = MY.BAT_TILT_SPEED*TIME;
   MY.BAT_TEMP.ROLL = 0;
   ROTATE MY ,MY.BAT_TEMP,nullvector;
   }

IF(MY.TILT >0){

   MY.BAT_TEMP.PAN = 0;
   MY.BAT_TEMP.TILT = -MY.BAT_TILT_SPEED*TIME;
   MY.BAT_TEMP.ROLL = 0;
   ROTATE MY ,MY.BAT_TEMP,nullvector;
}


}




ACTION bat {


MY.PUSH = 0;
MY.ENABLE_BLOCK = ON;
MY.ENABLE_STUCK = ON;
MY.ENABLE_ENTITY = ON;
MY.ENABLE_IMPACT = ON;
MY.ENABLE_PUSH = ON;
MY.ENABLE_TRIGGER = ON;


MY.BAT_STARTPOS.X = MY.X;
MY.BAT_STARTPOS.Y = MY.Y;
MY.BAT_STARTPOS.Z = MY.Z;

MY.BAT_MODE = BAT_SLEEPING;
MY.EVENT = BAT_EVENT;

MY.BAT_SQUEAK_TIMER = 0;

MY.TILT = 270;

bat_init();




WHILE(1)  {


IF (MY.BAT_MODE == BAT_SLEEPING) {bat_sleep();}
IF (MY.BAT_MODE == BAT_STARTING) {bat_start();}
IF (MY.BAT_MODE == BAT_FLYING) {bat_flight();}
IF (MY.BAT_MODE == BAT_SEARCHING) {bat_search();}
IF (MY.BAT_MODE == BAT_LANDING){bat_landing();}

WAIT (1);

}

}


