/////////////////////////////////////////////////////
// RPG/Adv. Temp 2.0
// Isometric camera module
//
// (C) 2006 by Claus N.
// www.nighthawk.dk
//
// -- UPDATES --
// July 16th 2006:
// -Only one instance of NHAC_ISOC can run
/////////////////////////////////////////////////////
// We are using the Camera "Core"
define USE_CORE_ISOCAMERA;
/////////////////////////////////////////////////////
// We need the Defines "sub-core"
ifndef USE_SUBCORE_DEFINES;
	include <NHASC_defines.wdl>;
endif;
/////////////////////////////////////////////////////
// The isometric camera script
function NHAC_ISOC()
{
	// Only one instance at a time
	proc_kill(4);
	
	// Local variables
	var NHAC_ROTATE_AMOUNT = 0;
	var NHAC_ZOOM_PERCENTAGE = 100;
	
	// If I'm not an entity (e.g. just called from the main() function)
	if(!my)
	{
		// Wait for the player to exist
		while(!player) {wait(1);}
		
		// Set the "my" pointer to the player
		my = player;
	}
	
	// As long as I exists
	while(my)
	{
		// If the isometric camera should be used
		if(NHAC_CMODE == CMODE_ISOC)
		{
			// Compute the new camera position
			temp.x = my.x + fcos(NHAC_CPOS[2],NHAC_CPOS[0]);
			temp.y = my.y + fsin(NHAC_CPOS[2],NHAC_CPOS[0]);
			temp.z = NHAC_CPOS[1];
			
			// Set the camera position
			vec_set(camera.x,temp);
			
			// Make the camera look at me!
			vec_set(temp,my.x);
			vec_sub(temp,camera.x);
			vec_to_angle(camera.pan,temp);
			
			// If we can rotate the camera
			if(int(NHAC_CFLAGS) > 0)
			{
				// Add rotate amount
				NHAC_ROTATE_AMOUNT = clamp(NHAC_ROTATE_AMOUNT + ((key_e - key_q) * 0.5 * NHAC_CMOVSPEED_MAX * time),-NHAC_CMOVSPEED_MAX,NHAC_CMOVSPEED_MAX);
				
				// Slowly equalize the rotate amount with 0
				NHAC_ROTATE_AMOUNT -= sign(NHAC_ROTATE_AMOUNT) * NHAC_CMOVSPEED_MAX * 0.2 * time;
				
				// If the rotate amount is very small...
				if(abs(NHAC_ROTATE_AMOUNT) < 0.1 * time)
				{
					// ...then set it equal to 0
					NHAC_ROTATE_AMOUNT = 0;
				}
				
				// Add the rotate amount to the angle
				NHAC_CPOS[2] += NHAC_ROTATE_AMOUNT * time;
			}
			
			// If we can zoom the camera
			if(frc(NHAC_CFLAGS) > 0)
			{
				// Add zoom percentage
				NHAC_ZOOM_PERCENTAGE = clamp(NHAC_ZOOM_PERCENTAGE + -mickey.z * time,0,100);
				
				// Move the camera, due to the zooming
				NHAC_CPOS[0] = NHAC_CPOS_MIN[0] + (NHAC_CPOS_MAX[0] - NHAC_CPOS_MIN[0]) / 100 * NHAC_ZOOM_PERCENTAGE;
				NHAC_CPOS[1] = NHAC_CPOS_MIN[1] + (NHAC_CPOS_MAX[1] - NHAC_CPOS_MIN[1]) / 100 * NHAC_ZOOM_PERCENTAGE;
			}
		}
		
		// Avoid endless loop errors
		wait(1);
	}
}
/////////////////////////////////////////////////////