/////////////////////////////////////////////////////
// RPG/Adv. Temp 2.0
// Misc. actions
//
// (C) 2006 by Claus N.
// www.nighthawk.dk
//
// -- UPDATES --
//	July 11th 2006:
// Upgraded from A6.31.4 to A6.40.5
// 	- Changed "remove me;" to "ent_remove(me);"
// 
// July 12th 2006:
// -The NHAC_Fader action has been added
// -Potions and "spell-pickups" will not be attached to the ground automatically (it was buggy)
// 
// July 13th 2006:
// -Fixed bug in the item pick-up action & event
// 
// July 16th 2006:
// -Added a few actions
// 	-NHAC_UntouchableEnt - Cannot be touched by the mouse
// 	-NHAC_AlphaEnt - Let's you set an alpha value, and the untouchable flag
// 	-NHAC_fadeByCam - Fades away, if the entity in inbetween camera and player
// -Updated action NHAC_fader
/////////////////////////////////////////////////////
// We are using the misc. actor core
define USE_CORE_MISCACTOR;
/////////////////////////////////////////////////////
// We need the Defines "sub-core"
ifndef USE_SUBCORE_DEFINES;
	include <NHASC_defines.wdl>;
endif;
/////////////////////////////////////////////////////
// Standard pick-up event
function NHAC_STD_PICKUP_EVE()
{
	// The player need to exist
	if(!player) {return;}
	
	// If we touched it with the mouse
	if(event_type == event_touch)
	{
		// Lit the item
		my.ambient = 100;
	}
	
	// If we moved the mouse away from it
	if(event_type == event_release)
	{
		// Unlit the item
		my.ambient = my.skill53;
	}
	
	// If we clicked it with the mouse
	if(event_type == event_click)
	{
		// Wait till we released the left mouse button
		while(mouse_left) {wait(1);}
		
		// The player need to exist
		if(!player) {return;}
		
		// Set the walkpoint to my.x
		vec_set(player.ent_target,my.x);
		
		// While the player is too far away to pick it up
		while(player && (vec_dist(my.x,vector(player.x,player.y,my.z)) > my.range))
		{
			// If we click somewhere else (e.g. changes walkpoint or clicks another item)
			if(mouse_left)
			{
				// We won't pickup this item
				return;
			}
			
			// Avoid "endless loop" errors
			wait(1);
		}
		
		// Unlit the item
		my.ambient = my.skill53;
		
		// Pickup the item
		my.skill52 = 1;
	}
}
/////////////////////////////////////////////////////
// Title: Standard pick-up action
// Desc: This is a standard pick-up function.
// Desc: Use it for custom pick-up functions.
// Section: Skills and flags
// Use: range
action NHAC_STD_Pickup
{
	// Distance for pickup
	if(my.range == 0) {my.range = 40;}
	
	// Skills used in the action
	my.skill52 = 0;
	my.skill53 = my.ambient;
	
	// Set the triggers and the event
	my.enable_click = on;
	my.enable_touch = on;
	my.enable_release = on;
	my.event = NHAC_STD_PICKUP_EVE;
	
	// Don't block other entities
	my.passable = on;
	
	// If we should use this function
	/*if(NHAC_ENTS_TO_GROUND)
	{
		// Then do it :)
		// Don't flow
		attach_to_ground();
	}*/
	
	// Label, to jumb back to, if the item couldn't be picked up
	readyForPickup:
	
	// Wait till I should be picked up
	while(!my.skill52) {wait(1);}
	
	// Give other actions (that uses this one) a frame to do some stuff
	wait(1);
	
	// Can be cancelled from other actions
	if(!my.skill52) {goto(readyForPickup);}
	
	// Wait a frame, and then remove me
	wait(1);
	ent_remove(me);
}
/////////////////////////////////////////////////////
// Potion for pickup
// Title: Potion pickup
// Desc: Potion pickup action
// Desc: (c) 2006 by Claus N.
// Section: Description
// Desc: Gives player e.g. health and mana on pickup
// Desc: It can also increase in e.g. damage or defense
// Desc: And give the player more exp. points
// Section: Skills and flags
// Use: range, health, mana, max_health, max_mana, damage, defense, speed, addExp
action NHAC_potion_pickup
{
	// Call standard pickup function
	NHAC_STD_Pickup();
	
	// Wait till I should be picked up
	while(!my.skill52) {wait(1);}
	
	// If player doesn't exist, cancel pickup
	if(!player) {my.skill52 = 0;}
	
	player.health += my.health;
	player.max_health += my.max_health;
	player.mana += my.mana;
	player.max_mana += my.max_mana;
	player.damage += my.damage;
	player.defense += my.defense;
	player.speed += my.speed;
	NHAC_plExp += my.addExp;
}
/////////////////////////////////////////////////////
// Spell for pickup
// Title: Spell pickup
// Desc: Spell pickup action
// Desc: (c) 2006 by Claus N.
// Section: Description
// Desc: For picking up a spell
// Section: Skills and flags
// Use: range, spellType
action NHAC_spell_pickup
{
	// Keep the spell within the limits
	my.spellType = clamp(my.spellType,0,NHASC_TOTAL_SPELLS);
	
	// Call standard pickup function
	NHAC_STD_Pickup();
	
	// Wait till I should be picked up
	while(!my.skill52) {wait(1);}
	
	// If player doesn't exist, cancel pickup
	if(!player) {my.skill52 = 0;}
	
	// Get the spell
	NHAC_CSPELL_OWNED[my.spellType] = 1;
}
/////////////////////////////////////////////////////
// Title: Fader Action
// Desc: Untouchable by the mouse.
// Desc: Will fade to the alpha value specified, when player is near.
// Desc: Default is 20.
// Desc: Will be solid again when player isn't near.
// Desc: Passable is automatically set. To disable passable, set flag1.
// Section: Skills and Flags
// Use: range, isUntouchable, _alpha
action NHAC_fader
{
	// Initialize flags/properties
	my.passable = (my.flag1 == false);
	my.untouchable = (my.isUntouchable == true);
	if(my.range == 0) {my.range = 250;}
	if(my._alpha == 0) {my._alpha = 20;}
	
	// Main loop
	while(my)
	{
		// Check whether we should be transparent
		my.transparent = (my.alpha != 100);
		
		// If player exists
		if(player)
		{
			// If player is close
			if(vec_dist(my.x,player.x) <= my.range)
			{
				// Decrease alpha
				my.alpha = clamp(my.alpha - 15 * time,my._alpha,100);
			}
			else
			{
				// Increase alpha
				my.alpha = clamp(my.alpha + 15 * time,my._alpha,100);
			}
		}
		
		// Avoid endless loops
		wait(1);
	}
}
/////////////////////////////////////////////////////
// Title: Fader Action (Camera)
// Desc: When inbetween player and camera, it will
// Desc: fade, till it get the alpha value specified.
// Desc: If no alpha value is set, default is 20.
// Desc: Passable is automatically set. To disable passable, set flag1.
// Section: Skills and Flags
// Use: _alpha, isUntouchable
action NHAC_fadeByCam
{
	// Initialize flags/properties
	my.passable = (my.flag1 == false);
	my.untouchable = (my.isUntouchable == true);
	if(my._alpha == 0) {my._alpha = 20;}
	
	// Main loop
	while(my)
	{
		// Check whether we should be transparent
		my.transparent = (my.alpha != 100);
		
		// If player exists
		if(player)
		{
			// Check whether we are between camera and player
			if((my.x + my.min_x < max(camera.x,player.x) + 10 && my.x + my.max_x > min(camera.x,player.x) - 10)
				&& (my.y + my.min_y < max(camera.y,player.y) + 10 && my.y + my.max_y > min(camera.y,player.y) - 10))
			{
				// Fade us away
				my.flag8 = true;
			}
			else
			{
				// Stay solid
				my.flag8 = false;
			}
			
			// If we should fade
			if(my.flag8)
			{
				// Decrease alpha
				my.alpha = clamp(my.alpha - 15 * time,my._alpha,100);
			}
			else
			{
				// Increase alpha
				my.alpha = clamp(my.alpha + 15 * time,my._alpha,100);
			}
		}
		
		// Avoid endless loops
		wait(1);
	}
}
/////////////////////////////////////////////////////
// Title: Untouchable action
// Desc: Untouchable by the mouse.
action NHAC_UntouchableEnt
{
	my.untouchable = true;
}
/////////////////////////////////////////////////////
// Title: Transparent entity
// Desc: A transparent entity
// Section: Skills and Flags
// Use: _alpha, isUntouchable
action NHAC_AlphaEnt
{
	my.transparent = true;
	my.alpha = my._alpha;
	my.untouchable = (my.isUntouchable == true);
}
/////////////////////////////////////////////////////