/////////////////////////////////////////////////////
// RPG/Adv. Temp 2.0
// Basic NPC AI script
// Also contains a basic dialogue function
//
// (C) 2006 by Claus N.
// www.nighthawk.dk
/////////////////////////////////////////////////////
// We are using the NPC AI "Core"
define USE_CORE_NPCAI;
/////////////////////////////////////////////////////
// We need the Defines "sub-core"
ifndef USE_SUBCORE_DEFINES;
	include <NHASC_defines.wdl>;
endif;
/////////////////////////////////////////////////////
// And the animation "sub-core"
ifndef USE_SUBCORE_ANIMATION;
	include <NHASC_animation.wdl>;
endif;
/////////////////////////////////////////////////////
// Get the strings
ifndef USE_SUBCORE_DIALOGUESTRINGS;
	include <NHASC_diaStrings.wdl>;
endif;
/////////////////////////////////////////////////////
// The background of the dialogue panel
bmap NHAC_dialogue_bg = <NHAC_dialogue_bg.bmp>;
/////////////////////////////////////////////////////
function NHAC_dialogue_hide();
/////////////////////////////////////////////////////
// The dialogue panel
panel NHAC_dialogue_pan
{
	bmap = NHAC_dialogue_bg;
	layer = 4;
	flags = refresh;
	
	button = 735,10,NHAC_closebut_hover,NHAC_closebut_normal,NHAC_closebut_hover,NHAC_dialogue_hide,null,null;
}
/////////////////////////////////////////////////////
// The text that is show on dialogue panel
text NHAC_dialogue_txt
{
	layer = 5;
	font = NHAC_dialogue_fnt;
	string = NHAC_dialogue_str;
	red = 255;
	green = 255;
	blue = 255;
	flags = outline;
}
/////////////////////////////////////////////////////
// Hides the dialogu panel
function NHAC_dialogue_hide()
{
	NHAC_dialogue_pan.visible = false;
	NHAC_dialogue_txt.visible = false;
	NHAC_CDIA_VISIBLE = false;
}
/////////////////////////////////////////////////////
// Positions and shows the panel
function NHAC_dialogue_show(str)
{
	
	// Position and show the panel
	NHAC_dialogue_pan.pos_x = NHAC_CHUD_POSX;
	NHAC_dialogue_pan.pos_y = NHAC_CHUD_POSY - bmap_height(NHAC_dialogue_pan.bmap);
	NHAC_dialogue_pan.visible = true;
	
	// Position, set the string and show the text
	NHAC_dialogue_txt.pos_x = NHAC_dialogue_pan.pos_x + 20;
	NHAC_dialogue_txt.pos_y = NHAC_dialogue_pan.pos_y + 20;
	str_cpy(NHAC_dialogue_txt.string,str);
	NHAC_dialogue_txt.visible = true;
	
	// Set some vars
	NHAC_CDIA_POSX = NHAC_dialogue_pan.pos_x;
	NHAC_CDIA_POSY = NHAC_dialogue_pan.pos_y;
	NHAC_CDIA_BMAPWIDTH = bmap_width(NHAC_dialogue_pan.bmap);
	NHAC_CDIA_BMAPHEIGHT = bmap_height(NHAC_dialogue_pan.bmap);
	NHAC_CDIA_VISIBLE = true;
}
/////////////////////////////////////////////////////
// Store your dialogue string handles in the array in this function
function NHAC_NPCDIALOGUE_INIT()
{
	NHAC_NPC_DIALOGUE[0] = handle(dialogueStr1);
	NHAC_NPC_DIALOGUE[1] = handle(dialogueStr2);
	NHAC_NPC_DIALOGUE[2] = handle(dialogueStr3);
	NHAC_NPC_DIALOGUE[3] = handle(dialogueStr4);
	NHAC_NPC_DIALOGUE[4] = handle(dialogueStr5);
	NHAC_NPC_DIALOGUE[5] = handle(dialogueStr6);
	NHAC_NPC_DIALOGUE[6] = handle(dialogueStr7);
	NHAC_NPC_DIALOGUE[7] = handle(dialogueStr8);
	NHAC_NPC_DIALOGUE[8] = handle(dialogueStr9);
	NHAC_NPC_DIALOGUE[9] = handle(dialogueStr10);
	NHAC_NPC_DIALOGUE_INIT = true;
}
/////////////////////////////////////////////////////
// Movement function
function NHAC_basicNPC_movement()
{
	// We only use the X and Y position of the target
	// Z could cause stupid-looking "errors"
	my.ent_target_z = 0;
	
	// If we got a walkpoint
	if(vec_dist(my.ent_target,nullvector) > 1)
	{
		// If we haven't yet reached our target
		if(vec_dist(vector(my.ent_target_x,my.ent_target_y,my.z),my.x) > 40)
		{
			// Turn against the target
			vec_set(temp,my.ent_target);
			vec_sub(temp,my.x);
			vec_to_angle(my.pan,temp);
			
			// Don't bow
			my.tilt = 0;
			
			// Set our movement speed
			my.curSpeed = my.speed * (1 + my.run);
			
			// Move us
			c_move(my,vector(my.curSpeed * time,0,0),nullvector,ignore_passable + ignore_you + glide);
			
			// Set the animation to walk or run
			my.anim_state = anim_state_walk + my.run;
		}
		else
		{
			// If I'm below 10 quants away from my target
			// Reset my target
			vec_set(my.ent_target,nullvector);
			
			// Use the stand animation
			my.anim_state = anim_state_stand;
		}
	}
}
/////////////////////////////////////////////////////
// The NPC event
function NHAC_basicNPC_event()
{
	// If we'd been clicked
	if(event_type == event_click)
	{
		// If the doesn't exist
		if(!player) {return;}
		
		// Get the angle, for the player to look at 'my'
		vec_set(temp,my.x);
		vec_sub(temp,player.x);
		vec_to_angle(temp.pan,temp);
		
		// Subtract a little from player's walkpoint
		player.ent_target_x += fcos(temp.pan,-40);
		player.ent_target_y += fsin(temp.pan,-40);
		
		// Wait for the player to release mouse_left
		while(mouse_left) {wait(1);}
		
		// Wait for the player to get close
		while(vec_dist(my.x,player.x) > 80)
		{
			// We clicked somewhere else
			if(mouse_left) {return;}
			
			// Ensure the existance of the player in the next frame
			wait(1);
			if(!player) {return;}
		}
		
		// If we haven't initialized the strings
		if(!NHAC_NPC_DIALOGUE_INIT) {NHAC_NPCDIALOGUE_INIT();}
		
		// Speak to me (:
		NHAC_dialogue_show(ptr_for_handle(NHAC_NPC_DIALOGUE[my.dialogue_id]));
	}
	
	// If we'd been touched by the mouse
	if(event_type == event_touch)
	{
		// Store a pointer to me
		NHAC_MOUSEENT_PTR = handle(my);
		
		// If we should be highlighted, do it!
		if(NHAC_MOUSEENT_HIGHLIGHT) {my.ambient = 100;}
	}
	
	// If the mouse has been moved away from me...
	if(event_type == event_release)
	{
		// Remove the pointer
		NHAC_MOUSEENT_PTR = 0;
		
		// If we should be highlighted, do it!
		if(NHAC_MOUSEENT_HIGHLIGHT) {my.ambient = 0;}
	}
}
/////////////////////////////////////////////////////
// Basic NPC script
// Title: NHA Core RPG NPC
// Desc: NHA RPG/Adv. temp 2.0 basic NPC
// Desc: (C) 2006 by Claus N. (www.nighthawk.dk)
// Section: Skills and Flags:
// Use: walkpoint_min_x, walkpoint_min_y, walkpoint_max_x, walkpoint_max_y
// Use: dialogue_id, moveable, silent
action NHAC_basicNPC
{
	// Event and triggers
	my.enable_click = true;
	my.enable_touch = true;
	my.enable_release = true;
	my.event = NHAC_basicNPC_event;
	
	// Initialize skills (same values as player)
	if(!my.speed) {my.speed = 3;}
	if(!my.anim_speed_stand) {my.anim_speed_stand = 2;}
	if(!my.anim_speed_walk) {my.anim_speed_walk = 4;}
	if(!my.anim_speed_run) {my.anim_speed_run = 12;}
	if(!my.anim_speed_attack) {my.anim_speed_attack = 10;}
	if(!my.anim_speed_death) {my.anim_speed_death = 5;}
	
	// Animate me
	std_animpack();
	
	// If we should use this function
	if(NHAC_ENTS_TO_GROUND)
	{
		// Then do it :)
		// Don't flow
		attach_to_ground();
	}
	
	// Main loop
	while(my)
	{
		// If we shouldn't move, reset our target
		if(my.moveable == false) {vec_set(my.ent_target,nullvector);}
		else
		{
			// If we haven't got a target
			if(vec_dist(my.ent_target,nullvector) <= 1)
			{
				// If we're lucky ;P
				if(random(1) > 0.999)
				{
					// Set walkpoint
					my.ent_target_x = clamp(my.walkpoint_min_x + random(my.walkpoint_max_x - my.walkpoint_min_x),my.walkpoint_min_x,my.walkpoint_max_x);
					my.ent_target_y = clamp(my.walkpoint_min_y + random(my.walkpoint_max_y - my.walkpoint_min_y),my.walkpoint_min_y,my.walkpoint_max_y);
				}
			}
		}
		
		// Do the movement
		NHAC_basicNPC_movement();
		
		wait(1);	// Avoid endless loops
	}
}
/////////////////////////////////////////////////////