/////////////////////////////////////////////////////
// RPG/Adv. Temp 2.0
// Defines
//
// (C) 2006 by Claus N.
// www.nighthawk.dk
//
// -- UPDATES --
//	July 11th 2006:
// Fixed bug in the item system
// 	- itemType is now defined as skill4
// 
// July 12th 2006:
// -Added prototype for function NHAC_CORE_ITEM_DROP(ent,item)
// -Added the NHAC_ENEMY_ITEMDROP variable
// 
// July 14th 2006:
// -Defined isAttacking (flag7)
// -Added the NHAC_ILF_VERSION variable
// -Added the NHAC_NSF_VERSION variable
// 
// July 16/17th 2006:
// -Added a few defines (sound & func. prototype)
/////////////////////////////////////////////////////
// If we are using this file, don't include it twice
define USE_SUBCORE_DEFINES;
/////////////////////////////////////////////////////
// Skill defines
define health,skill1;
define dialogue_id,skill2;
define spellType,skill2;
define max_health,skill2;
define mana,skill3;
define max_mana,skill4;
define itemType,skill4;

define damage,skill5;
define defense,skill6;

define ent_target,skill7;
define ent_target_x,skill7;
define ent_target_y,skill8;
define ent_target_z,skill9;

define anim_speed_stand,skill10;
define anim_speed_walk,skill11;
define anim_speed_run,skill12;
define anim_speed_attack,skill13;
define anim_speed_death,skill14;

define speed,skill15;

define cast_rate,skill16;
define addExp,skill17;
define cr_cdown,skill17;	// cast rate countdown

define team,skill18;

define range,skill19;

define walkpoint_min_x,skill16;
define walkpoint_min_y,skill17;
define walkpoint_max_x,skill18;
define walkpoint_max_y,skill19;

define anim_state,skill21;
define curSpeed,skill22;

define particle_func,skill23;

define enemy,skill24;

define scan_circle_pan,skill25;
define scan_circle_tilt,skill26;
define scan_mode,skill27;

define AISpellPrimary,skill28;
define AISpellSecondary,skill29;
/////////////////////////////////////////////////////
// Defines for actors (NHAC_miscActors.wdl) defines
define _alpha,skill2;

define isUntouchable,flag1;
/////////////////////////////////////////////////////
// Flag defines
define run,flag1;
define silent,flag2;
define isWizardAI,flag2;
define moveable,flag3;
define isAttacking,flag7;
define isAITarget,flag8;
/////////////////////////////////////////////////////
// Number defines
define true,1;
define false,0;

define anim_stop,-1;
define anim_state_stand,0;
define anim_state_walk,1;
define anim_state_run,2;
define anim_state_special,3;

define CMODE_FREEC,0;	// Free camera mode (camera not controlled)
define CMODE_ISOC,1;		// Isometric camera mode

define CFLAG_NONE,0;		// Player can't rotate/zoom camera
define CFLAG_ROTATE,1;	// Player can rotate the camera
define CFLAG_ZOOM,0.1;	// Player can zoom the camera
define CFLAG_BOTH,1.1;	// Player can rotate/zoom camera

define NHAC_max_items,400;		// Default a max of 400 items, change it if you need more
define NHAC_name_length,128;	// Length of the 'Name' strings
define NHAC_CINVCELLS,15;

define NHAC_CITMTYPE_WEAPON,0;
define NHAC_CITMTYPE_ARMOR,1;
define NHAC_CITMTYPE_HELM,2;

define NHAC_MAX_SPELLS,400;
define NHAC_spellname_length,128;

define SCAN_NULL,0;
define SCAN_ATTACK,1;
define SCAN_SEARCH,2;

define NHAC_MAX_CHARLEVEL,999;	// The highest level of the player
/////////////////////////////////////////////////////
// Bmaps
bmap def_mouse_map = <arrow.pcx>;

bmap NHAC_CINVENT_BG = <NHAC_inventory_bg.bmp>;

bmap NHAC_HPBAR = <NHAC_HPBAR.tga>;
bmap NHAC_MANABAR = <NHAC_MANABAR.tga>;

// Close button
bmap NHAC_closebut_normal = <NHAC_close_normal.tga>;
bmap NHAC_closebut_hover = <NHAC_close_hover.tga>;
/////////////////////////////////////////////////////
// variables
var NHAC_CMODE = CMODE_ISOC;		// Camera Mode
var NHAC_CPOS[3] = 200,120,0;		// Camera Position (dist,height,angle)
var NHAC_CPOS_MAX[2] = 200,200;	// Max. values for NHAC_CPOS (used for zooming). The angle isn't represented
var NHAC_CPOS_MIN[2] = 100,50;	// Min. values for NHAC_CPOS (used for zooming).
var NHAC_CFLAGS = 1.1;				// Camera flags (CFLAG_NONE, CFLAG_ROTATE, CFLAG_ZOOM, CFLAG_BOTH)
var NHAC_CMOVSPEED_MAX = 15;		// Max. camera rotate speed

var NHAC_CVAR_USE_CINVENTORY;			// DO NOT MODIFY THE VALUE OF THIS VARIABLE!!!
var NHAC_CINV_POSX;
var NHAC_CINV_POSY;
var NHAC_CINV_BMAPWIDTH;
var NHAC_CINV_BMAPHEIGHT;
var NHAC_CINV_VISIBLE;
var NHAC_CINVENT_SIDERIGHT = true;			// true = inventory in the left side, false = inventory in the right side
var NHAC_CINVENT_CELLS[NHAC_CINVCELLS];	// Keeps track of the items in the inventory
var NHAC_CINVENT_EQUIP[3];						// Eqipment cells
var NHAC_MOUSEITEM = 0;							// The item currently hold by the mouse

var NHAC_CITEMS_TOTAL = 0;
var NHAC_CITEMS_READ = false;
var NHAC_ILF_VERSION;
var NHAC_CITEM_MODELS[400];					// An array of handles to strings containing model names
var NHAC_ENEMY_ITEMDROP = true;				// If 'false', enemies won't drop items

var NHAC_CSPELLS_LOADED = false;
var NHAC_NSF_VERSION;
var NHAC_CURSPELL;
var NHAC_CSPELL_OWNED[NHAC_MAX_SPELLS];

// Used in NHAC_basicHUD.wdl
var pl_HUDC_health;
var pl_HUDC_mana;

var NHAC_CVAR_USE_CHUD;			// DO NOT MODIFY THE VALUE OF THIS VARIABLE!!!
var NHAC_CHUD_POSX;
var NHAC_CHUD_POSY;
var NHAC_CHUD_BMAPWIDTH;
var NHAC_CHUD_BMAPHEIGHT;
var NHAC_CHUD_VISIBLE;

var NHAC_CVAR_USE_CDIA;			// DO NOT MODIFY THE VALUE OF THIS VARIABLE!!!
var NHAC_CDIA_POSX;
var NHAC_CDIA_POSY;
var NHAC_CDIA_BMAPWIDTH;
var NHAC_CDIA_BMAPHEIGHT;
var NHAC_CDIA_VISIBLE;

var NHAC_CVAR_USE_CCHR;			// DO NOT MODIFY THE VALUE OF THIS VARIABLE!!!
var NHAC_CCHR_POSX;
var NHAC_CCHR_POSY;
var NHAC_CCHR_BMAPWIDTH;
var NHAC_CCHR_BMAPHEIGHT;
var NHAC_CCHR_VISIBLE;

var NHAC_PLAYER_STANDSTILL = false;
var NHAC_PAUSEAI = false;

var NHAC_AI_FADEAWAY = true;			// Should AIs fade away after they're death?
var NHAC_AI_FADEDELAY = 5;				// Seconds before fading an enemy away. Requires NHAC_AI_FADEAWAY to be true
var NHAC_AI_FADESPEED = 5;				// Alpha subtraction per second

var NHAC_MOUSEENT_HIGHLIGHT = true;	// Highlight ents (e.g. enemies) touched by the mouse
var NHAC_MOUSEENT_PTR;					// If the mouse is touching e.g. an enemy, this var will store a pointer to it

var NHAC_NPC_DIALOGUE[200];			// Contains handles to the strings used by the NPC core
var NHAC_NPC_DIALOGUE_INIT = false;

var NHAC_plExp = 0;						// Player experience
var NHAC_plLevel = 1;					// The level of the player
var NHAC_plNextLevelMultiplier = 17.45;	// int(this number * lvl) = exp for next lvl
var NHAC_plExpDivider = 1;			// Used to compute the given exp
var NHAC_plStatPoints = 0;				// Player's status points
var NHAC_plStatPointsPerLevel = 10;	// Status points gained per level
var NHAC_RECOVER_ON_LVLUP = true;	// Gain full health and mana on level up
var NHAC_statAddPerPoint = 2;			// Will be added to a property (e.g. max_health or damage) when a point is spend on it

var NHAC_SLI_RES;							// Used by the sliders in the options menu
var NHAC_SLI_BRI;

var NHAC_ENTS_TO_GROUND = true;
/////////////////////////////////////////////////////
// Item properties
var NHAC_CITEM_NAME[NHAC_max_items];
var NHAC_CITEM_BMAP[NHAC_max_items];
var NHAC_CITEM_MODEL[NHAC_max_items];
var NHAC_CITEM_SKIN[NHAC_max_items];
var NHAC_CITEM_TYPE[NHAC_max_items];
var NHAC_CITEM_DAMAGE[NHAC_max_items];
var NHAC_CITEM_DEFENSE[NHAC_max_items];
var NHAC_CITEM_ADDHEALTH[NHAC_max_items];
var NHAC_CITEM_ADDMANA[NHAC_max_items];
var NHAC_CITEM_ADDSPEED[NHAC_max_items];
var NHAC_CITEM_REQLEVEL[NHAC_max_items];
var NHAC_CITEM_VALUE[NHAC_max_items];
/////////////////////////////////////////////////////
// Sound handle
var_nsave snd_handle;
/////////////////////////////////////////////////////
// Strings
string NHASC_MSGSHOW_STR[512];
string NHAC_CPAN_INVDESCSTR[1024];
string NHAC_HUDSPELL_STR[NHAC_spellname_length];
string NHAC_dialogue_str[1024];
string NHAC_charpan_str_hlt[128];
string NHAC_charpan_str_man[128];
string NHAC_charpan_str_dmg[128];
string NHAC_charpan_str_dfs[128];
string NHAC_charpan_str_lvl[128];
string NHAC_charpan_str_exp[128];
string NHAC_charpan_str_nxt[128];
string NHAC_charpan_str_stp[128];

string NHAC_CSPELL_NEEDMANA_STR = "Not enough mana!";
string NHAC_LVLUP_STR = "You gained status points through Level up!";

// Default credits string. Add your name in the beginning of the string (you need to keep my name in the credits)
string NHAC_CREDITS_STR = "EURIPIDES (C) 2007 by Ren Unger \nEnjoy this RPG-Level\nit took about 5 weeks to create\n\n\nEURIPIDES\nthe famous classical greek tragedian\n\n\nUsing the NHA RPG Templates 2.0\n(C) 2006 by Claus N., Nighthawk Arts\nwww.nighthawk.dk";

string NHAC_CITEMFILE = <items.ilf>;
string NHAC_CSPELLFILE = <spells.nsf>;
/////////////////////////////////////////////////////
// Sound defines
sound beep_snd = <beep.wav>;
sound swing_snd = <swing.wav>;
sound empty_snd = <empty.wav>;
sound hit_snd = <hit.wav>;
/////////////////////////////////////////////////////
// Fonts
font NHAC_CITEM_DESCFNT = "Arial",1,20;
font NHAC_HUDSPELL_FNT = "Arial",1,20;
font NHAC_dialogue_fnt = "Arial",1,20;
font NHAC_charpan_fnt = "Arial",1,20;
font NHAC_mainMenu_fnt = "Arial",1,20;
/////////////////////////////////////////////////////
// Prototypes
function NHAC_enemyAI_castSpell(spell);
function NHA_CORE_SHOWMSG(str,tme);
function NHA_CORE_CHECK_SHOWMSG();
function NHA_CORE_READJUST_PANELS();
function attach_to_ground();
function NHAC_REQLVL_CHECK();
function NHAC_CORE_ITEM_DROP(ent,item);
function NHA_CORE_INVENTORY_REDRAW();
/////////////////////////////////////////////////////