/////////////////////////////////////////////////////
// NHA RPG Templates 2.0 MOD
// Shows the used equipment on the player
//
// (C) 2006 by Claus N.
// www.nighthawk.dk
/////////////////////////////////////////////////////
// Check whether MODs are enabled, and the inventory
// and item core is included
ifdef AllowMODs;
ifdef USE_CORE_INVENTORY;
/////////////////////////////////////////////////////
// Make sure we don't include it twice
ifndef USE_MOD_ITEMATTACH;
define USE_MOD_ITEMATTACH;
/////////////////////////////////////////////////////
// We need the Defines "sub-core"
ifndef USE_SUBCORE_DEFINES;
	include <NHASC_defines.wdl>;
endif;
/////////////////////////////////////////////////////
// Variables
var USE_MOD_ITEMATTACH = true;
var SHOW_ATTACHED_WEAPON = true;
var SHOW_ATTACHED_ARMOR = true;
var SHOW_ATTACHED_HELM = true;
var ATTACHED_ITEM_SHADOW = false;
/////////////////////////////////////////////////////
entity* ATTACHED_EQUIP_WEAPON;
entity* ATTACHED_EQUIP_HELM;
/////////////////////////////////////////////////////
string ITEMATTACH_MOD_TMPSTR[128];
/////////////////////////////////////////////////////
function MOD_attachToPlayer()
{
	// Can't be touched by the mouse
	my.untouchable = true;
	
	// Hide me
	my.invisible = true;
	my.passable = true;
	
	// Main loop
	while(USE_MOD_ITEMATTACH)
	{
		// If the player exists
		if(player)
		{
			// Set me at player's position
			vec_set(my.x,player.x);
			
			// Set angle
			vec_set(my.pan,player.pan);
			
			// Animate
			my.frame = player.frame;
			my.next_frame = player.next_frame;
			
			// If we should 'use' a shadow
			if(ATTACHED_ITEM_SHADOW)
			{
				my.shadow = true;
			}
			else
			{
				my.shadow = false;
			}
		}
		
		wait(1);	// Avoid endless loops
	}
	
	// remove me
	wait(1);
	ent_remove(me);
}
/////////////////////////////////////////////////////
starter MOD_itemAttach_main()
{
	// Wait till the core scripts has been initialized
	while(!InitMODs) {wait(1);}
	
	// Create the items
	ATTACHED_EQUIP_WEAPON = ent_create("kugle.mdl",nullvector,MOD_attachToPlayer);
	ATTACHED_EQUIP_HELM = ent_create("kugle.mdl",nullvector,MOD_attachToPlayer);
	
	// Main loop
	while(USE_MOD_ITEMATTACH)
	{
		// If it exists
		if(ATTACHED_EQUIP_WEAPON != null)
		{
			// Hide the weapon if no weapon is used
			if(NHAC_CINVENT_EQUIP[2 - NHAC_CITMTYPE_WEAPON] <= 0 || !SHOW_ATTACHED_WEAPON) {ATTACHED_EQUIP_WEAPON.invisible = true;}
			else
			{
				// Show the weapon
				ATTACHED_EQUIP_WEAPON.invisible = false;
				
				// Get the model string
				str_cpy(ITEMATTACH_MOD_TMPSTR,ptr_for_handle(NHAC_CITEM_MODELS[NHAC_CITEM_MODEL[NHAC_CINVENT_EQUIP[2 - NHAC_CITMTYPE_WEAPON] - 1]]));
				
				// Only morph if we are the wrong model
				if(!str_cmpi(str_for_entfile(null,ATTACHED_EQUIP_WEAPON),ITEMATTACH_MOD_TMPSTR))
				{
					// Morph to the used item's model
					ent_morph(ATTACHED_EQUIP_WEAPON,ITEMATTACH_MOD_TMPSTR);
				}
			}
		}
		else
		{
			ATTACHED_EQUIP_WEAPON = ent_create("kugle.mdl",nullvector,MOD_attachToPlayer);
		}
		
		// If player exists
		if(player)
		{
			// Set his skin
			player.skin = NHAC_CITEM_SKIN[NHAC_CINVENT_EQUIP[2 - NHAC_CITMTYPE_ARMOR]];
		}
		
		// If it exists
		if(ATTACHED_EQUIP_HELM != null)
		{
			// Hide the helm if no helm is used
			if(NHAC_CINVENT_EQUIP[2 - NHAC_CITMTYPE_HELM] <= 0 || !SHOW_ATTACHED_HELM) {ATTACHED_EQUIP_HELM.invisible = true;}
			else
			{
				// Show the helm
				ATTACHED_EQUIP_HELM.invisible = false;
				
				// Get the model string
				str_cpy(ITEMATTACH_MOD_TMPSTR,ptr_for_handle(NHAC_CITEM_MODELS[NHAC_CITEM_MODEL[NHAC_CINVENT_EQUIP[2 - NHAC_CITMTYPE_HELM] - 1]]));
				
				// Only morph if we are the wrong model
				if(!str_cmpi(str_for_entfile(null,ATTACHED_EQUIP_HELM),ITEMATTACH_MOD_TMPSTR))
				{
					// Morph to the used item's model
					ent_morph(ATTACHED_EQUIP_HELM,ITEMATTACH_MOD_TMPSTR);
				}
			}
		}
		else
		{
			ATTACHED_EQUIP_HELM = ent_create("kugle.mdl",nullvector,MOD_attachToPlayer);
		}
		
		wait(1);	// Avoid endless loops
	}
}
/////////////////////////////////////////////////////
endif;	// !USE_MOD_ITEMATTACH endif
endif;	// USE_CORE_INVENTORY endif
endif;	// AllowMODs endif
/////////////////////////////////////////////////////