////////////////////////////////////////////////////
// NHA RPG Templates 2.0 MOD
// Slowly recharges player's health and mana
//
// (C) 2006 by Claus N.
// www.nighthawk.dk
/////////////////////////////////////////////////////
// Check whether MODs are enabled, and the inventory
// and item core is included
ifdef AllowMODs;
/////////////////////////////////////////////////////
// Make sure we don't include it twice
ifndef USE_MOD_PLAYERRECHARGE;
define USE_MOD_PLAYERRECHARGE;
/////////////////////////////////////////////////////
// We need the Defines "sub-core"
ifndef USE_SUBCORE_DEFINES;
	include <NHASC_defines.wdl>;
endif;
/////////////////////////////////////////////////////
var USE_MOD_RECHARGEPLAYER = true;
var RECHARGE_HP_PER_SEC = 0.04;	// Health per sec
var RECHARGE_MN_PER_SEC = 0.04;	// Mana per sec
/////////////////////////////////////////////////////
starter MOD_rechargePlayer_main()
{
	// Wait till the core scripts has been initialized
	while(!InitMODs) {wait(1);}
	
	// While MOD should run
	while(USE_MOD_RECHARGEPLAYER)
	{
		// If player exists, and the game isn't paused
		if(player && !freeze_mode)
		{
			// If player is alive
			if(player.health > 0)
			{
				// Recharge health and mana
				player.health = clamp(player.health + RECHARGE_HP_PER_SEC * time,0,player.max_health + NHAC_ITM_GET_HLT());
				player.mana = clamp(player.mana + RECHARGE_MN_PER_SEC * time,0,player.max_mana + NHAC_ITM_GET_HLT());
			}
		}
		
		wait(1);	// Avoid endless loops
	}
}
/////////////////////////////////////////////////////
endif;
endif;
/////////////////////////////////////////////////////