/******************************************************************
Versatile Smoke effect - For A5.20 Extra and over
-------------------------------------------------------------------
Author            : David D. Thibault (aka Le DDT)
Date Started      : 2002 - 05 - 10
Date Completed    : 2002 - 05 - 15
Last Revision     : 2002 - 08 - 07
                    (Made code look better for release)
-------------------------------------------------------------------
Just include this script in your main script and assign the 
DDT_smokeFX action to an entity and it will emit smoke.
(I use a small, invisible and passable dummy entity)

You can change the parameters in WED to change the way the
smoke behave.

If you leave a parameter to 0, it will use it's [default] value.

Parameters

X_Vel      : Velocity of the smoke on the x axis [0]
Y_Vel      : Velocity of the smoke on the y axis [0]
Z_Vel      : Velocity of the smoke on the z axis [3]
For the velocity to use it's default value, all 3 settings must be 0

Fade_Speed : The speed at which the smoke will fade out [0.1]

size       : The size of the smoke bitmap [15]

Start_Alpha: The initial opacity of the smoke [10]

X_Disp     : Amount of dispertion of the effect on the x axis [16]
Y_Disp     : Amount of dispertion of the effect on the y axis [16]
Z_Disp     : Amount of dispertion of the effect on the z axis [0]
For the dispertion to use it's default value, all 3 settings must be 0

Amount     : The amount of smoke particles released per frame
             cycle. This is adjusted with the time variable
             to get a uniform effect on all machines. [5]
-------------------------------------------------------------------
If you use this script, or a modification of this script, please 
include my name in the credits under "Visual Effects programming".
Thanks!

If you have any suggestions for this script, please e-mail me at
david752@hotmail.com
-------------------------------------------------------------------
Thanks to fanatic, from the 3DGS user forum, for helping out a bit!
******************************************************************/

bmap DDT_smoke_bmap=<smoke.pcx>; //Change this if you want to

function DDT_smoke_effect();
function DDT_smoke_fade();

define _X_Vel,skill1;
define _Y_Vel,skill2;
define _Z_Vel,skill3;
define _Fade_Speed,skill4;
define _Size,skill5;
define _Start_Alpha,skill6;
define _X_Disp,skill7;
define _Y_Disp,skill8;
define _Z_Disp,skill9;
define _Amount,skill10;

var DDT_Smoke_Number;
var DDT_Smoke_Vel[3];

function DDT_smoke_effect() {
  //Get parameters from the velocity vector, fix the vector and set all the parameters
	my.skill_x  = my.vel_x % 1;
	my.vel_x    = my.vel_x - my.skill_x;
	my.skill_x *= 10;
	my.size     = my.vel_y % 1;
	my.vel_y    = my.vel_y - my.size;
	my.size    *= 1000;
	my.alpha    = my.vel_z % 1;
	my.vel_z    = my.vel_z - my.alpha;
	my.alpha   *= 1000;
	my.move     = on;
	my.bmap     = DDT_smoke_bmap;
	my.flare    = on;
	
	//Then fade out the particle
  my.function = DDT_smoke_fade;
}

function DDT_smoke_fade() {
	my.alpha-=my.skill_x*time;
	if (my.alpha<=0) {
		my.lifespan=0;
	}
}

// uses _X_Vel, _Y_Vel, _Z_Vel
// uses _X_Disp, _Y_Disp, _Z_Disp
// uses _Fade_Speed, _Size, _Start_Alpha, _Amount
action DDT_smokeFX {
	//Set default values
	if (my._Fade_Speed == 0) {my._Fade_Speed = 0.1;}
	if (my._X_Disp == 0 && my._Y_Disp == 0 && my._Z_Disp == 0) {my._X_Disp = 16; my._Y_Disp = 16;}
	if (my._X_Vel == 0 && my._Y_Vel == 0 && my._Z_Vel == 0) {my._Z_Vel = 3;}
	if (my._Size == 0) {my._Size = 15;}
	if (my._Start_Alpha == 0) {my._Start_Alpha = 10;}
	if (my._Amount == 0) {my._Amount = 5;}
	
	//No decimals on velocity
	my._X_Vel -= my._X_Vel % 1;
	my._Y_Vel -= my._Y_Vel % 1;
	my._Z_Vel -= my._Z_Vel % 1;
	
	//Max fade speed is 9.99 and no more than 2 decimals
	if (my._Fade_Speed < 0) {my._Fade_Speed = 0;}
	if (my._Fade_Speed >= 10) {my._Fade_Speed = 9.99;}
	my._Fade_Speed -= my._Fade_Speed % 0.01;
	
	//Max size is 999 and no decimals
	if (my._Size < 0) {my._Size = 0;}
	if (my._Size >= 1000) {my._Size = 999;}
	my._Size -= my._Size % 1;
	
	//Max Start Alpha is 100 and no decimals
	if (my._Start_Alpha < 0) {my._Start_Alpha = 0;}
	if (my._Start_Alpha >= 100) {my._Start_Alpha = 100;}
	my._Start_Alpha -= my._Start_Alpha % 1;

	//Indefinetly produce particles
	while (1) {
	  DDT_Smoke_Number = 0;
	  while (DDT_Smoke_Number <= (my._Amount * time)) {
  		//Set the starting position of the particles
  		temp.x = my.x + random(my._X_Disp * 2) - my._X_Disp;
  		temp.y = my.y + random(my._Y_Disp * 2) - my._Y_Disp;
  		temp.z = my.z + random(my._Z_Disp * 2) - my._Z_Disp;
  		
  		//Set the starting velocity of the particles
  		DDT_Smoke_Vel.x = my._X_Vel;
  		DDT_Smoke_Vel.y = my._Y_Vel;
  		DDT_Smoke_Vel.z = my._Z_Vel;
  		
  		//Add the needed values to the velocity vector. They will be deciphered in the function
  		DDT_Smoke_Vel.x += my._Fade_Speed / 10;    //so 9.99 will be .999
  		DDT_Smoke_Vel.y += my._Size / 1000;        //so 999 will be .999
  		DDT_Smoke_Vel.z += my._Start_Alpha / 1000; //so 100 will be .100
      	
  		effect(DDT_smoke_effect, 1, temp, DDT_Smoke_Vel);
  		
  		DDT_Smoke_Number += 1;
  	}
  	wait(1);
	}
}

action unused {wait(1);} //Dummy action to prevent WED bug