/////////////////////////////////////////////////////
// A glowing magic sword that follows the player, attacking anyone else
// Particularly effective in third-person/Isometric views.
//
// If you've ever played Dungeons and Dragons or Baldur's Gate, 
// then you'll recognize this as Mordenkainen's Sword.  
// Uh,Oh! Can I Say Mordenkainen without breaking
// some trademark law?  Too late I guess.
//
// This is my first and likely last contribution since my demo is about to expire.
// I hope someone finds this useful, it's been a lot of fun writing it.
//
//\\// >> NEWBIE WARNING!  I am a total amateur at cScript so this code, although << //\\//
//\\// >> functional, may contain some real stupidity! Use at your own risk!      << //\\//
//
// For simplicity's sake, I've included the particle effect functions in this file.
// In actual production that code should probably be moved to an effects.wdl or whatever.
//
// If you're a beginner, like me, then you could probably use a hand getting this to work:
// Copy this file, the three .tga files and the mdl file into your working directory.
// Open your main WDL file, ie. Office.wdl and add the following line near the top
// next to the other include lines: 
//    include <FlyingSword.wdl>; This will include this file into your game
// Now you just need a way to "summon/cast/etc.." the sword.  I added the line:
//     ON_M CallMagicSword; //Magic sword is cast when user presses the 'M' key
// at the bottom of my input.wdl but you could put it just about anywhere that
// makes sense to you.  If you're still using Office.wdl as your base template, I
// Strongly recommend you press [F7] to toggle to third-person mode for the full 
// effect of the sword.  You're welcome to email me for help, just keep in mind 
// I have no idea what I'm doing  8-)
//
// What good is a magic flying sword if there's nothing to attack?  The sword will
// only attack entities with a flag1 == on, and skill9>0.  As it attacks it decrements
// the target's skill9(health).  If you're using office.wdl be sure to set the guard's
// flag1 and skill9 accordingly and don't expect him to drop dead since his behavior, 
// "Patrol_prog" doesn't handle that.  If you want to see him die switch his behavior
// to "actor_walk_fight."
//
// Also, if you're new and you haven't read the tutorials by RealSpawn, GnomeTech,  
// Gabor Denes, AcidCrew, Doug's Adventure Workshop and all the others on Conitec's
// downloads page http://www.conitec.net/a4update.htm, do so now. My sword MDL is 
// actually Skillator's sword with a new paintjob.  Thanks for your help guys, 
// I would've been totally lost without your work as a reference.
//
// BTW, although you can fire off multiple swords, they will all go after one target.
// I'm sure there must be a way to give each sword an entity pointer to it's own target,
// but I couldn't figure it out.  Anyone have a suggestion? Anyone? Anyone?
//
// This code may be used by anyone for any purpose - however, I am not responsible.  
// No, really, I'm not responsible.  Ask anyone.
//
// Seriously, if you have any comments or suggestions please let me know at 
// jbeucus@bionicware.com. And if you do find it useful, the opportunity to play 
// your game would be a nice reward.  Regardless, enjoy...
// - John {5/7/02}


///////////////////////////////////////////  Variable Declarations  (we, the variables...)
var Distance;          	// used for the distance between the sword and player or target
var Hiltvec[3];		// Coordinates of the Sword Hilt
var Pointvec[3];	// Coordinates of the sword Point
var Tempvec[3];		// Temporary Vector
var TempAngle[3];	// Temporary Angle
var BladeLength = 0;	// Distance between Hilt and Point
var SwordDamage[3] = (2,4,1); //Dice,Sides,bonus-standard D&D stuff
var EffectCounter;	// Loop Counter used to manage the number of particle effects required
var Sword_TargetHeight;	// Height of the target
var OrbitPlayerMin = 70;// Distance limit to begin moving away from player
var OrbitPlayerMax = 80;// Distance limit to begin moving towards player
var indicator = 0;

string SwordModel=<magicsword1.mdl>;
entity* Sword_Target;	// Target entity, used in attacking

DEFINE SwordActionMode my.Skill23;	// 0=idle, 1=Hunting, 2=Attacking, 99=Dying
DEFINE SkipNextHit my.Skill24;		// Skips next n hits, prevents sword from getting stuck in target
DEFINE RotationDirection my.Skill25;	// Direction of rotation around target
DEFINE RotationAngle my.Skill26;	// Counter used for positioning sword
DEFINE PanDirection my.Skill27;		// Direction of sword attack swings
DEFINE OrbitPlayer my.Skill28;		// -1=move towards player, 1=move away, 0=idle
DEFINE SwordLifespan my.Skill29;	// How long the sword will live

BMAP Sword_Energy_map,<SwordEnergy.tga>;
BMAP Sword_Smoke_map,<SwordSmoke.tga>;
BMAP Sword_Flame_map,<SwordFlame.tga>;

//////////////////////////////////////////////////////   Sword Particle Effects
/// These functions could be moved to a master "effects.wdl"
/// I'm not going to exlplain these much, since there are very
/// good particle effect tutorials available for download.

FUNCTION SwordFire_property() {
	my.alpha -= my.skill_x*time;
	if (my.alpha<=0) {my.lifespan=0;return;}
	my.vel_x = (sin(Total_frames)/my.alpha)*my.size;	
	my.vel_y = (cos(Total_frames)/my.alpha)*my.size;
}
FUNCTION SwordEnergy_property() {
	my.alpha -= 6*time;
	if (my.alpha<=0) {my.lifespan=0;}
}
FUNCTION SwordPlasma_effect() {
	my.x+=random (3)+ -2;
	my.y+=random (3)+ -2;
	my.z+=random (3)+ -1;
	my.size=8;
	my.vel_x= (random(0.4) - 0.2) * 3;
	my.vel_y= (random(0.4) - 0.2) * 3;
	my.vel_z= (random(0.4) - 0.2) * 3;
	my.move=on;
	my.bmap=Sword_Energy_map;
	my.flare=on;
	my.bright=on;
	my.alpha=random(10)+5;
	my.function=SwordEnergy_property;
}
function SwordFire_effect() {
	my.x+=random (3)+ -2;
	my.y+=random (3)+ -2;
	my.z+=random (3)+ -1;
	my.size=7;
	my.vel_x=0;
	my.vel_y=0;
	my.vel_z=.6+random(2);
	my.move=on;
	my.bmap=Sword_Flame_map;
	my.flare=on;
	my.bright=on;
	my.alpha=random(10)+15;
	my.skill_x=6; //Larger numbers result in shorter particle lifespan
	my.function=SwordFire_property;
}
function SwordSmoke_effect(){
	my.x+=random (3) -2;
	my.y+=random (3) -2;
	my.z+=RANDOM(3);
	my.size=6;
	my.vel_x=0;
	my.vel_y=0;
	my.vel_z=.3+random(.5);
	my.move=on;
	my.bmap=Sword_Smoke_map;
	my.flare=on;
	my.alpha=random(30)+20;
	my.skill_x=1; //Larger numbers result in shorter particle lifespan
	my.function=SwordFire_property;
}
Function SwordSpark_effect(){
	my.x+=random (5)+ -3;
	my.y+=random (5)+ -3;
	my.z+=random (3)+ -1;
	my.size=2;
	my.vel_x=0;
	my.vel_y=0;
	my.vel_z=.9+random(1);
	my.move=on;
	my.bmap=Sword_Flame_map;
	my.flare=on;
	my.bright=on;
	my.alpha=random(50)+50;
	my.skill_x=6; //Larger numbers result in shorter particle lifespan
	my.function=SwordFire_property;
}


//////////////////////////////////////////////Sword Functions (the meat n' potatoes of the code)

FUNCTION SwordEvents(){
	IF(SwordActionMode>0){RETURN;} //The Sword is attacking or dying
	IF ((event_type == event_detect) && (you != player) && (you.flag1 >0) && (you.skill9 > 0) ) {  //The sword has detected something
	  Sword_target = You;	//Set the Sword's target to the entity that was detected
	  wait(1);
	   //Since Scan_entity sees through walls, we need to fire a trace between the sword and the target to ensure 
	   //the sword can actually see the target.  Originally I didn't include "Ignore_models" but whenever I had two
	   //enemies in a row, scan would detect the furthest entity first and then trace would be blocked by the closer
	   //entity resulting in a incredibly stupid-looking sword that ignored an enemy right in front of it's face!
	  trace_mode = ignore_me + ignore_you + ignore_passable + ignore_passents + ignore_models;
	  distance = trace (My.x,sword_target.x);
	  IF( distance ==0 ) {  //Nothing is blocking the sword's "View" of the target
	    SwordActionMode = 1;  //SwordActionMode: 1=attack
	    RotationDirection *=-1;  //With each newly aquired target, reverse angle of rotation around target, just for looks.
	    RotationAngle = RANDOM(200)-100;
	    Sword_TargetHeight = (Sword_target.Max_z-Sword_target.Min_z); //How tall is the target?
	  }
	 }	
}


FUNCTION ScanSword(){
//Look for enemies
	IF(SwordActionMode>0){RETURN;} //The Sword is attacking or dying
	temp.PAN = 90;
	temp.TILT = 180;
	temp.Z = 800;
	indicator = 4;
	scan_entity(MY.x,temp);
}

FUNCTION LightSword(){
//"Magic, glowy, sparkly, ooh" effect
	vec_for_vertex(PointVec,my,15);  //Sword Point, if you use a different model be sure to change the vertex
	Vec_for_vertex(tempvec,my,19);   //Sword Hilt, if you use a different model be sure to change the vertex
	BladeLength = vec_dist(PointVec.x,tempvec.x); //My game uses varying sword lengths so I check the length each Time
	OrbitPlayerMin=MAX(BladeLength*2,70); //Set the orbitplayer distances based on the sword length
	OrbitPlayerMax=MIN(BladeLength*3,80);

	vec_diff(tempangle,PointVec.x,tempvec.x); //Set tempangle to point from the hilt to the point
	effectcounter = BladeLength/2;  //Calculate the number of effects we need to light the sword
	vec_normalize(tempangle,2);	//normalize(reduce) the distance of tempangle to 2, we add
					//tempangle to the last effect position to calculate the
					//next effect position

	WHILE(effectCounter>0){
		effect(SwordPlasma_effect,2,tempvec,tempvec); //generate a plasma effect along the sword blade
		vec_add(tempvec.x,tempangle.x); //calculate the position to generate the next effect
		effectcounter -=1; //decrement the effect counter
	}

	my.lightrange = random(15) + 15; //it's gotta glow or it's just not cool!
	my.lightblue = 200;
}

FUNCTION MoveSword_RandPos(){
//Moves the sword in a gentle floating motion
	vec_set(tempvec,nullvector);
	tempvec.x +=COS(Total_frames)*.05;
	tempvec.y +=SIN(Total_frames)*.25;
	tempvec.z +=COS(Total_frames)*.15;
	ent_move(nullvector,tempvec);
}

FUNCTION MoveSword_RandAngle(){
//Rotates the sword as if it were "looking" for a target
	RotationAngle +=RotationDirection;
	my.pan +=(SIN(RotationAngle)*3.14) ;//+ RANDOM(3)-2;
	my.roll +=COS(RotationAngle)*1.5;
	my.tilt +=SIN(RotationAngle)*.5;
}


FUNCTION MoveSword_Follow(){
//Follow player
	IF(SwordActionMode>0){RETURN;} //The Sword is attacking or dying
	ScanSword(); //Check for nearby enemies

	move_mode = ignore_passable + Ignore_passents + glide + ignore_models;
	MoveSword_RandAngle() ;  //Adjust the sword's angles for that "looking around" effect

       	distance=vec_dist(my.x,player.x);  // distance between sword and player. 

	// Sword can move freely within OrbitPlayerMin to OrbitPlayerMax
	IF(distance>OrbitPlayerMin){ 
	   IF (distance>OrbitPlayerMax) {OrbitPlayer= -1;} //Sword has passed outer orbit limit and the flag is set to move it in
	   IF (orbitPlayer<0) {	//Move toward player
	     IF (distance<=OrbitPlayerMin){	//If Sword has reached inner orbit range the orbitplayer flag is set to 0(idle)
		OrbitPlayer=0;} ELSE {		//otherwise the sword continues inward
	     	vec_set(PointVec,my.x);
             	vec_set(TempVec,Player.x);
	     	TempVec.z += 35; 		//Adjust closer to players head
	     	vec_sub(PointVec.x,TempVec.x);
		PointVec.x =PointVec.x / 25 * -Time; 
		PointVec.y = PointVec.y / 25 * -Time; 
		PointVec.z = SIGN(PointVec.z)*Time*-3;
		ent_move(nullvector,PointVec);
	     	RETURN;}
	   }
	}
	IF(distance<OrbitPlayerMin){ // move away from Player
	   IF (distance<BladeLength+10) {OrbitPlayer= 1;}  //BladeLength+10 is the absolute minimum distance from the player
	   IF (OrbitPlayer>0) {
	     IF (distance>=OrbitPlayerMin){	//If Sword has reached inner orbit range the orbitplayer flag is set to 0(idle)
		OrbitPlayer=0;} ELSE {		//otherwise the sword continues outward
	     	vec_set(PointVec,my.x);
             	vec_set(TempVec,TempVec.x);
	     	TempVec.z += 35; //Adjust closer to players head
	     	vec_sub(PointVec.x,player.x);
	     	PointVec.x = SIGN(PointVec.x)*Time*2;
	     	PointVec.y = SIGN(PointVec.y)*Time*2;
	     	PointVec.z = 2*Time;	//Move the sword up
		ent_move(nullvector,PointVec);
	     	RETURN ;}
	   }
	}
	MoveSword_RandPos() ;	//Float the sword around the player

}

FUNCTION MagicSword_HitTest(){
//Check to see if the blade is inside the target
	IF (Sword_target==null || Sword_target.Skill9<0)	//Target is missing or dead
	  {SwordActionMode=0;Sword_Target=null;	//Set sword back to idle and return
	  //Point Sword at player
	  vec_set(temp,player.x);
	  vec_sub(temp,me.x);
	  vec_to_angle(me.pan,temp);
	  RETURN;}
	Vec_for_vertex(PointVec,my,15);
	Vec_for_vertex(HiltVec,my,19);
	trace_mode = ignore_me + ignore_you + ignore_passable + ignore_passents;
	distance = trace (HiltVec.x,PointVec.x);	//Trace between the hilt and point
	IF ( distance >0 && you == Sword_target) {	//If the sword 'Hit' it's target
	  IF(skipNextHit>0) {SkipNextHit -=1;RETURN;}  //Skip This hit and RETURN, skipping hits keeps the sword from becoming lodged in an enemy
	  //Calculate the damage
	  EffectCounter=SwordDamage[0];
	  Temp=0;
	  WHILE (EffectCounter>0) {
		Temp=Temp+RANDOM(SwordDamage[1]);
		EffectCounter -=1;}
	  Temp=Temp + SwordDamage[2];
	  //Create a burst of flame and puff of smoke
	  //the greater the damage done, the greater the show
	  effect(SwordFire_effect,(Temp/(SwordDamage[0]*SwordDamage[1]+SwordDamage[2]))*10,target,target);
	  effect(SwordSmoke_effect,(Temp/(SwordDamage[0]*SwordDamage[1]+SwordDamage[2]))*5,target,target);
	  effect(SwordSpark_effect,(Temp/(SwordDamage[0]*SwordDamage[1]+SwordDamage[2]))*5,target,target);
	  You.Skill9 -=temp;
	  PanDirection *=-1; 	//Reverse the sword swing direction
	  SkipNextHit=2;	//Skip the next two hits to avoid getting stuck inside the enemy
	}ELSE{SkipNextHit=0;}	//If we missed the enemy entirely, we don't need to skip the next hit
}

FUNCTION MoveSword_Attacktarget(){
	IF(Sword_target != Null && SwordActionMode>0) {
	   IF(SwordActionMode==99){RETURN;} //The Sword is dying
	   distance=vec_dist(my.x,Sword_target.x);  // distance between sword and target. 
	   move_mode = ignore_passable + Ignore_passents + glide;

	   IF(distance>BladeLength*3){ // Chase Target
	     //Point Sword at target
	       vec_set(temp,Sword_target.x);
	       vec_sub(temp,me.x);
	       vec_to_angle(me.pan,temp);
	   }
	   IF(SwordActionMode<2){
	     //Set Movement Vector
              vec_set(tempvec,my.x);
    	      vec_sub(tempVec.x,Sword_target.x);

	      tempvec.x =tempvec.x / 2 * -Time; // SIGN(tempvec.x)*Time*-3;
	      tempvec.y = tempvec.y / 2 * -Time; // SIGN(tempvec.y)*Time*-3;
	      tempvec.z = SIGN(tempvec.z)*Time*-3;
	      ent_move(nullvector,tempvec);
	   }
	   IF(distance<=BladeLength){SwordActionMode=2;} // If the target is within reach set action mode to 2, Attack target

	   IF(SwordActionMode==2){ //attacking
		my.pan +=SIN(total_frames*3.5)*20*PanDirection; //Swing the sword
		my.tilt=SIN(total_frames*4)*20;
		my.roll =0;
		my.z = Sword_target.z + (Sword_TargetHeight/5) + (SIN(RotationAngle*3)*(Sword_TargetHeight/5));
		IF(RANDOM(50)<=2){RotationDirection *=-1;} //Reverse rotation around target
		my.x = sword_target.x+(SIN(RotationAngle)*(BladeLength));
		my.y = sword_target.y+(COS(RotationAngle)*(BladeLength));
	        RotationAngle +=RotationDirection;
		IF( total_frames %2 ==0) {MagicSword_hitTest();} //Test for a hit every other frame
	   }ELSE{my.tilt=0;}
	}
}


FUNCTION Sword_follow
{
	while(SwordActionMode<99) //99=dying
	{
		IF(SwordActionMode>0){MoveSword_AttackTarget();}ELSE{MoveSword_Follow();}  //Either attack the target or follow the player
		LightSword(); //Twinkle the sword
		SwordLifeSpan -=Time;
		IF (SwordLifespan<0) {Sworddie();RETURN;} //When the lifespan is below zero, it's time to die
		WAIT(1);
	}
}

Function CreateSword(){
//Brings the sword to life in a flashy way
	my.passable = on;
	my.transparent=on;
        my.alpha=10;
	wait(1);

	SwordLifespan = 1;
	vec_for_vertex(PointVec,my,15);  //Sword Point
 	Vec_for_vertex(tempvec,my,19);   //Sword Hilt
	BladeLength = vec_dist(PointVec.x,tempvec.x);

	WHILE(SwordLifespan<200){  //The sword's birth lasts 200 ticks
	  my.lightblue = SwordLifespan;
 	  vec_for_vertex(PointVec,my,15);  //Sword Point
	  Vec_for_vertex(tempvec,my,19);   //Sword Hilt
	  vec_diff(tempangle,PointVec.x,tempvec.x);
	  vec_normalize(tempangle,3);
	  IF(SwordLifespan % 6 ==0){
	   effectcounter = BladeLength/3;
	   WHILE(effectCounter>0){
		effect(SwordPlasma_effect,SwordLifespan*.1,tempvec,tempvec);
		vec_add(tempvec.x,tempangle.x);
		effectcounter -=1;
		my.alpha += .2*Time;
		my.lightrange = random(20) + SwordLifespan;
	   }
	  }
	  my.pan -=2*Time;
	  SwordLifespan+=1;
	  wait(1);
	}

	my.lightrange = random(15) + 15;
	my.lightblue = 200;
	my.transparent = on;
	my.alpha = 20;
	my.bright = on;
	SwordActionMode = 0; //follow mode
	PanDirection = 1; //Rotation Direction
	RotationDirection = 1;
	RotationAngle = RANDOM(200);
	SwordLifespan = RANDOM(50)+500;  //Set the Sword's lifespan
	Sword_Follow(); //Begin the sword's life as a follower
	my.enable_detect = On;	//Enable detect entities
	my.event = SwordEvents;	//execute this function when an event occurs
	OrbitPlayerMin=MAX(BladeLength*2,70);
	OrbitPlayerMax=MIN(BladeLength*3,80);
}

FUNCTION SwordDie(){
//Fade the sword into oblivion
	SwordActionMode=99;  //99=dying
	WAIT(2); //Allow other functions to stop.
	SwordLifespan = 200;
	vec_for_vertex(PointVec,my,15);  //Sword Point
 	Vec_for_vertex(tempvec,my,19);   //Sword Hilt
	BladeLength = vec_dist(PointVec.x,tempvec.x);
	WHILE(SwordLifespan>5){
	  my.lightblue = SwordLifespan;	//Fade the brightness away
 	  vec_for_vertex(PointVec,my,15);  //Sword Point
	  Vec_for_vertex(tempvec,my,19);   //Sword Hilt
	  vec_diff(tempangle,PointVec.x,tempvec.x);
	  vec_normalize(tempangle,3);
	  IF(SwordLifespan % 6 ==0){
	   effectcounter = INT(BladeLength/3);
	   WHILE(effectCounter>0){
		effect(SwordPlasma_effect,SwordLifespan*.1,tempvec,tempvec);
		IF ((effectCounter+1) % 2 ==0) {effect(SwordFire_effect,SwordLifespan*.1,tempvec,tempvec);}
		IF (effectCounter % 2 ==0) {effect(SwordSpark_effect,SwordLifespan*.2,tempvec,tempvec);}
		vec_add(tempvec.x,tempangle.x);
		effectcounter -=1;
		my.alpha -= .2*Time;
		my.lightrange = random(20) + rotationdirection;
	   }
	  }
	  my.pan -=2*Time*(SwordLifespan*.05);
	  SwordLifespan-=1;
	  wait(1);
	}
	ent_remove(my); //Remove the sword
}

Function CallMagicSword(){
//Use this function to call the sword into existence!
	vec_set(temp,Nullvector);
	temp.z =player.max_z+25;
	temp.x = player.x+(SIN(Total_ticks)*(15));
	temp.y = player.y+(COS(Total_ticks)*(15));
	you = ent_create(Swordmodel,temp.x,createsword);
}

