//=============================================================================
//
//			Created by ScriptStar2063
//			Email: scriptwiz@hotmail.com
//                      
//============================================================================= 
//				License
//
//	This is creditware and if you wish to use this in a public
//	application you must include my name in the credits as follows:
//
//	Galaxy design and graphics by ScriptStar2063 - scriptwiz@hotmail.com
//
//=============================================================================
//	All of the files go in your project workspace.
//
//      Include galaxy.wdl in your main wdl file.
//
//	Place galaxy_c.mdl in your level where you want the center
//	of the galaxy to be. Right click on it and select properties.
//      Select the properties tab and check the Invisible and Passable
//      boxes. Now select the behavior tab and type "galaxy" in as
//      the action. Compile the level and run it.
//=============================================================================
BMAP star_1,<star1.pcx>; 	// Purple
BMAP star_2,<star2.pcx>; 	// Orange
BMAP star_3,<star3.pcx>; 	// Blue
BMAP star_4,<star4.pcx>; 	// Green
BMAP star_5,<star5.pcx>; 	// Red
BMAP star_6,<star6.pcx>; 	// Magenta
BMAP star_7,<star7.pcx>; 	// Maroon
BMAP star_8,<star8.pcx>; 	// Yellow
BMAP star_9,<star9.pcx>; 	// White

var star_num1 = 1; 	// Ring distance from center of galaxy for inner most ring
var star_num2 = 2; 
var star_num3 = 3;
var star_num4 = 4;
var star_num5 = 5;
var star_num6 = 6;
var star_num7 = 7;
var star_num8 = 8;
var star_num9 = 9;
var star_num10 = 10; 	// Ring distance from center of galaxy for the outside ring

var create_star = 1; 	// Do not change
var star_count = 0; 	// Do not change

var star_time = 3; 	// With the current wait of 3, the galaxy has a good looking spiral effect.
var max_stars = 200;	// Max number of stars. Number must be in 10s(10, 20, 30... 100, 110, 120, etc)

//=========================================================
// Just leave the action alone and don't mess with it.
//=========================================================
action galaxy() {
   while(create_star) {
      emit(1,my.pos,star_particle1);
      wait(star_time);
      emit(1,my.pos,star_particle2);
      wait(star_time);
      emit(1,my.pos,star_particle3);
      wait(star_time);
      emit(1,my.pos,star_particle4);
      wait(star_time);
      emit(1,my.pos,star_particle5);
      wait(star_time);
      emit(1,my.pos,star_particle6);
      wait(star_time);
      emit(1,my.pos,star_particle7);
      wait(star_time);
      emit(1,my.pos,star_particle8);
      wait(star_time);
      emit(1,my.pos,star_particle9);
      wait(star_time);
      emit(1,my.pos,star_particle10);
      star_count += 10;
      if(star_count > max_stars) {
         create_star = 0;
      }
      wait(20);
   }
}

var star_size = 200;	// Change this to change the size of the stars

var star_n = 5.5;	// Do not change

function star_particle1() {
  if (my_age == 0) {
    my_speed.z = random(25) - 12.5;
    my_size = star_size;
    my_map = star_9;	// Assign the star of the color that you want for galaxy ring 1
    my_bright = ON;
    my_flare = ON;
    my_pos.x -= (star_num1 * star_n);
  }
  else {
    my_speed.z = random(my_speed.z) - (my_speed.z / 2);
    my_speed.x = sin(my_age * 10) * star_num1;
    my_speed.y = cos(my_age * 10) * star_num1;
  }
}

function star_particle2() {
  if (my_age == 0) {
    my_speed.z = random(25) - 12.5;
    my_size = star_size;
    my_map = star_2;	// Assign the star of the color that you want for galaxy ring 2
    my_bright = ON;
    my_flare = ON;
    my_pos.x -= (star_num2 * star_n);
  }
  else {
    my_speed.z = random(my_speed.z) - (my_speed.z / 2);
    my_speed.x = sin(my_age * 10) * star_num2;
    my_speed.y = cos(my_age * 10) * star_num2;
  }
}
function star_particle3() {
  if (my_age == 0) {
    my_speed.z = random(25) - 12.5;
    my_size = star_size;
    my_map = star_3;	// Assign the star of the color that you want for galaxy ring 3
    my_bright = ON;
    my_flare = ON;
    my_pos.x -= (star_num3 * star_n);
  }
  else {
    my_speed.z = random(my_speed.z) - (my_speed.z / 2);
    my_speed.x = sin(my_age * 10) * star_num3;
    my_speed.y = cos(my_age * 10) * star_num3;

  }
}
function star_particle4() {
  if (my_age == 0) {
    my_speed.z = random(25) - 12.5;
    my_size = star_size;
    my_map = star_1;	// Assign the star of the color that you want for galaxy ring 4
    my_bright = ON;
    my_flare = ON;
    my_pos.x -= (star_num4 * star_n);
  }
  else {
    my_speed.z = random(my_speed.z) - (my_speed.z / 2);
    my_speed.x = sin(my_age * 10) * star_num4;
    my_speed.y = cos(my_age * 10) * star_num4;
  }
}
function star_particle5() {
  if (my_age == 0) {
    my_speed.z = random(25) - 12.5;
    my_size = star_size;
    my_map = star_2;	// Assign the star of the color that you want for galaxy ring 5
    my_bright = ON;
    my_flare = ON;
    my_pos.x -= (star_num5 * star_n);
  }
  else {
    my_speed.z = random(my_speed.z) - (my_speed.z / 2);
    my_speed.x = sin(my_age * 10) * star_num5;
    my_speed.y = cos(my_age * 10) * star_num5;
  }
}
function star_particle6() {
  if (my_age == 0) {
    my_speed.z = random(25) - 12.5;
    my_size = star_size;
    my_map = star_3;	// Assign the star of the color that you want for galaxy ring 6
    my_bright = ON;
    my_flare = ON;
    my_pos.x -= (star_num6 * star_n);
  }
  else {
    my_speed.z = random(my_speed.z) - (my_speed.z / 2);
    my_speed.x = sin(my_age * 10) * star_num6;
    my_speed.y = cos(my_age * 10) * star_num6;
  }
}
function star_particle7() {
  if (my_age == 0) {
    my_speed.z = random(25) - 12.5;
    my_size = star_size;
    my_map = star_1;	// Assign the star of the color that you want for galaxy ring 7
    my_bright = ON;
    my_flare = ON;
    my_pos.x -= (star_num7 * star_n);
  }
  else {
    my_speed.z = random(my_speed.z) - (my_speed.z / 2);
    my_speed.x = sin(my_age * 10) * star_num7;
    my_speed.y = cos(my_age * 10) * star_num7;
  }
}
function star_particle8() {
  if (my_age == 0) {
    my_speed.z = random(25) - 12.5;
    my_size = star_size;
    my_map = star_2;	// Assign the star of the color that you want for galaxy ring 8
    my_bright = ON;
    my_flare = ON;
    my_pos.x -= (star_num8 * star_n);
  }
  else {
    my_speed.z = random(my_speed.z) - (my_speed.z / 2);
    my_speed.x = sin(my_age * 10) * star_num8;
    my_speed.y = cos(my_age * 10) * star_num8;
  }
}
function star_particle9() {
  if (my_age == 0) {
    my_speed.z = random(25) - 12.5;
    my_size = star_size;
    my_map = star_3;	// Assign the star of the color that you want for galaxy ring 9
    my_bright = ON;
    my_flare = ON;
    my_pos.x -= (star_num9 * star_n);
  }
  else {
    my_speed.z = random(my_speed.z) - (my_speed.z / 2);
    my_speed.x = sin(my_age * 10) * star_num9;
    my_speed.y = cos(my_age * 10) * star_num9;
  }
}
function star_particle10() {
  if (my_age == 0) {
    my_speed.z = random(25) - 12.5;
    my_size = star_size;
    my_map = star_1;	// Assign the star of the color that you want for galaxy ring 10
    my_bright = ON;
    my_flare = ON;
    my_pos.x -= (star_num10 * star_n);
  }
  else {
    my_speed.z = random(my_speed.z) - (my_speed.z / 2);
    my_speed.x = sin(my_age * 10) * star_num10;
    my_speed.y = cos(my_age * 10) * star_num10;
  }
}