Path "D:\\PROGRAMME\\GSTUDIO\\template";

include <movement.wdl>;
include <messages.wdl>;
include <menu.wdl>;
include <particle.wdl>;
include <doors.wdl>;
include <actors.wdl>;
include <weapons.wdl>;
include <war.wdl>;

include <GENETIC.WDL>;

var video_mode = 6;
var video_depth = 16;
// var MAX_ENTITIES = 1000;

bmap splashmap = <logodark.bmp>;
panel splashscreen {
	bmap = splashmap;
	flags = refresh, d3d;
}

function main()
{
	splashscreen.pos_x = (screen_size.X - bmap_width(splashmap)) / 2;
	splashscreen.pos_y = (screen_size.Y - bmap_height(splashmap)) / 2;
	splashscreen.visible = ON;
	wait(2);

	load_level(<DNA.WMB>);
	waitt(8);
  	splashscreen.visible = OFF;

	load_status();

	control_camera();

	// DNA ERZEUGEN
	DNA_POS.X = 0;
	DNA_POS.Y = 0;
	DNA_POS.Z = 0;
	DNA_HEIGHT = 640;
	DNA_DIAMETER = 200;
	DNA_COILS = 2;
	DNA_SPEED = 1;
	DNA_ENT_PER_COIL = 70;
	DNA_ENT_PER_GEN = 10;
	DNA_GEN_EVERY_X_ENT = 10;
	create_dna();
}

WINDOW WINSTART
{
	TITLE			"A4 Engine";
	SIZE			480,320;
	MODE			IMAGE;	//STANDARD;
	BG_COLOR		RGB(240,240,240);
	FRAME			FTYP1,0,0,480,320;
	BUTTON		BUTTON_QUIT,SYS_DEFAULT,"Abort",400,288,72,24;
	TEXT_STDOUT	"Arial",RGB(0,0,0),10,10,460,280;
}


var cam_look = 0;
var cam_pan = 0;
FUNCTION control_camera {
	CAMERA.Z = 320;
	WHILE(1) {
		IF((CAMERA.Z >= 0) && (KEY_FORCE.Y == -1)) {CAMERA.Z += KEY_FORCE.Y * 1.4 * time * (KEY_CTRL * 2 + 1);}
		IF((CAMERA.Z <= 640) && (KEY_FORCE.Y == 1)) {CAMERA.Z += KEY_FORCE.Y * 1.4 * time * (KEY_CTRL * 2 + 1);}
		cam_pan += KEY_FORCE.X * 2 * time * (KEY_CTRL * 2 + 1);
		IF(cam_pan > 360) {cam_pan -= 360;}
		IF(cam_pan < 0) {cam_pan += 360;}
		CAMERA.X = 316 * COS(cam_pan);
		CAMERA.Y = 316 * SIN(cam_pan);
		CAMERA.PAN = cam_pan + 180 + cam_look;
		wait(1);
	}
}

ON_PGUP = zoom_in;
ON_PGDN = zoom_out;

ON_W = look_up;
ON_S = look_down;
ON_A = look_left;
ON_D = look_right;

ON_END = slwer;
ON_HOME = fster;

FUNCTION zoom_in {WHILE((KEY_PGUP == 1) && (CAMERA.ARC > 10)) {CAMERA.ARC -= 2 * time * (KEY_CTRL * 2 + 1); wait(1);}}
FUNCTION zoom_out {WHILE((KEY_PGDN == 1) && (CAMERA.ARC < 100)) {CAMERA.ARC += 2 * time * (KEY_CTRL * 2 + 1); wait(1);}}

FUNCTION look_up {WHILE((KEY_W == 1) && (CAMERA. TILT < 80)) {CAMERA. TILT += 2 * time * (KEY_CTRL * 2 + 1); wait(1);}}
FUNCTION look_down {WHILE((KEY_S == 1) && (CAMERA. TILT > -80)) {CAMERA. TILT -= 2 * time * (KEY_CTRL * 2 + 1); wait(1);}}
FUNCTION look_left {WHILE((KEY_A == 1) && (cam_look < 80)) {cam_look += 2 * time * (KEY_CTRL * 2 + 1); wait(1);}}
FUNCTION look_right {WHILE((KEY_D == 1) && (cam_look > -80)) {cam_look -= 2 * time * (KEY_CTRL * 2 + 1); wait(1);}}

FUNCTION slwer {WHILE((KEY_END == 1) && (DNA_SPEED > 0)) {DNA_SPEED -= .1 * time; wait(1);}}
FUNCTION fster {WHILE((KEY_HOME == 1) && (DNA_SPEED < 3)) {DNA_SPEED += .1 * time; wait(1);}}

