// Template file v5.12 (07/27/01)
////////////////////////////////////////////////////////////////////////
// File: path.wdl
//		WDL example to use MDJK_DLL
////////////////////////////////////////////////////////////////////////
// ACTIONS:
//		patrol: move from target to target
//    		actor_follow: follow the player
//
//	FUNCTIONS:
//		actor_move(): move aheading using 'force' (scan_floor, move_gravity, actor_anim)
//		actor_turn(): PAN towards target angle MY_ANGLE, according to force
//		_actor_connect(): remove self on EVENT_DISCONNECT
//	   	_scan_target(): find next start position
////////////////////////////////////////////////////////////////////////
//
// MDJK : Dclaration de fonction DLL
//

dllfunction mdjk_next_point(EntityPtr, Pt1, Pt2); 	// main function used to calculate path from Pt1 to Pt2
// return nextPoint (the point just after Pt1)
// return 0 if no way, 
// return negative value if error occured
dllfunction mdjk_distance(EntityPtr); 			// return distance following all points of the path
dllfunction mdjk_count(EntityPtr); 			// return the max index of the path array
dllfunction mdjk_point(EntityPtr, Index); 		// return the point number stored at array[index]
dllfunction mdjk_set_target(EntityPtr,&Vector, Index);	// set vector.x, vector.y, vector.z to Pt.x, Pt.y, Pt.z where Pt=array[index]
// return point opened or closed

dllfunction mdjk_find_point(EntityPtr, nbPoints);	// find the nearest point YOU MUST SAY HOW MUCH POINTS THERE IS IN THIS LEVEL
// return first opened point if any or nearest point

////////////////////////////////////////////////////////////////////////
//
// MDJK : errors values definition
//

DEFINE	kErrorNoWay = 0;		// No way found
DEFINE  kErrorFunctionWDL = -1;         // C-Script function not found
DEFINE  kErrorStartPoint = -2;          // Starting point not found
DEFINE  kErrorTooComplex = -3;          // Path too complex
DEFINE  kErrorDestPoint = -4;           // Destination point not found
DEFINE  kErrorIndexNeg = -5;            // Index must be positive
DEFINE  kErrorIndexMax = -6;            // Index too big
DEFINE  kPointOpened = -7;              // Point opened
DEFINE  kPointClosed = -8;              // Point closed
DEFINE  kErrorYouAreHere =-9;		// Destination point is Starting point
DEFINE  kErrorUnknownEntity =-10;       // Unknown entity
DEFINE  kErrorLost = -11;               // Entity is lost
DEFINE  kErrorLocked = -12;             // Entity is locked in a room
DEFINE  kYes = -13;                     // Yes
DEFINE  kNo = -14;                      // No

DEFINE  _Point1,SKILL1;
DEFINE  _Point2,SKILL2;
DEFINE  _Point3,SKILL3;
DEFINE  _Point4,SKILL4;
DEFINE  _Point5,SKILL5;
DEFINE  _Point6,SKILL6;
DEFINE  _Point7,SKILL7;
DEFINE  _Point9,SKILL8;



DEFINE _mdjk_pt1,SKILL33; 		// this is the last starting point used to calculate path
DEFINE _mdjk_pt2,SKILL34;		// this is the last destination point used to calculate path
DEFINE _mdjk_index,SKILL35;
DEFINE _mdjk_index_max,SKILL36;
DEFINE _mdjk_appel,SKILL37;


var mdjk_result;

var acounter;
var atemp;
var first_time;
var this_time;
var aperiod;
var appel;
var a_player_point;

string aShowMessage[80];
string aMessage[80];
string aPoint[10];
string aString[10];

SOUND appel_sound,<appel.wav>;

// **************** Don't forget to set MdJk_Nb_Pt in the next line ********************

DEFINE MdJk_Nb_Pt = 41; // this is the number of points we set in WED

function call_guard
{
	appel = 1;
	snd_play ( appel_sound, 50, 0);
	a_player_point = mdjk_find_point(player, MdJk_Nb_Pt);
	waitt(16);

}




//////////////////////////////////////////////////////////////////////

// Desc: move from point MdJk_Pt1 to Point MdJk_Pt2

action my_search
{
   //var MdJk_Handle;
   
   
   
   my._force=random (1)+1.2;

   actor_init();

   wait(30);   
   
   first_time =0;

   my._MdJk_Pt1 = mdjk_find_point(me, MdJk_Nb_Pt) ;
   if (my._MdJk_Pt1>0) // I know where I am
   {
     my._MdJk_Pt2 = int(random(MdJk_Nb_Pt))+1;

     my._MdJk_Index = 0;
     my._MdJk_Index_max=0;

     
     // attach next path
     MdJk_Result = mdjk_next_point(me, my._MdJk_Pt1, my._MdJk_Pt2);
     if (MdJk_Result>0) // path exist
     {
       
       my._MdJk_Index_max =  mdjk_count(me);
       
       // find first waypoint
       MdJk_Result=mdjk_set_target(me, my._TARGET_X, my._MdJk_Index );

       while (my._MOVEMODE >0) // while 2
       {

	if ((appel==1)&&(my._mdjk_appel!=1))
	{
		my._force += 2;
   		my._MdJk_Pt1 = mdjk_point(me, my._MdJk_Index);
		my._MdJk_Pt2 = a_player_point ;
		
		MdJk_Result = mdjk_next_point(me, my._MdJk_Pt1, my._MdJk_Pt2);

		my._MdJk_Index = 0;
   		my._MdJk_Index_max =  mdjk_count(me);
		my._mdjk_appel=1;
	}
	

	 my_patrol();
         
         if((my_speed.x == 0)&&(my_speed.z == 0)) // Something on the way
         {	
         if (first_time ==0) { first_time = total_ticks;}
           this_time = total_ticks;
           aperiod = this_time-first_time;
           if (aperiod<80) // we don't want entity to have problem longer than 80 ticks
           {
             
             atemp = this_time % 256;
             if (atemp<=128) { atemp = -1; } // at 70% turn on is right
             else { atemp = 1; }
	     my.pan = my.pan + atemp*40;
	     my_pos.Y =  my_pos.Y + atemp*10;
             actor_move();
             atemp = int(random(3))+1;
             wait(atemp);
           }
           else
           {	
             first_time = 0;
             
	     if (aperiod<480)
	     {		
             	my._MdJk_Pt1 = mdjk_find_point(me, MdJk_Nb_Pt) ;
		show_decision();
             	if (my._MdJk_Pt1>0) // I know where I am
             	{
               		my_next_point();					
             	} // end if "I know where I am"
             	else
             	{	
			this_time = total_ticks;
               		aperiod = this_time-first_time;
               		while (aperiod < 80)
               		{
                 		my._movemode = _mode_still;
                 		actor_move();
                 		wait(1);
               		}
               		my._movemode = _mode_walking;
             	}
	     }	
             

           }
           
           
         }

         wait(1);
         
       } // end while 2

     } // end if path exist
   } // end if "I know where I am"
   else
   {		
     beep;
     beep;
     beep; // somebody is lost in level
     my._movemode = _mode_still;
   }
   
   
}


function show_decision()
{
   //you = ptr_for_name ("lamp");
   //MdJk_Result = mdjk_set_target(me, you.X, my._MdJk_Index_max);  // set lamp at MdJk_Pt2
   //str_cpy (aMessage,"Rsultat "); // just to show guard decision
   str_for_num(aPoint, my._MdJk_Pt1);
   str_for_entname (aShowMessage, me);
   str_cat (aShowMessage," vers pt ");
   str_cat (aShowMessage,aPoint);
   //msg_show(aMessage,30);
   msg_show(aShowMessage,30);

}

function my_patrol()
{
   //find direction
   temp.x = MY._TARGET_X - MY.X;
   temp.y = MY._TARGET_Y - MY.Y;
   temp.z = 0;
   result = vec_to_angle(my_angle,temp);

   force = MY._FORCE;

   // near target? Find next waypoint
   // compare radius must exceed the turning cycle!
   if (result < 50) 
   { 
     if(my._MdJk_Index<my._MdJk_Index_max)
     {
       //breakpoint;
       my._MdJk_Index += 1;
       MdJk_Result = mdjk_set_target(me, my._TARGET_X, my._MdJk_Index);
       
       if (MdJk_Result == kPointClosed )// the door was closed meanwhile
       {	
         //breakpoint;
         beep; // just to notify the guard know the door is closed
         my._MdJk_Index -=1; // starting from prior point we'll get a new path
         my._MdJk_Pt1 = mdjk_point(me, my._MdJk_Index);
         my_next_point();	
       }
       
     }
     else
     {	
       my._mdjk_appel=0;
       appel = 0;
       my._force=random (1)+1.2;
       my._MdJk_Pt1 = my._MdJk_Pt2 ; // we arrived at the destination, now we'll get another path
       my_next_point();	

       //show_decision(); don't use this with several entities...

       
     }
     
   }

   my._TARGET_z = 0;

   // turn and walk towards target
   actor_turnto(my_angle.PAN);
   actor_move();

   
}

function my_next_point()
{

   my._MdJk_Pt2 = int(random(MdJk_Nb_Pt))+1;
   MdJk_Result = mdjk_next_point(me, my._MdJk_Pt1, my._MdJk_Pt2);

   // CAUTION here ! if you forgot to set Pt1 skills, 
   // Game will freeze in the loop

   while( MdJk_Result <= 0) // this loop looks for other point where to go
   
   {
     my._MdJk_Pt2 = int(random(MdJk_Nb_Pt))+1;
     MdJk_Result = mdjk_next_point(me, my._MdJk_Pt1, my._MdJk_Pt2);
   }

   my._MdJk_Index = 0;
   my._MdJk_Index_max =  mdjk_count(me);
   MdJk_Result=mdjk_set_target(me, my._TARGET_X, my._MdJk_Index );
   

}
// uses _Point1, _Point2, _Point3, _Point4, _Point5, _Point6, _Point7, _Point8
action set_flag  // set flags for waypoint
{
   if (my.ambient>0)
   {
	MY.fat = off;
   	MY.near = on;
     
     while(1)
     {	
       str_for_num (astring, my.ambient); 	// I give door number in ambient field
       str_cpy(amessage,"door_");		// Door name begin with "door_" and finish with number
       str_cat(amessage, astring);
       
       you = ptr_for_name (amessage);

       if ((you.SKILL9==you.SKILL1)||(you.SKILL8==on)) // door is closed or is moving
       {
         my.flag1=on; 	// Here I clause the point
       }
       else 
       {
         my.flag1=off;
       }
       
       wait(1); // I think we don't need to test to often
     }
   }

}



