///////////////////////////////////////////////////////////////////////////////////
// A5 main wdl
////////////////////////////////////////////////////////////////////////////
// Files to over-ride:
// * logodark.bmp - the engine logo, include your game title
// * horizon.pcx - A horizon map displayed over the sky and cloud maps
////////////////////////////////////////////////////////////////////////////
// The PATH keyword gives directories where game files can be found,
// relative to the level directory
path "D:\\Program Files\\GStudio\\template";	// Path to WDL templates subdirectory

////////////////////////////////////////////////////////////////////////////
// The INCLUDE keyword can be used to include further WDL files,
// like those in the TEMPLATE subdirectory, with prefabricated actions
include <movement.wdl>;
include <messages.wdl>;
include <menu.wdl>;		// must be inserted before doors and weapons
include <particle.wdl>; // remove when you need no particles
include <doors.wdl>;		// remove when you need no doors
include <actors.wdl>;   // remove when you need no actors
include <weapons.wdl>;  // remove when you need no weapons
include <war.wdl>;      // remove when you need no fighting
//include <venture.wdl>;	// include when doing an adventure
include <lflare.wdl>;   // remove when you need no lens flares

////////////////////////////////////////////////////////////////////////////
// The engine starts in the resolution given by the follwing vars.
var video_mode = 6;	 // screen size 640x480
var video_depth = 16; // 16 bit colour D3D mode

/////////////////////////////////////////////////////////////////
// Strings and filenames
// change this string to your own starting mission message.
string mission_str = "Fight your way through the level. Press [F1] for help";
string level_str = <menudemo.WMB>; // give file names in angular brackets

/////////////////////////////////////////////////////////////////
// define a splash screen with the required A4/A5 logo
bmap splashmap = <logodark.pcx>; // the default logo in templates
panel splashscreen {
	bmap = splashmap;
	flags = refresh,d3d;
}

////////////////////////////////////////////////////////////////////////////
// The following script controls the sky
sky horizon_sky {
// A backdrop texture's horizontal size must be a power of 2;
// the vertical size does not matter
	type = <horizon.pcx>;
	tilt = -10;
	flags = scene,overlay,visible;
	layer = 3;
}

/////////////////////////////////////////////////////////////////
// The main() function is started at game start
function main()
{
// set some common flags and variables
//	warn_level = 2;	// announce bad texture sizes and bad wdl code
	tex_share = on;	// map entities share their textures

// center the splash screen for non-640x480 resolutions, and display it
	splashscreen.pos_x = (screen_size.x - bmap_width(splashmap))/2;
	splashscreen.pos_y = (screen_size.y - bmap_height(splashmap))/2;
	splashscreen.visible = on;
	mouse_mode = 1;
	mouse_on();
// wait the required second, then switch the splashscreen off.
	wait(3);
  	splashscreen.visible = off;
	bmap_purge(splashmap);	// remove splashscreen from video memory
	main_back();
}

function main_strt()
{

// now load the level
	level_load(level_str);
// freeze the game
	freeze_mode = 1;
  wait(1);
  panels_off();//added for "ultima_panel.wdl"
// load some global variables, like sound volume
	load_status();

// display the initial message
	msg_show(mission_str,10);

// initialize lens flares when edition supports flares
ifdef CAPS_FLARE;
	lensflare_start();
endif;

// use the new 3rd person camera
	move_view_cap = 1;

// un-freeze the game
	freeze_mode = 0;

//	client_move();	// for a possible multiplayer game
// call further functions here...
}



/////////////////////////////////////////////////////////////////
// The following definitions are for the pro edition window composer
// to define the start and exit window of the application.
window WINSTART
{
	title			"3D GameStudio";
	size			480,320;
	mode			IMAGE;	//STANDARD;
	bg_color		RGB(240,240,240);
	frame			FTYP1,0,0,480,320;
//	BUTTON		BUTTON_START,SYS_DEFAULT,"Start",400,288,72,24;
	button		BUTTON_QUIT,SYS_DEFAULT,"Abort",400,288,72,24;
	text_stdout	"Arial",RGB(0,0,0),10,10,460,280;
}

/* no exit window at all..
window WINEND
{
	title			"Finished";
	size			540,320;
	mode	 		STANDARD;
	bg_color		RGB(0,0,0);
	text_stdout	"",RGB(255,40,40),10,20,520,270;

	set font		"",RGB(0,255,255);
	text			"Any key to exit",10,270;
}*/


/////////////////////////////////////////////////////////////////
//INCLUDE <debug.wdl>;
include <ultima_panel.wdl>;

