// Model path patrol code by Matt Fritz
// August 29, 2003
// Desc: 'bot' state, patrol a path composed entirely of models

DEFINE _TYPE_PATHNODE,25;       // for nodes of a model path

function patrol_model_path() // called from init_modelpath()
{
	my._MOVEMODE = _MODE_WALKING; // start the actor walking

	while (my._MOVEMODE == _MODE_WALKING) // he's walking
	{
		if(MY._FORCE <= 0) {MY._FORCE = 1.2;} // set a default force if none there
		force = MY._FORCE; // get the actor's force
		actor_move(); // move the actor
		temp.pan = 360; // a full circle
		temp.tilt = 180; // I wish I knew what this does... he he he
		temp.z = 10; // play with this value if you wish
		scan(my.pos,my.angle,temp); // scan for a cube
		// find direction
		if(YOU != NULL && you != player) // if a cube was found
		{
			if(YOU._TYPE == _TYPE_PATHNODE)
			{
				my.pan = you.pan; // set my pan to the cube's pan
			}
		}

		// Wait one tick, then repeat
		wait(1);
	}
}

function pathnode_event() // event of pathnode
{
	return; // don't do jack
}

action pathnode // assign this code to the node cube
{
	my._type = _TYPE_PATHNODE; // it's a path node
	my.passable = on; // it's passable
	my.enable_shoot = on; // you can shoot it: keep this here because when this was not
			      // here, my gunfire wouldn't register with anything around it.
	my.enable_scan = on; // enable scanning
	my.event = pathnode_event; // use the path node event
	my.invisible = on; // it's invisible: you may want to turn this off because it's kinda
			   // neat to watch the actor patrol the path, and it's good for debugging
			   // in case he takes a wrong turn.  That way, you can see which node
			   // he turned incorrectly on.
}

ACTION	pathbot // actor to walk the path
{
	// moves faster than normal
	MY._FORCE = 1.2;

	// shoots 'bullets' (yeah... right)
	// Frankly, I don't see how a purple particle can be considered a bullet,
	// but go figure.  Meh.
	MY._FIREMODE = DAMAGE_SHOOT+FIRE_DPARTICLE+HIT_SPARKS+HIT_FLASH+HIT_HOLE+HIT_SMOKE+0.20;

	// 'normal' death
	MY._HITMODE = 0;

	// 'normal' walking sound
	MY._WALKSOUND = _SOUND_WALKER;

	MY._I_COWARDICE = -1; // don't retreat
	MY._ACCURACY = -1; // "perfect" accuracy
	MY._WEAPONRANGE = 2000;


	// attach shadow
	drop_shadow();

	// start patrol bot behavior
	init_modelpath();
}

function init_modelpath() // called from pathbot
{
	var patrolling = 0;
	// set defaults
	if(MY._HEALTH == 0) { MY._HEALTH = 100; }	// default health
	if(MY._FORCE == 0) { MY._FORCE = 1; }       // default force
 	if(MY._FORCE == 0) {  MY._FORCE = 1; }
	if(MY._WALKSOUND == 0) { MY._WALKSOUND = _SOUND_WALKER; }

	actor_init(); // initialize actor

	// Allow player to pass thru actor if frozen
	if(freeze_actors > 1) { MY.PASSABLE = ON; }

	MY._SIGNAL = 0; // no signal yet
	MY.ENABLE_SCAN = ON; // enable a scan
	MY.ENABLE_SHOOT = ON; // enable gunfire
	MY.ENABLE_DETECT = ON; // enable detection
	MY.EVENT = fight_event; // use the default fight_event()

	while(1) // walks all the time
	{
		if(MY._HEALTH <= 0)      // no health? Die
		{
			EXCLUSIVE_ENTITY;
			wait(1);
			state_die();
			return;
		}
		if(patrolling == 0) // not patrolling yet...
		{
			patrol_model_path(); // patrol the heck out of the path
			patrolling = 1; // now I'm patrolling
		}
		temp.PAN = 360;
		temp.TILT = 180;
		temp.Z = 100; // play around with this value
		indicator = _WATCH;
		scan(MY.POS,MY.ANGLE,temp);
		// if the player has been detected while patrolling...
		if(MY._SIGNAL == _DETECTED)
		{
			MY._SIGNAL = 0;
			state_attack();	// ATTACK!
			return;
		}
		wait(3); // wait for 3 ticks
	}
}