// money.wdl by Matt Fritz
// WDL Script to handle money pickups

/////////////////////////////////////////////////////////////////////////
// Sounds and variables for picking up money
SOUND money_fetch <beamer.wav>; // money pickup sound (beamer.wav) from template folder
var money = 0; // money ID
var m_bill = 0; // money value

/////////////////////////////////////////////////////////////////////////
// Strings for needing and picking up money
STRING got_money1_str "Got a 1 dollar bill!";
STRING got_money5_str "Got a 5 dollar bill!";
STRING got_money10_str "Got a 10 dollar bill!";
STRING got_money20_str "Got a 20 dollar bill!";
STRING got_money50_str "Got a 50 dollar bill!";
STRING got_money100_str "Got a 100 dollar bill!";
/////////////////////////////////////////////////////////////////////////

// Desc: controls the money pickup
function _money_pickup()
{
	if(EVENT_TYPE == EVENT_SCAN && indicator != _HANDLE) { return; }
	if(EVENT_TYPE == EVENT_PUSH && YOU != player) { return; }

	if(m_bill == 1) { money = money + 1; msg.STRING = got_money1_str; }
	if(m_bill == 5) { money = money + 5; msg.STRING = got_money5_str; }
	if(m_bill == 10) { money = money + 10; msg.STRING = got_money10_str; }
	if(m_bill == 20) { money = money + 20; msg.STRING = got_money20_str; }
	if(m_bill == 50) { money = money + 50; msg.STRING = got_money50_str; }
	if(m_bill == 100) { money = money + 100; msg.STRING = got_money100_str; }
	if(MY.__SILENT != ON) { show_message(); }
	play_sound(money_fetch,50);
	wait(1);
	remove(ME);
}

// Assign an action to a money entity and pick up the entity and watch the results!
// Or, just use the included sprite, money.bmp

ACTION money_one
{
	m_bill = 1;
	MY.EVENT = _money_pickup;
	item_pickup();
}

ACTION money_five
{
	m_bill = 5;
	MY.EVENT = _money_pickup;
	item_pickup();
}

ACTION money_ten
{
	m_bill = 10;
	MY.EVENT = _money_pickup;
	item_pickup();
}

ACTION money_twenty
{
	m_bill = 20;
	MY.EVENT = _money_pickup;
	item_pickup();
}

ACTION money_fifty
{
	m_bill = 50;
	MY.EVENT = _money_pickup;
	item_pickup();
}

ACTION money_hundred
{
	m_bill = 100;
	MY.EVENT = _money_pickup;
	item_pickup();
}