////////////////////////////////////////////////////////////////////////
// Create trees automatically, based on the initial premise that
// a Map Entity is given within which the trees must appear.
// Version 2.0 .
// By	Dirk Mittler		January 24, 2007

var autotree_color1[3] = 127, 127, 127;
var autotree_color2[3] = 127, 127, 127;
var autotree_temp[3] = 0, 0, 0;
var autotrees_running = 0;

bmap autotree_bmap1 = <tree_image1.pcx>;
string autotree_str1 = <tree_image1.pcx>;
bmap autotree_bmap2 = <tree_image2.pcx>;
string autotree_str2 = <tree_image2.pcx>;
bmap autotree_bmap3 = <tree_image3.pcx>;
string autotree_str3 = <tree_image3.pcx>;
var tree_img_fmt = 888;
// Use your own filenames...
// Repeat last filename if using less than 3 of them.

bmap* autotree_bmap = autotree_bmap1;
string* autotree_str = autotree_str1;

define MAX_TREE_ALT, 50000;
define MIN_TREE_ALT, -20000;

define TREES_SINK, 8;
// Sink trees 8" into ground. In case quants no longer inches,
// change here.
define MAX_TREE_FAILURES, 100;

var tree_tolerance = 64;
// How closely does the Terrain colour need to match,
// absolute across colour-channels?

function autotree_behav() {
	my.oriented = ON;
	my.parent = you;
	my.PAN = temp.x;
	while (my.parent) {wait(1); }
							// Problem: Returns to .parent via stack.
	ent_remove(me);
}

function make_10_trees() {
	var count = 0;			// Local vars saved on stack.
	var failures = 0;
//	var tree_ang = 0;		// Useless since 'target' also lost.

	autotree_color2.red = 0;
	autotree_color2.green = 0;
	autotree_color2.blue = 0;

	tree_img_fmt = bmap_lock(autotree_bmap,0);

	// Specify 'transparent colour' here:
	autotree_temp.red = 0;
	autotree_temp.green = 0;
	autotree_temp.blue = 0;
ifdef ACKNEX_VERSION640;
	if (d3d_autotransparency == ON) {
		temp.x = pixel_for_bmap(autotree_bmap, 0, 0);
		pixel_to_vec(autotree_temp, temp.z, TREE_IMG_FMT, temp.x);
	}
endif;

	while (count < 8 && failures < 160) {
		// Test the tree's own colours.
		temp.x = pixel_for_bmap(autotree_bmap,
					int(random(bmap_width(autotree_bmap))),
					int(random(bmap_height(autotree_bmap))) );
		pixel_to_vec(autotree_color1, temp.z, TREE_IMG_FMT, temp.x);

		// Ignore pixels close to transparent colour.
		temp.y = (autotree_color1.red - autotree_temp.red) *
						(autotree_color1.red - autotree_temp.red);
		temp.y += (autotree_color1.green - autotree_temp.green) *
						(autotree_color1.green - autotree_temp.green);
		temp.y += (autotree_color1.blue - autotree_temp.blue) *
						(autotree_color1.blue - autotree_temp.blue);
		if (temp.y > tree_tolerance * tree_tolerance) {
			failures += 1;
			continue;
		}

		autotree_color2.red += autotree_color1.red;
		autotree_color2.green += autotree_color1.green;
		autotree_color2.blue += autotree_color1.blue;

		count += 1;
	}
	bmap_unlock(autotree_bmap);

	if (count == 0) {return(0); }

	// Make into averages.
	autotree_color2.red /= count;
	autotree_color2.green /= count;
	autotree_color2.blue /= count;
	// To compare with later.

	count = 0;
	failures = 0;
	while (count < 10 && failures < MAX_TREE_FAILURES) {
		// Choose random x, y above Terrain.
		autotree_temp.x = my.min_x;
		autotree_temp.y = my.min_y;
		autotree_temp.z = MAX_TREE_ALT;

		autotree_temp.x += random(my.max_x - my.min_x);
		autotree_temp.y += random(my.max_y - my.min_y);

		temp.x = autotree_temp.x;
		temp.y = autotree_temp.y;
		temp.z = MIN_TREE_ALT;

		// Scan vertically down from x, y for surface.
		autotree_color1.red = c_trace(autotree_temp, temp,
									 IGNORE_PASSABLE + IGNORE_SPRITES);
		if (autotree_color1.red <= 0) {
			failures += 1;
			continue;
		}

		// Compare Texture to Avg Sprite colour.
		autotree_color1.red = tex_color.red - autotree_color2.red;
		autotree_color1.green = tex_color.green - autotree_color2.green;
		autotree_color1.blue = tex_color.blue - autotree_color2.blue;

		temp.z = autotree_color1.red * autotree_color1.red +
					autotree_color1.green * autotree_color1.green +
					autotree_color1.blue * autotree_color1.blue;
			// Vec norm: r-squared + g-squared + b-squared .

		// Are they close enough?
		if (temp.z > tree_tolerance * tree_tolerance) {
			failures += 1;
			continue;
		}

		count += 1;

		// Position center of Sprite.
		target.z += bmap_height(autotree_bmap) / 2 - TREES_SINK;
			// Assuming normal scale = 1 quant / pixel.

		temp.x = random(360);
		autotree_temp.z = target.z;
					// x, y already set.
		autotree_color1.red = temp.x;
		ent_create(autotree_str, autotree_temp, autotree_behav);
			// *Possible* wait loses vars.

		temp.x = autotree_color1.red - 90;
		ent_create(autotree_str, autotree_temp, autotree_behav);
	}
	return(count);
}

ifdef ACKNEX_VERSION640;
function make_autotrees(var& number, entity* where) {
	if (where == NULL) {return; }
	var parent_handle = 0;
	parent_handle = handle(where);
	wait(1);				// New thread (process) created here.

	// Make sure Function only running once.
	while(autotrees_running) {wait(1); }

	me = ptr_for_handle(parent_handle);
	if (me == NULL) {return; }
	autotrees_running = 1;
	
	var count = 0.5;
	autotree_bmap = autotree_bmap1;
	autotree_str = autotree_str1;
	while (count < number[0]) {
		count += make_10_trees();
		wait(1);			// !!!
	}

	count = 0.5;
	autotree_bmap = autotree_bmap2;
	autotree_str = autotree_str2;
	while (count < number[1]) {
		count += make_10_trees();
		wait(1);			// !!!
	}

	count = 0.5;
	autotree_bmap = autotree_bmap3;
	autotree_str = autotree_str3;
	while (count < number[2]) {
		count += make_10_trees();
		wait(1);			// !!!
	}
	autotrees_running = 0;
}

ifelse;
// Requires 'you' to be set.
function make_autotrees(var& number) {
	if (you == NULL) {return; }
	var parent_handle = 0;
	parent_handle = handle(you);
	wait(1);				// New thread (process) created here.

	// Make sure Function only running once.
	while(autotrees_running) {wait(1); }

	me = ptr_for_handle(parent_handle);
	if (me == NULL) {return; }
	autotrees_running = 1;
	
	var count = 0.5;
	autotree_bmap = autotree_bmap1;
	autotree_str = autotree_str1;
	while (count < number[0]) {
		count += make_10_trees();
		wait(1);			// !!!
	}

	count = 0.5;
	autotree_bmap = autotree_bmap2;
	autotree_str = autotree_str2;
	while (count < number[1]) {
		count += make_10_trees();
		wait(1);			// !!!
	}

	count = 0.5;
	autotree_bmap = autotree_bmap3;
	autotree_str = autotree_str3;
	while (count < number[2]) {
		count += make_10_trees();
		wait(1);			// !!!
	}
	autotrees_running = 0;
}

endif;

/*		If you can't meet the requirement that me=
a Map Enity within which trees must be placed, then do
something like this:

var numtrees_each_type[3] = 300, 0, 0;

(...)

	make_autotrees(numtrees_each_type, arb_entity);

(...)

But this can be called from within <sublevels.wdl> ,
for which reason <autotrees.wdl> should be included after.

And in these examples, the argument is required to be an array,
with each element the required number for tree-types 1, 2, 3 ...

var numtrees_each_type[3] = 100, 50, 80;

(...)

	make_autotrees(numtrees_each_type, me);

(...)

fits directly into canyon_details() ,
which already gets called with me= sublevel.

*/