include <speclight.wdl>;

MATERIAL bumpmap
{
   effect
   "
matrix matWorldViewProj;
matrix matWorld;
 
texture entSkin1;
texture entSkin2;
 
vector vecLight;
		 
technique dot3map
{
	pass p0
	{
		Texture[0] = <entSkin2>;//2te Skin im Model ist die Normal Map
		Texture[1] = <entSkin1>;//1te Skin im Model ist die Textur
				
		COLOROP[0] = dotproduct3;
		COLORARG1[0] = texture;
		COLORARG2[0] = diffuse;
				
		COLOROP[1] = modulate;
		COLORARG1[1] = texture;
		COLORARG2[1] = current;
		
		VertexShaderConstant[0]=<matWorldViewProj>;
		VertexShaderConstant[4]=<matWorld>;
		VertexShaderConstant[18]={1f,1f,1f,1f};
		VertexShaderConstant[19]={0.5f,0.5f,0.5f,0.5f};
		VertexShaderConstant[20]= <vecLight>;
		VertexShaderConstant[30]={0f,1f,0f,0f};
		VertexShaderConstant[31]={1f,0f,0f,0f};
		VertexShaderConstant[32]={0f,0f,1f,0f};
		VertexShaderConstant[90]={1f,0f,0f,0f}; //damit oFog gefllt ist
		
		VertexShader =
		decl
		{
			stream 0;
			float v0[3]; //Position
			float v3[3]; //Normal
			float v7[2]; //Textur Koordinaten 0
		}
		asm
		{
			vs.1.0
			m4x4 oPos, v0, c0
			m4x4 r10,v0,c4
			m3x3 r8,v3,c4
			mov oT0, v7
			mov oT1, v7
			mov oT2, v7
			mov oT3, v7
			
			//calculate texture space matrix from normal and up
			mul r0,c31,v3.zxyw //-1,0,0
			mul r1,c32,v3.yzxw //0,0,-1
			sub r0,r1,r0
			
			dp3 r0.w,r0,r0
			rsq r0.w,r0.w
			mul r0,r0,r0.w //normalized right vector
			
			mov r1, c30 //0,-1,0
			mov r2, r8
			
			sub r9,c20,r10
			
			dp3 r9.w,r9,r9
			rsq r9.w,r9.w
			mul r9,r9,r9.w //normalized light vector
			
			m3x3 r3,r9,r0
			mov r3.w,c30.w  //transform light to texture space
			
			add r3,r3,c18 //bias
			mul r3,r3,c19//scale
			mov oD0,r3
			mov oFog,c90
		};
	}
}
   ";
}

action Shader_bumpmap
{
 my.material=bumpmap; 
}  