//////////////////////////////////////////////////////////////
/* this program writes out a file that looks like this:


// include this file in your main c-script file
// place any model in your level and attach it the flicker1 action

action flicker1
{
	while (1)
	{
		my.lightred = 250;
		my.lightgreen = 40;
		my.lightblue = 100;
		my.lightrange = 200;
		waitt (2);
		my.lightrange = 0;
		waitt (3);
	}
}


*/

//////////////////////////////////////////////////////////////
include <sprkgen.wdl>; //simple particle generator
include <explosions.wdl>; //boom

var video_mode = 7; // 800x600
var video_depth = 16; // 16 bit mode

var red = 50;
var green = 120;
var blue = 220;

var gravity;
var alpha;

var rsin1 = 0;
var rsin2 = 0;

var size = 5;
var life = 20;
var num = 12;
var rand = 5;

var distance = 300; // light range
var interval1 = 2;
var interval2 = 1;
var height = 100; // distance to the ground

var filehandle;

var counter;
var beam_counter;

//////////////////////////////////////////////////////////////

//font univers_font =  <univers.pcx>, 7, 9;

font univers_font = "Arial",1,12; // truetype font

font albertus_font = <albertus.pcx>, 11, 11;

//////////////////////////////////////////////////////////////

bmap arrow_pcx = <arrow.pcx>;
bmap slider_pcx = <slider2.pcx>;
bmap panel_pcx = <panel3.pcx>;
bmap save_pcx = <save.pcx>;

bmap spark_pcx = <sparkb.pcx>;
bmap fire_pcx = <fireb.pcx>;
bmap smoke_pcx = <Smokeb.pcx>;
bmap water_pcx = <Waterb.pcx>;


bmap beam_pcx = <rdlchk.pcx>;
bmap beam2_pcx = <rdl.pcx>;

bmap bon_pcx = <beamon.pcx>;
bmap boff_pcx = <beamoff.pcx>;

bmap rgravity_pcx = <rarrow.pcx>;
bmap lgravity_pcx = <larrow.pcx>;

bmap rsin1_pcx = <rarrow.pcx>;
bmap lrsin1_pcx = <larrow.pcx>;

bmap rsin2_pcx = <rarrow.pcx>;
bmap lrsin2_pcx = <larrow.pcx>;

bmap quit_pcx = <quit.pcx>;

//////////////////////////////////////////////////////////////

sound beep_sound = <beep.wav>;

//////////////////////////////////////////////////////////////

string flickgen_wmb = <flickgen.wmb>;

//string function1_str = "                         "; // holds the action name
//string function2_str = "                         "; // holds the action name
//string function3_str = "                         "; // holds the action name

string action1_str = "                         "; // holds the action name

string bmap_str = "                           "; // holds the bmap name

string beam_str = "                           "; // holds the beam name
string streak_str = "                           "; // holds the streak name


string action2_str = "                         "; // holds the action name

string filename_str = "                         "; // holds the file name

string empty_str = ""; // an empty string
string content_str; // holds the content of the file
string indent_str = "    "; // 4 spaces here but you can use any other indent value
string temp_str = "     "; // just a temporary string used to convert numbers to strings

//////////////////////////////////////////////////////////////

function mouse_init();
function save_file();
function quit();


entity* warlock_3;

//video_window(nullvector,nullvector,48,"My Window Title Goes Here"); 

/*
define CHECKMARK_OFF, 0;
define CHECKMARK_ON, 30;
//bmap panel_bmp, <panel.pcx>;
bmap checkboxUnchecked, <checkbox.pcx>, 0, 0, 30, 20;
bmap checkmark, <checkbox.pcx>; // same pcx file, contains checked and blank image
var checkbox_state = CHECKMARK_OFF; // contains checkbox state, start unchecked

panel sample_pan {
	layer 90;
	//bmap panel_bmp;
	pos_x  60; pos_y  0;

	button 10, 240, checkboxUnchecked,  checkboxUnchecked, checkboxUnchecked, null, checkbox_action, null;
	window 10, 240, 20, 20, checkmark, checkbox_state, 0;

	flags  overlay, refresh, d3d, visible;
}

function checkbox_action() {
	if(checkbox_state == CHECKMARK_OFF) {
		checkbox_state = CHECKMARK_ON;
		str_cat (beam2_str, "on"); // if pushed during save cycle
	}
	else {
		checkbox_state = CHECKMARK_OFF;
		//str_cat (beam2_str, "off"); // if pushed during save cycle
	}
}*/



//////////////////////////////////////////////////////////////

panel adjust_pan // main panel
{ 
	bmap = panel_pcx;

	layer = 20; 
	pos_x = 0; 
	pos_y = 0; 
	vslider = 2, 10, 100, slider_pcx, 0, 255, red; 
	vslider = 22, 10, 100, slider_pcx, 0, 255, green; 
	vslider = 42, 10, 100, slider_pcx, 0, 255, blue; 

	vslider = 150, 10, 100, slider_pcx, 1, 100, size; 

	vslider = 185, 10, 100, slider_pcx, 1, 100, life;
	vslider = 222, 10, 100, slider_pcx, 1, 100, num;
	vslider = 262, 10, 100, slider_pcx, 0, 100, rand;

	vslider = 62, 10, 100, slider_pcx, 1, 100, interval1; 
	vslider = 82, 10, 100, slider_pcx, 1, 100, interval2; 
	vslider = 102, 10, 100, slider_pcx, 0, 500, distance; 
	vslider = 122, 10, 100, slider_pcx, 10, 500, height; 
	flags = d3d, overlay, refresh, visible; 
}

panel digits_pan // shows the rgb... values
{
	layer = 21;	// appears over adjust_pan
	pos_x = 0;
	pos_y = 0;
	digits = 0, 126, 3, univers_font, 1, red;
	digits = 20, 134, 3, univers_font, 1, green;
	digits = 40, 126, 3, univers_font, 1, blue;


	digits = 220, 235, 1, univers_font, 1, rsin1;
	digits = 220, 255, 1, univers_font, 1, rsin2;

	digits = 155, 128, 1, univers_font, 1, size;
	digits = 220, 275, .25, univers_font, 1, gravity;

	digits = 220, 295, 1, univers_font, 1, alpha;

	digits = 192, 128, 1, univers_font, 1, life;
	digits = 225, 128, 1, univers_font, 1, num;
	digits = 265, 128, 1, univers_font, 1, rand;

	digits = 60, 134, 3, univers_font, 1, interval1;
	digits = 80, 126, 3, univers_font, 1, interval2;
	digits = 100, 134, 3, univers_font, 1, distance;
	digits = 120, 126, 3, univers_font, 1, height;
	flags = d3d, overlay, refresh, visible;
}

panel save_pan // shows the save button
{
	bmap = save_pcx;
	layer = 21;	// appears over adjust_pan
	pos_x = 10;
	pos_y = 260;
	flags = d3d, overlay, refresh, visible;
	on_click save_file;
}

panel bmp1_pan // shows the spark pcx button
{
	bmap = spark_pcx;
	layer = 21;	// appears over adjust_pan
	pos_x = 140;
	pos_y = 180;
	flags = d3d, overlay, refresh, visible;
	on_click sprk_bmp;
}



panel bmp2_pan // shows the fire pcx button
{
	bmap = fire_pcx;
	layer = 21;	// appears over adjust_pan
	pos_x = 175;
	pos_y = 180;
	flags = d3d, overlay, refresh, visible;
	on_click fire2_bmp;
}

panel bmp3_pan // shows the smoke pcx button
{
	bmap = smoke_pcx;
	layer = 21;	// appears over adjust_pan
	pos_x = 210;
	pos_y = 180;
	flags = d3d, overlay, refresh, visible;
	on_click smoke2_bmp;
}

panel bmp4_pan // shows the water pcx button
{
	bmap = water_pcx;
	layer = 21;	// appears over adjust_pan
	pos_x = 245;
	pos_y = 180;
	flags = d3d, overlay, refresh, visible;
	on_click water2_bmp;
}

panel bon_pan // shows the beam on/off button
{
	bmap = bon_pcx;
	layer = 21;	// appears over adjust_pan
	pos_x = 140;
	pos_y = 240;
	flags = d3d, overlay, refresh; //visible;
	//on_click bon_bmp;
}

panel boff_pan // shows the beam on/off button
{
	bmap = boff_pcx;
	layer = 21;	// appears over adjust_pan
	pos_x = 180;
	pos_y = 240;
	flags = d3d, overlay, refresh; //visible;
	//on_click boff_bmp;
}

panel rgravity_pan // shows the beam on/off button
{
	bmap = rgravity_pcx;
	layer = 22;	// appears over adjust_pan
	pos_x = 180;
	pos_y = 270;
	flags = d3d, overlay, refresh, visible; //visible;
	on_click rgravity_bmp;
}


panel lgravity_pan // shows the beam on/off button
{
	bmap = lgravity_pcx;
	layer = 22;	// appears over adjust_pan
	pos_x = 140;
	pos_y = 270;
	flags = d3d, overlay, refresh, visible; //visible;
	on_click lgravity_bmp;
}

panel ralpha_pan // shows the beam on/off button
{
	bmap = rgravity_pcx;
	layer = 22;	// appears over adjust_pan
	pos_x = 180;
	pos_y = 290;
	flags = d3d, overlay, refresh, visible; //visible;
	on_click ralpha_bmp;
}


panel lalpha_pan // shows the beam on/off button
{
	bmap = lgravity_pcx;
	layer = 22;	// appears over adjust_pan
	pos_x = 140;
	pos_y = 290;
	flags = d3d, overlay, refresh, visible; //visible;
	on_click lalpha_bmp;
}
panel rsin1_pan // shows the beam on/off button
{
	bmap = rsin1_pcx;
	layer = 22;	// appears over adjust_pan
	pos_x = 180;
	pos_y = 230;
	flags = d3d, overlay, refresh, visible; //visible;
	on_click rsin1_bmp;
}


panel lrsin1_pan // shows the beam on/off button
{
	bmap = lrsin1_pcx;
	layer = 22;	// appears over adjust_pan
	pos_x = 140;
	pos_y = 230;
	flags = d3d, overlay, refresh, visible; //visible;
	on_click lrsin1_bmp;
}


panel rsin2_pan // shows the beam on/off button
{
	bmap = rsin2_pcx;
	layer = 22;	// appears over adjust_pan
	pos_x = 180;
	pos_y = 250;
	flags = d3d, overlay, refresh, visible; //visible;
	on_click rsin2_bmp;
}


panel lrsin2_pan // shows the beam on/off button
{
	bmap = lrsin2_pcx;
	layer = 22;	// appears over adjust_pan
	pos_x = 140;
	pos_y = 250;
	flags = d3d, overlay, refresh, visible; //visible;
	on_click lrsin2_bmp;
}


panel quit_pan // shows the quit button
{
	bmap = quit_pcx;
	layer = 21;	// appears over adjust_pan
	pos_x = 10;
	pos_y = 290;
	flags = d3d, overlay, refresh, visible;
	on_click quit;
}

text action1_txt // prompts for the action name
{
	layer = 21;
	pos_x = 55;
	pos_y = 159;
	font = albertus_font;
	string = action1_str;
}

text bmap_txt // prompts for the bmap name
{
	layer = 21;
	pos_x = 170;
	pos_y = 159;
	font = albertus_font;
	string = bmap_str;
}
text action2_txt // prompts for the action name
{
	layer = 21;
	pos_x = 55;
	pos_y = 189;
	font = albertus_font;
	string = action2_str;
}

text beam_txt // prompts for the bmap name
{
	layer = 21;
	pos_x = 175;
	pos_y = 220;
	font = albertus_font;
	string = beam_str;
}

text streak_txt // prompts for the bmap name
{
	layer = 21;
	pos_x = 245;
	pos_y = 220;
	font = albertus_font;
	string = streak_str;
}

/*
text function1_txt // prompts for the function name
{
	layer = 21;
	pos_x = 55;
	pos_y = 217;
	font = albertus_font;
	string = function1_str;
}


text function2_txt // prompts for the function name
{
	layer = 21;
	pos_x = 55;
	pos_y = 249;
	font = albertus_font;
	string = function2_str;
}


text function3_txt // prompts for the function name
{
	layer = 21;
	pos_x = 55;
	pos_y = 279;
	font = albertus_font;
	string = function3_str;
}*/

text filename_txt // prompts for the file name
{
	//blue = 111; //truetype font color
	layer = 21;
	pos_x = 55;
	pos_y = 219;
	font = albertus_font;
	//font = univers_font; //truetype font	
	string = filename_str;
}

//////////////////////////////////////////////////////////////

function main()
{
	
	d3d_lightres = 1; // better dynamic lights
	level_load (flickgen_wmb);
	wait (2);
	mouse_init(); 
}	

function mouse_init()
{
	mouse_map = arrow_pcx;
	mouse_mode = 2;
	while (1)
	{
		mouse_pos.x = pointer.x;
		mouse_pos.y = pointer.y;
		wait (1); 		      
	}   
}

action camera_init
{
	my.invisible = on;
	my.passable = on;
	vec_set (camera.pos, my.pos);
	camera.pan = my.pan;
	camera.tilt = my.tilt;
}

action flicker
{
	//	my.invisible = on; // remove the comment if you want to hide the light generator
	my.passable = on; 
	while (1)
	{
		my.z = height;
		my.lightred = red;
		my.lightgreen = green;
		my.lightblue = blue;
		my.lightrange = distance;
		waitt (interval1);
		my.lightrange = 0;
		waitt (interval2);
	}
}

function save_file()
{
	beep;
	action1_txt.visible = on; // show the text
	str_cpy (action1_str, empty_str);
	while (str_cmpi (action1_str, empty_str) == 1) // make sure that the player has typed something
	{		
		inkey	action1_str; // show the cursor -> store the input in filename_str
		
		wait (1);
	}
	beep;
	bmap_txt.visible = on; // show the text
	str_cpy (bmap_str, empty_str);
	while (str_cmpi (bmap_str, empty_str) == 1) // make sure that the player has typed something
	{		
		inkey	bmap_str; // show the cursor -> store the input in filename_str
		
		wait (1);
		
	}

	beep;
	beam_txt.visible = on; // show the text
	str_cpy (beam_str, empty_str);
	while (str_cmpi (beam_str, empty_str) == 1) // make sure that the player has typed something
	{		
		inkey	beam_str; // show the cursor -> store the input in filename_str
		
		wait (1);
		
	}

	beep;
	streak_txt.visible = on; // show the text
	str_cpy (streak_str, empty_str);
	while (str_cmpi (streak_str, empty_str) == 1) // make sure that the player has typed something
	{		
		inkey	streak_str; // show the cursor -> store the input in filename_str
		
		wait (1);
		
	}

	beep;
	action2_txt.visible = on; // show the text
	str_cpy (action2_str, empty_str);
	while (str_cmpi (action2_str, empty_str) == 1) // make sure that the player has typed something
	{		
		inkey	action2_str; // show the cursor -> store the input in filename_str
		
		wait (1);
	}

	/*     beep;
	function1_txt.visible = on; // show the text
	str_cpy (function1_str, empty_str);
	while (str_cmpi (function1_str, empty_str) == 1) // make sure that the player has typed something
	{		
		inkey	function1_str; // show the cursor -> store the input in filename_str
		
		wait (1);
	}
	beep;
	function2_txt.visible = on; // show the text
	str_cpy (function2_str, empty_str);
	while (str_cmpi (function2_str, empty_str) == 1) // make sure that the player has typed something
	{		
		inkey	function2_str; // show the cursor -> store the input in filename_str
		
		wait (1);
	}
	beep;
	function3_txt.visible = on; // show the text
	str_cpy (function3_str, empty_str);
	while (str_cmpi (function3_str, empty_str) == 1) // make sure that the player has typed something
	{		
		inkey	function3_str; // show the cursor -> store the input in filename_str
		
		wait (1);
	}*/

	filename_txt.visible = on; // show the text
	str_cpy (filename_str, empty_str); // clear previous inputs
	while (str_cmpi (filename_str, empty_str) == 1) // make sure that the player has typed something
	{		
		inkey	filename_str; // show the cursor -> store the input in filename_str
		wait (1);
	}
	waitt (16); // wait a second
	
	//function1_txt.visible = off; // hide the text
	//function2_txt.visible = off; // hide the text
	//function3_txt.visible = off; // hide the text

	action1_txt.visible = off; // hide the text
	
	bmap_txt.visible = off; // hide the text
	beam_txt.visible = off; // hide the text
	streak_txt.visible = off; // hide the text

	action2_txt.visible = off; // hide the text

	filename_txt.visible = off; // hide the text

	str_cpy (content_str, empty_str); // clear the string
	str_cat (content_str, "// include this file in your main c-script file\n// place any model in your level and attach it the ");
	str_cat (content_str, action1_str);
	str_cat (content_str, " action");
	str_cat (content_str, "\n\naction ");
	str_cat (content_str, action1_str);
	str_cat (content_str, "\n{\n");
		str_cat (content_str, indent_str);
		str_cat (content_str, "while (1)\n");
		str_cat (content_str, indent_str);
		str_cat (content_str, "{\n");     	
			str_cat (content_str, indent_str);
			str_cat (content_str, indent_str);
			str_cat (content_str, "my.lightred = ");
			red = int(red);
			str_for_num (temp_str, red);
			str_cat (content_str, temp_str);
			str_cat (content_str, ";\n");
			str_cat (content_str, indent_str);
			str_cat (content_str, indent_str);
			str_cat (content_str, "my.lightgreen = ");
			green = int(green);
			str_for_num (temp_str, green);
			str_cat (content_str, temp_str);
			str_cat (content_str, ";\n");
			str_cat (content_str, indent_str);
			str_cat (content_str, indent_str);
			str_cat (content_str, "my.lightblue = ");
			blue = int(blue);
			str_for_num (temp_str, blue);
			str_cat (content_str, temp_str);
			str_cat (content_str, ";\n");
			str_cat (content_str, indent_str);
			str_cat (content_str, indent_str);
			str_cat (content_str, "my.lightrange = ");
			distance = int(distance);
			str_for_num (temp_str, distance);
			str_cat (content_str, temp_str);
			str_cat (content_str, ";\n");
			str_cat (content_str, indent_str);
			str_cat (content_str, indent_str);
			str_cat (content_str, "waitt (");
			interval1 = int(interval1);
			str_for_num (temp_str, interval1);
			str_cat (content_str, temp_str);
			str_cat (content_str, ");\n");
			str_cat (content_str, indent_str);
			str_cat (content_str, indent_str);
			str_cat (content_str, "my.lightrange = 0;\n");
			str_cat (content_str, indent_str);
			str_cat (content_str, indent_str);
			str_cat (content_str, "waitt (");
			interval2 = int(interval2);
			str_for_num (temp_str, interval2);
			str_cat (content_str, temp_str);
			str_cat (content_str, ");\n");
			str_cat (content_str, indent_str);
		str_cat (content_str, "}\n");
	str_cat (content_str, "}");
	//str_cpy (content_str, empty_str); // clear the string

	str_cat (content_str, "\n\nvar vec[3]; //vector direction");
	str_cat (content_str, "\nvar tumblespeed[3] = 10,0,0;");
	str_cat (content_str, "// sets the vector to a random direction and length (max. range)");
	str_cat (content_str, "\n\nfunction r_vec");
	//str_cat (content_str, function1_str);
	str_cat (content_str, "(&vec,range)");
	str_cat (content_str, "\n{\n");
		str_cat (content_str, "vec[0] = random(1)-.5;\n");
		str_cat (content_str, "vec[1] = random(1)-.5;\n");
		str_cat (content_str, "vec[2] = random(1)-.5;\n");
		str_cat (content_str, "vec_normalize(vec,random(range));\n");
	str_cat (content_str, "}\n");

	str_cat (content_str, "\n\nfunction a_fade");
	//str_cat (content_str, function2_str);
	str_cat (content_str, "()");
	str_cat (content_str, "\n{\n");
		str_cat (content_str, "my.alpha -=  2 * time;\n");
		str_cat (content_str, "my.vel_x == my.vel_x * .05;\n");
		str_cat (content_str, "my.vel_y == my.vel_y * .05;\n");
		str_cat (content_str, "if (my.alpha <= 0) { my.lifespan = 0; }\n");
	str_cat (content_str, "}\n\n");

	str_cat (content_str, "BMAP spark_map1,<");
	str_cat (content_str,bmap_str);
	str_cat (content_str, ">;  // changed to add my own sprite");
	str_cat (content_str, "\nbmap* scatter1_map = spark_map1;");

	str_cat (content_str, "\n\nfunction p_atrib");
	//str_cat (content_str, function3_str);
	str_cat (content_str, "()");
	str_cat (content_str, "\n{\n"); 


		//str_cat (content_str, function1_str);
		str_cat (content_str, "my.x+=random (");
		rsin1 = int(rsin1);
		str_for_num (temp_str, rsin1);
		str_cat (content_str, temp_str);
		str_cat (content_str, "*(sin(total_ticks*200) * cos(total_ticks*5)));\n");


		//str_cat (content_str, function1_str);
		str_cat (content_str, "my.x+=random (");
		rsin2 = int(rsin2);
		str_for_num (temp_str, rsin2);
		str_cat (content_str, temp_str);
		str_cat (content_str, "*(sin(total_ticks*20) * cos(total_ticks*50)));\n");




		//str_cat (content_str, "my.x+=random (7*(sin(total_ticks*200) * cos(total_ticks*5)));\n");
		//str_cat (content_str, "my.y+=random (7*(sin(total_ticks*20) * sin(total_ticks*50)));\n");

		//str_cat (content_str, function1_str);
		str_cat (content_str, "r_vec(temp,");
		rand = int(rand);
		str_for_num (temp_str, rand);
		str_cat (content_str, temp_str);
		str_cat (content_str, ");\n");

		str_cat (content_str, "vec_add (my.vel_x, temp);\n");


		str_cat (content_str, "my.gravity = ");
		gravity = int(gravity);
		str_for_num (temp_str, gravity);


		str_cat (content_str, temp_str);
		str_cat (content_str, ";\n");



		str_cat (content_str, "my.beam = ");		
		str_cat (content_str, beam_str);

		str_cat (content_str, ";\n");

		str_cat (content_str, "my.streak = ");		
		str_cat (content_str, streak_str);

		str_cat (content_str, ";\n");


		str_cat (content_str, "my.alpha = random(50) + ");
		alpha = int(alpha);
		str_for_num (temp_str, alpha);

		str_cat (content_str, temp_str);
		str_cat (content_str, ";\n");

		str_cat (content_str, "my.bmap = scatter1_map;\n");


		str_cat (content_str, "my.size = ");
		size = int(size);
		str_for_num (temp_str, size);
		str_cat (content_str, temp_str);
		str_cat (content_str, ";\n");
		str_cat (content_str, "my.flare = on;\n");
		str_cat (content_str, "my.bright = off;\n");
		str_cat (content_str, "my.move = on;\n");
		str_cat (content_str, "my.lifespan = ");
		life = int(life);
		str_for_num (temp_str, life);
		str_cat (content_str, temp_str);
		str_cat (content_str, ";\n");
		str_cat (content_str, "my.function = a_fade");
		//str_cat (content_str, function2_str);
		str_cat (content_str, ";");
	str_cat (content_str, "\n}\n");

	str_cat (content_str, "\n\naction ");
	str_cat (content_str, action2_str);
	str_cat (content_str, "\n{\n");
		str_cat (content_str, "while (1)\n");
		str_cat (content_str, "{\n");     
			str_cat (content_str, "vec_scale(normal,2);\n");
			str_cat (content_str, "effect(p_atrib");
			//str_cat (content_str, function3_str);
			str_cat (content_str, ",");
			num = int(num);
			str_for_num (temp_str, num);
			str_cat (content_str, temp_str);
			str_cat (content_str, ",my.x,normal);\n");
			str_cat (content_str, "wait(1);\n");
		str_cat (content_str, "}\n");
	str_cat (content_str, "}");


	str_cat (filename_str, ".wdl");
	filehandle = file_open_write (filename_str);
	file_str_write (filehandle, content_str);
	file_close (filehandle);	
}


function sprk_bmp()
{
	str_cat (bmap_str, "spark.pcx");
	counter = 1;
}

function fire2_bmp()
{
	str_cat (bmap_str, "fire2.tga");
	counter = 2;
}

function smoke2_bmp()
{
	str_cat (bmap_str, "smoke2.tga");
	counter = 3;
}

function water2_bmp()
{
	str_cat (bmap_str, "water2.tga");
	counter = 4;
}

function beam_bmp()
{
	/*if(beam_counter == 1)
	{
		str_cat (beam_str, "off"); // if pushed during save cycle
	}
	else
	{
		if(beam_counter != 1)
		{
			str_cat (beam2_str, "on"); // if pushed during save cycle
		}
	}*/
	//counter = 5;

	return;
}

function beam2_bmp()
{
	//str_cat (beam2_str, "on"); // if pushed during save cycle
	//counter = 5;
	return;

}

var pan_counter;

function bon_bmp()
{
	while(1)
	{
		if(pan_counter < = 22)
		{
			bon_pan.visible = on;
			boff_pan.visible = off;
			pan_counter += 1;
		}
		else
		{
			bon_pan.visible = off;
			boff_pan.visible = on;
			pan_counter -= 1;
		}
		wait(1);
	}
	
}

function rgravity_bmp()
{
	rgravity_pan.visible = on;
	gravity += .25;
	//str_cat (beam2_str, "on"); // if pushed during save cycle
	//counter = 5;
	return;

}

function lgravity_bmp()
{
	lgravity_pan.visible = on;
	gravity -= .25;
	//str_cat (beam2_str, "on"); // if pushed during save cycle
	//counter = 5;
	return;

}

function ralpha_bmp()
{
	ralpha_pan.visible = on;
	alpha += 5;
	//str_cat (beam2_str, "on"); // if pushed during save cycle
	//counter = 5;
	return;

}

function lalpha_bmp()
{
	lalpha_pan.visible = on;
	alpha -= 5;
	//str_cat (beam2_str, "on"); // if pushed during save cycle
	//counter = 5;
	return;

}

function rsin1_bmp()
{
	rsin1_pan.visible = on;
	rsin1 += 3;
	//str_cat (beam2_str, "on"); // if pushed during save cycle
	//counter = 5;
	return;

}

function lrsin1_bmp()
{
	lrsin1_pan.visible = on;
	rsin1 -= 3;
	//str_cat (beam2_str, "on"); // if pushed during save cycle
	//counter = 5;
	return;

}


function rsin2_bmp()
{
	rsin2_pan.visible = on;
	rsin2 += 3;
	//str_cat (beam2_str, "on"); // if pushed during save cycle
	//counter = 5;
	return;

}

function lrsin2_bmp()
{
	lrsin2_pan.visible = on;
	rsin2 -= 3;
	//str_cat (beam2_str, "on"); // if pushed during save cycle
	//counter = 5;
	return;

}


function quit()
{
	exit; // exit the engine
}