#ifndef FMOD_DLL
#define FMOD_DLL

//////////////////////////////////////////////////////////////////////
// LITE-C FMOD WRAPPER PLUGIN DLL
//--------------------------------------------------------------------
// module       : FMOD wrapper plugin DLL header
// created (by) : Christian Behrenberg, 2007-01-04
//--------------------------------------------------------------------
// version      : 0.1 - 2007-05-10
//--------------------------------------------------------------------
//////////////////////////////////////////////////////////////////////

//- LITE-C FMOD WRAPPER DLL FUNCTION PROTOTYPES ----------------------

	//PRE INITIALIZATION / INITIALIZATION / ENUMERATION FUNCTIONS

		void	LC_FSOUND_Close();
		//		LC_FSOUND_File_SetCallbacks
		var		LC_FSOUND_Init(int mixrate, int maxsoftwarechannels, int flags);
		var		LC_FSOUND_SetBufferSize (int len_ms);
		var		LC_FSOUND_SetDriver (int driver);
		var		LC_FSOUND_SetHWND (void *hwnd);
		var		LC_FSOUND_SetMaxHardwareChannels (int max);
		//		LC_FSOUND_SetMemorySystem
		var		LC_FSOUND_SetMinHardwareChannels (int min);
		var		LC_FSOUND_SetMixer (int mixer);
		var		LC_FSOUND_SetOutput (int outputtype);
		
	//GLOBAL RUN-TIME UPDATE FUNCTIONS
	
		void	LC_FSOUND_SetPanSeperation (double pansep);
		void	LC_FSOUND_SetSFXMasterVolume (int volume);
		void	LC_FSOUND_SetSpeakerMode (int speakermode);
		void	LC_FSOUND_Update ();

	//GLOBAL RUN-TIME INFORMATION FUNCTIONS
	
		double	LC_FSOUND_GetCPUUsage();
		int 	LC_FSOUND_GetChannelsPlaying();
		int 	LC_FSOUND_GetDriver ();
		//		LC_FSOUND_GetDriverCaps
			//substitutes:
			var 	LC_FSOUND_GetDriverCaps_HARDWARE (int driver);
			var 	LC_FSOUND_GetDriverCaps_EAX2 (int driver);
			var 	LC_FSOUND_GetDriverCaps_EAX3 (int driver);
		char*	LC_FSOUND_GetDriverName (int id);
		var 	LC_FSOUND_GetError ();
		var 	LC_FSOUND_GetMaxSamples ();
		int 	LC_FSOUND_GetMaxChannels ();
		void	LC_FSOUND_GetMemoryStats (int* currentalloced, int* maxalloced);
		var 	LC_FSOUND_GetNumDrivers ();
		var 	LC_FSOUND_GetNumHWChannels (int *num2d, int *num3d, int *total);
			//substitutes which return the selected value:
			var		LC_FSOUND_GetNumHWChannels_num2d ();
			var		LC_FSOUND_GetNumHWChannels_num3d ();
			var		LC_FSOUND_GetNumHWChannels_total ();
		var 	LC_FSOUND_GetOutput ();
		void*	LC_FSOUND_GetOutputHandle ();
		int 	LC_FSOUND_GetOutputRate ();
		var 	LC_FSOUND_GetSFXMasterVolume ();
		double 	LC_FSOUND_GetVersion ();

	//SAMPLE FUNCTIONS

		int		LC_FSOUND_Sample_Alloc (int index, int length, int mode, int deffreq, int defvol, int defpan, int defpri);
		void	LC_FSOUND_Sample_Free (int val);
		//int*	LC_FSOUND_Sample_Get (int sampno);
		BOOL	LC_FSOUND_Sample_GetDefaults (int val, int *deffreq, int *defvol, int *defpan, int *defpri);
		BOOL	LC_FSOUND_Sample_GetDefaultsEx (int val, int *deffreq, int *defvol, int *defpan, int *defpri, int *varfreq, int *varvol, int *varpan);
		int		LC_FSOUND_Sample_GetLength (int val);
		BOOL	LC_FSOUND_Sample_GetLoopPoints (int val, int *loopstart, int *loopend);
		BOOL	LC_FSOUND_Sample_GetMinMaxDistance (int val, float* min, float* max);
		int		LC_FSOUND_Sample_GetMode (int val);
		char*	LC_FSOUND_Sample_GetName (int val);
		int		LC_FSOUND_Sample_Load (int index, char *name_or_data, int inputmode, int offset, int length);
		//BOOL	LC_FSOUND_Sample_Lock (int* sptr, int offset, int length, void** ptr1, void** ptr2, int *len1, int* len2);
		BOOL	LC_FSOUND_Sample_SetDefaults (int val, int deffreq, int defvol, int defpan, int defpri);
		BOOL	LC_FSOUND_Sample_SetDefaultsEx (int val, int deffreq, int defvol, int defpan, int defpri, int varfreq, int varvol, int varpan);
		BOOL	LC_FSOUND_Sample_SetMaxPlaybacks (int val, int max);
		BOOL	LC_FSOUND_Sample_SetMinMaxDistance (int val, float min, float max);
		BOOL	LC_FSOUND_Sample_SetMode (int val, int mode);
		//BOOL	LC_FSOUND_Sample_SetLoopPoints (int* sptr, int loopstart, int loopend);
		//BOOL	LC_FSOUND_Sample_Unlock (int* sptr, void* ptr1, void* ptr2, int len1, int len2);
		//BOOL	LC_FSOUND_Sample_Upload (int* sptr, void* srcdata, int mode_in);

	//CHANNEL FUNCTIONS

 		int		LC_FSOUND_PlaySound (int channel, int val);
		//int	LC_FSOUND_PlaySoundEx(int channel, int* sptr, int* dspunit, BOOL startpaused);
		BOOL	LC_FSOUND_StopSound (int channel);
		BOOL	LC_FSOUND_SetFrequency (int channel, int freq);
		BOOL	LC_FSOUND_SetLoopMode (int channel, int loopmode);
		BOOL	LC_FSOUND_SetMute (int channel, int mute);
		BOOL	LC_FSOUND_SetPan (int channel, int pan);
		BOOL	LC_FSOUND_SetPaused (int channel, int paused);
		BOOL	LC_FSOUND_SetPriority (int channel, int priority);
		BOOL	LC_FSOUND_SetReserved (int channel, int reserved);
		BOOL	LC_FSOUND_SetSurround (int channel, int surround);
		BOOL	LC_FSOUND_SetPriority (int channel, int priority);
		BOOL	LC_FSOUND_SetVolume (int channel, int vol);
		BOOL	LC_FSOUND_SetVolumeAbsolute (int channel, int vol);
		BOOL	LC_FSOUND_SetVolumeAbsolute_global(int val); //(ext)
		int		LC_FSOUND_GetVolume (int channel);
		int		LC_FSOUND_GetAmplitude (int channel);
		//BOOL	LC_FSOUND_3D_SetAttributes (int channel, VECTOR* pos/*float *pos*/, float *vel);
		//BOOL	LC_FSOUND_3D_SetMinMaxDistance (int channel, float min, float max);
		BOOL	LC_FSOUND_SetCurrentPosition (int channel, int pos);
		int		LC_FSOUND_GetCurrentPosition (int channel);
		int		LC_FSOUND_GetCurrentSample (int channel);
		BOOL	LC_FSOUND_GetCurrentLevels (int channel, float *l, float *r);
		int		LC_FSOUND_GetFrequency (int channel);
		int		LC_FSOUND_GetLoopMode (int channel);
		int		LC_FSOUND_GetMixer ();
		BOOL	LC_FSOUND_GetMute (int channel);
		int		LC_FSOUND_GetNumSubChannels (int channel);
		int		LC_FSOUND_GetPan (int channel);
		BOOL	LC_FSOUND_GetPaused (int channel);
		int		LC_FSOUND_GetPriority (int channel);
		BOOL	LC_FSOUND_GetReserved (int channel);
		int		LC_FSOUND_GetSubChannel (int channel, int subchannel);
		BOOL	LC_FSOUND_GetSurround (int channel);
		BOOL	LC_FSOUND_IsPlaying (int channel);
		//BOOL	LC_FSOUND_3D_GetAttributes (int channel, float *pos, float *vel);
		//BOOL	LC_FSOUND_3D_GetMinMaxDistance(int channel, float* mindistance, float* maxdistance);

	//3D SOUND FUNCTIONS

		//void	LC_FSOUND_3D_Listener_GetAttributes (float *pos, float *vel, float *fx, float *fy, float *fz, float *tx, float *ty, float *tz);
		//void	LC_FSOUND_3D_Listener_SetAttributes (VECTOR* pos, VECTOR* vel);
		//void	LC_FSOUND_3D_Listener_SetCurrent (int current, int numlisteners);
		//void	LC_FSOUND_3D_SetDistanceFactor (float factor);
		//void	LC_FSOUND_3D_SetDopplerFactor (float scale);
		//void	LC_FSOUND_3D_SetRolloffFactor (float factor);

	//STREAM FUNCTIONS

		//int*	LC_FSOUND_Stream_AddSyncPoint (int* stream, int pcmoffset, char* name);
		BOOL	LC_FSOUND_Stream_Close (int val);
		//int*	LC_FSOUND_Stream_Create (void callback, int lenbytes, int mode, int samplerate, void* userdata);
		//int*	LC_FSOUND_Stream_CreateDSP (int* stream, void callback, int priority, void* userdata);
		//BOOL	LC_FSOUND_Stream_DeleteSyncPoint(void* point);
		BOOL	LC_FSOUND_Stream_FindTagField (int val, int type, char* name, void **value, int *length);
		int		LC_FSOUND_Stream_GetLength(int val);
		int		LC_FSOUND_Stream_GetLengthMs(int val);
		double 	LC_FSOUND_Stream_GetLengthSecs(int val); //ext
		int		LC_FSOUND_Stream_GetMode (int val);
		int		LC_FSOUND_Stream_GetNumSubStreams (int val);
		int		LC_FSOUND_Stream_GetNumSyncPoints (int val);
		BOOL	LC_FSOUND_Stream_GetNumTagFields (int val, int *num);
		int		LC_FSOUND_Stream_GetOpenState (int val);
		int		LC_FSOUND_Stream_GetPosition (int val);
		//int*	LC_FSOUND_Stream_GetSample (int* stream);
		//int*	LC_FSOUND_Stream_GetSyncPoint(int* stream, int index);
		//int*	LC_FSOUND_Stream_GetSyncPoint (int* stream, int index);
		BOOL	LC_FSOUND_Stream_GetTagField(int val, int num, int *type, char **name, void **value, int *length);
		int		LC_FSOUND_Stream_GetTime (int val);
		double	LC_FSOUND_Stream_GetTime_secs(int val); //(ext)
		//BOOL	LC_FSOUND_Stream_Net_GetBufferProperties(int* buffersize, int* prebuffer_percent, int* rebuffer_percent);
		BOOL*	LC_FSOUND_Stream_Net_GetLastServerStatus ();
		BOOL	LC_FSOUND_Stream_Net_GetStatus (int val, int *status, int *bufferused, int *bitrate, unsigned int *flags);
		BOOL	LC_FSOUND_Stream_Net_SetBufferProperties (int buffersize, int prebuffer_percent, int rebuffer_percent);
		//BOOL	LC_FSOUND_Stream_Net_SetMetadataCallback (int* stream, void* callback, void* userdata);
		BOOL	LC_FSOUND_Stream_Net_SetProxy (char *proxy);
		int		LC_FSOUND_Stream_Open (char* name_or_data, int mode, int offset, int length);
		int		LC_FSOUND_Stream_Play (int channel, int val);
		//int	LC_FSOUND_Stream_PlayEx (int channel, int* stream, int* dspunit, BOOL paused);
		BOOL	LC_FSOUND_Stream_SetBufferSize (int ms);
		//BOOL	LC_FSOUND_Stream_SetEndCallback(int* stream, void* callback, void* userdata);
		BOOL	LC_FSOUND_Stream_SetLoopCount (int val, int count);
		//BOOL	LC_FSOUND_Stream_SetLoopPoints (int* stream, int loopstart, int loopend);
		BOOL	LC_FSOUND_Stream_SetMode (int val, int mode);
		BOOL	LC_FSOUND_Stream_SetPosition (int val, int bytes);
		BOOL	LC_FSOUND_Stream_SetSubStream (int val, int index);
		//BOOL	LC_FSOUND_Stream_SetSubStreamSentence (int* stream, int* sentencelist, int numitems);
		//BOOL	LC_FSOUND_Stream_SetSyncCallback (int* stream, void* callback, void* userdata);
		BOOL	LC_FSOUND_Stream_SetTime (int val, int ms);
		BOOL	LC_FSOUND_Stream_SetTime_secs (int val, double secs);
		BOOL	LC_FSOUND_Stream_Stop (int val);

	//CD FUNCTIONS

		int		LC_FSOUND_CD_GetNumTracks (char* drive);
		BOOL	LC_FSOUND_CD_GetPaused (char* drive);
		int		LC_FSOUND_CD_GetTrack (char* drive);
		int		LC_FSOUND_CD_GetTrackLength (char* drive, int track);
		double	LC_FSOUND_CD_GetTrackLength_secs (char* drive, int track); //(ext)
		int		LC_FSOUND_CD_GetTrackTime (char* drive);
		double	LC_FSOUND_CD_GetTrackTime_secs (char* drive); //(ext)
		int		LC_FSOUND_CD_GetVolume (char* drive);
		BOOL	LC_FSOUND_CD_OpenTray (char* drive, int open);
		BOOL	LC_FSOUND_CD_Play (char drive, int track);
		BOOL	LC_FSOUND_CD_SetPaused (char* drive, int paused);
		void	LC_FSOUND_CD_SetPlayMode (char* drive, int mode);
		BOOL	LC_FSOUND_CD_SetTrackTime (char* drive, int ms);
		BOOL	LC_FSOUND_CD_SetVolume (char* drive, int volume);
		BOOL	LC_FSOUND_CD_Stop (char* drive);

	//DSP FUNCTIONS

		void	LC_FSOUND_DSP_ClearMixBuffer ();
		//int*	LC_FSOUND_DSP_Create (void* callback, int priority, void* userdata);
		void	LC_FSOUND_DSP_Free (int val);
		void	LC_FSOUND_DSP_SetActive (int val, BOOL active);
		var		LC_FSOUND_DSP_GetActive (int val);
		var		LC_FSOUND_DSP_GetBufferLength ();
		var		LC_FSOUND_DSP_GetBufferLengthTotal ();
		void	LC_FSOUND_DSP_SetPriority (int val, int priority);
		var		LC_FSOUND_DSP_GetPriority (int val);
		//		LC_FSOUND_DSP_Get...Unit
		//		substitute functions:
				void LC_FSOUND_DSP_OpenFFTUnit(); //(ext)
				void LC_FSOUND_DSP_CloseFFTUnit(); //(ext)
		float*	LC_FSOUND_DSP_GetSpectrum ();
		//BOOL	LC_FSOUND_DSP_MixBuffers (void* destbuffer, void* srcbuffer, int len, int freq, int vol, int pan, int mode);

	//FX FUNCTIONS
	
		//LC_FSOUND_FX_Disable
		//LC_FSOUND_FX_Enable
		//LC_FSOUND_FX_SetChorus
		//LC_FSOUND_FX_SetCompressor
		//LC_FSOUND_FX_SetDistortion
		//LC_FSOUND_FX_SetEcho
		//LC_FSOUND_FX_SetRanger
		//LC_FSOUND_FX_SetGargle
		//LC_FSOUND_FX_SetI3DL2Reverb
		//LC_FSOUND_FX_SetParamEQ
		//LC_FSOUND_FX_SetWavesReverb

	//REVERB FUNCTIONS

		//LC_FSOUND_Reverb_SetProperties
		//LC_FSOUND_Reverb_GetProperties
		//LC_FSOUND_Reverb_SetChannelProperties
		//LC_FSOUND_Reverb_GetChannelProperties

//- FMOD CONSTANTS, ENUMERATIONS & FLAGS -----------------------------

	// FSOUND_OUTPUTTYPES
	
		#define FSOUND_OUTPUT_NOSOUND				0
		#define FSOUND_OUTPUT_WINMM					1
		#define FSOUND_OUTPUT_DSOUND				2
		#define FSOUND_OUTPUT_A3D					3

		#define FSOUND_OUTPUT_OSS					4
		#define FSOUND_OUTPUT_ESD					5
		#define FSOUND_OUTPUT_ALSA					6

		#define FSOUND_OUTPUT_ASIO					7
		#define FSOUND_OUTPUT_XBOX					8
		#define FSOUND_OUTPUT_PS2					9
		#define FSOUND_OUTPUT_MAC					10
		#define FSOUND_OUTPUT_GC					11
		#define FSOUND_OUTPUT_PSP					12

		#define FSOUND_OUTPUT_NOSOUND_NONREALTIME	13

	// FSOUND_MIXERTYPES

		#define FSOUND_MIXER_AUTODETECT				0
		#define FSOUND_MIXER_BLENDMODE				1
		#define FSOUND_MIXER_MMXP5					2
		#define FSOUND_MIXER_MMXP6					3

		#define FSOUND_MIXER_QUALITY_AUTODETECT		4
		#define FSOUND_MIXER_QUALITY_FPU			5
		#define FSOUND_MIXER_QUALITY_MMXP5			6
		#define FSOUND_MIXER_QUALITY_MMXP6			7

		#define FSOUND_MIXER_MONO					8
		#define FSOUND_MIXER_QUALITY_MONO			9

		#define FSOUND_MIXER_MAX					10

	// FSOUND_DSP_PRIORITIES
	
		#define FSOUND_DSP_DEFAULTPRIORITY_CLEARUNIT        0
		#define FSOUND_DSP_DEFAULTPRIORITY_SFXUNIT          100
		#define FSOUND_DSP_DEFAULTPRIORITY_MUSICUNIT        200
		#define FSOUND_DSP_DEFAULTPRIORITY_USER             300
		#define FSOUND_DSP_DEFAULTPRIORITY_FFTUNIT          900
		#define FSOUND_DSP_DEFAULTPRIORITY_CLIPANDCOPYUNIT  1000

	// FSOUND_MODES
	
		#define FSOUND_LOOP_OFF      0x00000001
		#define FSOUND_LOOP_NORMAL   0x00000002
		#define FSOUND_LOOP_BIDI     0x00000004
		#define FSOUND_8BITS         0x00000008
		#define FSOUND_16BITS        0x00000010
		#define FSOUND_MONO          0x00000020
		#define FSOUND_STEREO        0x00000040
		#define FSOUND_UNSIGNED      0x00000080
		#define FSOUND_SIGNED        0x00000100
		#define FSOUND_DELTA         0x00000200
		#define FSOUND_IT214         0x00000400
		#define FSOUND_IT215         0x00000800
		#define FSOUND_HW3D          0x00001000
		#define FSOUND_2D            0x00002000
		#define FSOUND_STREAMABLE    0x00004000
		#define FSOUND_LOADMEMORY    0x00008000
		#define FSOUND_LOADRAW       0x00010000
		#define FSOUND_MPEGACCURATE  0x00020000
		#define FSOUND_FORCEMONO     0x00040000
		#define FSOUND_HW2D          0x00080000
		#define FSOUND_ENABLEFX      0x00100000
		#define FSOUND_MPEGHALFRATE  0x00200000
		#define FSOUND_IMAADPCM      0x00400000
		#define FSOUND_VAG           0x00800000
		#define FSOUND_NONBLOCKING   0x01000000
		#define FSOUND_GCADPCM       0x02000000
		#define FSOUND_MULTICHANNEL  0x04000000
		#define FSOUND_USECORE0      0x08000000
		#define FSOUND_USECORE1      0x10000000
		#define FSOUND_LOADMEMORYIOP 0x20000000
		#define FSOUND_IGNORETAGS    0x40000000
		#define FSOUND_STREAM_NET    0x80000000
	
		#define FSOUND_NORMAL       (FSOUND_16BITS | FSOUND_SIGNED | FSOUND_MONO)

	// FSOUND_CDPLAYMODES
	
		#define FSOUND_CD_PLAYCONTINUOUS    0
		#define FSOUND_CD_PLAYONCE          1
		#define FSOUND_CD_PLAYLOOPED        2
		#define FSOUND_CD_PLAYRANDOM        3

	// FSOUND_MISC_VALUES
	
		#define FSOUND_FREE             -1
		#define FSOUND_UNMANAGED        -2
		#define FSOUND_ALL              -3
		#define FSOUND_STEREOPAN        -1
		#define FSOUND_SYSTEMCHANNEL    -1000
		#define FSOUND_SYSTEMSAMPLE     -1000

	// FSOUND_REVERB_FLAGS
	
		#define FSOUND_REVERB_FLAGS_DECAYTIMESCALE        0x00000001
		#define FSOUND_REVERB_FLAGS_REFLECTIONSSCALE      0x00000002
		#define FSOUND_REVERB_FLAGS_REFLECTIONSDELAYSCALE 0x00000004
		#define FSOUND_REVERB_FLAGS_REVERBSCALE           0x00000008
		#define FSOUND_REVERB_FLAGS_REVERBDELAYSCALE      0x00000010
		#define FSOUND_REVERB_FLAGS_DECAYHFLIMIT          0x00000020
		#define FSOUND_REVERB_FLAGS_ECHOTIMESCALE         0x00000040
		#define FSOUND_REVERB_FLAGS_MODULATIONTIMESCALE   0x00000080
		#define FSOUND_REVERB_FLAGS_CORE0                 0x00000100
		#define FSOUND_REVERB_FLAGS_CORE1                 0x00000200
		#define FSOUND_REVERB_FLAGS_DEFAULT              (FSOUND_REVERB_FLAGS_DECAYTIMESCALE | FSOUND_REVERB_FLAGS_REFLECTIONSSCALE | FSOUND_REVERB_FLAGS_REFLECTIONSDELAYSCALE | FSOUND_REVERB_FLAGS_REVERBSCALE | FSOUND_REVERB_FLAGS_REVERBDELAYSCALE | FSOUND_REVERB_FLAGS_DECAYHFLIMIT | FSOUND_REVERB_FLAGS_CORE0 | FSOUND_REVERB_FLAGS_CORE1)

	// FSOUND_REVERB_PRESETS
	
		#define FSOUND_PRESET_OFF              {0,	7.5f,	1.00f, -10000, -10000, 0,   1.00f,  1.00f, 1.0f,  -2602, 0.007f, { 0.0f,0.0f,0.0f },   200, 0.011f, { 0.0f,0.0f,0.0f }, 0.250f, 0.00f, 0.25f, 0.000f, -5.0f, 5000.0f, 250.0f, 0.0f,   0.0f,   0.0f, 0x33f }
		#define FSOUND_PRESET_GENERIC          {0,	7.5f,	1.00f, -1000,  -100,   0,   1.49f,  0.83f, 1.0f,  -2602, 0.007f, { 0.0f,0.0f,0.0f },   200, 0.011f, { 0.0f,0.0f,0.0f }, 0.250f, 0.00f, 0.25f, 0.000f, -5.0f, 5000.0f, 250.0f, 0.0f, 100.0f, 100.0f, 0x3f }
		#define FSOUND_PRESET_PADDEDCELL       {1,	1.4f,	1.00f, -1000,  -6000,  0,   0.17f,  0.10f, 1.0f,  -1204, 0.001f, { 0.0f,0.0f,0.0f },   207, 0.002f, { 0.0f,0.0f,0.0f }, 0.250f, 0.00f, 0.25f, 0.000f, -5.0f, 5000.0f, 250.0f, 0.0f, 100.0f, 100.0f, 0x3f }
		#define FSOUND_PRESET_ROOM 	           {2,	1.9f,	1.00f, -1000,  -454,   0,   0.40f,  0.83f, 1.0f,  -1646, 0.002f, { 0.0f,0.0f,0.0f },    53, 0.003f, { 0.0f,0.0f,0.0f }, 0.250f, 0.00f, 0.25f, 0.000f, -5.0f, 5000.0f, 250.0f, 0.0f, 100.0f, 100.0f, 0x3f }
		#define FSOUND_PRESET_BATHROOM 	       {3,	1.4f,	1.00f, -1000,  -1200,  0,   1.49f,  0.54f, 1.0f,   -370, 0.007f, { 0.0f,0.0f,0.0f },  1030, 0.011f, { 0.0f,0.0f,0.0f }, 0.250f, 0.00f, 0.25f, 0.000f, -5.0f, 5000.0f, 250.0f, 0.0f, 100.0f,  60.0f, 0x3f }
		#define FSOUND_PRESET_LIVINGROOM       {4,	2.5f,	1.00f, -1000,  -6000,  0,   0.50f,  0.10f, 1.0f,  -1376, 0.003f, { 0.0f,0.0f,0.0f }, -1104, 0.004f, { 0.0f,0.0f,0.0f }, 0.250f, 0.00f, 0.25f, 0.000f, -5.0f, 5000.0f, 250.0f, 0.0f, 100.0f, 100.0f, 0x3f }
		#define FSOUND_PRESET_STONEROOM        {5,	11.6f,	1.00f, -1000,  -300,   0,   2.31f,  0.64f, 1.0f,   -711, 0.012f, { 0.0f,0.0f,0.0f },    83, 0.017f, { 0.0f,0.0f,0.0f }, 0.250f, 0.00f, 0.25f, 0.000f, -5.0f, 5000.0f, 250.0f, 0.0f, 100.0f, 100.0f, 0x3f }
		#define FSOUND_PRESET_AUDITORIUM       {6,	21.6f,	1.00f, -1000,  -476,   0,   4.32f,  0.59f, 1.0f,   -789, 0.020f, { 0.0f,0.0f,0.0f },  -289, 0.030f, { 0.0f,0.0f,0.0f }, 0.250f, 0.00f, 0.25f, 0.000f, -5.0f, 5000.0f, 250.0f, 0.0f, 100.0f, 100.0f, 0x3f }
		#define FSOUND_PRESET_CONCERTHALL      {7,	19.6f,	1.00f, -1000,  -500,   0,   3.92f,  0.70f, 1.0f,  -1230, 0.020f, { 0.0f,0.0f,0.0f },    -2, 0.029f, { 0.0f,0.0f,0.0f }, 0.250f, 0.00f, 0.25f, 0.000f, -5.0f, 5000.0f, 250.0f, 0.0f, 100.0f, 100.0f, 0x3f }
		#define FSOUND_PRESET_CAVE             {8,	14.6f,	1.00f, -1000,  0,      0,   2.91f,  1.30f, 1.0f,   -602, 0.015f, { 0.0f,0.0f,0.0f },  -302, 0.022f, { 0.0f,0.0f,0.0f }, 0.250f, 0.00f, 0.25f, 0.000f, -5.0f, 5000.0f, 250.0f, 0.0f, 100.0f, 100.0f, 0x1f }
		#define FSOUND_PRESET_ARENA            {9,	36.2f,	1.00f, -1000,  -698,   0,   7.24f,  0.33f, 1.0f,  -1166, 0.020f, { 0.0f,0.0f,0.0f },    16, 0.030f, { 0.0f,0.0f,0.0f }, 0.250f, 0.00f, 0.25f, 0.000f, -5.0f, 5000.0f, 250.0f, 0.0f, 100.0f, 100.0f, 0x3f }
		#define FSOUND_PRESET_HANGAR           {10,	50.3f,	1.00f, -1000,  -1000,  0,   10.05f, 0.23f, 1.0f,   -602, 0.020f, { 0.0f,0.0f,0.0f },   198, 0.030f, { 0.0f,0.0f,0.0f }, 0.250f, 0.00f, 0.25f, 0.000f, -5.0f, 5000.0f, 250.0f, 0.0f, 100.0f, 100.0f, 0x3f }
		#define FSOUND_PRESET_CARPETTEDHALLWAY {11,	1.9f,	1.00f, -1000,  -4000,  0,   0.30f,  0.10f, 1.0f,  -1831, 0.002f, { 0.0f,0.0f,0.0f }, -1630, 0.030f, { 0.0f,0.0f,0.0f }, 0.250f, 0.00f, 0.25f, 0.000f, -5.0f, 5000.0f, 250.0f, 0.0f, 100.0f, 100.0f, 0x3f }
		#define FSOUND_PRESET_HALLWAY          {12,	1.8f,	1.00f, -1000,  -300,   0,   1.49f,  0.59f, 1.0f,  -1219, 0.007f, { 0.0f,0.0f,0.0f },   441, 0.011f, { 0.0f,0.0f,0.0f }, 0.250f, 0.00f, 0.25f, 0.000f, -5.0f, 5000.0f, 250.0f, 0.0f, 100.0f, 100.0f, 0x3f }
		#define FSOUND_PRESET_STONECORRIDOR    {13,	13.5f,	1.00f, -1000,  -237,   0,   2.70f,  0.79f, 1.0f,  -1214, 0.013f, { 0.0f,0.0f,0.0f },   395, 0.020f, { 0.0f,0.0f,0.0f }, 0.250f, 0.00f, 0.25f, 0.000f, -5.0f, 5000.0f, 250.0f, 0.0f, 100.0f, 100.0f, 0x3f }
		#define FSOUND_PRESET_ALLEY 	       {14,	7.5f,	0.30f, -1000,  -270,   0,   1.49f,  0.86f, 1.0f,  -1204, 0.007f, { 0.0f,0.0f,0.0f },    -4, 0.011f, { 0.0f,0.0f,0.0f }, 0.125f, 0.95f, 0.25f, 0.000f, -5.0f, 5000.0f, 250.0f, 0.0f, 100.0f, 100.0f, 0x3f }
		#define FSOUND_PRESET_FOREST 	       {15,	38.0f,	0.30f, -1000,  -3300,  0,   1.49f,  0.54f, 1.0f,  -2560, 0.162f, { 0.0f,0.0f,0.0f },  -229, 0.088f, { 0.0f,0.0f,0.0f }, 0.125f, 1.00f, 0.25f, 0.000f, -5.0f, 5000.0f, 250.0f, 0.0f,  79.0f, 100.0f, 0x3f }
		#define FSOUND_PRESET_CITY             {16,	7.5f,	0.50f, -1000,  -800,   0,   1.49f,  0.67f, 1.0f,  -2273, 0.007f, { 0.0f,0.0f,0.0f }, -1691, 0.011f, { 0.0f,0.0f,0.0f }, 0.250f, 0.00f, 0.25f, 0.000f, -5.0f, 5000.0f, 250.0f, 0.0f,  50.0f, 100.0f, 0x3f }
		#define FSOUND_PRESET_MOUNTAINS        {17,	100.0f, 0.27f, -1000,  -2500,  0,   1.49f,  0.21f, 1.0f,  -2780, 0.300f, { 0.0f,0.0f,0.0f }, -1434, 0.100f, { 0.0f,0.0f,0.0f }, 0.250f, 1.00f, 0.25f, 0.000f, -5.0f, 5000.0f, 250.0f, 0.0f,  27.0f, 100.0f, 0x1f }
		#define FSOUND_PRESET_QUARRY           {18,	17.5f,	1.00f, -1000,  -1000,  0,   1.49f,  0.83f, 1.0f, -10000, 0.061f, { 0.0f,0.0f,0.0f },   500, 0.025f, { 0.0f,0.0f,0.0f }, 0.125f, 0.70f, 0.25f, 0.000f, -5.0f, 5000.0f, 250.0f, 0.0f, 100.0f, 100.0f, 0x3f }
		#define FSOUND_PRESET_PLAIN            {19,	42.5f,	0.21f, -1000,  -2000,  0,   1.49f,  0.50f, 1.0f,  -2466, 0.179f, { 0.0f,0.0f,0.0f }, -1926, 0.100f, { 0.0f,0.0f,0.0f }, 0.250f, 1.00f, 0.25f, 0.000f, -5.0f, 5000.0f, 250.0f, 0.0f,  21.0f, 100.0f, 0x3f }
		#define FSOUND_PRESET_PARKINGLOT       {20,	8.3f,	1.00f, -1000,  0,      0,   1.65f,  1.50f, 1.0f,  -1363, 0.008f, { 0.0f,0.0f,0.0f }, -1153, 0.012f, { 0.0f,0.0f,0.0f }, 0.250f, 0.00f, 0.25f, 0.000f, -5.0f, 5000.0f, 250.0f, 0.0f, 100.0f, 100.0f, 0x1f }
		#define FSOUND_PRESET_SEWERPIPE        {21,	1.7f,	0.80f, -1000,  -1000,  0,   2.81f,  0.14f, 1.0f,    429, 0.014f, { 0.0f,0.0f,0.0f },  1023, 0.021f, { 0.0f,0.0f,0.0f }, 0.250f, 0.00f, 0.25f, 0.000f, -5.0f, 5000.0f, 250.0f, 0.0f,  80.0f,  60.0f, 0x3f }
		#define FSOUND_PRESET_UNDERWATER       {22,	1.8f,	1.00f, -1000,  -4000,  0,   1.49f,  0.10f, 1.0f,   -449, 0.007f, { 0.0f,0.0f,0.0f },  1700, 0.011f, { 0.0f,0.0f,0.0f }, 0.250f, 0.00f, 1.18f, 0.348f, -5.0f, 5000.0f, 250.0f, 0.0f, 100.0f, 100.0f, 0x3f }

	//Non I3DL2 presets
	
		#define FSOUND_PRESET_DRUGGED          {23,	1.9f,	0.50f, -1000,  0,      0,   8.39f,  1.39f, 1.0f,  -115,  0.002f, { 0.0f,0.0f,0.0f },   985, 0.030f, { 0.0f,0.0f,0.0f }, 0.250f, 0.00f, 0.25f, 1.000f, -5.0f, 5000.0f, 250.0f, 0.0f, 100.0f, 100.0f, 0x1f }
		#define FSOUND_PRESET_DIZZY            {24,	1.8f,	0.60f, -1000,  -400,   0,   17.23f, 0.56f, 1.0f,  -1713, 0.020f, { 0.0f,0.0f,0.0f },  -613, 0.030f, { 0.0f,0.0f,0.0f }, 0.250f, 1.00f, 0.81f, 0.310f, -5.0f, 5000.0f, 250.0f, 0.0f, 100.0f, 100.0f, 0x1f }
		#define FSOUND_PRESET_PSYCHOTIC        {25,	1.0f,	0.50f, -1000,  -151,   0,   7.56f,  0.91f, 1.0f,  -626,  0.020f, { 0.0f,0.0f,0.0f },   774, 0.030f, { 0.0f,0.0f,0.0f }, 0.250f, 0.00f, 4.00f, 1.000f, -5.0f, 5000.0f, 250.0f, 0.0f, 100.0f, 100.0f, 0x1f }

	// FSOUND_REVERB_CHANNELFLAGS
	
		#define FSOUND_REVERB_CHANNELFLAGS_DIRECTHFAUTO  0x00000001
		#define FSOUND_REVERB_CHANNELFLAGS_ROOMAUTO      0x00000002
		#define FSOUND_REVERB_CHANNELFLAGS_ROOMHFAUTO    0x00000004
		#define FSOUND_REVERB_CHANNELFLAGS_DEFAULT       (FSOUND_REVERB_CHANNELFLAGS_DIRECTHFAUTO | FSOUND_REVERB_CHANNELFLAGS_ROOMAUTO| FSOUND_REVERB_CHANNELFLAGS_ROOMHFAUTO)

	// FSOUND_INIT_FLAGS
	
		#define FSOUND_INIT_USEDEFAULTMIDISYNTH     0x0001
		#define FSOUND_INIT_GLOBALFOCUS             0x0002
		#define FSOUND_INIT_ENABLESYSTEMCHANNELFX   0x0004
		#define FSOUND_INIT_ACCURATEVULEVELS        0x0008
		#define FSOUND_INIT_PS2_DISABLECORE0REVERB  0x0010
		#define FSOUND_INIT_PS2_DISABLECORE1REVERB  0x0020
		#define FSOUND_INIT_PS2_SWAPDMACORES        0x0040
		#define FSOUND_INIT_DONTLATENCYADJUST       0x0080
		#define FSOUND_INIT_GC_INITLIBS             0x0100
		#define FSOUND_INIT_STREAM_FROM_MAIN_THREAD 0x0200
		#define FSOUND_INIT_PS2_USEVOLUMERAMPING    0x0400
		#define FSOUND_INIT_DSOUND_DEFERRED         0x0800
		#define FSOUND_INIT_DSOUND_HRTF_LIGHT       0x1000
		#define FSOUND_INIT_DSOUND_HRTF_FULL        0x2000
		#define FSOUND_INIT_XBOX_REMOVEHEADROOM     0x4000
		#define FSOUND_INIT_PSP_SILENCEONUNDERRUN   0x8000

	// FSOUND_TAGFIELD_TYPE
	
		#define FSOUND_TAGFIELD_VORBISCOMMENT	0
		#define FSOUND_TAGFIELD_ID3V1			1
		#define FSOUND_TAGFIELD_ID3V2			2
		#define FSOUND_TAGFIELD_SHOUTCAST		3
		#define FSOUND_TAGFIELD_ICECAST			4
		#define FSOUND_TAGFIELD_ASF				5

	// FSOUND_STATUS_FLAGS
	
		#define FSOUND_PROTOCOL_SHOUTCAST   0x00000001
		#define FSOUND_PROTOCOL_ICECAST     0x00000002
		#define FSOUND_PROTOCOL_HTTP        0x00000004
		#define FSOUND_FORMAT_MPEG          0x00010000
		#define FSOUND_FORMAT_OGGVORBIS     0x00020000

	//FSOUND_SPEAKERMODES
	
		#define FSOUND_SPEAKERMODE_DOLBYDIGITAL 	0
		#define FSOUND_SPEAKERMODE_HEADPHONES		1
		#define FSOUND_SPEAKERMODE_MONO				2
		#define FSOUND_SPEAKERMODE_QUAD				3
		#define FSOUND_SPEAKERMODE_STEREO			4
		#define FSOUND_SPEAKERMODE_SURROUND			5

	//FSOUND INTERNAL DSP UNITS
	//These are the internal DSP units
	
		#define FSOUND_DSP_CLEAR_UNIT			-1
		#define FSOUND_DSP_CLIPANDCOPY_UNIT		-2
		#define FSOUND_DSP_MUSIC_UNIT			-3
		#define FSOUND_DSP_SFX_UNIT				-4
		#define FSOUND_DSP_FFT_UNIT				-5

#endif