//- includes ---------------------------------------------------------

	#include <acknex.h>
	#include <default.c>
	
	#include "LC_FMOD_WRAP.h";	//FMOD plugin header file

	//- IMPORTANT ----------------------------------------------------
	//the file "CD_02_seek.wdl" defines the plugin dir, so
	//don't forget it, when you play with your own code files. Other-
	//wise the engine won't find the plugin DLL!!!
	//----------------------------------------------------------------

//- slider ressources ------------------------------------------------

	var h_slider_pos; //slider value

	BMAP* h_slider_bar = "h_slider_bar.tga"; //bar
	BMAP* h_slider_anchor = "h_slider_anchor.tga"; //slider
	PANEL* CD_seek =
	{
		pos_x = 20;
		pos_y = 20;
		bmap = h_slider_bar;
		flags =  VISIBLE;
		hslider = 0, 0, 512, h_slider_anchor, 0, 1000, h_slider_pos;
	}

	TEXT* sliderLabel = {
		pos_x = 20;
		pos_y = 90;
		string ("adjust the slider to seek the CD track");
		flags = VISIBLE;
	}

//- mouse ressources -------------------------------------------------
	void mouse (); //mouse loop prototype
	BMAP* cursor = "cursor.tga"; //cursor image

//--------------------------------------------------------------------
// main: program entry
//--------------------------------------------------------------------
void main()
{
	video_switch (6, 32, 2);
	vec_set(screen_color, vector(100, 100, 100)); //no tearing
	mouse(); //mouse

 	on_exit = LC_FSOUND_Close; //shut down FMOD on engine exit

	char drive = 0;	//drive which will be used (0 = primary drive)
	int track = 1;	//track which will be played

	LC_FSOUND_CD_Play(drive, track); //start playing track
	LC_FSOUND_CD_SetPlayMode(drive, FSOUND_CD_PLAYLOOPED); //play the track infinite (in loop)

	//variables needed for seeking

		var CD_length = LC_FSOUND_CD_GetTrackLength(drive, track); //track length in ms
		var CD_position = 0; //track position in ms
		var CD_position_slider = 0; //converted slider position (temp)
		var CD_seek_frame = 0; //logs the frame in which we seeked
		
	if (CD_length == 0) {
		error("please insert a CD into your primary drive and restart the demo!");
		sys_exit();
		return;
	}

	//main loop for the seeking example
 	while (1)
	{
		CD_position = LC_FSOUND_CD_GetTrackTime(drive); //get position in ms
		CD_position_slider = (CD_position / CD_length) * 1000; //calculate the slider position

		if (mouse_left) { //if we adjust the slider, keep on playing
			h_slider_pos = CD_position_slider;
		} else {

			//ok, maybe we released the mouse and the slider is seeked

			//seek only, if the slider is farer away as the calculated position
			//and if we did'nt seeked in the last frame
			if 	((abs(h_slider_pos - CD_position_slider) > 10) &&
				(total_frames - CD_seek_frame > 1))
			{
				//we calculate with the slider position info the target time where we want to seek to
				LC_FSOUND_CD_SetTrackTime(drive, ((int)((h_slider_pos / 1000) * CD_length)));

				CD_seek_frame = total_frames; //log the frame in which we seeked

			} else {
				//nothing happend, keep on playing (default)
				h_slider_pos = CD_position_slider;
			}
		}

		wait(1);
	}
}

//--------------------------------------------------------------------
//simple mouse loop
//--------------------------------------------------------------------
void mouse ()
{
	mouse_map = cursor; //assign mouse map
	mouse_mode = 2; //turn on the mouse

	//move mouse
	while (1) {
		mouse_pos.x = mouse_cursor.x;
		mouse_pos.y = mouse_cursor.y;
		wait(1);
	}
}