//- includes ---------------------------------------------------------

	#include <acknex.h>
	#include <default.c>
	
	#include "LC_FMOD_WRAP.h";	//FMOD plugin header file

	//- IMPORTANT ----------------------------------------------------
	//the file "CD_03_volume.wdl" defines the plugin dir, so
	//don't forget it, when you play with your own code files. Other-
	//wise the engine won't find the plugin DLL!!!
	//----------------------------------------------------------------
	
//- channel volume ressources ------------------------------------------------

	BMAP* v_slider_volume_bar = "v_slider_bar.tga"; //bar
	BMAP* v_slider_volume_anchor = "v_slider_anchor.tga"; //anchor

	var v_slider_pos; //adjust the slider to adjust this value [0..255]

	PANEL* CD_volume_bar = {
		pos_x = 20;
		pos_y = 20;
		layer = 1;
		bmap = v_slider_volume_bar;
		flags =  VISIBLE;
		vslider = 0, 0, 512, v_slider_volume_anchor, 0, 255, v_slider_pos;
	}

		TEXT* CD_volume_label = {
			pos_x = 20;
			pos_y = 540;
			string ("CD volume");
			flags = VISIBLE;
		}
		
//- mouse ressources -------------------------------------------------
	void mouse (); //mouse loop prototype
	BMAP* cursor = "cursor.tga"; //cursor image

//--------------------------------------------------------------------
// main: program entry
//--------------------------------------------------------------------
void main()
{
	video_switch (7, 32, 2);
	vec_set(screen_color, vector(100, 100, 100)); //no tearing
	mouse(); //mouse

 	on_exit = LC_FSOUND_Close; //shut down FMOD on engine exit

	char drive = 0;	//drive which will be used (0 = primary drive)
	int track = 1;		//track which will be played

	LC_FSOUND_CD_Play(drive, track); //start playing track
	LC_FSOUND_CD_SetPlayMode(drive, FSOUND_CD_PLAYLOOPED); //play the track infinite (in loop)

	//set the slider to the real volume of the CD
	v_slider_pos = 255 - LC_FSOUND_CD_GetVolume(drive);

	while (1) {

		//set the volume according to the slider position
		LC_FSOUND_CD_SetVolume(drive, ((int)(255-v_slider_pos)));

		wait(1);
	}
}

//--------------------------------------------------------------------
//simple mouse loop
//--------------------------------------------------------------------
void mouse ()
{
	mouse_map = cursor; //assign mouse map
	mouse_mode = 2; //turn on the mouse

	//move mouse
	while (1) {
		mouse_pos.x = mouse_cursor.x;
		mouse_pos.y = mouse_cursor.y;
		wait(1);
	}
}