//- includes ---------------------------------------------------------

	#include <acknex.h>
	#include <default.c>
	#include <stdio.h>;		//needed for "sprintf"
	
	#include "LC_FMOD_WRAP.h";	//FMOD plugin header file

	//- IMPORTANT ----------------------------------------------------
	//the file "stream_04_mediaplay.wdl" defines the plugin dir, so
	//don't forget it, when you play with your own code files. Other-
	//wise the engine won't find the plugin DLL!!!
	//----------------------------------------------------------------

//- Mediaplayer ------------------------------------------------------

	char drive = 0;	//drive which will be used (0 = primary drive)
	int track = 1;		//track which will be played
	int track_amount;	//how many tracks the CD has

	STRING* echo;
	TEXT* mediaplayer_info = {pos_x = 170; pos_y = 25; layer = 2; string = "#256"; flags = VISIBLE;}
 	void CDPlay_fnc ();
	void CDPause_fnc ();
	void CDStop_fnc ();
	void CDPrev_fnc ();
	void CDNext_fnc ();
	//- buttons ----------------------------------------------------------

		BMAP* b_01_n = "b_01_n.tga"; //normal
		BMAP* b_01_t = "b_01_t.tga"; //touched

		PANEL* CDPlay = {
			pos_x = 20;
			pos_y = 20;
			bmap = b_01_n;
			flags =  VISIBLE;
			button = 0, 0, b_01_n, b_01_n, b_01_t, CDPlay_fnc, null, null;
		}
			TEXT* CDPlay_label = {pos_x = 30; pos_y = 30; layer = 2; string ("play"); flags = VISIBLE;}
			
		PANEL* CDPause = {
			pos_x = 20;
			pos_y = 70;
			bmap = b_01_n;
			flags =  VISIBLE;
			button = 0, 0, b_01_n, b_01_n, b_01_t, CDPause_fnc, null, null;
		}
			TEXT* CDPause_label = {pos_x = 30; pos_y = 80; layer = 2; string ("pause"); flags = VISIBLE;}
			
		PANEL* CDStop = {
			pos_x = 20;
			pos_y = 120;
			bmap = b_01_n;
			flags =  VISIBLE;
			button = 0, 0, b_01_n, b_01_n, b_01_t, CDStop_fnc, null, null;
		}
			TEXT* CDStop_label = {pos_x = 30; pos_y = 130; layer = 2; string ("stop"); flags = VISIBLE;}
			
		PANEL* CDPrev = {
			pos_x = 370;
			pos_y = 20;
			bmap = b_01_n;
			flags =  VISIBLE;
			button = 0, 0, b_01_n, b_01_n, b_01_t, CDPrev_fnc, null, null;
		}
			TEXT* CDPrev_label = {pos_x = 380; pos_y = 30; layer = 2; string ("<< previous track"); flags = VISIBLE;}
			
		PANEL* CDNext = {
			pos_x = 525;
			pos_y = 20;
			bmap = b_01_n;
			flags =  VISIBLE;
			button = 0, 0, b_01_n, b_01_n, b_01_t, CDNext_fnc, null, null;
		}
			TEXT* CDNext_label = {pos_x = 535; pos_y = 30; layer = 2; string ("next track >>"); flags = VISIBLE;}

		//shows the currently playing track
		TEXT* CDTrack_label = {pos_x = 512; pos_y = 62; string ("#16"); flags = VISIBLE | CENTER_X;}

//- mouse ressources -------------------------------------------------
	void mouse (); //mouse loop prototype
	BMAP* cursor = "cursor.tga"; //cursor image

//--------------------------------------------------------------------
// main: program entry
//--------------------------------------------------------------------
void main()
{
	video_switch (7, 32, 2);
	vec_set(screen_color, vector(100, 100, 100)); //no tearing

	mouse();

 	on_exit = LC_FSOUND_Close; //shut down FMOD on engine exit

	//str pointer for easy access to the information TEXT
	echo = (mediaplayer_info.pstring)[0];

	LC_FSOUND_CD_Play(drive, track); //start playing track
	LC_FSOUND_CD_SetPlayMode(drive, FSOUND_CD_PLAYCONTINUOUS); //play the track infinite (in loop)

	//we are ready!
	str_cpy(echo, "CD track opened and playing!\nPLAY - restart the song\nPAUSE - pause the song\nSTOP - stop the song");
	
	while (1) {
		
		if (LC_FSOUND_CD_GetTrack(drive) != 0) {
			sprintf(((STRING*)(CDTrack_label.pstring)[0])->chars, "track %d of %d", LC_FSOUND_CD_GetTrack(drive), LC_FSOUND_CD_GetNumTracks(drive));
		} else {
			//no track is playing
			str_cpy((CDTrack_label.pstring)[0], "...");
		}

		wait(1);
	}
}

//--------------------------------------------------------------------
//simple mouse loop
//--------------------------------------------------------------------
void mouse ()
{
	mouse_map = cursor; //assign mouse map
	mouse_mode = 2; //turn on the mouse

	//move mouse
	while (1) {
		mouse_pos.x = mouse_cursor.x;
		mouse_pos.y = mouse_cursor.y;
		wait(1);
	}
}

//--------------------------------------------------------------------
// Mediaplayer functions
//--------------------------------------------------------------------

 	//- play -------------------------------------------------------------
	void CDPlay_fnc ()
	{
		
		//no track? -> no CD is playing!
		if (LC_FSOUND_CD_GetTrack(drive) == 0) {
			track = 1;
			LC_FSOUND_CD_Play(drive, track); //start playing track
			LC_FSOUND_CD_SetPlayMode(drive, FSOUND_CD_PLAYCONTINUOUS); //play the track infinite (in loop)
			str_cpy(echo, "CD playing.\n\nPLAY - restart song\nPAUSE - pause song\nSTOP - stop song");
		} else {

			//if the CD is paused, unpause it
			
			if (LC_FSOUND_CD_GetPaused(drive)) {
				LC_FSOUND_CD_SetPaused (drive, false);
				str_cpy(echo, "CD has been unpaused.\n\nPLAY - restart song\nPAUSE - pause song\nSTOP - stop song");
			} else {
				//CD is playing, so we restart it
				track = LC_FSOUND_CD_GetTrack(drive);
				LC_FSOUND_CD_Play(drive, track);
				str_cpy(echo, "song restarted.\n\nPLAY - restart song\nPAUSE - pause song\nSTOP - stop song");
			}
		}
	}

	//- pause ------------------------------------------------------------
	void CDPause_fnc ()
	{
		//no channel? -> no CD is playing!
		if (LC_FSOUND_CD_GetTrack(drive) == 0) {
			//do nothing, you cant pause a CD which isnt plaiyng ;)
			str_cpy(echo, "No CD playing.. press PLAY first!\n\nPLAY - start song\nPAUSE - n/a\nSTOP - n/a");
		} else {
			
			//CD is playing..

			//toggle pause state
			if (LC_FSOUND_CD_GetPaused(drive)) {
				LC_FSOUND_CD_SetPaused (drive, false);
				str_cpy(echo, "CD has been unpaused.\n\nPLAY - restart song\nPAUSE - pause song\nSTOP - stop song");
			} else {
				LC_FSOUND_CD_SetPaused (drive, true);
				str_cpy(echo, "CD has been paused.\n\nPLAY - unpause song\nPAUSE - unpause song\nSTOP - stop song");
			}
			
			//hint: you can also toggle it this way:
			//LC_FSOUND_CD_SetPaused (drive, !LC_FSOUND_CD_GetPaused(drive));
		}
	}

	//- stop -------------------------------------------------------------
	void CDStop_fnc ()
	{
		//no channel? -> no CD is playing!
		if (LC_FSOUND_CD_GetTrack(drive) == 0) {
			//we can't stop a CD which isnt playing ;)
			str_cpy(echo, "No CD playing.. press PLAY first!\n\nPLAY - start song\nPAUSE - n/a\nSTOP - n/a");
		} else {
			LC_FSOUND_CD_Stop(drive); //stop the CD
			track = 1; //reset track to frist track!
			str_cpy(echo, "CD has been stopped.\n\nPLAY - start song\nPAUSE - n/a\nSTOP - n/a");
		}
	}
	
	//- next -------------------------------------------------------------
	void CDNext_fnc ()
	{
		//no track? -> no CD is playing!
		if (LC_FSOUND_CD_GetTrack(drive) == 0) {
			//cant skip when there is no song playing ;)
			str_cpy(echo, "No CD playing.. press PLAY first!\n\nPLAY - start song\nPAUSE - n/a\nSTOP - n/a");
		} else {
			
			if (LC_FSOUND_CD_GetTrack(drive) == LC_FSOUND_CD_GetNumTracks(drive)) {
				track = 1;
			} else {
				track++;
			}
			
			LC_FSOUND_CD_Play(drive, track);

			str_cpy(echo, "Skipped to next song.\n\nPLAY - restart song\nPAUSE - pause song\nSTOP - stop song");
		}
	}

	//- previous ---------------------------------------------------------
	void CDPrev_fnc ()
	{
		//no track? -> no CD is playing!
		if (LC_FSOUND_CD_GetTrack(drive) == 0) {
			//cant skip when there is no song playing ;)
			str_cpy(echo, "No CD playing.. press PLAY first!\n\nPLAY - start song\nPAUSE - n/a\nSTOP - n/a");
		} else {

			if (LC_FSOUND_CD_GetTrack(drive) == 1) {
				track = LC_FSOUND_CD_GetNumTracks(drive);
			} else {
				track--;
			}

			LC_FSOUND_CD_Play(drive, track);

			str_cpy(echo, "Skipped to previous song.\n\nPLAY - restart song\nPAUSE - pause song\nSTOP - stop song");
		}
	}