//- includes ---------------------------------------------------------

	#include <acknex.h>
	#include <default.c>
	
	#include "LC_FMOD_WRAP.h";	//FMOD plugin header file

	//- IMPORTANT ----------------------------------------------------
	//the file "channel_01_volume.wdl" defines the plugin dir, so
	//don't forget it, when you play with your own code files. Other-
	//wise the engine won't find the plugin DLL!!!
	//----------------------------------------------------------------

//- pan slider ressources --------------------------------------------

	var pan_slider_pos = 128; //slider value

	BMAP* pan_slider_bar = "h_slider_bar.tga"; //bar
	BMAP* pan_slider_anchor = "h_slider_anchor.tga"; //slider
	PANEL* channel_pan =
	{
		pos_x = 20;
		pos_y = 20;
		bmap = pan_slider_bar;
		flags =  VISIBLE;
		hslider = 0, 0, 512, pan_slider_anchor, 0, 255, pan_slider_pos;
	}

		TEXT* channel_pan_label = {pos_x = 20; pos_y = 90; string ("pan (left - right)"); flags = VISIBLE;}

//- volume slider ressources -----------------------------------------

	var volume_slider_pos = 0; //slider value

	BMAP* volume_slider_bar = "v_slider_bar.tga"; //bar
	BMAP* volume_slider_anchor = "v_slider_anchor.tga"; //slider
	PANEL* channel_volume =
	{
		pos_x = 20;
		pos_y = 120;
		bmap = volume_slider_bar;
		flags =  VISIBLE;
		vslider = 0, 0, 512, volume_slider_anchor, 0, 255, volume_slider_pos;
	}

		TEXT* channel_volume_label = {pos_x = 20; pos_y = 640; layer = 2; string ("volume"); flags = VISIBLE;}
		
//- frequency slider ressources --------------------------------------

	var freq_slider_pos = 0; //slider value
	var freq_slider_pos_reset;

	BMAP* freq_slider_bar = "v_slider_bar.tga"; //bar
	BMAP* freq_slider_anchor = "v_slider_anchor.tga"; //slider
	PANEL* channel_freq =
	{
		pos_x = 100;
		pos_y = 120;
		bmap = freq_slider_bar;
		flags =  VISIBLE;
		vslider = 0, 0, 512, freq_slider_anchor, 0, 1000, freq_slider_pos;
	}

		TEXT* channel_freq_label = {pos_x = 100; pos_y = 640; layer = 2; string ("frequency"); flags = VISIBLE;}
		
	//- reset button -----------------------------------------------------
	
		void freq_reset_fnc ();

		BMAP* b_01_n = "b_01_n.tga"; //normal
		BMAP* b_01_t = "b_01_t.tga"; //touched

		PANEL* freq_reset = {
			pos_x = 190;
			pos_y = 120;
			bmap = b_01_n;
			flags =  VISIBLE;
			button = 0, 0, b_01_n, b_01_n, b_01_t, freq_reset_fnc, null, null;
		}
			TEXT* freq_reset_label = {pos_x = 200; pos_y = 130; layer = 2; string ("reset frequency"); flags = VISIBLE;}
			


//- mouse ressources -------------------------------------------------
	void mouse (); //mouse loop prototype
	BMAP* cursor = "cursor.tga"; //cursor image

//--------------------------------------------------------------------
// main: program entry
//--------------------------------------------------------------------
void main()
{
	video_switch (8, 32, 2);
	vec_set(screen_color, vector(100, 100, 100)); //no tearing
	mouse(); //mouse

 	on_exit = LC_FSOUND_Close; //shut down FMOD on engine exit

	int stream, channel; //we store stream and channel IDs in integers

	stream = LC_FSOUND_Stream_Open("Revolution Void - City Lights at Night.ogg", 0, 0, 0); //open a stream
	channel = LC_FSOUND_Stream_Play(FSOUND_FREE, stream); //play the stream in a free channel

	freq_slider_pos = 1000 - (((LC_FSOUND_GetFrequency(channel)-100)*1000) / 705500);
	freq_slider_pos_reset = freq_slider_pos; //store reset value

	while (1)
	{
		LC_FSOUND_SetPan(channel, pan_slider_pos); //set pan
		LC_FSOUND_SetVolume(channel, 255 - volume_slider_pos); //set volume
		LC_FSOUND_SetFrequency(channel, (((1000 - freq_slider_pos)/1000) * 705500)+100); //set frequency

		wait(1);
	}
}

//--------------------------------------------------------------------
//reset frequency
//--------------------------------------------------------------------
void freq_reset_fnc ()
{
	freq_slider_pos = freq_slider_pos_reset;
}

//--------------------------------------------------------------------
//simple mouse loop
//--------------------------------------------------------------------
void mouse ()
{
	mouse_map = cursor; //assign mouse map
	mouse_mode = 2; //turn on the mouse

	//move mouse
	while (1) {
		mouse_pos.x = mouse_cursor.x;
		mouse_pos.y = mouse_cursor.y;
		wait(1);
	}
}