//- includes ---------------------------------------------------------

	#include <acknex.h>
	#include <default.c>

	#include "LC_FMOD_WRAP.h";	//FMOD plugin header file

	//- IMPORTANT ----------------------------------------------------
	//the file "sample_01_simplest.wdl" defines the plugin dir, so
	//don't forget it, when you play with your own code files. Other-
	//wise the engine won't find the plugin DLL!!!
	//----------------------------------------------------------------
	
//- sample ressources ------------------------------------------------

 	int sample, channel;

	BMAP* b_01_n = "b_01_n.tga"; //normal
	BMAP* b_01_t = "b_01_t.tga"; //touched

	void sample_play_fnc ();

	PANEL* sample_play = {
		pos_x = 20;
		pos_y = 20;
		bmap = b_01_n;
		flags =  VISIBLE;
		button = 0, 0, b_01_n, b_01_n, b_01_t, sample_play_fnc, null, null;
	}
		TEXT* sample_play_label = {pos_x = 30; pos_y = 30; layer = 2; string ("click!"); flags = VISIBLE;}

//- mouse ressources -------------------------------------------------
	void mouse (); //mouse loop prototype
	BMAP* cursor = "cursor.tga"; //cursor image

//--------------------------------------------------------------------
// main: program entry
//--------------------------------------------------------------------
void main()
{
	video_switch (7, 32, 2);
	vec_set(screen_color, vector(100, 100, 100)); //no tearing

	mouse();

 	on_exit = LC_FSOUND_Close; //shut down FMOD on engine exit

	channel = FSOUND_FREE; //set channel to FSOUND_FREE foir the first call
	sample = LC_FSOUND_Sample_Load(FSOUND_FREE, "jaguar.wav", FSOUND_NORMAL, 0, 0);
}

//--------------------------------------------------------------------
//plays the sample
//--------------------------------------------------------------------
void sample_play_fnc ()
{
	//use existing channel
	channel = LC_FSOUND_PlaySound(channel, sample);
}

//--------------------------------------------------------------------
//simple mouse loop
//--------------------------------------------------------------------
void mouse ()
{
	mouse_map = cursor; //assign mouse map
	mouse_mode = 2; //turn on the mouse

	//move mouse
	while (1) {
		mouse_pos.x = mouse_cursor.x;
		mouse_pos.y = mouse_cursor.y;
		wait(1);
	}
}