//- includes ---------------------------------------------------------

	#include <acknex.h>
	#include <default.c>
	
	#include "LC_FMOD_WRAP.h";	//FMOD plugin header file

	//- IMPORTANT ----------------------------------------------------
	//the file "stream_03_stereo.wdl" defines the plugin dir, so
	//don't forget it, when you play with your own code files. Other-
	//wise the engine won't find the plugin DLL!!!
	//----------------------------------------------------------------
	
//- channel volume ressources ------------------------------------------------

	BMAP* v_slider_channelVolume_bar = "v_slider_bar.tga"; //bar
	BMAP* v_slider_channelVolume_volume = "v_slider_volume.tga"; //volume

	PANEL* channelVolume_barL = {
		pos_x = 20;
		pos_y = 20;
		layer = 1;
		bmap = v_slider_channelVolume_bar;
		flags =  VISIBLE;
	}

	PANEL* channelVolume_volumeL = {
		pos_x = 20;
		layer = 2;
		bmap = v_slider_channelVolume_volume;
		flags =  VISIBLE;
	}

	PANEL* channelVolume_barR = {
		pos_x = 100;
		pos_y = 20;
		layer = 1;
		bmap = v_slider_channelVolume_bar;
		flags =  VISIBLE;
	}

	PANEL* channelVolume_volumeR = {
		pos_x = 100;
		layer = 2;
		bmap = v_slider_channelVolume_volume;
		flags =  VISIBLE;
	}

		TEXT* volumeLabels = {
			pos_x = 60;
			pos_y = 540;
			string ("left - right");
			flags = VISIBLE;
		}

//--------------------------------------------------------------------
// main: program entry
//--------------------------------------------------------------------
void main()
{
	video_switch (7, 32, 2);
	vec_set(screen_color, vector(100, 100, 100)); //no tearing

 	on_exit = LC_FSOUND_Close; //shut down FMOD on engine exit

	int stream, channel; //we store stream and channel IDs in integers

	stream = LC_FSOUND_Stream_Open("Revolution Void - City Lights at Night.ogg", 0, 0, 0); //open a stream
	channel = LC_FSOUND_Stream_Play(FSOUND_FREE, stream); //play the stream in a free channel

	float left, right; //these floats will store the stereo amplitudes (=runtime volume)

	while (1)
	{
		//retrieve the amplitude
		LC_FSOUND_GetCurrentLevels (channel, &left, &right);
		
		//display the volume

		//pose volume panels at the "volume height"
			channelVolume_volumeL.pos_y = channelVolume_barL->pos_y + (1 - left) * v_slider_channelVolume_bar->height;
			channelVolume_volumeR.pos_y = channelVolume_barR->pos_y + (1 - right) * v_slider_channelVolume_bar->height;

		//scale the volume panels so that they fit the vertical bar
			channelVolume_volumeL.scale_y = (left * v_slider_channelVolume_bar->height) / v_slider_channelVolume_volume->height;
			channelVolume_volumeR.scale_y = (right * v_slider_channelVolume_bar->height) / v_slider_channelVolume_volume->height;

		wait(1);
	}
}