//- includes ---------------------------------------------------------

	#include <acknex.h>
	#include <default.c>
	
	#include "LC_FMOD_WRAP.h";	//FMOD plugin header file

	//- IMPORTANT ----------------------------------------------------
	//the file "stream_04_mediaplay.wdl" defines the plugin dir, so
	//don't forget it, when you play with your own code files. Other-
	//wise the engine won't find the plugin DLL!!!
	//----------------------------------------------------------------

//- Mediaplayer ------------------------------------------------------

	int stream, channel;

	STRING* echo;
	TEXT* mediaplayer_info = {pos_x = 170; pos_y = 25; layer = 2; string = "#256"; flags = VISIBLE;}
	void streamPlay_fnc ();
	void streamPause_fnc ();
	void streamStop_fnc ();

	//- buttons ----------------------------------------------------------
	
		BMAP* b_01_n = "b_01_n.tga"; //normal
		BMAP* b_01_t = "b_01_t.tga"; //touched

		PANEL* streamPlay = {
			pos_x = 20;
			pos_y = 20;
			bmap = b_01_n;
			flags =  VISIBLE;
			button = 0, 0, b_01_n, b_01_n, b_01_t, streamPlay_fnc, null, null;
		}
			TEXT* streamPlay_label = {pos_x = 30; pos_y = 30; layer = 2; string ("play"); flags = VISIBLE;}
			
		PANEL* streamPause = {
			pos_x = 20;
			pos_y = 70;
			bmap = b_01_n;
			flags =  VISIBLE;
			button = 0, 0, b_01_n, b_01_n, b_01_t, streamPause_fnc, null, null;
		}
			TEXT* streamPause_label = {pos_x = 30; pos_y = 80; layer = 2; string ("pause"); flags = VISIBLE;}
			
		PANEL* streamStop = {
			pos_x = 20;
			pos_y = 120;
			bmap = b_01_n;
			flags =  VISIBLE;
			button = 0, 0, b_01_n, b_01_n, b_01_t, streamStop_fnc, null, null;
		}
			TEXT* streamStop_label = {pos_x = 30; pos_y = 130; layer = 2; string ("stop"); flags = VISIBLE;}

//- mouse ressources -------------------------------------------------
	void mouse (); //mouse loop prototype
	BMAP* cursor = "cursor.tga"; //cursor image

//--------------------------------------------------------------------
// main: program entry
//--------------------------------------------------------------------
void main()
{
	video_switch (7, 32, 2);
	vec_set(screen_color, vector(100, 100, 100)); //no tearing

	mouse();

 	on_exit = LC_FSOUND_Close; //shut down FMOD on engine exit

	//str pointer for easy access to the information TEXT
	echo = (mediaplayer_info.pstring)[0];

	stream = LC_FSOUND_Stream_Open("Revolution Void - City Lights at Night.ogg", 0, 0, 0); //open a stream

	//we are ready!
	str_cpy(echo, "Stream opened.\nClick play to start the song.");
}

//--------------------------------------------------------------------
//simple mouse loop
//--------------------------------------------------------------------
void mouse ()
{
	mouse_map = cursor; //assign mouse map
	mouse_mode = 2; //turn on the mouse

	//move mouse
	while (1) {
		mouse_pos.x = mouse_cursor.x;
		mouse_pos.y = mouse_cursor.y;
		wait(1);
	}
}

//--------------------------------------------------------------------
// Mediaplayer functions
//--------------------------------------------------------------------

	//- play -------------------------------------------------------------
	void streamPlay_fnc ()
	{
		//no channel? -> no stream is playing!
		if (channel == 0) {
			channel = LC_FSOUND_Stream_Play(FSOUND_FREE, stream); //play the stream in a free channel
			str_cpy(echo, "Stream playing.\n\nPLAY - restart song\nPAUSE - pause song\nSTOP - stop song");
		} else {

			//if the stream is paused, unpause it
			if (LC_FSOUND_GetPaused(channel)) {
				LC_FSOUND_SetPaused (channel, false);
				str_cpy(echo, "Stream has been unpaused.\n\nPLAY - restart song\nPAUSE - pause song\nSTOP - stop song");
			} else {

				//stream is playing, so we restart it by stopping it and
				//then replaying it

				LC_FSOUND_Stream_Stop (stream);
				channel = LC_FSOUND_Stream_Play(FSOUND_FREE, stream); //play the stream in a free channel

				str_cpy(echo, "Stream restarted.\n\nPLAY - restart song\nPAUSE - pause song\nSTOP - stop song");
			}
		}
	}

	//- pause ------------------------------------------------------------
	void streamPause_fnc ()
	{
		//no channel? -> no stream is playing!
		if (channel == 0) {
			//do nothing, you cant pause a stream which isnt plaiyng ;)
			str_cpy(echo, "No stream playing.. press PLAY first!\n\nPLAY - start song\nPAUSE - n/a\nSTOP - n/a");
		} else {
			
			//stream is playing..

			//toggle pause state
			if (LC_FSOUND_GetPaused(channel)) {
				LC_FSOUND_SetPaused (channel, false);
				str_cpy(echo, "Stream has been unpaused.\n\nPLAY - restart song\nPAUSE - pause song\nSTOP - stop song");
			} else {
				LC_FSOUND_SetPaused (channel, true);
				str_cpy(echo, "Stream has been paused.\n\nPLAY - unpause song\nPAUSE - unpause song\nSTOP - stop song");
			}
			
			//hint: you can also toggle it this way:
			//LC_FSOUND_SetPaused (channel, !LC_FSOUND_GetPaused(channel));
		}
	}

	//- stop -------------------------------------------------------------
	void streamStop_fnc ()
	{
		//no channel? -> no stream is playing!
		if (channel == 0) {
			//we can't stop a stream which isnt playing ;)
			str_cpy(echo, "No stream playing.. press PLAY first!\n\nPLAY - start song\nPAUSE - n/a\nSTOP - n/a");
		} else {
			LC_FSOUND_Stream_Stop (stream); //stop the stream
			channel = 0; //nullify channel assignment

			str_cpy(echo, "Stream has been stopped.\n\nPLAY - start song\nPAUSE - n/a\nSTOP - n/a");
		}
	}
