//- includes ---------------------------------------------------------

	#include <acknex.h>
	#include <default.c>
	#include <stdio.h>;		//needed for "sprintf"

	#include "LC_FMOD_WRAP.h";	//FMOD plugin header file

	//- IMPORTANT ----------------------------------------------------
	//the file "stream_05_information.wdl" defines the plugin dir, so
	//don't forget it, when you play with your own code files. Other-
	//wise the engine won't find the plugin DLL!!!
	//----------------------------------------------------------------

//- info fields ------------------------------------------------------
	TEXT* stream_lengthBytes =		{pos_x = 10; pos_y = 10; string ("#128"); flags = VISIBLE;}
	TEXT* stream_lengthMs =			{pos_x = 10; pos_y = 30; string ("#128"); flags = VISIBLE;}
	TEXT* stream_lengthSec =		{pos_x = 10; pos_y = 50; string ("#128"); flags = VISIBLE;}
	TEXT* stream_positionBytes =	{pos_x = 10; pos_y = 70; string ("#128"); flags = VISIBLE;}
	TEXT* stream_timeMs = 			{pos_x = 10; pos_y = 90; string ("#128"); flags = VISIBLE;}
	TEXT* stream_timeSec = 			{pos_x = 10; pos_y = 110; string ("#128"); flags = VISIBLE;}
	TEXT* stream_volume = 			{pos_x = 10; pos_y = 130; string ("#128"); flags = VISIBLE;}
	TEXT* stream_levelLeft = 		{pos_x = 10; pos_y = 150; string ("#128"); flags = VISIBLE;}
	TEXT* stream_levelRight = 		{pos_x = 10; pos_y = 170; string ("#128"); flags = VISIBLE;}
	TEXT* stream_frequency = 		{pos_x = 10; pos_y = 190; string ("#128"); flags = VISIBLE;}

//--------------------------------------------------------------------
// main: program entry
//--------------------------------------------------------------------
void main()
{
	video_switch (7, 32, 2);
	vec_set(screen_color, vector(100, 100, 100)); //no tearing

 	on_exit = LC_FSOUND_Close; //shut down FMOD on engine exit

	int stream, channel;
	float left, right;

	stream = LC_FSOUND_Stream_Open("Revolution Void - City Lights at Night.ogg", 0, 0, 0); //open a stream
	channel = LC_FSOUND_Stream_Play(FSOUND_FREE, stream); //play the stream in a free channel

	while (1) {

		sprintf(((stream_lengthBytes.pstring)[0])->chars, "length in bytes: %d", LC_FSOUND_Stream_GetLength(stream));
		sprintf(((stream_lengthMs.pstring)[0])->chars, "length in ms: %d", LC_FSOUND_Stream_GetLengthMs(stream));
		sprintf(((stream_lengthSec.pstring)[0])->chars, "length in sec: %d", (int)(LC_FSOUND_Stream_GetLengthSecs(stream)));
		sprintf(((stream_positionBytes.pstring)[0])->chars, "position in bytes: %d", LC_FSOUND_Stream_GetPosition(stream));
		sprintf(((stream_timeMs.pstring)[0])->chars, "time in ms: %d", LC_FSOUND_Stream_GetTime(stream));
		sprintf(((stream_timeSec.pstring)[0])->chars, "time in sec: %d", (int)(LC_FSOUND_Stream_GetTime_secs(stream)));
		sprintf(((stream_volume.pstring)[0])->chars, "volume: %d", LC_FSOUND_GetVolume(channel));

		LC_FSOUND_GetCurrentLevels(channel, &left, &right);
		sprintf(((stream_levelLeft.pstring)[0])->chars, "level left x 100: %d", (int)(100 * left));
		sprintf(((stream_levelRight.pstring)[0])->chars, "level right x 100: %d", (int)(100 * right));

		sprintf(((stream_frequency.pstring)[0])->chars, "frequency: %d", LC_FSOUND_GetFrequency(channel));

		wait(1);
	}
}