//- includes ---------------------------------------------------------

	#include <acknex.h>
	#include <default.c>
	#include <stdio.h>;		//needed for "sprintf"

	#include "LC_FMOD_WRAP.h";	//FMOD plugin header file

	//- IMPORTANT ----------------------------------------------------
	//the file "stream_06_tags.wdl" defines the plugin dir, so
	//don't forget it, when you play with your own code files. Other-
	//wise the engine won't find the plugin DLL!!!
	//----------------------------------------------------------------

//- info fields ------------------------------------------------------
	TEXT* stream_tag_title =		{pos_x = 10; pos_y = 10; string ("#128"); flags = VISIBLE;}
	TEXT* stream_tag_artist =		{pos_x = 10; pos_y = 30; string ("#128"); flags = VISIBLE;}
	TEXT* stream_tag_album =		{pos_x = 10; pos_y = 50; string ("#128"); flags = VISIBLE;}
	TEXT* stream_tag_genre =		{pos_x = 10; pos_y = 70; string ("#128"); flags = VISIBLE;}
	TEXT* stream_tag_date = 		{pos_x = 10; pos_y = 90; string ("#128"); flags = VISIBLE;}
	TEXT* stream_tag_comment = 		{pos_x = 10; pos_y = 110; string ("#128"); flags = VISIBLE;}
	TEXT* stream_tag_tracknumber =	{pos_x = 10; pos_y = 130; string ("#128"); flags = VISIBLE;}

//--------------------------------------------------------------------
// main: program entry
//--------------------------------------------------------------------
void main()
{
	video_switch (7, 32, 2);
	vec_set(screen_color, vector(100, 100, 100)); //no tearing

 	on_exit = LC_FSOUND_Close; //shut down FMOD on engine exit

	int stream, channel;
	float left, right;

	stream = LC_FSOUND_Stream_Open("Revolution Void - City Lights at Night.ogg", 0, 0, 0); //open a stream
	channel = LC_FSOUND_Stream_Play(FSOUND_FREE, stream); //play the stream in a free channel

	char* buffer = "#128";	//used to write the tag field values in it

	//find each tag and copy it into the TEXT - strings

	//TITLE
		LC_FSOUND_Stream_FindTagField(stream, 0, "TITLE", &buffer, 0);
		sprintf(((stream_tag_title.pstring)[0])->chars, "title: %s", buffer);

	//ARTIST
		LC_FSOUND_Stream_FindTagField(stream, 0, "ARTIST", &buffer, 0);
		sprintf(((stream_tag_artist.pstring)[0])->chars, "artist: %s", buffer);

	//ALBUM
		LC_FSOUND_Stream_FindTagField(stream, 0, "ALBUM", &buffer, 0);
		sprintf(((stream_tag_album.pstring)[0])->chars, "album: %s", buffer);

	//GENRE
		LC_FSOUND_Stream_FindTagField(stream, 0, "GENRE", &buffer, 0);
		sprintf(((stream_tag_genre.pstring)[0])->chars, "genre: %s", buffer);

	//DATE
		LC_FSOUND_Stream_FindTagField(stream, 0, "DATE", &buffer, 0);
		sprintf(((stream_tag_date.pstring)[0])->chars, "date: %s", buffer);

	//COMMENT
		LC_FSOUND_Stream_FindTagField(stream, 0, "COMMENT", &buffer, 0);
		sprintf(((stream_tag_comment.pstring)[0])->chars, "comment: %s", buffer);

	//TRACKNUMBER
		LC_FSOUND_Stream_FindTagField(stream, 0, "TRACKNUMBER", &buffer, 0);
		sprintf(((stream_tag_tracknumber.pstring)[0])->chars, "tracknumber: %s", buffer);
}