//- includes ---------------------------------------------------------

	#include <acknex.h>
	#include <default.c>
	#include <stdio.h>

	#include "LC_FMOD_WRAP.h";	//FMOD plugin header file

	//- IMPORTANT ----------------------------------------------------
	//the file "stream_07_spectrum.wdl" defines the plugin dir, so
	//don't forget it, when you play with your own code files. Other-
	//wise the engine won't find the plugin DLL!!!
	//----------------------------------------------------------------

//--------------------------------------------------------------------
// main: program entry
//--------------------------------------------------------------------
void main()
{
	video_switch (6, 32, 2);
	vec_set(screen_color, vector(100, 100, 100)); //no tearing

 	on_exit = LC_FSOUND_Close; //shut down FMOD on engine exit

	int stream, channel; //we store stream and channel IDs in integers

	stream = LC_FSOUND_Stream_Open("Revolution Void - City Lights at Night.ogg", 0, 0, 0); //open a stream
	channel = LC_FSOUND_Stream_Play(FSOUND_FREE, stream); //play the stream in a free channel

	//create bmap and panel for the spectrum display

		BMAP* canvas = bmap_createblack(512, 300, 24);
		PANEL* spectrum_panel = pan_create("");

		//settings
			spectrum_panel->bmap = canvas;
			set(spectrum_panel, VISIBLE | OVERLAY);
			spectrum_panel->pos_x = 20;
			spectrum_panel->pos_y = 20;

	while (1) {

		static float* spectrum; //access to the spectrum data
 		spectrum = LC_FSOUND_DSP_GetSpectrum (); //calculate and retrieve spectrum

		static int i,j; //used for the painting algorithm
		static var format, pixel; //needed for paint
		
		bmap_fill(canvas, vector(0,0,0), 0);

 		format = bmap_lock(canvas); //lock bitmap for painting

         	//from left to right
			for (i = 0; i < canvas->width; i++) {

            	//column
				for (j = 0; j < canvas->height; j++) {

                	//fill pixel white or black depening if the pixel is covered of the spectrum
					if (j > ((int)(((float)1 - spectrum[i]) * (float)canvas->height))) {
						pixel = pixel_for_vec(vector(255,255,255), 0, format);
						pixel_to_bmap(canvas, i, j, pixel); //draw pixel
					}
				}
			}

		bmap_unlock(canvas); //unlock the bitmap

		wait(1);
	}
}