//- includes ---------------------------------------------------------

	#include <acknex.h>
	#include <default.c>
	#include <stdio.h>;		//needed for "sprintf"

	#include "LC_FMOD_WRAP.h";	//FMOD plugin header file

	//- IMPORTANT ----------------------------------------------------
	//the file "system_01_information.wdl" defines the plugin dir, so
	//don't forget it, when you play with your own code files. Other-
	//wise the engine won't find the plugin DLL!!!
	//----------------------------------------------------------------

//- info fields ------------------------------------------------------
	TEXT* CPUUsage =		{pos_x = 10; pos_y = 10; string ("#128"); flags = VISIBLE;}
	TEXT* ChannelsPlaying =	{pos_x = 10; pos_y = 30; string ("#128"); flags = VISIBLE;}
	TEXT* DriverName =		{pos_x = 10; pos_y = 50; string ("#128"); flags = VISIBLE;}
	TEXT* MaxChannels =		{pos_x = 10; pos_y = 70; string ("#128"); flags = VISIBLE;}
	TEXT* MemoryStats =		{pos_x = 10; pos_y = 90; string ("#128"); flags = VISIBLE;}
	TEXT* MixingRate = 		{pos_x = 10; pos_y = 110; string ("#128"); flags = VISIBLE;}
	TEXT* FMODVersion =		{pos_x = 10; pos_y = 130; string ("#128"); flags = VISIBLE;}

//--------------------------------------------------------------------
// main: program entry
//--------------------------------------------------------------------
void main()
{
	video_switch (7, 32, 2);
	vec_set(screen_color, vector(100, 100, 100)); //no tearing

 	on_exit = LC_FSOUND_Close; //shut down FMOD on engine exit

	int stream, channel;

	stream = LC_FSOUND_Stream_Open("Revolution Void - City Lights at Night.ogg", 0, 0, 0); //open a stream
	channel = LC_FSOUND_Stream_Play(FSOUND_FREE, stream); //play the stream in a free channel

	int currentalloced, maxalloced; //for memory stats

	while (1) {

		sprintf(((CPUUsage.pstring)[0])->chars, "CPU usage: %f percent", LC_FSOUND_GetCPUUsage());
 		sprintf(((ChannelsPlaying.pstring)[0])->chars, "number of active channels: %d", LC_FSOUND_GetChannelsPlaying());
 		sprintf(((DriverName.pstring)[0])->chars, "name of the selected driver: %s", LC_FSOUND_GetDriverName(LC_FSOUND_GetDriver()));
 		sprintf(((MaxChannels.pstring)[0])->chars, "total number of channels allocated: %d", LC_FSOUND_GetMaxChannels());

		LC_FSOUND_GetMemoryStats(&currentalloced, &maxalloced);
 		sprintf(((MemoryStats.pstring)[0])->chars, "memory usage: current alloced: %d; max. alloced: %d", currentalloced, maxalloced);

 		sprintf(((MixingRate.pstring)[0])->chars, "current mixing rate: %d", LC_FSOUND_GetOutputRate());
 		sprintf(((FMODVersion.pstring)[0])->chars, "FMOD version number: %f", LC_FSOUND_GetVersion());

		wait(1);
	}
}