//////////////////////////////
// InGame(IG)Shader Editor 2009
// Created by Emre Sasmaz 
// www.patharay.com 
// pantharay@gmail.com
//////////////////////////////
// Recommend resolution                 1280x1024
// Minimum resolution                   1024x768
// Maximum materialfound                28 (22 empty slot + 5 your's view materials + mat_model)
// Maximum _bmapfound (in fxfile)       6
// Maximum skinfound                    All(4)
//////////////////////////////
// Pros:+You can change all material's bmap&skin with panels.
// Pros:+You can change fx code with internal text editor.
// Pros:+You can use sliders for fx code, with SE_usable(1-10) variables.
// Pros:+You can change material's ambient(+spec+diff) with sliders.
// Pros:+You can save all the changes.
// Pros:+You can add 5 view material.
// Pros:+And you are free to improve it. (look at the readme.html)
//////////////////////////////
// Cons:-You can't search words in editor
// Cons:-There is no Syntax Highlighting
// Cons:-If you want to change cubemap image, cubemap feature of the image is lost.
//////////////////////////////


/*||||||||||||||||||||||||||||||||||||

SOLUTIONS FOR POSSIBLE ERRORS&BROKENS
________________________________________
________________________________________
________________ERRORS__________________
________________________________________
::::::::::::::::::::::::::::::::::::::::
ERROR1: "Error 1513: Crash in SE_bmp_for_str"
SOLUTION: Check your .c file for  _bmap.
if [texture spec_bump_bmap;] is within the .fx file,
but [BMAP* spec_bump="...";] is not within the .c file, the editor gives an error.
AND
Don't use "//" for _bmap in .fx file. If you will not use _bmap, just delete it.
Simple:
//spec_bump_bmap  ---->WRONG! JUST DELETE IT!
spec_bump_bmap    ---->CORRECT
________________________________________
________________________________________
::::::::::::::::::::::::::::::::::::::::
ERROR2: "Error 1513: Crash in SE_mat_for_str"
SOLUTION: Check the names of the view material that you have added.
If you add the wrong name, the editor gives an error.
________________________________________
________________________________________
_______________BROKENS__________________
________________________________________
::::::::::::::::::::::::::::::::::::::::
BROKEN1: WRONG _BMAP ON THE _BMAP PANELS
SOLUTION: Check your fx _bmap in .fx file.
Don't use "//" for _bmap in .fx file. If you will not use _bmap, just delete it.
Simple:
//spec_bump_bmap  ---->WRONG! JUST DELETE IT!
spec_bump_bmap    ---->CORRECT
________________________________________
________________________________________
::::::::::::::::::::::::::::::::::::::::
BROKEN2: FILE NOT FOUND (.fx file)
SOLUTION: Check the name of the fx paths, that you have added.
________________________________________
sorry for my bad english
||||||||||||||||||||||||||||||||||||*/



#define __if(var,var2) if(var){var2} 
#define __ifelse(var,var2,var3) if(var){var2} else {var3}
#define __rgb(var,var1,var2,var3) var.red=var1; var.green=var2; var.blue=var3;
#define __oO(var) while(1){var wait(1);} 
#define __es(var,var2)  if(var==var2)



#ifdef windows_h	
	#else
	#include <windows.h>
#endif

var SE_dil_ing=1;

//title:IG InGame Shader Editor
//section:Right click for help
#ifndef usable_varsandminmax
	#define usable_varsandminmax
	var SE_usable1;
	var SE_usable2;
	var SE_usable3;
	var SE_usable4;
	var SE_usable5;
	var SE_usable6;
	var SE_usable7;
	var SE_usable8;
	var SE_usable9;
	var SE_usable10;
	//Help: Slider minmax. You can change in game.
	//section:Usable Variables Minmax Step
	//title:SE_usable1
	//entry:SE_usable1_minstep
	//cntl: spin 0 1000 0.1
	var SE_usable1_minstep=0.0;
	//entry:SE_usable1_maxstep
	//cntl: spin 0 1000 1
	var SE_usable1_maxstep=255.0;

	//title:SE_usable2
	//entry:SE_usable2_minstep
	//cntl: spin 0 1000 1
	var SE_usable2_minstep=0.0;
	//entry:SE_usable2_maxstep
	//cntl: spin 0 1000 1
	var SE_usable2_maxstep=255.0;

	//title:SE_usable3
	//entry:SE_usable3_minstep
	//cntl: spin 0 1000 1
	var SE_usable3_minstep=0.0;
	//entry:SE_usable3_maxstep
	//cntl: spin 0 1000 1
	var SE_usable3_maxstep=255.0;

	//title:SE_usable4
	//entry:SE_usable4_minstep
	//cntl: spin 0 1000 1
	var SE_usable4_minstep=0;
	//entry:SE_usable4_maxstep
	//cntl: spin 0 1000 1
	var SE_usable4_maxstep=255;

	//title:SE_usable5
	//entry:SE_usable5_minstep
	//cntl: spin 0 1000 1
	var SE_usable5_minstep=0;
	//entry:SE_usable5_maxstep
	//cntl: spin 0 1000 1
	var SE_usable5_maxstep=255;


	//title:SE_usable6
	//entry:SE_usable6_minstep
	//cntl: spin 0 1000 1
	var SE_usable6_minstep=0;
	//entry:SE_usable6_maxstep
	//cntl: spin 0 1000 1
	var SE_usable6_maxstep=255;

	//title:SE_usable7
	//entry:SE_usable7_minstep
	//cntl: spin 0 1000 1
	var SE_usable7_minstep=0;
	//entry:SE_usable7_maxstep
	//cntl: spin 0 1000 1
	var SE_usable7_maxstep=255;

	//title:SE_usable8
	//entry:SE_usable8_minstep
	//cntl: spin 0 1000 1
	var SE_usable8_minstep=0;
	//entry:SE_usable8_maxstep
	//cntl: spin 0 1000 1
	var SE_usable8_maxstep=255;

	//title:SE_usable9
	//entry:SE_usable9_minstep
	//cntl: spin 0 1000 1
	var SE_usable9_minstep=0;
	//entry:SE_usable9_maxstep
	//cntl: spin 0 1000 1
	var SE_usable9_maxstep=255;

	//title:SE_usable10
	//entry:SE_usable10_minstep
	//cntl: spin 0 1000 1
	var SE_usable10_minstep=0;
	//entry:SE_usable10_maxstep
	//cntl: spin 0 1000 1
	var SE_usable10_maxstep=255;
#endif
HWND se_hwnd;

PANEL* SE_pan_mtlskn1;
PANEL* SE_pan_mtlskn2;
PANEL* SE_pan_mtlskn3;
PANEL* SE_pan_mtlskn4;

PANEL* SE_pan_bmpskn1;
PANEL* SE_pan_bmpskn2;
PANEL* SE_pan_bmpskn3;
PANEL* SE_pan_bmpskn4;
PANEL* SE_pan_bmpskn5;
PANEL* SE_pan_bmpskn6;

BMAP* se_mtlskin1bmap="sebosbos.bmp";
BMAP* se_mtlskin2bmap="sebosbos.bmp";
BMAP* se_mtlskin3bmap="sebosbos.bmp";
BMAP* se_mtlskin4bmap="sebosbos.bmp";

BMAP* se_bmpskin1bmap="sebosbos.bmp";
BMAP* se_bmpskin2bmap="sebosbos.bmp";
BMAP* se_bmpskin3bmap="sebosbos.bmp";
BMAP* se_bmpskin4bmap="sebosbos.bmp";
BMAP* se_bmpskin5bmap="sebosbos.bmp";
BMAP* se_bmpskin6bmap="sebosbos.bmp";

STRING* se_fxbmapname1="#25";
STRING* se_fxbmapname2="#25";
STRING* se_fxbmapname3="#25";
STRING* se_fxbmapname4="#25";
STRING* se_fxbmapname5="#25";
STRING* se_fxbmapname6="#25";



//Help: You must write the file path(where is your shader files?). 
//Help: Sample:fx
//Help: Sample:shader\\fx
//Help: (No need exe_dir)
//section: SET .FX PATH
//Help: You must write the file path(where is your shader files?). 
//Help: Sample:fx
//Help: Sample:shader\\fx
//Help: (No need exe_dir)
//entry: se_fxpath1 
STRING* se_fxpath1="fx";
//entry: se_fxpath2 
STRING* se_fxpath2="shader\\fx";
//entry: se_fxpath3 
STRING* se_fxpath3="myshader\\myfx";


STRING* SE_fxpath_temp="#75"; 
/*
fx dosyasi yuklenirken yol icin kullanilacak
3 yol da bununla kontrol edilecek
(path for .fx load)
*/
STRING* SE_fxpathwrite_temp="#75";
/*
fx dosyasi yazilirken yol icin kullanilacak
3 yol da bununla kontrol edilecek
(path for .fx save)
*/

//section:WINDOW
//entry_drop: Maximize window with startup(Recommend 1)
//cntl: drop_list 0 1
var se_maximize_window=1;

BMAP* SE_info_arka_bmp = "se_infopanarka.tga";
BMAP* SE_info_bmap = "se_info_pan.tga";
BMAP* SE_slide_bmap="se_slide.tga";
BMAP* SE_slider_bmap="se_slider.tga";
BMAP* se_bosbuton = "se_bosbuton.tga";
BMAP* se_bosbutonk = "se_bosbuton2.tga";
BMAP* se_bosbutonkmavi = "se_bosbutonmavi2.tga";
BMAP* se_bosbutonmavi = "se_bosbutonmavi.tga";
BMAP* se_minbmap = "se_min.bmp";
BMAP* se_maxbmap = "se_max.bmp";
BMAP* se_lookbmap = "se_look.bmp";
FONT* SE_ana_font = "se_efont.pcx";


int SE_DosyaKontrol(char* fileName) //dosya varlik kontrolu (file exist?)
{
	long fileAttr;
	fileAttr = GetFileAttributes(fileName);
	if (0xFFFFFFFF == fileAttr)
	return 0;
	return 1;
}

char* SE_yukle_chr[70000];
/*
fx dosyasi yuklenirken kullanilacak
70000 harf veriyorum ne olur ne olmaz
(for fx load to editbox)
*/

var SE_string_handle;
/*
fx dosyasi yuklenirken ve yazilirken kullanilacak
(Edit kutusuna aktarirken filan.Evet filan?)
(filehandle)
*/

STRING* su_anki_str="#25";
/*
"su_anki_str", o an hangi effect dosyasinin aktif oldugunu gosterir.
Dosyanin ismini tutar. Orn: "test.fx"
Dosya bununla bulunacak, okunacak, silinecek, yeniden yazilacak.
(Current .fx file name)
*/

RECT recta;
/*
se_hwnd(Edit kutusu)in pozisyonunu bununla alacagiz
ve "save&reload" butonunun pozisyonunu buna gore atayacagiz.
Buton, se_hwnd yi takip edecek.
(Recta for "Save&Reload" button position. Button will follow se_hwnd window(Editbox))
*/

var editor_acik=0;
/*
Editor(se_hwnd penceresi) acik mi degil mi?
Aciksa kapatacagiz.
(EditBox is open?)
*/

PANEL* se_save_panel;
/*
"Save&Reload" butonunun paneli
("Save&Reload" buton's panel)
*/


#define _ttfont 1
#define _bmfont 0
//Help: _ttfont-->True type(courier new)
//Help: _bmfont-->Bitmapfont(se_efont.pcx)
//Help:  Performance is dropping sometimes because of the ttf.
//Help:  You can select the bitmap font if so.
// section: FONT
//entry_drop:Buttons Font Type (Recommend _ttfont)
//cntl: drop_list _ttfont _bmfont 
//Help: _ttfont-->True type(courier new)
//Help: _bmfont-->Bitmapfont(se_efont.pcx)
//Help:  Performance is dropping sometimes because of the ttf.
//Help:  You can select the bitmap font if so.
var font_sec=_ttfont;

#define _Arial 0
#define _Fixedsys 1
#define _CourierNew 2

//entry_drop:Editor Font Type 
//cntl: drop_list _Arial _Fixedsys  _CourierNew
//Help: NULL
var se_edit_font = _CourierNew;

//entry:Editor Font Size (Recommend 18)
//Help: NULL
//cntl: slider 8 28 1
int se_font_size=18.0;

var SE_ilk_acilis=0; //editor opens for the first time?

var SE_dosya_bulundu=0; //fx dosyasi bulunamazsa... (fx file found or not)


var panel_skin_boyutu=128; //panelsize_xy (don't change)

STRING* sz_tam_yol="#75";//-->current .fx file paths.
BMAP* SE_bmp_for_str(STRING* name) //Material ismi icin (Clear. Change bmap name with str)
{

	BMAP* temp_bmp = *((BMAP**)engine_getvar(name,0));
	return(temp_bmp);
}
#ifndef se_view_mats
	#define se_view_mats
	
	//Help: Shader Editor can't detect view material(only entity's material)
	//Help: if you want edit your view materials, put the name
	//Help: Sample:bloom_mat
	//Help: Sample:blur_mat
	//Help: (If you enter the wrong name, the editor gives an error)
	//Help: If you will not be used, leave it blank.
	//section: ADD VIEW MATERIAL 
	//Help: Shader Editor can't detect view material(only entity's material)
	//Help: if you want edit your view materials, put the name
	//Help: Sample:bloom_mat
	//Help: Sample:blur_mat
	//Help: (If you enter the wrong name, the editor gives an error)
	//Help: If you will not be used, leave it blank.
	//entry:View Material 1 Name
	STRING* se_view_mat_1_str="";
	//entry:View Material 2 Name
	STRING* se_view_mat_2_str="";
	//entry:View Material 3 Name
	STRING* se_view_mat_3_str="";
	//entry:View Material 4 Name
	STRING* se_view_mat_4_str="";
	//entry:View Material 5 Name
	STRING* se_view_mat_5_str="";
	var se_view_mat_var1=0;
	var se_view_mat_var2=0;
	var se_view_mat_var3=0;
	var se_view_mat_var4=0;
	var se_view_mat_var5=0;
	MATERIAL* se_view_mat_1 ={}
	MATERIAL* se_view_mat_2 ={}
	MATERIAL* se_view_mat_3 ={}
	MATERIAL* se_view_mat_4 ={}
	MATERIAL* se_view_mat_5 ={}
	void se_view_mat_cont()
	{
		__if(str_len(se_view_mat_1_str)!=0,se_view_mat_var1=1;)
		__if(str_len(se_view_mat_2_str)!=0,se_view_mat_var2=1;)
		__if(str_len(se_view_mat_3_str)!=0,se_view_mat_var3=1;)
		__if(str_len(se_view_mat_4_str)!=0,se_view_mat_var4=1;)
		__if(str_len(se_view_mat_5_str)!=0,se_view_mat_var5=1;)
		
	}
#endif

#ifndef SE_CONS_DIAG
	#define SE_CONS_DIAG
	//konsol icin
	HWND* se_hwnd2; //-->diag consol window
	RECT recta2;//-->for diag consol position(follow the main window(hWnd))
	STRING* SE_konsol_str="";
	STRING* SE_konsoltemp_str="";
	var se_diag_handle;
	void se_konsola_aktar(STRING* str,STRING* str2,var satir)
	{
		
		__if(SE_DosyaKontrol(_chr("IG_EDITOR_DIAG.txt"))==1,file_delete("IG_EDITOR_DIAG.txt");)
		se_diag_handle=file_open_append("IG_EDITOR_DIAG.txt");
		
	__ifelse(
		SE_dil_ing==1,//if
		str_cpy(SE_konsoltemp_str,SE_konsol_str);
		str_cpy(SE_konsol_str,str);
		if(satir==1){str_cat(SE_konsol_str,"\r\n");}
		if(satir==2){str_cat(SE_konsol_str,"\r\n\r\n");}
		str_cat(SE_konsol_str,SE_konsoltemp_str);
		SetWindowText(se_hwnd2,_chr(SE_konsol_str));
		file_str_write(se_diag_handle,SE_konsol_str);,//else
		str_cpy(SE_konsoltemp_str,SE_konsol_str);
		str_cpy(SE_konsol_str,str2);
		if(satir==1){str_cat(SE_konsol_str,"\r\n");}
		if(satir==2){str_cat(SE_konsol_str,"\r\n\r\n");}
		str_cat(SE_konsol_str,SE_konsoltemp_str);
		SetWindowText(se_hwnd2,_chr(SE_konsol_str));
		file_str_write(se_diag_handle,SE_konsol_str);
		)
		file_close(se_diag_handle);
		
	}
	var SE_develop=0;
	void se_konsol_dev(STRING* str,STRING* str2,var satir)
	{
		__es(SE_develop,0){return;}
		
		__if(SE_DosyaKontrol(_chr("IG_EDITOR_DIAG.txt"))==1,file_delete("IG_EDITOR_DIAG.txt");)
		se_diag_handle=file_open_append("IG_EDITOR_DIAG.txt");
		
	__ifelse(
		SE_dil_ing==1,//if
		str_cpy(SE_konsoltemp_str,SE_konsol_str);
		str_cpy(SE_konsol_str,str);
		if(satir==1){str_cat(SE_konsol_str,"\r\n");}
		if(satir==2){str_cat(SE_konsol_str,"\r\n\r\n");}
		str_cat(SE_konsol_str,SE_konsoltemp_str);
		SetWindowText(se_hwnd2,_chr(SE_konsol_str));
		file_str_write(se_diag_handle,SE_konsol_str);,//else
		str_cpy(SE_konsoltemp_str,SE_konsol_str);
		str_cpy(SE_konsol_str,str2);
		if(satir==1){str_cat(SE_konsol_str,"\r\n");}
		if(satir==2){str_cat(SE_konsol_str,"\r\n\r\n");}
		str_cat(SE_konsol_str,SE_konsoltemp_str);
		SetWindowText(se_hwnd2,_chr(SE_konsol_str));
		file_str_write(se_diag_handle,SE_konsol_str);
		)
		file_close(se_diag_handle);
		
	}

	void se_konsoll_startup()//diag consol
	{
		//wait(-1);
		se_hwnd2 = CreateWindowEx(WS_EX_CLIENTEDGE,("EDIT"),"",
		WS_VISIBLE | WS_POPUP|WS_VSCROLL | ES_READONLY |
		WS_HSCROLL | ES_AUTOVSCROLL | ES_AUTOHSCROLL | ES_MULTILINE,
		200,200,200,100,hWnd,NULL,hInstance,NULL );
		
		long hFont2=CreateFont (12, 0, 0, 0, FW_DONTCARE, FALSE, FALSE, FALSE, ANSI_CHARSET, \
		OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS, DEFAULT_QUALITY, \ DEFAULT_PITCH | FF_SWISS, 
		"Arial");	
		
		SendMessage (se_hwnd2, WM_SETFONT, hFont2, TRUE);

		__oO(GetWindowRect(hWnd,&recta2);
		MoveWindow(se_hwnd2,recta2.right-320,recta2.bottom-103,200,100,TRUE);)//bottom-150
		
	}
#endif

function editor_ac(STRING* str,STRING* str2)//open editbox
{
	wait(1);
	editor_acik=1;//Editor acildi.(se_hwnd is visible)
	int sx; int sy;
	sx=screen_size.x/2;
	sy=screen_size.y/2;
	
	if(str_len(str2)!=0)//search the .fx file...
	{
		str=str_create("#75");
		__if(SE_DosyaKontrol(_chr("se_internal1.fx"))==1,file_delete("se_internal1.fx");)
		

		SE_string_handle=file_open_append("se_internal1.fx");
		file_str_write(SE_string_handle,str2);
		file_close(SE_string_handle);
		str_cpy(str,"se_internal1.fx");
		if(SE_dil_ing==1)
		{

			MessageBox(NULL,"Material has no fx file.
			\r\nIf you do not save when you're finished, the changes are lost.
			\r\nSo for avoid losing changes,  use the \"save info\" button ,before closing the window.
			\r\n \"se_internal1.fx\" file was created temporarily.
			\r\nWhen you close the window , the shader  return to  original."
			,"Material's effect is internal",MB_OK);
		}
		else
		{
			MessageBox(NULL,"Materyalin efekt dosyas yok
			\ninizi bitirdikten sonra kayt yapmazsanz, deiiklikleri kaybedersiniz.
			\nDeiiklikleri tamamladktan sonra,pencereyi kapatmadan nce\"save info\" butonunu kullanabilirsiniz.
			\n \"se_internal1.fx\" dosyas geici olarak yaratlacaktr."
			,"Efekt dosyas gml",MB_OK);
		}
		
	}

	SE_dosya_bulundu=1;
	if(SE_DosyaKontrol(_chr(str))==1)  //Acacagimiz fx dosyasi ana dizin de mi? Oyleyse
	{
		SE_string_handle=file_open_read(str); //dosyayi ac 
		file_str_readto(SE_string_handle,SE_yukle_chr,"",70000); //ve yukle_char a aktar
		file_close(SE_string_handle); //dosyayi kapat
		str_cpy(sz_tam_yol,str);
	}
	else //ana dizinde degilse, kullanicinin girdigi 3 dizini kontrol et ve ayni islemi tekrarla.
	{
		str_cpy(SE_fxpath_temp,se_fxpath1);
		str_cat(SE_fxpath_temp,"\\");
		str_cat(SE_fxpath_temp,str);
		if(SE_DosyaKontrol(_chr(SE_fxpath_temp))==1)
		{
			SE_string_handle=file_open_read(SE_fxpath_temp);
			file_str_readto(SE_string_handle,SE_yukle_chr,"",70000);
			file_close(SE_string_handle);
			str_cpy(sz_tam_yol,SE_fxpath_temp);
		}
		else
		{
			str_cpy(SE_fxpath_temp,se_fxpath2);
			str_cat(SE_fxpath_temp,"\\");
			str_cat(SE_fxpath_temp,str);
			if(SE_DosyaKontrol(_chr(SE_fxpath_temp))==1)
			{
				SE_string_handle=file_open_read(SE_fxpath_temp);
				file_str_readto(SE_string_handle,SE_yukle_chr,"",70000);
				file_close(SE_string_handle);
				str_cpy(sz_tam_yol,SE_fxpath_temp);
			}
			else
			{
				str_cpy(SE_fxpath_temp,se_fxpath3);
				str_cat(SE_fxpath_temp,"\\");
				str_cat(SE_fxpath_temp,str);
				if(SE_DosyaKontrol(_chr(SE_fxpath_temp))==1)
				{
					SE_string_handle=file_open_read(SE_fxpath_temp);
					file_str_readto(SE_string_handle,SE_yukle_chr,"",70000);
					file_close(SE_string_handle);
					str_cpy(sz_tam_yol,SE_fxpath_temp);
				}
				else
				{
					
					str_cpy(SE_fxpath_temp,exe_dir);
					str_cat(SE_fxpath_temp,"\\code\\");
					str_cat(SE_fxpath_temp,str);
					
					if(SE_DosyaKontrol(_chr(SE_fxpath_temp))==1)
					{
						SE_string_handle=file_open_read(SE_fxpath_temp);
						file_str_readto(SE_string_handle,SE_yukle_chr,"",70000);
						file_close(SE_string_handle);
						str_cpy(sz_tam_yol,SE_fxpath_temp);
					}	
					else
					{
						MessageBox(NULL,"File not found","!",MB_OK);//Dosya yok adamim!
						SE_dosya_bulundu=0;
						
					}
				}
			}
		}
		
	}
	STRING* temp_str=str_create("#70"); //-->mtl _bmap isimleri icin (for _bmap name)
	STRING* temp_yukleme=str_create("#70000");//-->mtl _bmap aramak icin (for "texture "search in .fx file)
	
	STRING* temp_yukleme2=str_create("#70000");//-->mtl _bmap aramak icin (for "_bmap" search in .fx file)
	STRING* temp_str2=str_create("#70"); 
	#ifndef find_bmapinfx  //this function for search the fx_bmap. (in fx file) like "blood_bmap"
		#define find_bmapinfx
		var texture_var;     //once fx dosyasinda "texture" kelimesi var mi ona bakacagiz
		if(SE_dosya_bulundu==1)//-->Search "texture" in .fx file
		{
			se_konsola_aktar("_BMAP SEARCHING...","_BMAPLAR ARANIYOR...",2);
			SE_string_handle=file_open_read(sz_tam_yol);
			file_str_readto(SE_string_handle,temp_yukleme2,"",70000);
			int i;
			for(i=0;i<100; i++)
			{
				if(file_find(SE_string_handle,"texture")<1)
				{
					
					file_seek(SE_string_handle,5,0);
					
				}
				else
				{
					file_str_read(SE_string_handle,temp_str2);
					if(str_stri(temp_str2,"_bmap"))
					{
						texture_var=1;
						break;
					}
					
					
				}
			}
			file_close(SE_string_handle);
		}//yoksa texture var=0; asagidaki islem aktif olmayacak. Varsa asagidaki islem, bmaplarin adlarini alacak.
		if(SE_dosya_bulundu==1&&texture_var==1) //"texture" is exist. Now is this a _bmap? 
		{
			
			var total_bmap=0;
			SE_string_handle=file_open_read(sz_tam_yol);
			file_str_readto(SE_string_handle,temp_yukleme,"",70000);
			loop:
			str_cpy(delimit_str,";");
			if(file_find(SE_string_handle,"texture")<1)
			{
				
				file_seek(SE_string_handle,5,0);
				goto loop;
				
			}
			file_str_read(SE_string_handle,temp_str);
			
			if(!str_stri(temp_str,"_bmap")||str_stri(temp_str,"="))
			{
				goto loop;		
			}
			
			total_bmap+=1;
			if(total_bmap==1)
			{
				str_trunc(temp_str,5); 
				str_clip(temp_str,1);
				str_cpy(se_fxbmapname1,temp_str);
				SE_pan_bmpskn1.bmap=SE_bmp_for_str(_chr(temp_str));
				set(SE_pan_bmpskn1,SHOW);
				pan_setdigits(SE_pan_bmpskn1,1,30,10,se_fxbmapname1,SE_ana_font,0,0);
				wait(1);
				se_konsola_aktar(temp_str,temp_str,1);
				se_konsola_aktar("Found: ","Bulunan: ",0);
				/*
				Alttaki stri meselsi su; Paneller ve bmaplari boyut degistiriyor. 512 ve 128 arasinda
				eger kullanilan bmap bir depth view bmapi ise o da degisiyor ve goruntu bozuluyor.
				bmap in adinda depth vs. varsa, olayi atliyoruz.
				*/
				if(!str_stri(temp_str,"depth")&&!str_stri(temp_str,"refract")&&!str_stri(temp_str,"mirror")&&!str_stri(temp_str,"shadow"))
				{
					SE_pan_bmpskn1.bmap.finalwidth=panel_skin_boyutu;
					SE_pan_bmpskn1.bmap.finalheight=panel_skin_boyutu;
				}
			}
			if(total_bmap==2)
			{
				
				str_trunc(temp_str,5); 
				str_clip(temp_str,1);
				if(!str_cmp(temp_str,se_fxbmapname1))
				{
					se_konsola_aktar(temp_str,temp_str,1);
					se_konsola_aktar("Found: ","Bulunan: ",0);
					str_cpy(se_fxbmapname2,temp_str);
					SE_pan_bmpskn2.bmap=SE_bmp_for_str(_chr(temp_str));
					set(SE_pan_bmpskn2,SHOW);
					pan_setdigits(SE_pan_bmpskn2,1,30,10,se_fxbmapname2,SE_ana_font,0,0);
					wait(1);
					if(!str_stri(temp_str,"depth")&&!str_stri(temp_str,"refract")&&!str_stri(temp_str,"mirror")&&!str_stri(temp_str,"shadow"))
					{
						SE_pan_bmpskn2.bmap.finalwidth=panel_skin_boyutu;
						SE_pan_bmpskn2.bmap.finalheight=panel_skin_boyutu;
					}
				}
			}
			if(total_bmap==3)
			{
				str_trunc(temp_str,5); 
				str_clip(temp_str,1);
				
				if(!str_cmp(temp_str,se_fxbmapname1)&&!str_cmp(temp_str,se_fxbmapname2))
				{
					se_konsola_aktar(temp_str,temp_str,1);
					se_konsola_aktar("Found: ","Bulunan: ",0);
					str_cpy(se_fxbmapname3,temp_str);
					SE_pan_bmpskn3.bmap=SE_bmp_for_str(_chr(temp_str));
					set(SE_pan_bmpskn3,SHOW);	
					pan_setdigits(SE_pan_bmpskn3,1,30,10,se_fxbmapname3,SE_ana_font,0,0);
					wait(1);
					if(!str_stri(temp_str,"depth")&&!str_stri(temp_str,"refract")&&!str_stri(temp_str,"mirror")&&!str_stri(temp_str,"shadow"))
					{
						SE_pan_bmpskn3.bmap.finalwidth=panel_skin_boyutu;
						SE_pan_bmpskn3.bmap.finalheight=panel_skin_boyutu;
					}
				}
				
			}
			if(total_bmap==4)
			{
				
				str_trunc(temp_str,5); 
				str_clip(temp_str,1);
				if(!str_cmp(temp_str,se_fxbmapname1)&&!str_cmp(temp_str,se_fxbmapname2)&&!str_cmp(temp_str,se_fxbmapname3))
				{
					se_konsola_aktar(temp_str,temp_str,1);
					se_konsola_aktar("Found: ","Bulunan: ",0);
					str_cpy(se_fxbmapname4,temp_str);
					SE_pan_bmpskn4.bmap=SE_bmp_for_str(_chr(temp_str));
					set(SE_pan_bmpskn4,SHOW);
					pan_setdigits(SE_pan_bmpskn4,1,30,10,se_fxbmapname4,SE_ana_font,0,0);
					wait(1);
					if(!str_stri(temp_str,"depth")&&!str_stri(temp_str,"refract")&&!str_stri(temp_str,"mirror")&&!str_stri(temp_str,"shadow"))
					{
						SE_pan_bmpskn4.bmap.finalwidth=panel_skin_boyutu;
						SE_pan_bmpskn4.bmap.finalheight=panel_skin_boyutu;
					}
				}
			}
			if(total_bmap==5)
			{
				
				str_trunc(temp_str,5); 
				str_clip(temp_str,1);
				if(!str_cmp(temp_str,se_fxbmapname1)&&!str_cmp(temp_str,se_fxbmapname2)&&!str_cmp(temp_str,se_fxbmapname3)
				&&!str_cmp(temp_str,se_fxbmapname4))
				{
					se_konsola_aktar(temp_str,temp_str,1);
					se_konsola_aktar("Found: ","Bulunan: ",0);
					str_cpy(se_fxbmapname5,temp_str);
					SE_pan_bmpskn5.bmap=SE_bmp_for_str(_chr(temp_str));
					set(SE_pan_bmpskn5,SHOW);
					pan_setdigits(SE_pan_bmpskn5,1,30,10,se_fxbmapname5,SE_ana_font,0,0);
					wait(1);
					if(!str_stri(temp_str,"depth")&&!str_stri(temp_str,"refract")&&!str_stri(temp_str,"mirror")&&!str_stri(temp_str,"shadow"))
					{
						SE_pan_bmpskn5.bmap.finalwidth=panel_skin_boyutu;
						SE_pan_bmpskn5.bmap.finalheight=panel_skin_boyutu;
					}
				}
			}
			if(total_bmap==6)
			{
				
				str_trunc(temp_str,5); 
				str_clip(temp_str,1);
				if(!str_cmp(temp_str,se_fxbmapname1)&&!str_cmp(temp_str,se_fxbmapname2)&&!str_cmp(temp_str,se_fxbmapname3)
				&&!str_cmp(temp_str,se_fxbmapname4)&&!str_cmp(temp_str,se_fxbmapname5))
				{
					se_konsola_aktar(temp_str,temp_str,1);
					se_konsola_aktar("Found: ","Bulunan: ",0);
					str_cpy(se_fxbmapname6,temp_str);
					SE_pan_bmpskn6.bmap=SE_bmp_for_str(_chr(temp_str));
					set(SE_pan_bmpskn6,SHOW);
					pan_setdigits(SE_pan_bmpskn6,1,30,10,se_fxbmapname6,SE_ana_font,0,0);
					wait(1);
					if(!str_stri(temp_str,"depth")&&!str_stri(temp_str,"refract")&&!str_stri(temp_str,"mirror")&&!str_stri(temp_str,"shadow"))
					{
						SE_pan_bmpskn6.bmap.finalwidth=panel_skin_boyutu;
						SE_pan_bmpskn6.bmap.finalheight=panel_skin_boyutu;
					}
				}
			}
			__if(total_bmap<6,goto loop;)
			
			file_close(SE_string_handle);
			
		}
		str_cpy(delimit_str,"$");
	#endif
	if(str_len(str2)==0)//create editbox
	{
		se_hwnd = CreateWindowEx(NULL,("EDIT"),_chr(SE_fxpath_temp),
		WS_POPUP|WS_VISIBLE| MF_STRING |0x96cf0000|WS_VSCROLL | 
		WS_HSCROLL | ES_AUTOVSCROLL | ES_AUTOHSCROLL | ES_MULTILINE,
		200,200,sx,sy,hWnd,NULL,hInstance,NULL );
	}
	else //create editbox
	{
		se_hwnd = CreateWindowEx(NULL,("EDIT"),_chr("Material's effect is internal.There is no fx file.Temporary fx name is \"se_internal1.fx\""),
		WS_POPUP|WS_VISIBLE| MF_STRING |0x96cf0000|WS_VSCROLL | 
		WS_HSCROLL | ES_AUTOVSCROLL | ES_AUTOHSCROLL | ES_MULTILINE,
		200,200,sx,sy,hWnd,NULL,hInstance,NULL );
	}

	/*Pencereyi yarattik. Ekran boyutuna uygun bir degerle acilacak.*/
	/*Editor icin ozel font yaratiyoruz asagida*/
	/*Editbox font*/
	long hFont;
	if(se_edit_font==_Arial)
	{
		hFont=CreateFont (se_font_size, 0, 0, 0, FW_DONTCARE, FALSE, FALSE, FALSE, ANSI_CHARSET, \
		OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS, DEFAULT_QUALITY, \ DEFAULT_PITCH | FF_SWISS, 
		"Arial");
	}

	
	if(se_edit_font==_Fixedsys)
	{
		hFont=CreateFont (se_font_size, 0, 0, 0, FW_DONTCARE, FALSE, FALSE, FALSE, ANSI_CHARSET, \
		OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS, DEFAULT_QUALITY, \ DEFAULT_PITCH | FF_SWISS, 
		"Fixedsys");	
	}
	if(se_edit_font==_CourierNew)
	{
		hFont=CreateFont (se_font_size, 0, 0, 0, FW_DONTCARE, FALSE, FALSE, FALSE, ANSI_CHARSET, \
		OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS, DEFAULT_QUALITY, \ DEFAULT_PITCH | FF_SWISS, 
		"Courier New");	
	}
	
	/*Mesaj kuyruguna gonderiyoruz(Aktif ediyoruz diyelim)*/
	/*Send Editbox's font*/
	SendMessage (se_hwnd, WM_SETFONT, hFont, TRUE);

	if(SE_dosya_bulundu==1)
	{
		
		SetWindowText(se_hwnd, SE_yukle_chr);/*Load text*/
		se_konsola_aktar("EDITBOX LOADING...","METIN KUTUSU YUKLENIYOR",2);
		
	}
	
	
	ShowWindow(se_hwnd,SW_SHOW);
	UpdateWindow(se_hwnd);
	
	set(se_save_panel,SHOW); //Save butonunu goster
	

	
	__es(SE_ilk_acilis,0)// sadece ilk acilista yap (for only first open)
	{
		__es(font_sec,_ttfont){pan_setdigits(se_save_panel,0,15,3,"SAVE & RELOAD",SE_ana_font,0,0);}
		else{pan_setdigits(se_save_panel,0,15,7,"SAVE & RELOAD",SE_ana_font,0,0);}
	}
	__es(SE_ilk_acilis,0){SE_ilk_acilis=1;}
	/*
	Burada gereksiz gibi gorunen bir islem yaptik.
	Eger editor ilk kez aciliyorsa(tekrar tekrar eklemesin diye) butona bir digit ekleyecek
	Ardindan da ilk acilisin yapildigini teyit edecek "if(SE_ilk_acilis==0){SE_ilk_acilis=1;}"
	Bunu yapmasaydim, digiti panele direkt ekleseydim,digit font degisiminden etkilenmeyecekti.
	TTF sectigimiz halde digit yine bitmap kalacakti. Bu yuzden bu kadar sacmalamak zorunda kaldim.
	Eger ttf ise pan_set... degilse pan_set... olayi da iki font boyutunun farkli olmasi,
	yazilarin y ekseninin kaymasindan kaynaklaniyor.
	Bu kadar ugrasacagima, kodu direkt "setup_shadereditor" fonksiyonuna ekleyebilirdim ama
	kodlarin bir orada bir burada olmasini sevmiyorum. Editor burada aciliyorsa, buton da burada olacak.
	Evet manyagim... Bir sey mi vardi?
	*/
	
	while(IsWindowVisible(se_hwnd)) //Editor acik oldugu surece... Save butonu editoru takip edecek
	{

		se_save_panel.pos_x=screen_size.x/2-55; //orta
		se_save_panel.pos_y=10;
		GetWindowRect(se_hwnd,&recta);
	__ifelse(
		se_maximize_window==1,
		se_save_panel.pos_x=recta.right-110;
		se_save_panel.pos_y=recta.top-45;,
		se_save_panel.pos_x=screen_size.x/2-55;
		se_save_panel.pos_y=10;
		)
		
		wait(1);
	}
	se_konsola_aktar("EDIT BOX CLOSED. ","METIN KUTUSU KAPANDI ",2);
	reset(se_save_panel,SHOW);//Save butonunu gizle
	reset(SE_pan_mtlskn1,SHOW);
	reset(SE_pan_mtlskn2,SHOW);
	reset(SE_pan_mtlskn3,SHOW);
	reset(SE_pan_mtlskn4,SHOW);
	
	reset(SE_pan_bmpskn1,SHOW);
	reset(SE_pan_bmpskn2,SHOW);
	reset(SE_pan_bmpskn3,SHOW);
	reset(SE_pan_bmpskn4,SHOW);
	reset(SE_pan_bmpskn5,SHOW);
	reset(SE_pan_bmpskn6,SHOW);
	ptr_remove(temp_str);se_konsol_dev("temp_str deleted","temp_str silindi",1);
	ptr_remove(temp_str2);se_konsol_dev("temp_str2 deleted","temp_str2 silindi",1);
	ptr_remove(temp_yukleme);se_konsol_dev("temp_yukleme deleted","temp_yukleme silindi",1);
	ptr_remove(temp_yukleme2);se_konsol_dev("temp_yukleme2 deleted","temp_yukleme2 silindi",1);

	DestroyWindow(se_hwnd); se_konsol_dev("se_hwnd window was destroyed","se_hwnd penceresi yok edildi",1);
	editor_acik=0;//Editor kapandi.(se_hwnd is not visible)


}
MATERIAL* SE_mat_for_str(STRING* name) //Material ismi icin 
{
	MATERIAL* temp_mat = *((MATERIAL**)engine_getvar(name,0));
	return(temp_mat);
}
MATERIAL* su_anki_mat =  //su anki materyal adini bununla alacagiz ki "effect_load" yapabilelim (Current material name)
{
	
}

#ifndef SE_FXSAVE_E
	#define SE_FXSAVE_E
	char* SE_kaydet_chr[70000];
	/*
	Ayni yukle_char gibi.
	Fx dosyasi yazilirken kullanilacak.
	(For .fx write)
	*/
	STRING* se_fx_saat_str="#20";//min,sec,hour
	STRING* se_fx_saat_str2="#20";
	STRING* se_fx_saat_str3="#20";

	function se_fx_kaydet()
	{
		wait(1);
		int i;

		i = GetWindowTextLength(se_hwnd) + 1; //penceredeki yazinin karakter uzunlugunu al
		GetWindowText(se_hwnd,SE_kaydet_chr,i); //penceredeki yaziyi SE_kaydet_chr a aktar
		
		if(SE_DosyaKontrol(_chr(su_anki_str))==1) //Dosya ana dizinde mi
		{
			file_delete(su_anki_str);
			SE_string_handle = file_open_append(su_anki_str);
			file_str_write(SE_string_handle,SE_kaydet_chr);
			file_close(SE_string_handle);
			effect_load(su_anki_mat,su_anki_str);

		}
		else //Dosya ana dizinde degilse, diger 3 yolu kontrol et
		{
			
			str_cpy(SE_fxpathwrite_temp,se_fxpath1);
			str_cat(SE_fxpathwrite_temp,"\\");
			str_cat(SE_fxpathwrite_temp,su_anki_str);
			if(SE_DosyaKontrol(_chr(SE_fxpathwrite_temp))==1)
			{
				file_delete(SE_fxpathwrite_temp);
				SE_string_handle = file_open_append(SE_fxpathwrite_temp);
				file_str_write(SE_string_handle,SE_kaydet_chr);
				file_close(SE_string_handle);
				
			}
			else
			{
				
				str_cpy(SE_fxpathwrite_temp,se_fxpath2);
				str_cat(SE_fxpathwrite_temp,"\\");
				str_cat(SE_fxpathwrite_temp,su_anki_str);
				if(SE_DosyaKontrol(_chr(SE_fxpathwrite_temp))==1)
				{
					file_delete(SE_fxpathwrite_temp);
					SE_string_handle = file_open_append(SE_fxpathwrite_temp);//dosyayi yeniden ac
					file_str_write(SE_string_handle,SE_kaydet_chr);
					file_close(SE_string_handle);
					
				}
				else
				{
					str_cpy(SE_fxpathwrite_temp,se_fxpath3);
					str_cat(SE_fxpathwrite_temp,"\\");
					str_cat(SE_fxpathwrite_temp,su_anki_str);
					if(SE_DosyaKontrol(_chr(SE_fxpathwrite_temp))==1)
					{
						file_delete(SE_fxpathwrite_temp);
						SE_string_handle = file_open_append(SE_fxpathwrite_temp);//dosyayi yeniden ac
						file_str_write(SE_string_handle,SE_kaydet_chr);
						file_close(SE_string_handle);
						
					}
					else
					{
						str_cpy(SE_fxpathwrite_temp,exe_dir);
						str_cat(SE_fxpathwrite_temp,"\\code\\");
						str_cat(SE_fxpathwrite_temp,su_anki_str);
						if(SE_DosyaKontrol(_chr(SE_fxpathwrite_temp))==1)
						{
							file_delete(SE_fxpathwrite_temp);
							SE_string_handle = file_open_append(SE_fxpathwrite_temp);//dosyayi yeniden ac
							file_str_write(SE_string_handle,SE_kaydet_chr);
							file_close(SE_string_handle);
						}	
					}
				}
			}
			
		}
		se_konsola_aktar("SAVE&RELOAD","KAYDET&YUKLE",2);
		se_konsola_aktar(su_anki_str,su_anki_str,1);
		str_for_num(se_fx_saat_str,sys_hours);
		str_for_num(se_fx_saat_str2,sys_minutes);
		str_for_num(se_fx_saat_str3,sys_seconds);
		str_cat(se_fx_saat_str,":");
		str_cat(se_fx_saat_str,se_fx_saat_str2);
		str_cat(se_fx_saat_str,":");
		str_cat(se_fx_saat_str,se_fx_saat_str3);
		se_konsola_aktar(" "," ",0);
		se_konsola_aktar(se_fx_saat_str,se_fx_saat_str,0);
		effect_load(su_anki_mat,su_anki_str);
		/*Dosyayi kaydettik. Simdi effectload ile materiali yeniden cagiriyoruz.*/
	}
#endif


PANEL* se_save_panel = //save&reload button
{
	pos_x = 0; pos_y = 0;
	red = 0;green = 0;blue = 0; layer = 999;
	button = 1, 0, se_bosbuton, se_bosbuton, se_bosbutonmavi, se_fx_kaydet,NULL,NULL;
	
}
PANEL* SE_ana_panel = // main panel
{
	bmap=SE_info_arka_bmp;
	pos_x = 200; pos_y = 999;
	flags = SHOW;
	layer = 999;
	red = 0;
	green = 0;
	blue = 0; 

}

void se_anapanel_pan_startup()
{
	SE_ana_font.type=NULL;
	__if(font_sec==_ttfont,SE_ana_font = font_create("Courier new#14");)
	__if(font_sec==_bmfont,SE_ana_font = font_create("se_efont.pcx");)
	__oO(
	SE_ana_panel.pos_y=0;
	SE_ana_panel.pos_x=screen_size.x-120;
	if is(SE_ana_panel,SHOW)
	{
	__ifelse(mouse_right,mouse_mode=1;,mouse_mode=3;)
		mouse_pointer = 2; mouse_pos.x = mouse_cursor.x;    
		mouse_pos.y = mouse_cursor.y;
	}
	)
	
}

typedef struct {

	STRING* matname_str[80]; //-->Total 28 usable slot (but you can add your function if you want)
	STRING* effectname_str[80]; 
	MATERIAL* matname_mtl[80]; 
	EVENT	funcname_fnc[80]; 
	var var_mtl[40];
	var number;
	var total_number;

} SE_Matt_Depot;
/*|||||||||||||||||||||||||||||||||||||||||	
|||||||||||||||||||||||||||||||||||||||||||
ADD YOUR FUNCTION IF YOU WANT
-----------------------------
Sample:

SE_Mat_Depot->funcname_fnc[29]=funcname_fnc29;  //put to --> setup_shadereditor()(under SE_Mat_Depot->funcname_fnc[28]=funcname_fnc28;)

and create function; (under function funcname_fnc28(){.....})

function funcname_fnc29()
{
	wait(1);if(SE_info_temp_pan_aktif==1){reset(SE_info_temp_pan,SHOW);}wait(-0.1);
	SE_create_info_pan(SE_Mat_Depot->matname_str[29],SE_Mat_Depot->effectname_str[29],SE_Mat_Depot->matname_mtl[29]);
	
}

|||||||||||||||||||||||||||||||||||||||||||
|||||||||||||||||||||||||||||||||||||||||*/
SE_Matt_Depot* SE_Mat_Depot = 
{
	number=1;
	total_number=1;
} 
PANEL* SE_info_temp_pan;
PANEL* se_usablevar_pan;
var SE_info_temp_pan_aktif=0;
function se_save_info();
STRING* su_anki_eff="#35";
/*
Yukaridaki string export ederken kullanilacak.
Export ederken, material effekt dosyasina sahip mi onu kontrol edecegiz.
Kullanmazsak, bir onceki fx dosyasinin adini kaydediyor.
Bir de material in efekt dosyasinin disarida olup olmadigini kontrol ediyor.
mtl.effect="abc.fx"
ise sorun yok ama
mtl.effect="technique tech1{......}";
gibiyse bunun ayrimini yapmaliyiz ve bu string ile yapiyoruz.
Yoksa "technique tech1{......}" kismini dosya adi zannedip komple iceri aliyor.
Bu yuzden su_anki_str yerine bunu kullaniyoruz.
*/

STRING* SE_temp_txt_str="#20"; //slider minmax degerleri icin kullanilacak.
TEXT* SE_temp_txt = 
{
	layer = 1001;
	pos_x = 512;
	pos_y = 512;
	font(SE_ana_font);
	string(SE_temp_txt_str);
	flags= CENTER_Y;
}

/*
Slider minmax fonksiyonlari
*/
#define SE__minmax_entry wait(1);set (SE_temp_txt, SHOW);inkey(SE_temp_txt_str);	var temp_st;temp_st=str_to_num(SE_temp_txt_str);
function SE_usable1_minfunc()
{
	SE__minmax_entry
	SE_usable1_minstep=temp_st;
	reset (SE_temp_txt, SHOW);
	pan_setslider(se_usablevar_pan,1,0,35,SE_slide_bmap,SE_slider_bmap,SE_usable1_minstep,SE_usable1_maxstep,SE_usable1);
}
function SE_usable1_maxfunc()
{
	SE__minmax_entry
	SE_usable1_maxstep=temp_st;
	reset (SE_temp_txt, SHOW);
	pan_setslider(se_usablevar_pan,1,0,35,SE_slide_bmap,SE_slider_bmap,SE_usable1_minstep,SE_usable1_maxstep,SE_usable1);	
}

function SE_usable2_minfunc()
{
	SE__minmax_entry
	SE_usable2_minstep=temp_st;
	reset (SE_temp_txt, SHOW);
	pan_setslider(se_usablevar_pan,2,0,55,SE_slide_bmap,SE_slider_bmap,SE_usable2_minstep,SE_usable2_maxstep,SE_usable2);
}
function SE_usable2_maxfunc()
{
	SE__minmax_entry
	SE_usable2_maxstep=temp_st;
	reset (SE_temp_txt, SHOW);
	pan_setslider(se_usablevar_pan,2,0,55,SE_slide_bmap,SE_slider_bmap,SE_usable2_minstep,SE_usable2_maxstep,SE_usable2);	
}

function SE_usable3_minfunc()
{
	SE__minmax_entry
	SE_usable3_minstep=temp_st;
	reset (SE_temp_txt, SHOW);
	pan_setslider(se_usablevar_pan,3,0,75,SE_slide_bmap,SE_slider_bmap,SE_usable3_minstep,SE_usable3_maxstep,SE_usable3);
}
function SE_usable3_maxfunc()
{
	SE__minmax_entry
	SE_usable3_maxstep=temp_st;
	reset (SE_temp_txt, SHOW);
	pan_setslider(se_usablevar_pan,3,0,75,SE_slide_bmap,SE_slider_bmap,SE_usable3_minstep,SE_usable3_maxstep,SE_usable3);	
}

function SE_usable4_minfunc()
{
	SE__minmax_entry
	SE_usable4_minstep=temp_st;
	reset (SE_temp_txt, SHOW);
	pan_setslider(se_usablevar_pan,4,0,95,SE_slide_bmap,SE_slider_bmap,SE_usable4_minstep,SE_usable4_maxstep,SE_usable4);
}
function SE_usable4_maxfunc()
{
	SE__minmax_entry
	SE_usable4_maxstep=temp_st;
	reset (SE_temp_txt, SHOW);
	pan_setslider(se_usablevar_pan,4,0,95,SE_slide_bmap,SE_slider_bmap,SE_usable4_minstep,SE_usable4_maxstep,SE_usable4);	
}

function SE_usable5_minfunc()
{
	SE__minmax_entry
	SE_usable5_minstep=temp_st;
	reset (SE_temp_txt, SHOW);
	pan_setslider(se_usablevar_pan,5,0,115,SE_slide_bmap,SE_slider_bmap,SE_usable5_minstep,SE_usable5_maxstep,SE_usable5);
}
function SE_usable5_maxfunc()
{
	SE__minmax_entry
	SE_usable5_maxstep=temp_st;
	reset (SE_temp_txt, SHOW);
	pan_setslider(se_usablevar_pan,5,0,115,SE_slide_bmap,SE_slider_bmap,SE_usable5_minstep,SE_usable5_maxstep,SE_usable5);	
}

function SE_usable6_minfunc()
{
	SE__minmax_entry
	SE_usable6_minstep=temp_st;
	reset (SE_temp_txt, SHOW);
	pan_setslider(se_usablevar_pan,6,0,135,SE_slide_bmap,SE_slider_bmap,SE_usable6_minstep,SE_usable6_maxstep,SE_usable6);
}
function SE_usable6_maxfunc()
{
	SE__minmax_entry
	SE_usable6_maxstep=temp_st;
	reset (SE_temp_txt, SHOW);
	pan_setslider(se_usablevar_pan,6,0,135,SE_slide_bmap,SE_slider_bmap,SE_usable6_minstep,SE_usable6_maxstep,SE_usable6);	
}

function SE_usable7_minfunc()
{
	SE__minmax_entry
	SE_usable7_minstep=temp_st;
	reset (SE_temp_txt, SHOW);
	pan_setslider(se_usablevar_pan,7,0,155,SE_slide_bmap,SE_slider_bmap,SE_usable7_minstep,SE_usable7_maxstep,SE_usable7);
}
function SE_usable7_maxfunc()
{
	SE__minmax_entry
	SE_usable7_maxstep=temp_st;
	reset (SE_temp_txt, SHOW);
	pan_setslider(se_usablevar_pan,7,0,155,SE_slide_bmap,SE_slider_bmap,SE_usable7_minstep,SE_usable7_maxstep,SE_usable7);	
}

function SE_usable8_minfunc()
{
	SE__minmax_entry
	SE_usable8_minstep=temp_st;
	reset (SE_temp_txt, SHOW);
	pan_setslider(se_usablevar_pan,8,0,175,SE_slide_bmap,SE_slider_bmap,SE_usable8_minstep,SE_usable8_maxstep,SE_usable8);
}
function SE_usable8_maxfunc()
{
	SE__minmax_entry
	SE_usable8_maxstep=temp_st;
	reset (SE_temp_txt, SHOW);
	pan_setslider(se_usablevar_pan,8,0,175,SE_slide_bmap,SE_slider_bmap,SE_usable8_minstep,SE_usable8_maxstep,SE_usable8);	
}

function SE_usable9_minfunc()
{
	SE__minmax_entry
	SE_usable9_minstep=temp_st;
	reset (SE_temp_txt, SHOW);
	pan_setslider(se_usablevar_pan,9,0,195,SE_slide_bmap,SE_slider_bmap,SE_usable9_minstep,SE_usable9_maxstep,SE_usable9);
}
function SE_usable9_maxfunc()
{
	SE__minmax_entry
	SE_usable9_maxstep=temp_st;
	reset (SE_temp_txt, SHOW);
	pan_setslider(se_usablevar_pan,9,0,195,SE_slide_bmap,SE_slider_bmap,SE_usable9_minstep,SE_usable9_maxstep,SE_usable9);	
}

function SE_usable10_minfunc()
{
	SE__minmax_entry
	SE_usable10_minstep=temp_st;
	reset (SE_temp_txt, SHOW);
	pan_setslider(se_usablevar_pan,10,0,215,SE_slide_bmap,SE_slider_bmap,SE_usable10_minstep,SE_usable10_maxstep,SE_usable10);
}
function SE_usable10_maxfunc()
{
	SE__minmax_entry
	SE_usable10_maxstep=temp_st;
	reset (SE_temp_txt, SHOW);
	pan_setslider(se_usablevar_pan,10,0,215,SE_slide_bmap,SE_slider_bmap,SE_usable10_minstep,SE_usable10_maxstep,SE_usable10);	
}
BMAP* SE_deger_alti_bmap = "se_degeralti.tga";
PANEL* SE_deger_pan = 
{
	bmap = SE_deger_alti_bmap;
	layer = 11;
	pos_x = 5;
	pos_y = 100;
	flags = SHOW | TRANSLUCENT;
	red=167;
	green=220;
	blue=245;
	alpha=50;
	
}
STRING* SE_bmapname="#25";
/*
Eger bmap baska bir bmap a yonlendiyse ve dosya ismine sahip degilse sorun oluyor. 
Orn;
BMAP* bmap_mirrortarget;
mtl.skin3=bmap_mirrortarget;
Su durumda bmap bir dosya ismine sahip degil.
Boyle skinleri es gecmek icin asagida bu string i ve "unnamed" i kullanacagiz.
*/
function SE_create_info_pan(STRING* str_mat, STRING* str_effect,MATERIAL* mtll)
{
	
	if(editor_acik==1) // editor(se_hwnd) is visible?
	{
		DestroyWindow(se_hwnd);//destroy it!
		wait(1);
		
	}
	SE_info_temp_pan_aktif=1;
	su_anki_mat = SE_mat_for_str(_chr(mtll.link.name));
	SE_info_temp_pan = pan_create("bmap = se_info_pan.tga;",1);se_konsol_dev("SE_info_temp_pan created","SE_info_temp_pan yaratld",1);
	__rgb(SE_info_temp_pan,0,0,0) // set rgb
	SE_info_temp_pan.layer=999;
	set(SE_info_temp_pan,SHOW);
	
	//usable
	se_usablevar_pan = pan_create("bmap = se_info_pan2.tga;",1);se_konsol_dev("se_usablevar_pan created","se_usablevar_pan yaratld",1);
	__rgb(se_usablevar_pan,0,0,0)
	se_usablevar_pan.layer=999;
	set(se_usablevar_pan,SHOW);
	
__ifelse(screen_size.y>800&&se_maximize_window==1,  //if(var) to-> var2 else to ->var3
	se_usablevar_pan.pos_x=0;se_usablevar_pan.pos_y=400;,
	se_usablevar_pan.pos_x=200;se_usablevar_pan.pos_y=0;
	)
	pan_setdigits(se_usablevar_pan,0,40,0,"Usable Variables",SE_ana_font,1,NULL); 
	
	
	/*MINMAX*/pan_setbutton(se_usablevar_pan,0,1,140,25,se_minbmap,se_minbmap,se_minbmap,NULL,SE_usable1_minfunc,NULL,NULL);
	/*MINMAX*/pan_setbutton(se_usablevar_pan,0,1,170,25,se_maxbmap,se_maxbmap,se_maxbmap,NULL,SE_usable1_maxfunc,NULL,NULL);
__ifelse(font_sec==_ttfont,
	pan_setdigits(se_usablevar_pan,0,0,20,"SE_usable1 : %.1f",SE_ana_font,1,SE_usable1);,
	pan_setdigits(se_usablevar_pan,0,0,30,"SE_usable1 : %.1f",SE_ana_font,1,SE_usable1);)
	pan_setslider(se_usablevar_pan,0,0,35,SE_slide_bmap,SE_slider_bmap,SE_usable1_minstep,SE_usable1_maxstep,SE_usable1);
	
	/*MINMAX*/pan_setbutton(se_usablevar_pan,0,1,140,48,se_minbmap,se_minbmap,se_minbmap,NULL,SE_usable2_minfunc,NULL,NULL);
	/*MINMAX*/pan_setbutton(se_usablevar_pan,0,1,170,48,se_maxbmap,se_maxbmap,se_maxbmap,NULL,SE_usable2_maxfunc,NULL,NULL);
__ifelse(font_sec==_ttfont,
	pan_setdigits(se_usablevar_pan,0,0,45,"SE_usable2 : %.1f",SE_ana_font,1,SE_usable2);,
	pan_setdigits(se_usablevar_pan,0,0,48,"SE_usable2 : %.1f",SE_ana_font,1,SE_usable2);)
	

	pan_setslider(se_usablevar_pan,0,0,55,SE_slide_bmap,SE_slider_bmap,SE_usable2_minstep,SE_usable2_maxstep,SE_usable2);
	
	/*MINMAX*/pan_setbutton(se_usablevar_pan,0,1,140,68,se_minbmap,se_minbmap,se_minbmap,NULL,SE_usable3_minfunc,NULL,NULL);
	/*MINMAX*/pan_setbutton(se_usablevar_pan,0,1,170,68,se_maxbmap,se_maxbmap,se_maxbmap,NULL,SE_usable3_maxfunc,NULL,NULL);
__ifelse(font_sec==_ttfont,
	pan_setdigits(se_usablevar_pan,0,0,65,"SE_usable3 : %.1f",SE_ana_font,1,SE_usable3);,
	pan_setdigits(se_usablevar_pan,0,0,69,"SE_usable3 : %.1f",SE_ana_font,1,SE_usable3);)
	pan_setslider(se_usablevar_pan,0,0,75,SE_slide_bmap,SE_slider_bmap,SE_usable3_minstep,SE_usable3_maxstep,SE_usable3);

	/*MINMAX*/pan_setbutton(se_usablevar_pan,0,1,140,88,se_minbmap,se_minbmap,se_minbmap,NULL,SE_usable4_minfunc,NULL,NULL);
	/*MINMAX*/pan_setbutton(se_usablevar_pan,0,1,170,88,se_maxbmap,se_maxbmap,se_maxbmap,NULL,SE_usable4_maxfunc,NULL,NULL);
__ifelse(font_sec==_ttfont,
	pan_setdigits(se_usablevar_pan,0,0,85,"SE_usable4 : %.1f",SE_ana_font,1,SE_usable4);,
	pan_setdigits(se_usablevar_pan,0,0,89,"SE_usable4 : %.1f",SE_ana_font,1,SE_usable4);)
	pan_setslider(se_usablevar_pan,0,0,95,SE_slide_bmap,SE_slider_bmap,SE_usable4_minstep,SE_usable4_maxstep,SE_usable4);
	
	/*MINMAX*/pan_setbutton(se_usablevar_pan,0,1,140,108,se_minbmap,se_minbmap,se_minbmap,NULL,SE_usable5_minfunc,NULL,NULL);
	/*MINMAX*/pan_setbutton(se_usablevar_pan,0,1,170,108,se_maxbmap,se_maxbmap,se_maxbmap,NULL,SE_usable5_maxfunc,NULL,NULL);
__ifelse(font_sec==_ttfont,
	pan_setdigits(se_usablevar_pan,0,0,105,"SE_usable5 : %.1f",SE_ana_font,1,SE_usable5);,
	pan_setdigits(se_usablevar_pan,0,0,109,"SE_usable5 : %.1f",SE_ana_font,1,SE_usable5);)
	pan_setslider(se_usablevar_pan,0,0,115,SE_slide_bmap,SE_slider_bmap,SE_usable5_minstep,SE_usable5_maxstep,SE_usable5);

	/*MINMAX*/pan_setbutton(se_usablevar_pan,0,1,140,128,se_minbmap,se_minbmap,se_minbmap,NULL,SE_usable6_minfunc,NULL,NULL);
	/*MINMAX*/pan_setbutton(se_usablevar_pan,0,1,170,128,se_maxbmap,se_maxbmap,se_maxbmap,NULL,SE_usable6_maxfunc,NULL,NULL);
__ifelse(font_sec==_ttfont,
	pan_setdigits(se_usablevar_pan,0,0,125,"SE_usable6 : %.1f",SE_ana_font,1,SE_usable6);,
	pan_setdigits(se_usablevar_pan,0,0,129,"SE_usable6 : %.1f",SE_ana_font,1,SE_usable6);)
	pan_setslider(se_usablevar_pan,0,0,135,SE_slide_bmap,SE_slider_bmap,SE_usable6_minstep,SE_usable6_maxstep,SE_usable6);
	
	
	/*MINMAX*/pan_setbutton(se_usablevar_pan,0,1,140,148,se_minbmap,se_minbmap,se_minbmap,NULL,SE_usable7_minfunc,NULL,NULL);
	/*MINMAX*/pan_setbutton(se_usablevar_pan,0,1,170,148,se_maxbmap,se_maxbmap,se_maxbmap,NULL,SE_usable7_maxfunc,NULL,NULL);
__ifelse(font_sec==_ttfont,
	pan_setdigits(se_usablevar_pan,0,0,145,"SE_usable7 : %.1f",SE_ana_font,1,SE_usable7);,
	pan_setdigits(se_usablevar_pan,0,0,149,"SE_usable7 : %.1f",SE_ana_font,1,SE_usable7);)
	pan_setslider(se_usablevar_pan,0,0,155,SE_slide_bmap,SE_slider_bmap,SE_usable7_minstep,SE_usable7_maxstep,SE_usable7);
	
	
	/*MINMAX*/pan_setbutton(se_usablevar_pan,0,1,140,168,se_minbmap,se_minbmap,se_minbmap,NULL,SE_usable8_minfunc,NULL,NULL);
	/*MINMAX*/pan_setbutton(se_usablevar_pan,0,1,170,168,se_maxbmap,se_maxbmap,se_maxbmap,NULL,SE_usable8_maxfunc,NULL,NULL);
__ifelse(font_sec==_ttfont,
	pan_setdigits(se_usablevar_pan,0,0,165,"SE_usable8 : %.1f",SE_ana_font,1,SE_usable8);,
	pan_setdigits(se_usablevar_pan,0,0,169,"SE_usable8 : %.1f",SE_ana_font,1,SE_usable8);)
	pan_setslider(se_usablevar_pan,0,0,175,SE_slide_bmap,SE_slider_bmap,SE_usable8_minstep,SE_usable8_maxstep,SE_usable8);
	
	/*MINMAX*/pan_setbutton(se_usablevar_pan,0,1,140,188,se_minbmap,se_minbmap,se_minbmap,NULL,SE_usable9_minfunc,NULL,NULL);
	/*MINMAX*/pan_setbutton(se_usablevar_pan,0,1,170,188,se_maxbmap,se_maxbmap,se_maxbmap,NULL,SE_usable9_maxfunc,NULL,NULL);
__ifelse(font_sec==_ttfont,
	pan_setdigits(se_usablevar_pan,0,0,185,"SE_usable9 : %.1f",SE_ana_font,1,SE_usable9);,
	pan_setdigits(se_usablevar_pan,0,0,189,"SE_usable9 : %.1f",SE_ana_font,1,SE_usable9);)
	pan_setslider(se_usablevar_pan,0,0,195,SE_slide_bmap,SE_slider_bmap,SE_usable9_minstep,SE_usable9_maxstep,SE_usable9);
	
	/*MINMAX*/pan_setbutton(se_usablevar_pan,0,1,140,208,se_minbmap,se_minbmap,se_minbmap,NULL,SE_usable10_minfunc,NULL,NULL);
	/*MINMAX*/pan_setbutton(se_usablevar_pan,0,1,170,208,se_maxbmap,se_maxbmap,se_maxbmap,NULL,SE_usable10_maxfunc,NULL,NULL);
__ifelse(font_sec==_ttfont,
	pan_setdigits(se_usablevar_pan,0,0,205,"SE_usable10 : %.1f",SE_ana_font,1,SE_usable10);,
	pan_setdigits(se_usablevar_pan,0,0,209,"SE_usable10 : %.1f",SE_ana_font,1,SE_usable10);)
	pan_setslider(se_usablevar_pan,0,0,215,SE_slide_bmap,SE_slider_bmap,SE_usable10_minstep,SE_usable10_maxstep,SE_usable10);
	//usable
	
	
	
	STRING* str1 = str_create("#20");//material name
	STRING* str2 = str_create("#20");//effect name
	STRING* str3 = str_create("#20");//skin1
	STRING* str4 = str_create("#20");//skin2
	STRING* str5 = str_create("#20");//skin3
	STRING* str6 = str_create("#20");//skin4
	STRING* str7 = str_create("#20");//event
	
	str_cpy(str1,"Mat.Name:");
	str_cat(str1,str_mat);
	pan_setdigits(SE_info_temp_pan,0,10,10,str1,SE_ana_font,1,NULL); 
	if(str_stri(str_effect,".fx")) //fx dosyasi disarida mi? Eger gomulu ise acma (fx file is external?)
	{

		str_cpy(str2,"Eff.Name:");
		str_cat(str2,str_effect);
		str_cpy(su_anki_eff,str_effect);
		pan_setdigits(SE_info_temp_pan,0,10,20,str2,SE_ana_font,1,NULL); 
	}
	else
	{
		str_cpy(su_anki_eff,"NULL");
	}

	pan_setdigits(SE_info_temp_pan,0,10,30,"Ambient Red: %.0f",SE_ana_font,1,mtll.ambient_red); 
	pan_setdigits(SE_info_temp_pan,0,10,40,"Ambient Green: %.0f",SE_ana_font,1,mtll.ambient_green); 
	pan_setdigits(SE_info_temp_pan,0,10,50,"Ambient Blue: %.0f",SE_ana_font,1,mtll.ambient_blue); 
	pan_setdigits(SE_info_temp_pan,0,10,60,"Specular Red: %.0f",SE_ana_font,1,mtll.specular_red); 
	pan_setdigits(SE_info_temp_pan,0,10,70,"Specular Green: %.0f",SE_ana_font,1,mtll.specular_green); 
	pan_setdigits(SE_info_temp_pan,0,10,80,"Specular Blue: %.0f",SE_ana_font,1,mtll.specular_blue); 
	pan_setdigits(SE_info_temp_pan,0,10,90,"Diffuse Red: %.0f",SE_ana_font,1,mtll.diffuse_red); 
	pan_setdigits(SE_info_temp_pan,0,10,100,"Diffuse Green: %.0f",SE_ana_font,1,mtll.diffuse_green); 
	pan_setdigits(SE_info_temp_pan,0,10,110,"Diffuse Blue: %.0f",SE_ana_font,1,mtll.diffuse_blue); 
	se_konsola_aktar(_chr(mtll.link.name),_chr(mtll.link.name),2);
	se_konsola_aktar("Chosen Material: ","Secilen mteryal: ",0);
	
	se_konsola_aktar("SKIN SEARCHING...","SKINLER ARANIYOR...",2);
	if(mtll.skin1!=NULL)
	{
		str_cpy(str3,"SKIN 1: ");
		str_cat(str3,mtll.skin1.link.name);
		pan_setdigits(SE_info_temp_pan,0,10,120,str3,SE_ana_font,1,NULL); 	
		str_cpy(SE_bmapname,mtll.skin1.link.name);
		if(!str_stri(SE_bmapname,"unnamed"))	
		{
			set(SE_pan_mtlskn1,SHOW);
			SE_pan_mtlskn1.bmap=mtll.skin1;
			wait(1);
			SE_pan_mtlskn1.bmap.finalwidth=panel_skin_boyutu;
			SE_pan_mtlskn1.bmap.finalheight=panel_skin_boyutu;
			se_konsola_aktar(SE_bmapname,SE_bmapname,1);
			se_konsola_aktar(" : "," : ",0);
			se_konsola_aktar("Skin1 found","Skin1 bulundu.",0);

		}
		else
		{
			se_konsola_aktar("Skin1 found but it's unnamed","Skin1 bulundu ama isimsiz.",1);
		}
	}
	if(mtll.skin2!=NULL)
	{
		str_cpy(str4,"SKIN 2: ");
		str_cat(str4,mtll.skin2.link.name);
		pan_setdigits(SE_info_temp_pan,0,10,130,str4,SE_ana_font,1,NULL); 
		str_cpy(SE_bmapname,mtll.skin2.link.name);
		if(!str_stri(SE_bmapname,"unnamed"))	
		{	
			set(SE_pan_mtlskn2,SHOW);
			SE_pan_mtlskn2.bmap=mtll.skin2;
			wait(1);
			SE_pan_mtlskn2.bmap.finalwidth=panel_skin_boyutu;
			SE_pan_mtlskn2.bmap.finalheight=panel_skin_boyutu;
			se_konsola_aktar(SE_bmapname,SE_bmapname,1);
			se_konsola_aktar(" : "," : ",0);
			se_konsola_aktar("Skin2 found","Skin2 bulundu.",0);
			
		}
		else
		{
			se_konsola_aktar("Skin2 found but it's unnamed.","Skin2 bulundu ama isimsiz.",1);
		}
		
	}
	if(mtll.skin3!=NULL)
	{
		str_cpy(str5,"SKIN 3: ");
		str_cat(str5,mtll.skin3.link.name);
		pan_setdigits(SE_info_temp_pan,0,10,140,str5,SE_ana_font,1,NULL); 
		str_cpy(SE_bmapname,mtll.skin3.link.name);
		if(!str_stri(SE_bmapname,"unnamed"))	
		{
			set(SE_pan_mtlskn3,SHOW);	
			SE_pan_mtlskn3.bmap=mtll.skin3;
			wait(1);
			SE_pan_mtlskn3.bmap.finalwidth=panel_skin_boyutu;
			SE_pan_mtlskn3.bmap.finalheight=panel_skin_boyutu;
			se_konsola_aktar(SE_bmapname,SE_bmapname,1);
			se_konsola_aktar(" : "," : ",0);
			se_konsola_aktar("Skin3 found","Skin3 bulundu.",0);
		}
		else
		{
			se_konsola_aktar("Skin3 found but it's unnamed.","Skin3 bulundu ama isimsiz.",1);
		}
	}
	if(mtll.skin4!=NULL)
	{
		str_cpy(str6,"SKIN 4: ");
		str_cat(str6,mtll.skin4.link.name);
		pan_setdigits(SE_info_temp_pan,0,10,150,str6,SE_ana_font,1,NULL); 
		str_cpy(SE_bmapname,mtll.skin4.link.name);
		if(!str_stri(SE_bmapname,"unnamed"))	
		{	
			set(SE_pan_mtlskn4,SHOW);
			SE_pan_mtlskn4.bmap=mtll.skin4;
			wait(1);
			SE_pan_mtlskn4.bmap.finalwidth=panel_skin_boyutu;
			SE_pan_mtlskn4.bmap.finalheight=panel_skin_boyutu;
			se_konsola_aktar(SE_bmapname,SE_bmapname,1);
			se_konsola_aktar(" : "," : ",0);
			se_konsola_aktar("Skin4 found","Skin4 bulundu.",0);
			
			
		}
		else
		{
			se_konsola_aktar("Skin4 found but it's unnamed.","Skin4 bulundu ama ismsiz.",1);
		}
	}
	if(mtll.skin1==NULL&&mtll.skin2==NULL&&mtll.skin3==NULL&&mtll.skin4==NULL)
	{
		se_konsola_aktar("Noskin","Skin yok",2);
	}
	if(str_stri(str_effect,".fx")&&editor_acik==0)
	{
		
		editor_ac(str_effect,"");
		str_cpy(su_anki_str,str_effect);
	}
	if(!str_stri(str_effect,".fx")&&editor_acik==0&&str_len(str_effect)!=45)
	{
		editor_ac("internal material",str_effect);
		str_cpy(su_anki_str,"se_internal1.fx");
		se_konsola_aktar("INTERNAL MATERIAL","GOMULU MATERYAL",2);
	}
	

	pan_setbutton(SE_info_temp_pan,0,1,60,190,se_bosbutonk,se_bosbutonk,se_bosbutonkmavi,NULL,se_save_info,NULL,NULL);	
	

	
__ifelse(font_sec==_bmfont,
	pan_setdigits(SE_info_temp_pan,0,69,190+7,"Save Info",SE_ana_font,1,NULL);,
	pan_setdigits(SE_info_temp_pan,0,67,190+2,"Save Info",SE_ana_font,1,NULL);
	)

	
	pan_setslider(SE_info_temp_pan,0,0,210,SE_slide_bmap,SE_slider_bmap,0,255,mtll.ambient_red);
	pan_setslider(SE_info_temp_pan,0,0,230,SE_slide_bmap,SE_slider_bmap,0,255,mtll.ambient_green);
	pan_setslider(SE_info_temp_pan,0,0,250,SE_slide_bmap,SE_slider_bmap,0,255,mtll.ambient_blue);
	
	pan_setslider(SE_info_temp_pan,0,0,270,SE_slide_bmap,SE_slider_bmap,0,255,mtll.specular_red);
	pan_setslider(SE_info_temp_pan,0,0,290,SE_slide_bmap,SE_slider_bmap,0,255,mtll.specular_green);
	pan_setslider(SE_info_temp_pan,0,0,310,SE_slide_bmap,SE_slider_bmap,0,255,mtll.specular_blue);
	
	pan_setslider(SE_info_temp_pan,0,0,330,SE_slide_bmap,SE_slider_bmap,0,255,mtll.diffuse_red);
	pan_setslider(SE_info_temp_pan,0,0,350,SE_slide_bmap,SE_slider_bmap,0,255,mtll.diffuse_green);
	pan_setslider(SE_info_temp_pan,0,0,370,SE_slide_bmap,SE_slider_bmap,0,255,mtll.diffuse_blue);
	



	while is(SE_info_temp_pan,SHOW)
	{
		wait(1);
	}
	
	ptr_remove(se_usablevar_pan);se_konsol_dev("se_usablevar_pan deleted","se_usablevar_pan silindi",1);
	
	ptr_remove(SE_info_temp_pan);se_konsol_dev("SE_info_temp_pan deleted","SE_info_temp_pan silindi",1);
	ptr_remove(str1);se_konsol_dev("str1 deleted","str1 silindi",1);
	ptr_remove(str2);se_konsol_dev("str2 deleted","str2 silindi",1);
	ptr_remove(str3);se_konsol_dev("str3 deleted","str3 silindi",1);
	ptr_remove(str4);se_konsol_dev("str4 deleted","str4 silindi",1);
	ptr_remove(str5);se_konsol_dev("str5 deleted","str5 silindi",1);
	ptr_remove(str6);se_konsol_dev("str6 deleted","str6 silindi",1);
	ptr_remove(str7);se_konsol_dev("str7 deleted","str7 silindi",1);
	SE_info_temp_pan_aktif=0;
}
function funcname_fnc1()
{
	wait(1);if(SE_info_temp_pan_aktif==1){reset(SE_info_temp_pan,SHOW);}wait(-0.1);
	SE_create_info_pan(SE_Mat_Depot->matname_str[1],SE_Mat_Depot->effectname_str[1],SE_Mat_Depot->matname_mtl[1]);
	
}
function funcname_fnc2()
{
	wait(1);if(SE_info_temp_pan_aktif==1){reset(SE_info_temp_pan,SHOW);}wait(-0.1);
	SE_create_info_pan(SE_Mat_Depot->matname_str[2],SE_Mat_Depot->effectname_str[2],SE_Mat_Depot->matname_mtl[2]);
}
function funcname_fnc3()
{
	wait(1);if(SE_info_temp_pan_aktif==1){reset(SE_info_temp_pan,SHOW);}wait(-0.1);
	SE_create_info_pan(SE_Mat_Depot->matname_str[3],SE_Mat_Depot->effectname_str[3],SE_Mat_Depot->matname_mtl[3]);
}
function funcname_fnc4()
{
	wait(1);if(SE_info_temp_pan_aktif==1){reset(SE_info_temp_pan,SHOW);}wait(-0.1);
	SE_create_info_pan(SE_Mat_Depot->matname_str[4],SE_Mat_Depot->effectname_str[4],SE_Mat_Depot->matname_mtl[4]);
}
function funcname_fnc5()
{
	wait(1);if(SE_info_temp_pan_aktif==1){reset(SE_info_temp_pan,SHOW);}wait(-0.1);
	SE_create_info_pan(SE_Mat_Depot->matname_str[5],SE_Mat_Depot->effectname_str[5],SE_Mat_Depot->matname_mtl[5]);
}
function funcname_fnc6()
{
	wait(1);if(SE_info_temp_pan_aktif==1){reset(SE_info_temp_pan,SHOW);}wait(-0.1);
	SE_create_info_pan(SE_Mat_Depot->matname_str[6],SE_Mat_Depot->effectname_str[6],SE_Mat_Depot->matname_mtl[6]);
}
function funcname_fnc7()
{
	wait(1);if(SE_info_temp_pan_aktif==1){reset(SE_info_temp_pan,SHOW);}wait(-0.1);
	SE_create_info_pan(SE_Mat_Depot->matname_str[7],SE_Mat_Depot->effectname_str[7],SE_Mat_Depot->matname_mtl[7]);
}
function funcname_fnc8()
{
	wait(1);if(SE_info_temp_pan_aktif==1){reset(SE_info_temp_pan,SHOW);}wait(-0.1);
	SE_create_info_pan(SE_Mat_Depot->matname_str[8],SE_Mat_Depot->effectname_str[8],SE_Mat_Depot->matname_mtl[8]);
}
function funcname_fnc9()
{
	wait(1);if(SE_info_temp_pan_aktif==1){reset(SE_info_temp_pan,SHOW);}wait(-0.1);
	SE_create_info_pan(SE_Mat_Depot->matname_str[9],SE_Mat_Depot->effectname_str[9],SE_Mat_Depot->matname_mtl[9]);
}
function funcname_fnc10()
{
	wait(1);if(SE_info_temp_pan_aktif==1){reset(SE_info_temp_pan,SHOW);}wait(-0.1);
	SE_create_info_pan(SE_Mat_Depot->matname_str[10],SE_Mat_Depot->effectname_str[10],SE_Mat_Depot->matname_mtl[10]);
}

function funcname_fnc11()
{
	wait(1);if(SE_info_temp_pan_aktif==1){reset(SE_info_temp_pan,SHOW);}wait(-0.1);
	SE_create_info_pan(SE_Mat_Depot->matname_str[11],SE_Mat_Depot->effectname_str[11],SE_Mat_Depot->matname_mtl[11]);
}
function funcname_fnc12()
{
	wait(1);if(SE_info_temp_pan_aktif==1){reset(SE_info_temp_pan,SHOW);}wait(-0.1);
	SE_create_info_pan(SE_Mat_Depot->matname_str[12],SE_Mat_Depot->effectname_str[12],SE_Mat_Depot->matname_mtl[12]);
}
function funcname_fnc13()
{
	wait(1);if(SE_info_temp_pan_aktif==1){reset(SE_info_temp_pan,SHOW);}wait(-0.1);
	SE_create_info_pan(SE_Mat_Depot->matname_str[13],SE_Mat_Depot->effectname_str[13],SE_Mat_Depot->matname_mtl[13]);
}
function funcname_fnc14()
{
	wait(1);if(SE_info_temp_pan_aktif==1){reset(SE_info_temp_pan,SHOW);}wait(-0.1);
	SE_create_info_pan(SE_Mat_Depot->matname_str[14],SE_Mat_Depot->effectname_str[14],SE_Mat_Depot->matname_mtl[14]);
}
function funcname_fnc15()
{
	wait(1);if(SE_info_temp_pan_aktif==1){reset(SE_info_temp_pan,SHOW);}wait(-0.1);
	SE_create_info_pan(SE_Mat_Depot->matname_str[15],SE_Mat_Depot->effectname_str[15],SE_Mat_Depot->matname_mtl[15]);
}

function funcname_fnc16()
{
	wait(1);if(SE_info_temp_pan_aktif==1){reset(SE_info_temp_pan,SHOW);}wait(-0.1);
	SE_create_info_pan(SE_Mat_Depot->matname_str[16],SE_Mat_Depot->effectname_str[16],SE_Mat_Depot->matname_mtl[16]);
}
function funcname_fnc17()
{
	wait(1);if(SE_info_temp_pan_aktif==1){reset(SE_info_temp_pan,SHOW);}wait(-0.1);
	SE_create_info_pan(SE_Mat_Depot->matname_str[17],SE_Mat_Depot->effectname_str[17],SE_Mat_Depot->matname_mtl[17]);
}
function funcname_fnc18()
{
	wait(1);if(SE_info_temp_pan_aktif==1){reset(SE_info_temp_pan,SHOW);}wait(-0.1);
	SE_create_info_pan(SE_Mat_Depot->matname_str[18],SE_Mat_Depot->effectname_str[18],SE_Mat_Depot->matname_mtl[18]);
}
function funcname_fnc19()
{
	wait(1);if(SE_info_temp_pan_aktif==1){reset(SE_info_temp_pan,SHOW);}wait(-0.1);
	SE_create_info_pan(SE_Mat_Depot->matname_str[19],SE_Mat_Depot->effectname_str[19],SE_Mat_Depot->matname_mtl[19]);
}
function funcname_fnc20()
{
	wait(1);if(SE_info_temp_pan_aktif==1){reset(SE_info_temp_pan,SHOW);}wait(-0.1);
	SE_create_info_pan(SE_Mat_Depot->matname_str[20],SE_Mat_Depot->effectname_str[20],SE_Mat_Depot->matname_mtl[20]);
}
function funcname_fnc21()
{
	wait(1);if(SE_info_temp_pan_aktif==1){reset(SE_info_temp_pan,SHOW);}wait(-0.1);
	SE_create_info_pan(SE_Mat_Depot->matname_str[21],SE_Mat_Depot->effectname_str[21],SE_Mat_Depot->matname_mtl[21]);
}
function funcname_fnc22()
{
	wait(1);if(SE_info_temp_pan_aktif==1){reset(SE_info_temp_pan,SHOW);}wait(-0.1);
	SE_create_info_pan(SE_Mat_Depot->matname_str[22],SE_Mat_Depot->effectname_str[22],SE_Mat_Depot->matname_mtl[22]);
}
function funcname_fnc23()
{
	wait(1);if(SE_info_temp_pan_aktif==1){reset(SE_info_temp_pan,SHOW);}wait(-0.1);
	SE_create_info_pan(SE_Mat_Depot->matname_str[23],SE_Mat_Depot->effectname_str[23],SE_Mat_Depot->matname_mtl[23]);
}
function funcname_fnc24()
{
	wait(1);if(SE_info_temp_pan_aktif==1){reset(SE_info_temp_pan,SHOW);}wait(-0.1);
	SE_create_info_pan(SE_Mat_Depot->matname_str[24],SE_Mat_Depot->effectname_str[24],SE_Mat_Depot->matname_mtl[24]);
}
function funcname_fnc25()
{
	wait(1);if(SE_info_temp_pan_aktif==1){reset(SE_info_temp_pan,SHOW);}wait(-0.1);
	SE_create_info_pan(SE_Mat_Depot->matname_str[25],SE_Mat_Depot->effectname_str[25],SE_Mat_Depot->matname_mtl[25]);
}
function funcname_fnc26()
{
	wait(1);if(SE_info_temp_pan_aktif==1){reset(SE_info_temp_pan,SHOW);}wait(-0.1);
	SE_create_info_pan(SE_Mat_Depot->matname_str[26],SE_Mat_Depot->effectname_str[26],SE_Mat_Depot->matname_mtl[26]);
}
function funcname_fnc27()
{
	wait(1);if(SE_info_temp_pan_aktif==1){reset(SE_info_temp_pan,SHOW);}wait(-0.1);
	SE_create_info_pan(SE_Mat_Depot->matname_str[27],SE_Mat_Depot->effectname_str[27],SE_Mat_Depot->matname_mtl[27]);
}
function funcname_fnc28() //---> reserved for mat_model
{
	wait(1);if(SE_info_temp_pan_aktif==1){reset(SE_info_temp_pan,SHOW);}wait(-0.1);
	SE_create_info_pan(SE_Mat_Depot->matname_str[28],SE_Mat_Depot->effectname_str[28],SE_Mat_Depot->matname_mtl[28]);
}

/*
function funcname_fnc29(){...............}
function funcname_fnc30(){...............}
more...
*/


function setup_shadereditor() 
{
	
	str_cpy(delimit_str,"$");
	if(video_screen==1)
	{
		video_switch(0,0,2);
	}
	se_view_mat_cont();

	if(se_maximize_window==1)
	{
		ShowWindow(hWnd,SW_SHOWMAXIMIZED); 
		RECT r;
		GetClientRect(hWnd,&r); 
		video_set(r.right,r.bottom,0,0); 	
	}


	wait(-2); //Entityler icin bekle
	
	if(num_entities<1)
	{
		//MessageBox(NULL,"There is no Entity!","!",MB_OK);
		error("There is no Entity!");
	}
	SE_Mat_Depot->funcname_fnc[1]=funcname_fnc1;
	SE_Mat_Depot->funcname_fnc[2]=funcname_fnc2;
	SE_Mat_Depot->funcname_fnc[3]=funcname_fnc3;
	SE_Mat_Depot->funcname_fnc[4]=funcname_fnc4;
	SE_Mat_Depot->funcname_fnc[5]=funcname_fnc5;
	SE_Mat_Depot->funcname_fnc[6]=funcname_fnc6;
	SE_Mat_Depot->funcname_fnc[7]=funcname_fnc7;
	SE_Mat_Depot->funcname_fnc[8]=funcname_fnc8;
	SE_Mat_Depot->funcname_fnc[9]=funcname_fnc9;
	SE_Mat_Depot->funcname_fnc[10]=funcname_fnc10;
	SE_Mat_Depot->funcname_fnc[11]=funcname_fnc11;
	SE_Mat_Depot->funcname_fnc[12]=funcname_fnc12;
	SE_Mat_Depot->funcname_fnc[13]=funcname_fnc13;
	SE_Mat_Depot->funcname_fnc[14]=funcname_fnc14;
	SE_Mat_Depot->funcname_fnc[15]=funcname_fnc15;
	SE_Mat_Depot->funcname_fnc[16]=funcname_fnc16;
	SE_Mat_Depot->funcname_fnc[17]=funcname_fnc17;
	SE_Mat_Depot->funcname_fnc[18]=funcname_fnc18;
	SE_Mat_Depot->funcname_fnc[19]=funcname_fnc19;
	SE_Mat_Depot->funcname_fnc[20]=funcname_fnc20;
	SE_Mat_Depot->funcname_fnc[21]=funcname_fnc21;
	SE_Mat_Depot->funcname_fnc[22]=funcname_fnc22;
	SE_Mat_Depot->funcname_fnc[23]=funcname_fnc23; //---> reserved for view_material 5
	SE_Mat_Depot->funcname_fnc[24]=funcname_fnc24; //---> reserved for view_material 4
	SE_Mat_Depot->funcname_fnc[25]=funcname_fnc25; //---> reserved for view_material 3
	SE_Mat_Depot->funcname_fnc[26]=funcname_fnc26; //---> reserved for view_material 2
	SE_Mat_Depot->funcname_fnc[27]=funcname_fnc27; //---> reserved for view_material 1
	SE_Mat_Depot->funcname_fnc[28]=funcname_fnc28; //---> reserved for mat_model
	/*
	SE_Mat_Depot->funcname_fnc[29]=funcname_fnc29;
	SE_Mat_Depot->funcname_fnc[30]=funcname_fnc30;
	more...
	*/
	int j;
	for (j=1; j<80; j++ ) //stringleri doldur (SE_Mat_Depot)[Stringler bos olursa hata verir]
	{ 
		SE_Mat_Depot->matname_str[j] = str_create("#45");
		SE_Mat_Depot->effectname_str[j] = str_create("#45");
	}
	var SE_mat_model_var=0;//mat_model icin ayirdik.
	j=1; 
	var i=0;
	var pan_dig_boyutu=10; //panel y ekseni
	if(se_view_mat_var1==1||se_view_mat_var2==1||se_view_mat_var3==1||se_view_mat_var4==1||se_view_mat_var5==1)
	{
		se_konsola_aktar("VIEW MATERIALS SEARCHING...","GORUS MATERYALLERI ARANIYOR...(1)",2);
	}
	se_konsola_aktar("MATERIALS SEARCHING...","MATERYALLER ARANIYOR...",0);

	you = ent_next(NULL);  //find material
	while (you) 
	{ 
		
		if(your.material!=mat_model)
		{

			i=0;
			for(j=1; j<80; j++) //ayni isimden var mi kontrol et (check same name)
			{
				if(str_cmp(_str(you.material.link.name),SE_Mat_Depot->matname_str[j])) //eger ayni isimse(if same name)
				{
					i=1; //atlayacak
					break; //birak
				}
				
			}
			j=0;
			if(i==0) //ayni isim degilse(if is not same name)
			{
				str_cpy(	SE_Mat_Depot->matname_str[SE_Mat_Depot->number],you.material.link.name);
				se_konsola_aktar(SE_Mat_Depot->matname_str[SE_Mat_Depot->number],SE_Mat_Depot->matname_str[SE_Mat_Depot->number],1);
				se_konsola_aktar("Found: ","Bulunan: ",0);
				if(your.material.effect!=NULL)
				{
					str_cpy(	SE_Mat_Depot->effectname_str[SE_Mat_Depot->number],you.material.effect);
					
				}
				
				SE_Mat_Depot->matname_mtl[SE_Mat_Depot->number]=you.material;
				
				pan_setbutton(SE_ana_panel,0,1,5,pan_dig_boyutu,se_bosbuton,se_bosbuton,se_bosbutonmavi,NULL,SE_Mat_Depot->funcname_fnc[SE_Mat_Depot->number],NULL,NULL);	
				
				
				
				if(font_sec==_bmfont)
				{
					pan_setdigits(SE_ana_panel,0,7,pan_dig_boyutu+7,SE_Mat_Depot->matname_str[SE_Mat_Depot->number],SE_ana_font,1,NULL);	
				}
				else
				{
					pan_setdigits(SE_ana_panel,0,7,pan_dig_boyutu+4,SE_Mat_Depot->matname_str[SE_Mat_Depot->number],SE_ana_font,1,NULL);	
				}
				
				
				
				SE_Mat_Depot->number+=1;
				pan_dig_boyutu+=25;
			}
			
		}
		else
		{
			if(SE_mat_model_var==0)
			{
				str_cpy(	SE_Mat_Depot->matname_str[28],you.material.link.name);
				if(your.material.effect!=NULL)
				{
					str_cpy(	SE_Mat_Depot->effectname_str[28],you.material.effect);	
					
				}
				SE_Mat_Depot->matname_mtl[28]=you.material;
				
				pan_setbutton(SE_ana_panel,0,1,5,pan_dig_boyutu,se_bosbuton,se_bosbuton,se_bosbutonmavi,NULL,SE_Mat_Depot->funcname_fnc[28],NULL,NULL);	
				
				
				
				if(font_sec==_bmfont)
				{
					pan_setdigits(SE_ana_panel,0,7,pan_dig_boyutu+7,SE_Mat_Depot->matname_str[28],SE_ana_font,1,NULL);	
				}
				else
				{
					pan_setdigits(SE_ana_panel,0,7,pan_dig_boyutu+4,SE_Mat_Depot->matname_str[28],SE_ana_font,1,NULL);	
				}
				SE_Mat_Depot->number+=1;
				pan_dig_boyutu+=25;
				#ifndef se_view_mat_addd
					#define se_view_mat_addd
					
					if(se_view_mat_var1==1)
					{
						
						se_konsola_aktar("","",1);
						se_konsola_aktar(se_view_mat_1_str,se_view_mat_1_str,0);
						se_konsola_aktar("VIEW MATERIAL FOUND: ","BULUNAN GORUS MATERYALI: ",0);
						se_konsola_aktar("","",1);
						se_view_mat_1 = SE_mat_for_str(_chr(se_view_mat_1_str));
						str_cpy(	SE_Mat_Depot->matname_str[27],se_view_mat_1_str);
						if(se_view_mat_1.effect!=NULL)
						{
							str_cpy(	SE_Mat_Depot->effectname_str[27],se_view_mat_1.effect);	
						}
						SE_Mat_Depot->matname_mtl[27]=se_view_mat_1;
						pan_setbutton(SE_ana_panel,0,1,5,pan_dig_boyutu,se_bosbuton,se_bosbuton,se_bosbutonmavi,NULL,SE_Mat_Depot->funcname_fnc[27],NULL,NULL);	
						if(font_sec==_bmfont)
						{
							pan_setdigits(SE_ana_panel,0,7,pan_dig_boyutu+7,SE_Mat_Depot->matname_str[27],SE_ana_font,1,NULL);	
						}
						else
						{
							pan_setdigits(SE_ana_panel,0,7,pan_dig_boyutu+4,SE_Mat_Depot->matname_str[27],SE_ana_font,1,NULL);	
						}
						SE_Mat_Depot->number+=1;
						pan_dig_boyutu+=25;
					}
					
					if(se_view_mat_var2==1)
					{
						se_konsola_aktar("","",1);
						se_konsola_aktar(se_view_mat_2_str,se_view_mat_2_str,0);
						se_konsola_aktar("VIEW MATERIAL FOUND: ","BULUNAN GORUS MATERYALI: ",0);
						se_konsola_aktar("","",1);
						se_view_mat_2 = SE_mat_for_str(_chr(se_view_mat_2_str));
						str_cpy(	SE_Mat_Depot->matname_str[26],se_view_mat_2_str);
						
						if(se_view_mat_2.effect!=NULL)
						{
							str_cpy(	SE_Mat_Depot->effectname_str[26],se_view_mat_2.effect);	
						}
						SE_Mat_Depot->matname_mtl[26]=se_view_mat_2;
						pan_setbutton(SE_ana_panel,0,1,5,pan_dig_boyutu,se_bosbuton,se_bosbuton,se_bosbutonmavi,NULL,SE_Mat_Depot->funcname_fnc[26],NULL,NULL);	
						if(font_sec==_bmfont)
						{
							pan_setdigits(SE_ana_panel,0,7,pan_dig_boyutu+7,SE_Mat_Depot->matname_str[26],SE_ana_font,1,NULL);	
						}
						else
						{
							pan_setdigits(SE_ana_panel,0,7,pan_dig_boyutu+4,SE_Mat_Depot->matname_str[26],SE_ana_font,1,NULL);	
						}
						SE_Mat_Depot->number+=1;
						pan_dig_boyutu+=25;
					}
					
					if(se_view_mat_var3==1)
					{
						
						se_konsola_aktar("","",1);
						se_konsola_aktar(se_view_mat_3_str,se_view_mat_3_str,0);
						se_konsola_aktar("VIEW MATERIAL FOUND: ","BULUNAN GORUS MATERYALI: ",0);
						se_konsola_aktar("","",1);
						se_view_mat_3 = SE_mat_for_str(_chr(se_view_mat_3_str));
						str_cpy(	SE_Mat_Depot->matname_str[25],se_view_mat_3_str);
						
						if(se_view_mat_3.effect!=NULL)
						{
							str_cpy(	SE_Mat_Depot->effectname_str[25],se_view_mat_3.effect);	
						}
						SE_Mat_Depot->matname_mtl[25]=se_view_mat_3;
						pan_setbutton(SE_ana_panel,0,1,5,pan_dig_boyutu,se_bosbuton,se_bosbuton,se_bosbutonmavi,NULL,SE_Mat_Depot->funcname_fnc[25],NULL,NULL);	
						if(font_sec==_bmfont)
						{
							pan_setdigits(SE_ana_panel,0,7,pan_dig_boyutu+7,SE_Mat_Depot->matname_str[25],SE_ana_font,1,NULL);	
						}
						else
						{
							pan_setdigits(SE_ana_panel,0,7,pan_dig_boyutu+4,SE_Mat_Depot->matname_str[25],SE_ana_font,1,NULL);	
						}
						SE_Mat_Depot->number+=1;
						pan_dig_boyutu+=25;
					}
					if(se_view_mat_var4==1)
					{
						
						se_konsola_aktar("","",1);
						se_konsola_aktar(se_view_mat_4_str,se_view_mat_4_str,0);
						se_konsola_aktar("VIEW MATERIAL FOUND: ","BULUNAN GORUS MATERYALI: ",0);
						se_konsola_aktar("","",1);
						se_view_mat_4 = SE_mat_for_str(_chr(se_view_mat_4_str));
						str_cpy(	SE_Mat_Depot->matname_str[24],se_view_mat_4_str);
						if(se_view_mat_4.effect!=NULL)
						{
							str_cpy(	SE_Mat_Depot->effectname_str[24],se_view_mat_4.effect);	
						}
						SE_Mat_Depot->matname_mtl[24]=se_view_mat_4;
						pan_setbutton(SE_ana_panel,0,1,5,pan_dig_boyutu,se_bosbuton,se_bosbuton,se_bosbutonmavi,NULL,SE_Mat_Depot->funcname_fnc[24],NULL,NULL);	
						if(font_sec==_bmfont)
						{
							pan_setdigits(SE_ana_panel,0,7,pan_dig_boyutu+7,SE_Mat_Depot->matname_str[24],SE_ana_font,1,NULL);	
						}
						else
						{
							pan_setdigits(SE_ana_panel,0,7,pan_dig_boyutu+4,SE_Mat_Depot->matname_str[24],SE_ana_font,1,NULL);	
						}
						SE_Mat_Depot->number+=1;
						pan_dig_boyutu+=25;
					}
					if(se_view_mat_var5==1)
					{
						
						se_konsola_aktar("","",1);
						se_konsola_aktar(se_view_mat_5_str,se_view_mat_5_str,0);
						se_konsola_aktar("VIEW MATERIAL FOUND: ","BULUNAN GORUS MATERYALI: ",0);
						se_konsola_aktar("","",1);
						se_view_mat_5 = SE_mat_for_str(_chr(se_view_mat_5_str));
						str_cpy(	SE_Mat_Depot->matname_str[23],se_view_mat_5_str);
						
						if(se_view_mat_5.effect!=NULL)
						{
							str_cpy(	SE_Mat_Depot->effectname_str[23],se_view_mat_5.effect);	
						}
						SE_Mat_Depot->matname_mtl[23]=se_view_mat_5;
						pan_setbutton(SE_ana_panel,0,1,5,pan_dig_boyutu,se_bosbuton,se_bosbuton,se_bosbutonmavi,NULL,SE_Mat_Depot->funcname_fnc[23],NULL,NULL);	
						if(font_sec==_bmfont)
						{
							pan_setdigits(SE_ana_panel,0,7,pan_dig_boyutu+7,SE_Mat_Depot->matname_str[23],SE_ana_font,1,NULL);	
						}
						else
						{
							pan_setdigits(SE_ana_panel,0,7,pan_dig_boyutu+4,SE_Mat_Depot->matname_str[23],SE_ana_font,1,NULL);	
						}
						SE_Mat_Depot->number+=1;
						pan_dig_boyutu+=25;
					}
				#endif
				SE_mat_model_var=1;
			}
		}
		you = ent_next(you); 
		
	}
	se_konsol_dev("DONE!","BITTI!",1);
	SE_Mat_Depot->total_number=SE_Mat_Depot->number-1;//maybe i need this later

}

/*
Asagidaki panelleri sonradan ekledim.
Materyal skinleri icin. Bir de info kaydetme fonksiyonu var oralarda.
*/

PANEL* SE_pan_mtlskn1 = 
{
	bmap = se_mtlskin1bmap;
	layer = 11;
	pos_x=250;
	pos_y=250;
	red=255;
	green=255;
	blue=255;
	//flags = LIGHT;
	on_click=se_open_texture;
}
PANEL* SE_pan_mtlskn2 = 
{
	bmap = se_mtlskin2bmap;
	layer = 11;
	pos_x=250;
	pos_y=250;
	red=255;
	green=255;
	blue=255;
	//flags = LIGHT;
	on_click=se_open_texture2;
}
PANEL* SE_pan_mtlskn3 = 
{
	bmap = se_mtlskin3bmap;
	layer = 11;
	pos_x=250;
	pos_y=250;
	red=255;
	green=255;
	blue=255;
	//flags =LIGHT;
	on_click=se_open_texture3;
}
PANEL* SE_pan_mtlskn4 = 
{
	bmap = se_mtlskin4bmap;
	layer = 11;
	pos_x=250;
	pos_y=250;
	red=255;
	green=255;
	blue=255;
	//flags = LIGHT;
	on_click=se_open_texture4;
}

PANEL* SE_pan_bmpskn1 = 
{
	bmap = se_bmpskin1bmap;
	layer = 11;	pos_x=250;pos_y=250;	red=255;
	green=255;	blue=255;
	on_click=se_open_bmptexture;
}
PANEL* SE_pan_bmpskn2 = 
{
	bmap = se_bmpskin2bmap;
	layer = 11;	pos_x=250;pos_y=250;	red=255;
	green=255;	blue=255;
	on_click=se_open_bmptexture2;
}
PANEL* SE_pan_bmpskn3 = 
{
	bmap = se_bmpskin3bmap;
	layer = 11;	pos_x=250;pos_y=250;	red=255;
	green=255;	blue=255;
	on_click=se_open_bmptexture3;
}
PANEL* SE_pan_bmpskn4 = 
{
	bmap = se_bmpskin4bmap;
	layer = 11;	pos_x=250;pos_y=250;	red=255;
	green=255;	blue=255;
	on_click=se_open_bmptexture4;
}
PANEL* SE_pan_bmpskn5 = 
{
	bmap = se_bmpskin5bmap;
	layer = 11;	pos_x=250;pos_y=250;	red=255;
	green=255;	blue=255;
	on_click=se_open_bmptexture5;
}
PANEL* SE_pan_bmpskn6 = 
{
	bmap = se_bmpskin6bmap;
	layer = 11;	pos_x=250;pos_y=250;	red=255;
	green=255;	blue=255;
	on_click=se_open_bmptexture6;
}
#ifndef se_over
	#define se_over
	STRING* SE_pan_bmpskntemp_str="#25";//bmap adini alacagiz. kucultme icin
	/*
	Buradaki mesel su. Paneller ve bmaplari boyut degistiriyor. 512 ve 128 arasinda
	eger kullanilan bmap bir depth view bmapi ise o da degisiyor ve goruntu bozuluyor.
	bmap in adinda depth vs. varsa, olayi atliyoruz.
	*/
	void SE_pan_overbmp1()
	{
		str_cpy(SE_pan_bmpskntemp_str,SE_pan_bmpskn1.bmap.link.name);
		if(str_stri(SE_pan_bmpskntemp_str,"depth")
		||str_stri(SE_pan_bmpskntemp_str,"refract")
		||str_stri(SE_pan_bmpskntemp_str,"mirror")
		||str_stri(SE_pan_bmpskntemp_str,"shadow"))
		{
			return;
		}
		SE_pan_bmpskn1.size_x=512;	
		SE_pan_bmpskn1.size_y=512;	
		wait(1);
		SE_pan_bmpskn1.bmap.finalwidth=512;
		SE_pan_bmpskn1.bmap.finalheight=512;
		
	}
	void SE_pan_overbmpoff1()
	{
		str_cpy(SE_pan_bmpskntemp_str,SE_pan_bmpskn1.bmap.link.name);
		if(str_stri(SE_pan_bmpskntemp_str,"depth")
		||str_stri(SE_pan_bmpskntemp_str,"refract")
		||str_stri(SE_pan_bmpskntemp_str,"mirror")
		||str_stri(SE_pan_bmpskntemp_str,"shadow"))
		{
			return;
		}
		SE_pan_bmpskn1.size_x=panel_skin_boyutu;	
		SE_pan_bmpskn1.size_y=panel_skin_boyutu;	
		wait(1);
		SE_pan_bmpskn1.bmap.finalwidth=panel_skin_boyutu;
		SE_pan_bmpskn1.bmap.finalheight=panel_skin_boyutu;
	}
	void SE_pan_overbmp2()
	{
		str_cpy(SE_pan_bmpskntemp_str,SE_pan_bmpskn2.bmap.link.name);
		if(str_stri(SE_pan_bmpskntemp_str,"depth")
		||str_stri(SE_pan_bmpskntemp_str,"refract")
		||str_stri(SE_pan_bmpskntemp_str,"mirror")
		||str_stri(SE_pan_bmpskntemp_str,"shadow"))
		{
			return;
		}
		SE_pan_bmpskn2.size_x=512;	
		SE_pan_bmpskn2.size_y=512;	
		wait(1);
		SE_pan_bmpskn2.bmap.finalwidth=512;
		SE_pan_bmpskn2.bmap.finalheight=512;
	}
	void SE_pan_overbmpoff2()
	{
		str_cpy(SE_pan_bmpskntemp_str,SE_pan_bmpskn2.bmap.link.name);
		if(str_stri(SE_pan_bmpskntemp_str,"depth")
		||str_stri(SE_pan_bmpskntemp_str,"refract")
		||str_stri(SE_pan_bmpskntemp_str,"mirror")
		||str_stri(SE_pan_bmpskntemp_str,"shadow"))
		{
			return;
		}
		SE_pan_bmpskn2.size_x=panel_skin_boyutu;	
		SE_pan_bmpskn2.size_y=panel_skin_boyutu;	
		wait(1);
		SE_pan_bmpskn2.bmap.finalwidth=panel_skin_boyutu;
		SE_pan_bmpskn2.bmap.finalheight=panel_skin_boyutu;
	}
	void SE_pan_overbmp3()
	{
		str_cpy(SE_pan_bmpskntemp_str,SE_pan_bmpskn3.bmap.link.name);
		if(str_stri(SE_pan_bmpskntemp_str,"depth")
		||str_stri(SE_pan_bmpskntemp_str,"refract")
		||str_stri(SE_pan_bmpskntemp_str,"mirror")
		||str_stri(SE_pan_bmpskntemp_str,"shadow"))
		{
			return;
		}
		SE_pan_bmpskn3.size_x=512;	
		SE_pan_bmpskn3.size_y=512;	
		wait(1);
		SE_pan_bmpskn3.bmap.finalwidth=512;
		SE_pan_bmpskn3.bmap.finalheight=512;
	}
	void SE_pan_overbmpoff3()
	{
		str_cpy(SE_pan_bmpskntemp_str,SE_pan_bmpskn3.bmap.link.name);
		if(str_stri(SE_pan_bmpskntemp_str,"depth")
		||str_stri(SE_pan_bmpskntemp_str,"refract")
		||str_stri(SE_pan_bmpskntemp_str,"mirror")
		||str_stri(SE_pan_bmpskntemp_str,"shadow"))
		{
			return;
		}
		SE_pan_bmpskn3.size_x=panel_skin_boyutu;	
		SE_pan_bmpskn3.size_y=panel_skin_boyutu;	
		wait(1);
		SE_pan_bmpskn3.bmap.finalwidth=panel_skin_boyutu;
		SE_pan_bmpskn3.bmap.finalheight=panel_skin_boyutu;
	}
	void SE_pan_overbmp4()
	{
		str_cpy(SE_pan_bmpskntemp_str,SE_pan_bmpskn4.bmap.link.name);
		if(str_stri(SE_pan_bmpskntemp_str,"depth")
		||str_stri(SE_pan_bmpskntemp_str,"refract")
		||str_stri(SE_pan_bmpskntemp_str,"mirror")
		||str_stri(SE_pan_bmpskntemp_str,"shadow"))
		{
			return;
		}
		SE_pan_bmpskn4.size_x=512;	
		SE_pan_bmpskn4.size_y=512;	
		wait(1);
		SE_pan_bmpskn4.bmap.finalwidth=512;
		SE_pan_bmpskn4.bmap.finalheight=512;
	}
	void SE_pan_overbmpoff4()
	{
		str_cpy(SE_pan_bmpskntemp_str,SE_pan_bmpskn4.bmap.link.name);
		if(str_stri(SE_pan_bmpskntemp_str,"depth")
		||str_stri(SE_pan_bmpskntemp_str,"refract")
		||str_stri(SE_pan_bmpskntemp_str,"mirror")
		||str_stri(SE_pan_bmpskntemp_str,"shadow"))
		{
			return;
		}
		SE_pan_bmpskn4.size_x=panel_skin_boyutu;	
		SE_pan_bmpskn4.size_y=panel_skin_boyutu;	
		wait(1);
		SE_pan_bmpskn4.bmap.finalwidth=panel_skin_boyutu;
		SE_pan_bmpskn4.bmap.finalheight=panel_skin_boyutu;
	}
	void SE_pan_overbmp5()
	{
		str_cpy(SE_pan_bmpskntemp_str,SE_pan_bmpskn5.bmap.link.name);
		if(str_stri(SE_pan_bmpskntemp_str,"depth")
		||str_stri(SE_pan_bmpskntemp_str,"refract")
		||str_stri(SE_pan_bmpskntemp_str,"mirror")
		||str_stri(SE_pan_bmpskntemp_str,"shadow"))
		{
			return;
		}
		SE_pan_bmpskn5.size_x=512;	
		SE_pan_bmpskn5.size_y=512;	
		wait(1);
		SE_pan_bmpskn5.bmap.finalwidth=512;
		SE_pan_bmpskn5.bmap.finalheight=512;
	}
	void SE_pan_overbmpoff5()
	{
		str_cpy(SE_pan_bmpskntemp_str,SE_pan_bmpskn5.bmap.link.name);
		if(str_stri(SE_pan_bmpskntemp_str,"depth")
		||str_stri(SE_pan_bmpskntemp_str,"refract")
		||str_stri(SE_pan_bmpskntemp_str,"mirror")
		||str_stri(SE_pan_bmpskntemp_str,"shadow"))
		{
			return;
		}
		SE_pan_bmpskn5.size_x=panel_skin_boyutu;	
		SE_pan_bmpskn5.size_y=panel_skin_boyutu;	
		wait(1);
		SE_pan_bmpskn5.bmap.finalwidth=panel_skin_boyutu;
		SE_pan_bmpskn5.bmap.finalheight=panel_skin_boyutu;
	}
	void SE_pan_overbmp6()
	{
		str_cpy(SE_pan_bmpskntemp_str,SE_pan_bmpskn6.bmap.link.name);
		if(str_stri(SE_pan_bmpskntemp_str,"depth")
		||str_stri(SE_pan_bmpskntemp_str,"refract")
		||str_stri(SE_pan_bmpskntemp_str,"mirror")
		||str_stri(SE_pan_bmpskntemp_str,"shadow"))
		{
			return;
		}
		SE_pan_bmpskn6.size_x=512;	
		SE_pan_bmpskn6.size_y=512;	
		wait(1);
		SE_pan_bmpskn6.bmap.finalwidth=512;
		SE_pan_bmpskn6.bmap.finalheight=512;
	}
	void SE_pan_overbmpoff6()
	{
		str_cpy(SE_pan_bmpskntemp_str,SE_pan_bmpskn6.bmap.link.name);
		if(str_stri(SE_pan_bmpskntemp_str,"depth")
		||str_stri(SE_pan_bmpskntemp_str,"refract")
		||str_stri(SE_pan_bmpskntemp_str,"mirror")
		||str_stri(SE_pan_bmpskntemp_str,"shadow"))
		{
			return;
		}
		SE_pan_bmpskn6.size_x=panel_skin_boyutu;	
		SE_pan_bmpskn6.size_y=panel_skin_boyutu;	
		wait(1);
		SE_pan_bmpskn6.bmap.finalwidth=panel_skin_boyutu;
		SE_pan_bmpskn6.bmap.finalheight=panel_skin_boyutu;
	}
	
	//mtl
	void SE_pan_overmtl1()
	{
		SE_pan_mtlskn1.size_x=512;	
		SE_pan_mtlskn1.size_y=512;	
		wait(1);
		SE_pan_mtlskn1.bmap.finalwidth=512;
		SE_pan_mtlskn1.bmap.finalheight=512;
	}
	void SE_pan_overmtloff1()
	{
		SE_pan_mtlskn1.size_x=panel_skin_boyutu;	
		SE_pan_mtlskn1.size_y=panel_skin_boyutu;	
		wait(1);
		SE_pan_mtlskn1.bmap.finalwidth=panel_skin_boyutu;
		SE_pan_mtlskn1.bmap.finalheight=panel_skin_boyutu;
	}
	void SE_pan_overmtl2()
	{
		SE_pan_mtlskn2.size_x=512;	
		SE_pan_mtlskn2.size_y=512;	
		wait(1);
		SE_pan_mtlskn2.bmap.finalwidth=512;
		SE_pan_mtlskn2.bmap.finalheight=512;
	}
	void SE_pan_overmtloff2()
	{
		SE_pan_mtlskn2.size_x=panel_skin_boyutu;	
		SE_pan_mtlskn2.size_y=panel_skin_boyutu;	
		wait(1);
		SE_pan_mtlskn2.bmap.finalwidth=panel_skin_boyutu;
		SE_pan_mtlskn2.bmap.finalheight=panel_skin_boyutu;
	}
	void SE_pan_overmtl3()
	{
		SE_pan_mtlskn3.size_x=512;	
		SE_pan_mtlskn3.size_y=512;	
		wait(1);
		SE_pan_mtlskn3.bmap.finalwidth=512;
		SE_pan_mtlskn3.bmap.finalheight=512;

	}
	void SE_pan_overmtloff3()
	{
		SE_pan_mtlskn3.size_x=panel_skin_boyutu;	
		SE_pan_mtlskn3.size_y=panel_skin_boyutu;	
		wait(1);
		SE_pan_mtlskn3.bmap.finalwidth=panel_skin_boyutu;
		SE_pan_mtlskn3.bmap.finalheight=panel_skin_boyutu;
		
	}
	void SE_pan_overmtl4()
	{
		SE_pan_mtlskn4.size_x=512;	
		SE_pan_mtlskn4.size_y=512;	
		wait(1);
		SE_pan_mtlskn4.bmap.finalwidth=512;
		SE_pan_mtlskn4.bmap.finalheight=512;
	}
	void SE_pan_overmtloff4()
	{
		SE_pan_mtlskn4.size_x=panel_skin_boyutu;	
		SE_pan_mtlskn4.size_y=panel_skin_boyutu;	
		wait(1);
		SE_pan_mtlskn4.bmap.finalwidth=panel_skin_boyutu;
		SE_pan_mtlskn4.bmap.finalheight=panel_skin_boyutu;
	}
#endif
void SE_panmtl_startup()
{
	wait(-3);

	SE_pan_mtlskn1.size_x=panel_skin_boyutu;
	SE_pan_mtlskn1.size_y=panel_skin_boyutu;
	SE_pan_mtlskn1.pos_x=0;
	SE_pan_mtlskn1.pos_y=screen_size.y-128;
	pan_setdigits(SE_pan_mtlskn1,0,30,10,"MTL.SKIN1",SE_ana_font,0,0);
	pan_setbutton(SE_pan_mtlskn1,0,0,0,0,se_lookbmap,se_lookbmap,se_lookbmap,NULL,NULL,SE_pan_overmtloff1,SE_pan_overmtl1);
	
	SE_pan_mtlskn2.size_x=panel_skin_boyutu;
	SE_pan_mtlskn2.size_y=panel_skin_boyutu;
	SE_pan_mtlskn2.pos_x=128;
	SE_pan_mtlskn2.pos_y=screen_size.y-128;
	pan_setdigits(SE_pan_mtlskn2,0,30,10,"MTL.SKIN2",SE_ana_font,0,0);
	pan_setbutton(SE_pan_mtlskn2,0,0,0,0,se_lookbmap,se_lookbmap,se_lookbmap,NULL,NULL,SE_pan_overmtloff2,SE_pan_overmtl2);
	
	SE_pan_mtlskn3.size_x=panel_skin_boyutu;
	SE_pan_mtlskn3.size_y=panel_skin_boyutu;
	SE_pan_mtlskn3.pos_x=0;//256
	SE_pan_mtlskn3.pos_y=screen_size.y-256;
	pan_setdigits(SE_pan_mtlskn3,0,30,10,"MTL.SKIN3",SE_ana_font,0,0);
	pan_setbutton(SE_pan_mtlskn3,0,0,0,0,se_lookbmap,se_lookbmap,se_lookbmap,NULL,NULL,SE_pan_overmtloff3,SE_pan_overmtl3);
	
	SE_pan_mtlskn4.size_x=panel_skin_boyutu;
	SE_pan_mtlskn4.size_y=panel_skin_boyutu;
	SE_pan_mtlskn4.pos_x=128;//384
	SE_pan_mtlskn4.pos_y=screen_size.y-256;
	pan_setdigits(SE_pan_mtlskn4,0,30,10,"MTL.SKIN4",SE_ana_font,0,0);
	pan_setbutton(SE_pan_mtlskn4,0,0,0,0,se_lookbmap,se_lookbmap,se_lookbmap,NULL,NULL,SE_pan_overmtloff4,SE_pan_overmtl4);
	
	//bmap
	SE_pan_bmpskn1.size_x=panel_skin_boyutu;
	SE_pan_bmpskn1.size_y=panel_skin_boyutu;
	SE_pan_bmpskn1.pos_x=256;//384
	SE_pan_bmpskn1.pos_y=screen_size.y-128;
	pan_setdigits(SE_pan_bmpskn1,0,30,10,"MTL.BMAP1",SE_ana_font,0,0);
	pan_setbutton(SE_pan_bmpskn1,0,0,0,0,se_lookbmap,se_lookbmap,se_lookbmap,NULL,NULL,SE_pan_overbmpoff1,SE_pan_overbmp1);
	SE_pan_bmpskn2.size_x=panel_skin_boyutu;
	SE_pan_bmpskn2.size_y=panel_skin_boyutu;
	SE_pan_bmpskn2.pos_x=384;//384
	SE_pan_bmpskn2.pos_y=screen_size.y-128;
	pan_setdigits(SE_pan_bmpskn2,0,30,10,"MTL.BMAP2",SE_ana_font,0,0);
	pan_setbutton(SE_pan_bmpskn2,0,0,0,0,se_lookbmap,se_lookbmap,se_lookbmap,NULL,NULL,SE_pan_overbmpoff2,SE_pan_overbmp2);
	SE_pan_bmpskn3.size_x=panel_skin_boyutu;
	SE_pan_bmpskn3.size_y=panel_skin_boyutu;
	SE_pan_bmpskn3.pos_x=256;//512
	SE_pan_bmpskn3.pos_y=screen_size.y-256;//screen_size.y-128;
	pan_setdigits(SE_pan_bmpskn3,0,30,10,"MTL.BMAP3",SE_ana_font,0,0);
	pan_setbutton(SE_pan_bmpskn3,0,0,0,0,se_lookbmap,se_lookbmap,se_lookbmap,NULL,NULL,SE_pan_overbmpoff3,SE_pan_overbmp3);
	SE_pan_bmpskn4.size_x=panel_skin_boyutu;
	SE_pan_bmpskn4.size_y=panel_skin_boyutu;
	SE_pan_bmpskn4.pos_x=384;//640
	SE_pan_bmpskn4.pos_y=screen_size.y-256;
	pan_setdigits(SE_pan_bmpskn4,0,30,10,"MTL.BMAP4",SE_ana_font,0,0);
	pan_setbutton(SE_pan_bmpskn4,0,0,0,0,se_lookbmap,se_lookbmap,se_lookbmap,NULL,NULL,SE_pan_overbmpoff4,SE_pan_overbmp4);


	SE_pan_bmpskn5.size_x=panel_skin_boyutu;
	SE_pan_bmpskn5.size_y=panel_skin_boyutu;
	SE_pan_bmpskn5.pos_x=512;//640
	SE_pan_bmpskn5.pos_y=screen_size.y-128;
	pan_setdigits(SE_pan_bmpskn5,0,30,10,"MTL.BMAP5",SE_ana_font,0,0);
	pan_setbutton(SE_pan_bmpskn5,0,0,0,0,se_lookbmap,se_lookbmap,se_lookbmap,NULL,NULL,SE_pan_overbmpoff5,SE_pan_overbmp5);
	SE_pan_bmpskn6.size_x=panel_skin_boyutu;
	SE_pan_bmpskn6.size_y=panel_skin_boyutu;
	SE_pan_bmpskn6.pos_x=512;//640
	SE_pan_bmpskn6.pos_y=screen_size.y-256;
	pan_setdigits(SE_pan_bmpskn6,0,30,10,"MTL.BMAP6",SE_ana_font,0,0);
	pan_setbutton(SE_pan_bmpskn6,0,0,0,0,se_lookbmap,se_lookbmap,se_lookbmap,NULL,NULL,SE_pan_overbmpoff6,SE_pan_overbmp6);
	__oO(
	/*SE_deger_pan.pos_x=screen_size.x-120-128;
	SE_deger_pan.pos_y=screen_size.y-45;
	SE_temp_txt.pos_x=SE_deger_pan.pos_x+10;
	SE_temp_txt.pos_y=SE_deger_pan.pos_y+22;*/
	SE_deger_pan.pos_x=screen_size.x-110-128;
	SE_deger_pan.pos_y=screen_size.y-140;
	SE_temp_txt.pos_x=SE_deger_pan.pos_x+10;
	SE_temp_txt.pos_y=SE_deger_pan.pos_y+22;
	)	
	

	
}
STRING* se_skin1_str="#35";
STRING* se_skin2_str="#35";
STRING* se_skin3_str="#35";
STRING* se_skin4_str="#35";

STRING* se_bmap1_str="#35";
STRING* se_bmap2_str="#35";
STRING* se_bmap3_str="#35";
STRING* se_bmap4_str="#35";
STRING* se_bmap5_str="#35";
STRING* se_bmap6_str="#35";
var se_skin_degisti[5]; //->Skin degismediyse, info kaydederken belirtecegiz
var se_bmap_degisti[7]; //->Skin degismediyse, info kaydederken belirtecegiz
function se_open_bmptexture()
{
	wait(1);

	char szFile[MAX_PATH];
	char szFile2[MAX_PATH];
	ZeroMemory(szFile, MAX_PATH);
	OPENFILENAME ofn;
	ZeroMemory(&ofn, sizeof(OPENFILENAME));
	ofn.lStructSize	= sizeof(OPENFILENAME);
	ofn.Flags		= OFN_FILEMUSTEXIST | OFN_PATHMUSTEXIST | OFN_HIDEREADONLY | OFN_NOCHANGEDIR;
	ofn.lpstrFilter	= "Supported File Types(*.png,*.tga,*.bmp,*.pcx,*.dds,*.jpg)\0*.tga;*.png;*.bmp;*.pcx;*.jpg;*.dds\0\0";
	ofn.nMaxFileTitle =MAX_PATH;
	ofn.lpstrFileTitle = szFile2;
	ofn.lpstrTitle	= "Load Image";
	ofn.lpstrFile	= szFile;
	ofn.nMaxFile	= MAX_PATH;
	if ( GetOpenFileName(&ofn) )
	{

		wait(1);
		SE_pan_bmpskn1.bmap.finalwidth=512;
		SE_pan_bmpskn1.bmap.finalheight=512;

		
		bmap_load(se_bmpskin1bmap,szFile,0);
		bmap_load(SE_pan_bmpskn1.bmap,szFile,0);
		str_cpy(se_bmap1_str,szFile);
		se_bmap_degisti[1]=1;
		se_konsola_aktar("_BMAP CHANGED","_BMAP DEGISTIRILDI",2);
		se_konsola_aktar(szFile,szFile,1);
		se_konsola_aktar("NEW FILE:  ","YENI DOSYA: ",0);
		se_konsola_aktar(se_fxbmapname1,se_fxbmapname1,1);
		se_konsola_aktar("CHANGED FILE NAME:  ","DEGISTIRILEN DOSYANIN ADI:  ",0);
		wait(1);
		SE_pan_bmpskn1.bmap.finalwidth=panel_skin_boyutu;
		SE_pan_bmpskn1.bmap.finalheight=panel_skin_boyutu;
		
	}
}
function se_open_bmptexture2()
{
	wait(1);

	char szFile[MAX_PATH];
	char szFile2[MAX_PATH];
	ZeroMemory(szFile, MAX_PATH);
	OPENFILENAME ofn;
	ZeroMemory(&ofn, sizeof(OPENFILENAME));
	ofn.lStructSize	= sizeof(OPENFILENAME);
	ofn.Flags		= OFN_FILEMUSTEXIST | OFN_PATHMUSTEXIST | OFN_HIDEREADONLY | OFN_NOCHANGEDIR;
	ofn.lpstrFilter	= "Supported File Types(*.png,*.tga,*.bmp,*.pcx,*.dds,*.jpg)\0*.tga;*.png;*.bmp;*.pcx;*.jpg;*.dds\0\0";
	ofn.nMaxFileTitle =MAX_PATH;
	ofn.lpstrFileTitle = szFile2;
	ofn.lpstrTitle	= "Load Image";
	ofn.lpstrFile	= szFile;
	ofn.nMaxFile	= MAX_PATH;
	if ( GetOpenFileName(&ofn) )
	{
		wait(1);
		SE_pan_bmpskn2.bmap.finalwidth=512;
		SE_pan_bmpskn2.bmap.finalheight=512;
		
		bmap_load(se_bmpskin2bmap,szFile,0);
		bmap_load(SE_pan_bmpskn2.bmap,szFile,0);
		str_cpy(se_bmap2_str,szFile);
		se_bmap_degisti[2]=1;
		
		se_konsola_aktar("_BMAP CHANGED","_BMAP DEGISTIRILDI",2);
		se_konsola_aktar(szFile,szFile,1);
		se_konsola_aktar("NEW FILE:  ","YENI DOSYA: ",0);
		se_konsola_aktar(se_fxbmapname2,se_fxbmapname2,1);
		se_konsola_aktar("CHANGED FILE NAME:  ","DEGISTIRILEN DOSYANIN ADI:  ",0);
		wait(1);
		SE_pan_bmpskn2.bmap.finalwidth=panel_skin_boyutu;
		SE_pan_bmpskn2.bmap.finalheight=panel_skin_boyutu;
		
	}
}
function se_open_bmptexture3()
{
	wait(1);

	char szFile[MAX_PATH];
	char szFile2[MAX_PATH];
	ZeroMemory(szFile, MAX_PATH);
	OPENFILENAME ofn;
	ZeroMemory(&ofn, sizeof(OPENFILENAME));
	ofn.lStructSize	= sizeof(OPENFILENAME);
	ofn.Flags		= OFN_FILEMUSTEXIST | OFN_PATHMUSTEXIST | OFN_HIDEREADONLY | OFN_NOCHANGEDIR;
	ofn.lpstrFilter	= "Supported File Types(*.png,*.tga,*.bmp,*.pcx,*.dds,*.jpg)\0*.tga;*.png;*.bmp;*.pcx;*.jpg;*.dds\0\0";
	ofn.nMaxFileTitle =MAX_PATH;
	ofn.lpstrFileTitle = szFile2;
	ofn.lpstrTitle	= "Load Image";
	ofn.lpstrFile	= szFile;
	ofn.nMaxFile	= MAX_PATH;
	if ( GetOpenFileName(&ofn) )
	{
		wait(1);
		SE_pan_bmpskn3.bmap.finalwidth=512;
		SE_pan_bmpskn3.bmap.finalheight=512;
		bmap_load(se_bmpskin3bmap,szFile,0);
		bmap_load(SE_pan_bmpskn3.bmap,szFile,0);
		str_cpy(se_bmap3_str,szFile);
		se_bmap_degisti[3]=1;
		
		se_konsola_aktar("_BMAP CHANGED","_BMAP DEGISTIRILDI",2);
		se_konsola_aktar(szFile,szFile,1);
		se_konsola_aktar("NEW FILE:  ","YENI DOSYA: ",0);
		se_konsola_aktar(se_fxbmapname3,se_fxbmapname3,1);
		se_konsola_aktar("CHANGED FILE NAME:  ","DEGISTIRILEN DOSYANIN ADI:  ",0);
		wait(1);
		SE_pan_bmpskn3.bmap.finalwidth=panel_skin_boyutu;
		SE_pan_bmpskn3.bmap.finalheight=panel_skin_boyutu;
	}
}
function se_open_bmptexture4()
{
	wait(1);

	char szFile[MAX_PATH];
	char szFile2[MAX_PATH];
	ZeroMemory(szFile, MAX_PATH);
	OPENFILENAME ofn;
	ZeroMemory(&ofn, sizeof(OPENFILENAME));
	ofn.lStructSize	= sizeof(OPENFILENAME);
	ofn.Flags		= OFN_FILEMUSTEXIST | OFN_PATHMUSTEXIST | OFN_HIDEREADONLY | OFN_NOCHANGEDIR;
	ofn.lpstrFilter	= "Supported File Types(*.png,*.tga,*.bmp,*.pcx,*.dds,*.jpg)\0*.tga;*.png;*.bmp;*.pcx;*.jpg;*.dds\0\0";
	ofn.nMaxFileTitle =MAX_PATH;
	ofn.lpstrFileTitle = szFile2;
	ofn.lpstrTitle	= "Load Image";
	ofn.lpstrFile	= szFile;
	ofn.nMaxFile	= MAX_PATH;
	if ( GetOpenFileName(&ofn) )
	{
		wait(1);

		SE_pan_bmpskn4.bmap.finalwidth=512;
		SE_pan_bmpskn4.bmap.finalheight=512;
		bmap_load(se_bmpskin4bmap,szFile,0);
		bmap_load(SE_pan_bmpskn4.bmap,szFile,0);
		str_cpy(se_bmap4_str,szFile);
		se_bmap_degisti[4]=1;
		se_konsola_aktar("_BMAP CHANGED","_BMAP DEGISTIRILDI",2);
		se_konsola_aktar(szFile,szFile,1);
		se_konsola_aktar("NEW FILE:  ","YENI DOSYA: ",0);
		se_konsola_aktar(se_fxbmapname4,se_fxbmapname4,1);
		se_konsola_aktar("CHANGED FILE NAME:  ","DEGISTIRILEN DOSYANIN ADI:  ",0);
		wait(1);
		SE_pan_bmpskn4.bmap.finalwidth=panel_skin_boyutu;
		SE_pan_bmpskn4.bmap.finalheight=panel_skin_boyutu;
		wait(1);

	}
}
function se_open_bmptexture5()
{
	wait(1);

	char szFile[MAX_PATH];
	char szFile2[MAX_PATH];
	ZeroMemory(szFile, MAX_PATH);
	OPENFILENAME ofn;
	ZeroMemory(&ofn, sizeof(OPENFILENAME));
	ofn.lStructSize	= sizeof(OPENFILENAME);
	ofn.Flags		= OFN_FILEMUSTEXIST | OFN_PATHMUSTEXIST | OFN_HIDEREADONLY | OFN_NOCHANGEDIR;
	ofn.lpstrFilter	= "Supported File Types(*.png,*.tga,*.bmp,*.pcx,*.dds,*.jpg)\0*.tga;*.png;*.bmp;*.pcx;*.jpg;*.dds\0\0";
	ofn.nMaxFileTitle =MAX_PATH;
	ofn.lpstrFileTitle = szFile2;
	ofn.lpstrTitle	= "Load Image";
	ofn.lpstrFile	= szFile;
	ofn.nMaxFile	= MAX_PATH;
	if ( GetOpenFileName(&ofn) )
	{
		wait(1);
		SE_pan_bmpskn5.bmap.finalwidth=512;
		SE_pan_bmpskn5.bmap.finalheight=512;
		bmap_load(se_bmpskin5bmap,szFile,0);
		bmap_load(SE_pan_bmpskn5.bmap,szFile,0);
		str_cpy(se_bmap5_str,szFile);
		se_bmap_degisti[5]=1;
		
		se_konsola_aktar("_BMAP CHANGED","_BMAP DEGISTIRILDI",2);
		se_konsola_aktar(szFile,szFile,1);
		se_konsola_aktar("NEW FILE:  ","YENI DOSYA: ",0);
		se_konsola_aktar(se_fxbmapname5,se_fxbmapname5,1);
		se_konsola_aktar("CHANGED FILE NAME:  ","DEGISTIRILEN DOSYANIN ADI:  ",0);
		wait(1);
		SE_pan_bmpskn5.bmap.finalwidth=panel_skin_boyutu;
		SE_pan_bmpskn5.bmap.finalheight=panel_skin_boyutu;
	}
}
function se_open_bmptexture6()
{
	wait(1);

	char szFile[MAX_PATH];
	char szFile2[MAX_PATH];
	ZeroMemory(szFile, MAX_PATH);
	OPENFILENAME ofn;
	ZeroMemory(&ofn, sizeof(OPENFILENAME));
	ofn.lStructSize	= sizeof(OPENFILENAME);
	ofn.Flags		= OFN_FILEMUSTEXIST | OFN_PATHMUSTEXIST | OFN_HIDEREADONLY | OFN_NOCHANGEDIR;
	ofn.lpstrFilter	= "Supported File Types(*.png,*.tga,*.bmp,*.pcx,*.dds,*.jpg)\0*.tga;*.png;*.bmp;*.pcx;*.jpg;*.dds\0\0";
	ofn.nMaxFileTitle =MAX_PATH;
	ofn.lpstrFileTitle = szFile2;
	ofn.lpstrTitle	= "Load Image";
	ofn.lpstrFile	= szFile;
	ofn.nMaxFile	= MAX_PATH;
	if ( GetOpenFileName(&ofn) )
	{
		wait(1);
		SE_pan_bmpskn6.bmap.finalwidth=512;
		SE_pan_bmpskn6.bmap.finalheight=512;
		bmap_load(se_bmpskin6bmap,szFile,0);
		bmap_load(SE_pan_bmpskn6.bmap,szFile,0);
		str_cpy(se_bmap5_str,szFile);
		se_bmap_degisti[6]=1;
		
		se_konsola_aktar("_BMAP CHANGED","_BMAP DEGISTIRILDI",2);
		se_konsola_aktar(szFile,szFile,1);
		se_konsola_aktar("NEW FILE:  ","YENI DOSYA: ",0);
		se_konsola_aktar(se_fxbmapname6,se_fxbmapname6,1);
		se_konsola_aktar("CHANGED FILE NAME:  ","DEGISTIRILEN DOSYANIN ADI:  ",0);
		wait(1);
		SE_pan_bmpskn6.bmap.finalwidth=panel_skin_boyutu;
		SE_pan_bmpskn6.bmap.finalheight=panel_skin_boyutu;
	}
}
function se_open_texture()
{
	wait(1);

	char szFile[MAX_PATH];
	char szFile2[MAX_PATH];
	ZeroMemory(szFile, MAX_PATH);
	OPENFILENAME ofn;
	ZeroMemory(&ofn, sizeof(OPENFILENAME));
	ofn.lStructSize	= sizeof(OPENFILENAME);
	ofn.Flags		= OFN_FILEMUSTEXIST | OFN_PATHMUSTEXIST | OFN_HIDEREADONLY | OFN_NOCHANGEDIR;
	ofn.lpstrFilter	= "Supported File Types(*.png,*.tga,*.bmp,*.pcx,*.dds,*.jpg)\0*.tga;*.png;*.bmp;*.pcx;*.jpg;*.dds\0\0";
	ofn.nMaxFileTitle =MAX_PATH;
	ofn.lpstrFileTitle = szFile2;
	ofn.lpstrTitle	= "Load Image";
	ofn.lpstrFile	= szFile;
	ofn.nMaxFile	= MAX_PATH;
	if ( GetOpenFileName(&ofn) )
	{

		wait(1);
		SE_pan_mtlskn1.bmap.finalwidth=512;
		SE_pan_mtlskn1.bmap.finalheight=512;

		
		bmap_load(se_mtlskin1bmap,szFile,0);
		bmap_load(su_anki_mat.skin1,szFile,0);	
		str_cpy(se_skin1_str,szFile);
		se_skin_degisti[1]=1;
		
		se_konsola_aktar("SKIN1 CHANGED","SKIN1 DEGISTIRILDI",2);
		se_konsola_aktar(szFile,szFile,1);
		se_konsola_aktar("NEW FILE:  ","YENI DOSYA:  ",0);
		wait(1);
		SE_pan_mtlskn1.bmap.finalwidth=panel_skin_boyutu;
		SE_pan_mtlskn1.bmap.finalheight=panel_skin_boyutu;
		
		
	}
}
function se_open_texture2()
{
	wait(1);
	char szFile[MAX_PATH];
	char szFile2[MAX_PATH];
	ZeroMemory(szFile, MAX_PATH);
	OPENFILENAME ofn;
	ZeroMemory(&ofn, sizeof(OPENFILENAME));
	ofn.lStructSize	= sizeof(OPENFILENAME);
	ofn.Flags		= OFN_FILEMUSTEXIST | OFN_PATHMUSTEXIST | OFN_HIDEREADONLY | OFN_NOCHANGEDIR;
	ofn.lpstrFilter	= "Supported File Types(*.png,*.tga,*.bmp,*.pcx,*.dds,*.jpg)\0*.tga;*.png;*.bmp;*.pcx;*.jpg;*.dds\0\0";
	ofn.nMaxFileTitle =MAX_PATH;
	ofn.lpstrFileTitle = szFile2;
	ofn.lpstrTitle	= "Load Image";
	ofn.lpstrFile	= szFile;
	ofn.nMaxFile	= MAX_PATH;
	if ( GetOpenFileName(&ofn) )
	{

		wait(1);
		SE_pan_mtlskn2.bmap.finalwidth=512;
		SE_pan_mtlskn2.bmap.finalheight=512;
		
		bmap_load(se_mtlskin2bmap,szFile,0);
		bmap_load(su_anki_mat.skin2,szFile,0);	
		str_cpy(se_skin2_str,szFile);
		se_skin_degisti[2]=1;
		se_konsola_aktar("SKIN2 CHANGED","SKIN2 DEGISTIRILDI",2);
		se_konsola_aktar(szFile,szFile,1);
		se_konsola_aktar("NEW FILE:  ","YENI DOSYA:  ",0);
		wait(1);
		SE_pan_mtlskn2.bmap.finalwidth=panel_skin_boyutu;
		SE_pan_mtlskn2.bmap.finalheight=panel_skin_boyutu;
	}
	
}
function se_open_texture3()
{
	wait(1);
	char szFile[MAX_PATH];
	char szFile2[MAX_PATH];
	ZeroMemory(szFile, MAX_PATH);
	OPENFILENAME ofn;
	ZeroMemory(&ofn, sizeof(OPENFILENAME));
	ofn.lStructSize	= sizeof(OPENFILENAME);
	ofn.Flags		= OFN_FILEMUSTEXIST | OFN_PATHMUSTEXIST | OFN_HIDEREADONLY | OFN_NOCHANGEDIR;
	ofn.lpstrFilter	= "Supported File Types(*.png,*.tga,*.bmp,*.pcx,*.dds,*.jpg)\0*.tga;*.png;*.bmp;*.pcx;*.jpg;*.dds\0\0";
	ofn.nMaxFileTitle =MAX_PATH;
	ofn.lpstrFileTitle = szFile2;
	ofn.lpstrTitle	= "Load Image";
	ofn.lpstrFile	= szFile;
	ofn.nMaxFile	= MAX_PATH;
	if ( GetOpenFileName(&ofn) )
	{

		wait(1);
		SE_pan_mtlskn3.bmap.finalwidth=512;
		SE_pan_mtlskn3.bmap.finalheight=512;
		bmap_load(se_mtlskin3bmap,szFile,0);
		bmap_load(su_anki_mat.skin3,szFile,0);
		str_cpy(se_skin3_str,szFile);	
		se_skin_degisti[3]=1;
		
		se_konsola_aktar("SKIN3 CHANGED","SKIN3 DEGISTIRILDI",2);
		se_konsola_aktar(szFile,szFile,1);
		se_konsola_aktar("NEW FILE:  ","YENI DOSYA:  ",0);
		wait(1);
		SE_pan_mtlskn3.bmap.finalwidth=panel_skin_boyutu;
		SE_pan_mtlskn3.bmap.finalheight=panel_skin_boyutu;
		
	}
	
}
function se_open_texture4()
{
	wait(1);
	char szFile[MAX_PATH];
	char szFile2[MAX_PATH];
	ZeroMemory(szFile, MAX_PATH);
	OPENFILENAME ofn;
	ZeroMemory(&ofn, sizeof(OPENFILENAME));
	ofn.lStructSize	= sizeof(OPENFILENAME);
	ofn.Flags		= OFN_FILEMUSTEXIST | OFN_PATHMUSTEXIST | OFN_HIDEREADONLY | OFN_NOCHANGEDIR;
	ofn.lpstrFilter	= "Supported File Types(*.png,*.tga,*.bmp,*.pcx,*.dds,*.jpg)\0*.tga;*.png;*.bmp;*.pcx;*.jpg;*.dds\0\0";
	ofn.nMaxFileTitle =MAX_PATH;
	ofn.lpstrFileTitle = szFile2;
	ofn.lpstrTitle	= "Load Image";
	ofn.lpstrFile	= szFile;
	ofn.nMaxFile	= MAX_PATH;
	if ( GetOpenFileName(&ofn) )
	{

		wait(1);
		SE_pan_mtlskn4.bmap.finalwidth=512;
		SE_pan_mtlskn4.bmap.finalheight=512;
		bmap_load(se_mtlskin4bmap,szFile,0);
		bmap_load(su_anki_mat.skin4,szFile,0);	
		str_cpy(se_skin4_str,szFile);
		se_skin_degisti[4]=1;
		
		se_konsola_aktar("SKIN4 CHANGED","SKIN4 DEGISTIRILDI",2);
		se_konsola_aktar(szFile,szFile,1);
		se_konsola_aktar("NEW FILE:  ","YENI DOSYA:  ",0);
		wait(1);
		SE_pan_mtlskn4.bmap.finalwidth=panel_skin_boyutu;
		SE_pan_mtlskn4.bmap.finalheight=panel_skin_boyutu;
		
	}
	
}

STRING* se_kay_str="#35";
function se_write_info(STRING* str);
function se_save_info()
{
	wait(1);

	char szFile[MAX_PATH];
	ZeroMemory(szFile, MAX_PATH);
	OPENFILENAME ofn;
	ZeroMemory(&ofn, sizeof(OPENFILENAME));
	ofn.lStructSize	= sizeof(OPENFILENAME);
	ofn.Flags		= OFN_FILEMUSTEXIST | OFN_PATHMUSTEXIST | OFN_HIDEREADONLY | OFN_NOCHANGEDIR;
	ofn.lpstrFilter	= "Supported File Types(*.txt)\0*.txt\0\0";
	ofn.lpstrTitle	= "Save Info(*.txt)";
	ofn.lpstrFile	= szFile;
	ofn.nMaxFile	= MAX_PATH;
	ofn.lpstrDefExt = "txt";

	if ( GetSaveFileName(&ofn) )
	{
		str_cpy(se_kay_str,szFile);
		se_write_info(se_kay_str);
		
		se_konsola_aktar("SAVE INFO","SAVE INFO",2);
		se_konsola_aktar(se_kay_str,se_kay_str,1);
	}

}

var file_se_hand;
STRING* eff_kaydet="#35";// kaydederken su_anki_mat in effect adi lazim.
#define SE_satir_atla 	file_asc_write (file_se_hand, 13); file_asc_write (file_se_hand, 10);
function se_write_info(STRING* str)
{
	file_se_hand = file_open_write(str); 
	
	file_str_write(file_se_hand,"MATERIAL NAME = ");
	file_str_write(file_se_hand,su_anki_mat.link.name);file_str_write(file_se_hand,";");
	SE_satir_atla
	str_cpy(eff_kaydet,su_anki_eff);
	if(str_stri(eff_kaydet,".fx"))
	{
		file_str_write(file_se_hand,"Effect(FX)Name=");	
		file_str_write(file_se_hand,eff_kaydet);
		SE_satir_atla
	}
	else
	{
		if(str_stri(su_anki_str,"se_internal1.fx"))
		{
			file_str_write(file_se_hand,"Effect is internal");	
			SE_satir_atla
		}
		
	}
	
	if(su_anki_mat.skin1!=NULL)
	{
		file_str_write(file_se_hand,"Skin1=");	
		
		if(se_skin_degisti[1]==1)
		{
			file_str_write(file_se_hand,se_skin1_str);
			
		}
		else
		{
			file_str_write(file_se_hand,su_anki_mat.skin1.link.name);
			file_str_write(file_se_hand,"  //-->not changed");
		}
		
		SE_satir_atla
	}
	if(su_anki_mat.skin2!=NULL)
	{
		file_str_write(file_se_hand,"Skin2=");	
		
		if(se_skin_degisti[2]==1)
		{
			file_str_write(file_se_hand,se_skin2_str);
			
		}
		else
		{
			file_str_write(file_se_hand,su_anki_mat.skin2.link.name);
			file_str_write(file_se_hand,"  //-->not changed");
		}
		
		SE_satir_atla
	}
	if(su_anki_mat.skin3!=NULL)
	{
		file_str_write(file_se_hand,"Skin3=");	
		
		if(se_skin_degisti[3]==1)
		{
			file_str_write(file_se_hand,se_skin3_str);
			
		}
		else
		{
			file_str_write(file_se_hand,su_anki_mat.skin3.link.name);
			file_str_write(file_se_hand,"  //-->not changed");
		}
		
		SE_satir_atla
	}
	if(su_anki_mat.skin4!=NULL)
	{
		file_str_write(file_se_hand,"Skin4=");	
		
		if(se_skin_degisti[4]==1)
		{
			file_str_write(file_se_hand,se_skin4_str);
			
			
		}
		else
		{
			file_str_write(file_se_hand,su_anki_mat.skin4.link.name);
			file_str_write(file_se_hand,"  //-->not changed");
		}
		
		SE_satir_atla
	}
	
	
	SE_satir_atla
	if(se_bmap_degisti[1]==1)
	{
		file_str_write(file_se_hand,"<---FX BMAPS--->");
		SE_satir_atla
		file_str_write(file_se_hand,se_fxbmapname1);
		file_str_write(file_se_hand,"=");	
		file_str_write(file_se_hand,se_bmap1_str);
		SE_satir_atla
	}
	if(se_bmap_degisti[2]==1)
	{
		file_str_write(file_se_hand,se_fxbmapname2);
		file_str_write(file_se_hand,"=");		
		file_str_write(file_se_hand,se_bmap2_str);
		SE_satir_atla
	}
	if(se_bmap_degisti[3]==1)
	{
		file_str_write(file_se_hand,se_fxbmapname3);
		file_str_write(file_se_hand,"=");		
		file_str_write(file_se_hand,se_bmap3_str);
		SE_satir_atla
	}
	if(se_bmap_degisti[4]==1)
	{
		file_str_write(file_se_hand,se_fxbmapname4);	
		file_str_write(file_se_hand,"=");	
		file_str_write(file_se_hand,se_bmap4_str);
		SE_satir_atla
	}
	if(se_bmap_degisti[5]==1)
	{
		file_str_write(file_se_hand,se_fxbmapname5);	
		file_str_write(file_se_hand,"=");	
		file_str_write(file_se_hand,se_bmap5_str);
		SE_satir_atla
	}
	if(se_bmap_degisti[6]==1)
	{
		file_str_write(file_se_hand,se_fxbmapname6);	
		file_str_write(file_se_hand,"=");	
		file_str_write(file_se_hand,se_bmap6_str);
		SE_satir_atla
	}
	SE_satir_atla


	
	file_str_write(file_se_hand,"AmbientRed=");
	file_var_write (file_se_hand,su_anki_mat.ambient_red);
	SE_satir_atla
	file_str_write(file_se_hand,"AmbientGreen=");
	file_var_write (file_se_hand,su_anki_mat.ambient_green);
	SE_satir_atla
	file_str_write(file_se_hand,"AmbientBlue=");
	file_var_write (file_se_hand,su_anki_mat.ambient_blue);
	SE_satir_atla
	file_str_write(file_se_hand,"SpecularRed=");
	file_var_write (file_se_hand,su_anki_mat.specular_red);
	SE_satir_atla
	file_str_write(file_se_hand,"SpecularGreen=");
	file_var_write (file_se_hand,su_anki_mat.specular_green);
	SE_satir_atla
	file_str_write(file_se_hand,"SpecularBlue=");
	file_var_write (file_se_hand,su_anki_mat.specular_blue);
	SE_satir_atla
	file_str_write(file_se_hand,"DiffuseRed=");
	file_var_write (file_se_hand,su_anki_mat.diffuse_red);
	SE_satir_atla
	file_str_write(file_se_hand,"DiffuseGreen=");
	file_var_write (file_se_hand,su_anki_mat.diffuse_green);
	SE_satir_atla
	file_str_write(file_se_hand,"DiffuseBlue=");
	file_var_write (file_se_hand,su_anki_mat.diffuse_blue);
	SE_satir_atla
	SE_satir_atla
	if(str_stri(eff_kaydet,".fx"))
	{

		file_str_write(file_se_hand,"<---USABLE VARIABLES--->");
		SE_satir_atla
		file_str_write(file_se_hand,"SE_usable1=");
		file_var_write (file_se_hand,SE_usable1);
		SE_satir_atla
		file_str_write(file_se_hand,"SE_usable2=");
		file_var_write (file_se_hand,SE_usable2);
		SE_satir_atla
		file_str_write(file_se_hand,"SE_usable3=");
		file_var_write (file_se_hand,SE_usable3);
		SE_satir_atla
		file_str_write(file_se_hand,"SE_usable4=");
		file_var_write (file_se_hand,SE_usable4);
		SE_satir_atla
		file_str_write(file_se_hand,"SE_usable5=");
		file_var_write (file_se_hand,SE_usable5);
		SE_satir_atla
		file_str_write(file_se_hand,"SE_usable6=");
		file_var_write (file_se_hand,SE_usable6);
		SE_satir_atla
		file_str_write(file_se_hand,"SE_usable7=");
		file_var_write (file_se_hand,SE_usable7);
		SE_satir_atla
		file_str_write(file_se_hand,"SE_usable8=");
		file_var_write (file_se_hand,SE_usable8);
		SE_satir_atla
		file_str_write(file_se_hand,"SE_usable9=");
		file_var_write (file_se_hand,SE_usable9);
		SE_satir_atla
		file_str_write(file_se_hand,"SE_usable10=");
		file_var_write (file_se_hand,SE_usable10);
		SE_satir_atla
	}


	if(str_stri(su_anki_str,"se_internal1.fx"))
	{
		file_str_write(file_se_hand,"Internal fx test file: ");	
		SE_satir_atla
		SE_satir_atla
		file_str_write(file_se_hand,"\"");	
		file_str_write(file_se_hand,SE_kaydet_chr);
		SE_satir_atla
		file_str_write(file_se_hand,"\"");	
		
	}
	
	
	file_close(file_se_hand); // close the file      

}




















