///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////

ENTITY* ladder;

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////

FONT* digfont = "digfont.pcx";

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////

VECTOR dist;
VECTOR absdist;
VECTOR force;
VECTOR camera_center;

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////

var my_height;
var step_height = 4;
var mouse_spd = 10;
var cam_height = 30;
var climb = 0; // if it is 1 then player is climbing
var pandeladder;

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////

function camera_()
{
	vec_lerp(camera.x,camera.x,camera_center.x,0.3);
	vec_lerp(camera_center,camera_center,vector(0,0,cam_height),1);
	vec_rotate(camera_center,my.pan);
	vec_add(camera_center,my.x);
	camera.arc = 90;
	camera.pan -= mouse_spd * mouse_force.x * time_step;
	camera.tilt += mouse_spd * mouse_force.y * time_step;
	if(camera.tilt > 70){camera.tilt = 70;}
	if(camera.tilt < -70){camera.tilt =-70;}
}

function input()
{
	if(climb == 1)
	{
	   if(camera.tilt > - 40)
	   {
		   absdist.z = 15 * (key_w - key_s) * time_step;
	   } 
	   if(camera.tilt < - 40)
	   {
		   absdist.z = 15 * (key_s - key_w) * time_step;
	   }
	   dist.x = 0;
		dist.y = 15 * (key_a - key_d) * time_step;
	}
	if(my_height <= 10)
	{
		force.x = 15 * (key_w - key_s) * time_step;
		accelerate(dist.x,force.x,0.7);
		force.y = 15 * (key_a - key_d) * time_step;
		accelerate(dist.y,force.y,0.7);
	}
	move_friction = 0.2;
	move_min_z = -1;

}

action player_()
{
	player = my;
	set(my,INVISIBLE|POLYGON);
	my.scale_x = 1;
	my.scale_y = my.scale_x;
	my.scale_z = my.scale_x;
	while(1)
	{
		if(climb == 0 && my_height <= 10)
		{
			my.pan = camera.pan;
		}
		my_height = c_trace(my.x,vector(my.x,my.y,my.z-9999),IGNORE_MODELS|IGNORE_PASSABLE|IGNORE_ME|USE_BOX);
		if(my_height > 10)
		{
			accelerate(absdist.z,-10 * time_step,-1);
		}    
		else
		{
			absdist.z = -(my_height/1.2)+ step_height;
			absdist.z = clamp(absdist.z,-step_height,step_height);
			if((my_height + absdist.z) > 10){ absdist.z = -my_height -10; }
		} 
		input();
		c_move(my,dist,absdist, IGNORE_PASSABLE|GLIDE);		
		camera_();
		wait(1);
	} 
}
function ladder_event()
{
	if(event_type == EVENT_IMPACT)
	{
		ladder = my;
		pandeladder = ladder.pan;
		if(you == player)
		{
			my.emask &= ~(ENABLE_IMPACT);	
			while(1)
			{
				camera.pan=clamp(camera.pan,player.pan-30,player.pan+30);
				player.pan += clamp(ang(ladder.pan-player.pan)*0.5,-25,25)*time_step;	
				if(pandeladder == 0)
				{
					player.x = ladder.x - 30;
				}	
				if(pandeladder == 90)
				{
					player.y = ladder.y - 30;
				}
				if(pandeladder == 180)
				{
					player.x = ladder.x + 30;
				}	
				if(pandeladder == 270)
				{
					player.y = ladder.y + 30;
				}	
				proc_mode = PROC_LATE;
				climb = 1;
				if(player.z + player.min_z - 40 > my.max_z + my.z || player.z + player.min_z + 20 < my.min_z + my.z)	
				{
					force.x = 65  * time_step;
					accelerate(dist.x,force.x,1.1);
					break;
				}
				if(key_space || vec_dist(vector(my.x,my.y,0),vector(player.x,player.y,0)) > 35)
				{
					force.x = - 25  * time_step;
					accelerate(dist.x,force.x,1.1);
					break;
				}
				wait(1);
			}
			climb = 0;
			wait(-0.1);	
			my.emask |= (ENABLE_IMPACT);	
		}
	}
}

action ladder_act()
{
	my.eflags |= FAT | NARROW;
	set(my,POLYGON);
	c_updatehull(my,0);
	my.emask |= (ENABLE_IMPACT); 
	my.event = ladder_event;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////
//PANELS//////////////////////////////////////////////////////////////////////////////////////////////////////

PANEL* gui_ =
{
	layer = 4;
	//digits(10,0,4,digfont,1,player.skill1); // use to be health here
	flags = SHOW;
}