//This is a script to handle drowning the player


// The amount of time the character can hold his or her breath is short
// so you won't have to wait so long to see the effect, but should be 
// made considerably longer for a real game

var current_breath_time = 10; //seconds
var max_breath_time = 10; //seconds (short for example)
var drowning_flag = OFF; // Not curretnly drowning
var underwater_check; // used to hold camera content var

SOUND ahh_wav = <ahh.wav>; // sound when damaged

// temporary action to assign to the swimming character

ACTION swimmer
{
//player = ME;
my._health = 100;

underwater_function();	//Check to see if player is underwater (always running)
player_walk();
}


// This shows the amount of seconds left the character 
// can hold his or her breath
// It should be replaced with a real panel
panel breath_remaining_panel
{
pos_x = 10;
pos_y = 20;
LAYER = 2;
FLAGS = D3D,refresh,visible;
DIGITS 10,20,3,standard_font,1,current_breath_time;
DIGITS 50,20,3,standard_font,1,player._health;
}


// This function is called when the character has run out of air while underwater
FUNCTION drowning()
{
while (underwater_check == content_passable) // as long as the player is underwater
	{
	drowning_flag = ON; // is currently drowning
	my._health -= 10; //subtract health (change this)
	PLAY_SOUND ahh_wav, 25; // that doesn't feel good
	waitt(32); //two seconds before reducing health again

	if (my._health <= 0 ) // If health is gone
		{
		// code to kill the player here
		// I'll just do a simple template tip and then exit
		msg.string = ("You have drowned!");
		show_message();
		player_tip(); // kock the character over
		waitt(64);
		game_exit(); // kicks you out of the game
		}
	}

drowning_flag = OFF; // Not underwater anymore, so not drowning
current_breath_time = max_breath_time; // Not underwater, so can breath again
//PLAY_SOUND big_gasp_wav, 75; // add your own big gasp sound
}

// This function runs all the time and checks to see if the character is in a
// passable block, which means he or she is underwater
FUNCTION underwater_function()
{
while (player == null) { wait(1); } // wait until there is a player

while(1) // run forever -- endless loop
	{
	// set the contents of camera.x to a var
	underwater_check = content(camera.x);
	
	// While the character is underwater...
	while (underwater_check == content_passable)
		{
		underwater_check = content(camera.x); // set it again
		
		// while the player still has some air
		while ( (current_breath_time >= 1) && (underwater_check == content_passable) ) 
			{
			underwater_check = content(camera.x); // set it again
			current_breath_time -= 1; // the character starts holding his or her breath
			waitt(16); //wait a second before decreasing breath time
			}
		
		// if the character is out of breath
		// and hasn't started to drown yet
		if ( (current_breath_time <=0) && (drowning_flag == OFF) )
			{
			drowning();
			} // No more air; player starts to drown
		
		// if the character surfaced
		if (underwater_check != content_passable)
			{
			// came up for air, for play a gasp sound
			//PLAY_SOUND small_gasp_wav, 50; }
			current_breath_time = max_breath_time; // replenish air
			}
		wait(1);
		}
	wait(1);
	}
}