// colormap.wdl to defined different sounds on terrain and more?
// by Lolek september 2003 /changed april 2004 now ready for A6.2
// www.lolek.net

bmap* mymap;
entity* myter;
string soundmap_color = "000000000"; //soundmapcolor RGB = Black

//the color vectors contained the rgb example colors from "soundmap for terrain" tutorial
//to example VIOLET_cv[3] means violet colorvector = RED 255, GREEN 0, BLUE 255


var VIOLET_cv[3] = 255,000,255; //houseground
var VIOLET_sound = 0; //switch
sound s_violet = <swing.wav>;
var_nsave s_violet_handle;

var RED_cv[3] = 255,000,000; //ways
var RED_sound = 0; //switch
sound s_red = <tap.wav>;
var_nsave s_red_handle;

var GREEN_cv[3] = 000,255,000; //meadows
var GREEN_sound = 0; //switch
sound s_green = <sack.wav>;
var_nsave s_green_handle;

var BLUE_cv[3] = 000,000,255; //mountains
var BLUE_sound = 0; //switch
sound s_blue = <rock.wav>;
var_nsave s_blue_handle;

var YELLOW_cv[3] = 255,255,000; //beach
var YELLOW_sound = 0; //switch
sound s_yellow = <rock.wav>;
var_nsave s_yellow_handle;
//

var terrain_ver[3] = 0,0,0;     //world pos of terrain vertex 1
var terrain_ver_frc[3] = 0,0,0; //decimals of terrain vertex1
var terrain_ver_mov[3] = 0,0,0; //contain the shift from
                                // terrain vertex 1 to world xy = 0
var soundmap_x = 0;             //pos x of colorpixel in the soundmap
var soundmap_y = 0;             //pos y of colorpixel in the soundmap
var smap_temp_x = 0;            //intern player pos x rescaled on terrain scale = 1
var smap_temp_y = 0;            //intern player pos y rescaled on terrain scale = 1
var soundmap_frc_x = 0;         //decimals of soundmap pos x
var soundmap_frc_y = 0;         //decimals of soundmap pos y
var walk_sound_switch = 0;      //switch for walksound, 0= player stop,walksound off


//contain the terrainscale in WED put the scale into terrain properties SKILL1
//contain the scale from colormap bitmap size to original terrainsize into colormap properties SKILL1
DEFINE TERRAIN_SCALE,skill1;
DEFINE COLORMAP_SCALE,skill2;

// uses: TERRAIN_SCALE, COLORMAP_SCALE
action terrain_colmap  //give this action to terrain in WED
{
 myter= my;
 myter.TERRAIN_SCALE  = my.skill1;
 myter.COLORMAP_SCALE = my.skill2;
 ent_vertex(terrain_ver,1);      //get vertex 1 pos from WED
 terrain_ver.x = terrain_ver.x / myter.TERRAIN_SCALE; //rescale vertex 1 back to
 terrain_ver.y = terrain_ver.y / myter.TERRAIN_SCALE; //original terrain_size = scale 1
 terrain_ver_frc.x = frc(terrain_ver.x);
 terrain_ver_frc.y = frc(terrain_ver.y);
 if (terrain_ver_frc.x >= 0.5) { //nachkommastellen > 0.5 aufrunden
     if (terrain_ver.x < 0) {    //wenn vertex pos x negativ
         terrain_ver.x -= 1;}    //minus 1
     else {terrain_ver.x += 1;}  //ansonsten wenn positiv addiere 1
                               }
 if (terrain_ver_frc.y >= 0.5) { //nachkommastellen > 0.5 aufrunden
     if (terrain_ver.y < 0) {    //wenn vertex pos y negativ
         terrain_ver.y -= 1;}    //minus 1
     else {terrain_ver.y += 1;}  //ansonsten wenn positiv addiere 1
                               }
 terrain_ver.x = int(terrain_ver.x); //vertex pos x ganzzahlig
 terrain_ver.y = int(terrain_ver.y); //vertex pos y ganzzahlig
 terrain_ver_mov.x = terrain_ver.x;
 terrain_ver_mov.y = terrain_ver.y;
 if(terrain_ver_mov.x < 0) {
    vec_inverse(terrain_ver_mov.x);
                           }
 if(terrain_ver_mov.y < 0) {
    vec_inverse(terrain_ver_mov.y);
                           }
} 

var rgb_vec[3];//red,green,blue vector
var pix_alpha; //pixel alpha 0
var format;    //bitmap format
var pixel;     //pixelcolor

function pixelcolor()
{
 while(mymap == 0) {
       wait(1);    }
 format = bmap_lock(mymap,0);
 str_cpy(soundmap_color,"");
 pixel = pixel_for_bmap(mymap,soundmap_x,soundmap_y); // get upper left pixel
 pixel_to_vec(rgb_vec,pix_alpha,format,pixel); // store pixel color in temp  
 bmap_unlock(mymap);
}
 
function sound_instruct() {
//
      if (rgb_vec.red   == VIOLET_cv.red    && 
          rgb_vec.green == VIOLET_cv.green  &&
          rgb_vec.blue  == VIOLET_cv.blue   && 
          snd_playing(s_violet_handle) == 0 && 
          walk_sound_switch == 1 ) {
          s_violet_handle = snd_play(s_violet,100,0);
          snd_tune(s_violet_handle,50,200,0);
                                   }
      if (walk_sound_switch == 0)  {
          snd_stop(s_violet_handle);
                                   }
//
      if (rgb_vec.red   == RED_cv.red    && 
          rgb_vec.green == RED_cv.green  &&
          rgb_vec.blue  == RED_cv.blue   && 
          snd_playing(s_red_handle) == 0 &&
          walk_sound_switch == 1 ) {
          s_red_handle = snd_play(s_red,100,0);
          snd_tune(s_red_handle,50,200,0);
                                   }
      if (walk_sound_switch == 0)  {
          snd_stop(s_red_handle);
                                   }
//
      if (rgb_vec.red   == GREEN_cv.red    && 
          rgb_vec.green == GREEN_cv.green  &&
          rgb_vec.blue  == GREEN_cv.blue   &&  
          snd_playing(s_green_handle) == 0 &&
          walk_sound_switch == 1 ) {
          s_green_handle = snd_play(s_green,100,0);
             snd_tune(s_green_handle,50,200,0);
                                   }
      if (walk_sound_switch == 0)  {
          snd_stop(s_green_handle);
                                   }
//
      if (rgb_vec.red   == BLUE_cv.red    && 
          rgb_vec.green == BLUE_cv.green  &&
          rgb_vec.blue  == BLUE_cv.blue   &&  
          snd_playing(s_blue_handle) == 0 &&
          walk_sound_switch == 1 ) {
          s_blue_handle = snd_play(s_blue,100,0);
          snd_tune(s_blue_handle,50,200,0);
                                   }
      if (walk_sound_switch == 0)  {
          snd_stop(s_blue_handle);
                                   }
//
      if (rgb_vec.red   == YELLOW_cv.red    && 
          rgb_vec.green == YELLOW_cv.green  &&
          rgb_vec.blue  == YELLOW_cv.blue   && 
          snd_playing(s_yellow_handle) == 0 &&
          walk_sound_switch == 1 ) {
          s_yellow_handle = snd_play(s_yellow,100,0);
          snd_tune(s_yellow_handle,50,200,0);
                                   }
      if (walk_sound_switch == 0)  {
          snd_stop(s_yellow_handle);
                                   }
 pixelcolor();
}

function sound_on_terrain() { //give this function to player
         while(myter == 0) {
               wait(1);    }
         smap_temp_x = my.x;  //copy my pos_x to soundmap_pos
         smap_temp_y = my.y;  //copy my pos_y to soundmap_pos
         smap_temp_x = smap_temp_x / myter.TERRAIN_SCALE; //rescale soundmap pos to terrainbasic size
         smap_temp_y = smap_temp_y / myter.TERRAIN_SCALE;
         soundmap_frc_x = frc(smap_temp_x);
         soundmap_frc_y = frc(smap_temp_y);
         if (soundmap_frc_x >= 0.5) {  //nachkommastellen > 0.5 aufrunden
             if (smap_temp_x < 0) {    //wenn soundmap pos x negativ
                 smap_temp_x -= 1;}    //minus 1
             else {smap_temp_x += 1;}  //ansonsten wenn positiv addiere 1
                                    }
         if (soundmap_frc_y >= 0.5) {  //nachkommastellen > 0.5 aufrunden
             if (smap_temp_y < 0) {    //wenn soundmap pos x negativ
                 smap_temp_y -= 1;}    //minus 1
             else {smap_temp_y += 1;}  //ansonsten wenn positiv addiere 1
                                    }
         smap_temp_x = int(smap_temp_x); //soundmap pos x ganzzahlig
         smap_temp_y = int(smap_temp_y); //soundmap pos y ganzzahlig
         if(terrain_ver.x < 0) {
            smap_temp_x += terrain_ver_mov.x;
                             }
         else { smap_temp_x -= terrain_ver_mov.x; }
         if(terrain_ver.y < 0) {
            smap_temp_y += terrain_ver_mov.y;
            vec_inverse(smap_temp_y);
                             }
         else { smap_temp_y -= terrain_ver_mov.y;
                vec_inverse(smap_temp_y);
              }
     if(you.COLORMAP_SCALE <= 0) {  //avoid crash
        you.COLORMAP_SCALE = 1;  } 
        smap_temp_x = smap_temp_x / myter.COLORMAP_SCALE;//rescale terrainbasic size to colormap size
        smap_temp_y = smap_temp_y / myter.COLORMAP_SCALE;
        soundmap_frc_x = frc(smap_temp_x);
        soundmap_frc_y = frc(smap_temp_y);
        if (soundmap_frc_x >= 0.5) {  //nachkommastellen > 0.5 aufrunden
            if (smap_temp_x < 0) {    //wenn soundmap pos x negativ
                smap_temp_x -= 1;}    //minus 1
            else {smap_temp_x += 1;}  //ansonsten wenn positiv addiere 1
                                   }
        if (soundmap_frc_y >= 0.5) {  //nachkommastellen > 0.5 aufrunden
            if (smap_temp_y < 0) {    //wenn soundmap pos x negativ
                smap_temp_y -= 1;}    //minus 1
            else {smap_temp_y += 1;}  //ansonsten wenn positiv addiere 1
                                   }
        smap_temp_x = int(smap_temp_x); //soundmap pos x ganzzahlig
        smap_temp_y = int(smap_temp_y); //soundmap pos y ganzzahlig
        soundmap_x = smap_temp_x;
        soundmap_y = smap_temp_y;
        sound_instruct();
}

action get_color //give this action to colormap bitmap in WED
{
 mymap = bmap_for_entity(my,0);
}
	
//example bind walk_sound_switch to player forward walk animation///////////

/*function player_animation() {  //player stand
    if (force.y == 0) {
        ent_cycle("stand", my.skill47);
        my.skill47 += 2 * time;
        walk_sound_switch = 0;   //no sound
        if (my.skill47 > 100) {my.skill47 %= 100;}
                      }
    if (key_cuu == 1 && key_enter == 0) {  //player walk forward
        ent_cycle("walk", my.skill48);
        my.skill48 += 5 * time;
        if (my.skill48 > 95) {     //anim. > 95%
            walk_sound_switch = 1; //play walk sound   left foot
                             }
        else {walk_sound_switch = 0;}
        if (my.skill48 > 40 && my.skill48 < 50) { //anim. 40%-50%
            walk_sound_switch = 1;              } //play walksound  right foot
        if (my.skill48 > 100) {my.skill48 %= 100;}
        my.tempo = 1;
                                        }
} */
