///////////////////////////////////////////////////////////////////////////////////
// A4 main wdl
////////////////////////////////////////////////////////////////////////////
// The PATH keyword gives directories where game files can be found,
// relative to the level directory
path "models";	// Path to model subdirectory - if any
path "sounds";	// Path to sound subdirectory - if any
path "bmaps";		// Path to graphics subdirectory - if any
Path "..\\template";	// Path to WDL templates subdirectory

////////////////////////////////////////////////////////////////////////////
// The INCLUDE keyword can be used to include further WDL files,
// like those in the TEMPLATE subdirectory, with prefabricated actions
include <movement.wdl>;
include <messages.wdl>;
include <menu.wdl>;		// must be inserted before doors and weapons
include <particle.wdl>; // remove when you need no particles
include <doors.wdl>;		// remove when you need no doors
include <actors.wdl>;   // remove when you need no actors
include <weapons.wdl>;  // remove when you need no weapons
include <war.wdl>;      // remove when you need no fighting
//include <venture.wdl>;	// include when doing an adventure

////////////////////////////////////////////////////////////////////////////
// The engine starts in the resolution given by the follwing vars.
var video_mode = 6;	 // screen size 640x480
var video_depth = 16; // 16 bit colour D3D mode

/////////////////////////////////////////////////////////////////
// define a splash screen with the required A4/A5 logo
bmap splashmap = <logodark.bmp>; // the default A4 logo in templates
panel splashscreen {
	bmap = splashmap;
	flags = refresh,d3d;
}


bmap menu_map,<menu.pcx>;

bmap b1_on,<b1_on.pcx>;
bmap b1_ov,<b1_ov.pcx>;
bmap b2_on,<b2_on.pcx>;
bmap b2_ov,<b2_ov.pcx>;
bmap b3_on,<b3_on.pcx>;
bmap b3_ov,<b3_ov.pcx>;
bmap b4_on,<b4_on.pcx>;
bmap b4_ov,<b4_ov.pcx>;
bmap b5_on,<b5_on.pcx>;
bmap b5_ov,<b5_ov.pcx>;
bmap b6_on,<b6_on.pcx>;
bmap b6_ov,<b6_ov.pcx>;

panel menu_pan //
{
	pos_x = 0;pos_y = 0;
     	layer = 10;
	bmap menu_map;
	button = 270,80,b1_on,b1_on,b1_ov,null,f_play,little_beep;
	button = 270,140,b2_on,b2_on,b2_ov,null,f_levels,little_beep;
	button = 270,200,b3_on,b3_on,b3_ov,null,f_help,little_beep;
	button = 270,260,b4_on,b4_on,b4_ov,null,f_options,little_beep;
	button = 270,320,b5_on,b5_on,b5_ov,null,f_credit,little_beep;
	button = 270,380,b6_on,b6_on,b6_ov,null,f_quit,little_beep;
      	flags = refresh;
}




/////////////////////////////////////////////////////////////////
// The main() function is started at game start
function main()
{
// set some common flags and variables
	warn_level = 2;	// announce bad texture sizes and bad wdl code
	tex_share = on;	// map entities share their textures

// center the splash screen for non-640x480 resolutions
	splashscreen.pos_x = (screen_size.x - bmap_width(splashmap))/2;
	splashscreen.pos_y = (screen_size.y - bmap_height(splashmap))/2;
// display the splash screen
	splashscreen.visible = on;
// wait 3 frames (for triple buffering) until it is rendered and flipped to the foreground
	wait(3);

// now load the level
	load_level(<menu.WMB>);
// wait the required second, then switch the splashscreen off.
	waitt(16);
  	splashscreen.visible = off;
	bmap_purge(splashmap);	// remove splashscreen from video memory

// load some global variables, like sound volume
	load_status();
	affiche_menu();

//	client_move();	// for a possible multiplayer game
// call further functions here...
}

/////////////////////////////////////////////////////////////////
// The following definitions are for the pro edition window composer
// to define the start and exit window of the application.
WINDOW WINSTART
{
	TITLE			"A4 Engine";
	SIZE			480,320;
	MODE			IMAGE;	//STANDARD;
	BG_COLOR		RGB(240,240,240);
	FRAME			FTYP1,0,0,480,320;
//	BUTTON		BUTTON_START,SYS_DEFAULT,"Start",400,288,72,24;
	BUTTON		BUTTON_QUIT,SYS_DEFAULT,"Abort",400,288,72,24;
	TEXT_STDOUT	"Arial",RGB(0,0,0),10,10,460,280;
}

/* no exit window at all..
WINDOW WINEND
{
	TITLE			"Finished";
	SIZE			540,320;
	MODE	 		STANDARD;
	BG_COLOR		RGB(0,0,0);
	TEXT_STDOUT	"",RGB(255,40,40),10,20,520,270;

	SET FONT		"",RGB(0,255,255);
	TEXT			"Any key to exit",10,270;
}*/

/////////////////////////////////////////////////////////////////
//INCLUDE <debug.wdl>;

function affiche_menu
{
	menu_pan.visible = on;
	mouse_mode =  2;
	mouse_on();
	enable_mouse = on;

}

function f_play
{
	hide_menu();
	//your game hier
	return;
}

function f_levels
{
	hide_menu();
	//your levels hier
	return;
}

function f_help
{
	hide_menu();
	//your help hier
	return;
}

function f_options
{
	hide_menu();
	//your options hier
	return;
}

function f_credit
{
	hide_menu();
	//your credit hier
	return;
}

function f_quit
{
	exit;
}

function hide_menu
{
//	menu_pan.visible = off;
	mouse_mode =  0;
	mouse_off();
	enable_mouse = off;

}

sound beep_sound,<tap.wav>;
function little_beep
{
	play_sound(beep_sound,20);
}
