#include <acknex.h>
#include <default.c>
#include "asPathfinder.h"

VECTOR CarPos;

// Add waypoint to node list
action AddWaypoint()
{
	set(me, PASSABLE);
	asNode newnode;
	asZeroNode(newnode);
	vec_set(newnode.pos, my.x);
	asID += 1;
	newnode.ID = asID;
	asPrepend(asNodeList, newnode);
}

function FindPath()
{
	VECTOR from;
	VECTOR to;
	
	vec_set(from, vector(mouse_pos.x, mouse_pos.y, 10));
	vec_for_screen(from, camera);
	vec_set(to, vector(mouse_pos.x, mouse_pos.y, 5000));
	vec_for_screen(to, camera);
	
	c_trace(&from, &to, IGNORE_PASSABLE | IGNORE_SPRITES);

	if (trace_hit != 0)
	{
		vec_scale(&normal, 10);
		vec_add(&target, &normal);
		
		VECTOR target_pos;
		vec_set(&target_pos, &target);
		
		// Find path from the car position to the clicked position on a level
		asFindasPath(CarPos, target_pos);
	}
}

action Car()
{
	VECTOR Dir;
	
	while(1)
	{
		vec_set(&CarPos, my.x);
		// If path list isn't empty, move to the first node of the list
		if(asPath.head != NULL)
		{
			vec_diff(&Dir, asPath.head.pos, my.x);
			vec_to_angle(my.pan, &Dir);
			my.tilt = 0;
			vec_normalize(&Dir, 15*time_step);
			c_move(me, nullvector, &Dir, IGNORE_PASSABLE | GLIDE);
			
			// If car near node
			if(vec_dist(my.x, asPath.head.pos) < 10)
			{
				// Make path list iterator pointer points to the first node of the list
				asPath.itr = asPath.head;
				asRemoveNode(asPath);  // Remove node that iterator pointer points to
			}
		}
		wait(1);
	}
}

function main()
{
	level_load("map.wmb");
	wait(2);
	vec_set(sky_color,vector(0,0,0)); 	

	camera.x = 0; 
	camera.y = -600; 
	camera.z = 750; 
	camera.tilt = -30;
	
	VECTOR cam;
	
	while(1)
	{
		vec_set(mouse_pos, mouse_cursor); // update the mouse pointer position at all times
		
		vec_diff(cam, CarPos, camera.x);
		vec_to_angle(camera.pan, cam);
		camera.roll = 0;
		
		// If path list isn't empty draw lines between path nodes
		asPath.itr = asPath.head;
		while(asPath.itr != NULL)
		{
			draw_line3d(asPath.itr.pos,NULL,100);
			if(asPath.itr.next != NULL)
				draw_line3d(asPath.itr.next.pos,vector(0,255,0),100);
			asForth(asPath);
		}
		
		on_mouse_left = FindPath;
		wait(1);
	}

	asFree();
}