//////////////////////////////
// Physics Template 
// Created by Emre SASMAZ - 05/06/08 
// pantharay@gmail.com
// devartoi@hotmail.com
//////////////////////////////
#define mass skill1
#define friction skill2
#define bounciness skill3
#define minSpeed skill4
#define linear skill5
#define angular skill6
#define sensitive skill7//sensitive|if select it,gun force 150 quant for it.else standart (500 quant)
#define box FLAG1
#define sphere FLAG2
#define stone FLAG3
#define wood FLAG4
#define metal FLAG5
#define pillow FLAG6
#define cardboard FLAG7
#define holding FLAG8
#define SOUND_IMPACT_DELAY 28

#define time time_step
//section Sounds
//entry:stone Entities Sound:
SOUND* stone_k = "stone_hit.wav";
//entry:Wood Entities Sound:
SOUND* wood_k = "wood_hit.wav";
//entry:Metal Entities Sound:
SOUND* metal_k = "hit_metal.wav";
//entry:Pillow Entities Sound:
SOUND* pillow_k = "pillow_sound.wav";
//entry:Gravity Gun Sound1
SOUND* noise1 = "Noise.ogg";
//entry:Gravity Gun Sound1
SOUND* noise2 = "Soundscape18.ogg";


ENTITY* hold_ent;


ENTITY* gun_entity ;
var gravgun;

//section Bmaps
//entry:Lazer Bmap
BMAP* laser_tga = "PT_laser_blau.tga";
//entry:Crosshair Bmap
BMAP* cross = "PT_crosshair_64x64.tga";
//entry:mouse icon bmap
BMAP* icon = "PT_arrow_blue.pcx"; 

//need for entity scan
void scan_cam_startup()
{
	
	while(!level_load(""))
	{
		wait(1);
	}
	while(1)
	{
		
		c_scan(camera.x,camera.pan,vector(90,90,130),IGNORE_ME | IGNORE_YOU | SCAN_ENTS | SCAN_LIMIT | USE_POLYGON | USE_BOX);
		wait(1);
	}
}

PANEL* cr= //crosshairpanel
{
	bmap=cross; 
	layer = 1; 
	flags =  overlay,center_x,center_y;//,light; 
	pos_x = 10; 
	pos_y = 10; 
	alpha=100; 
	red = 75; 
	green = 128; 
	blue = 223; 
}

function panel_startup()
{
	//enable:CROSSHAIR ENABLE?
	set(cr,VISIBLE);
	
	while(1)
	{
		

		cr.pos_x = (screen_size.x - bmap_width(cross))/2;
		cr.pos_y = (screen_size.y - bmap_height(cross))/2;
		wait(1);
	}
}

MATERIAL* highlighted0 =
{
	ambient_red=225;
	ambient_green=255;
	ambient_blue=255;
	diffuse_red=225;
	diffuse_green=255;
	diffuse_blue=255;
}
MATERIAL* highlighted =
{
	ambient_red=0;
	ambient_green=128;
	ambient_blue=255;
	diffuse_red=0;
	diffuse_green=128;
	diffuse_blue=255;
}


function fade_mist(PARTICLE* p) 
{ 
	p.alpha -= 0.3 * time; 
	p.size += 0.1 * time; 

	if(p.alpha < 0) 
	{ 
		p.lifespan = 0; 
	} 
} 


function physic_part_eff(PARTICLE* p)
{
	VECTOR temp;
	temp.x = random(2) - 1; 
	temp.y = random(2) - 1; 
	temp.z = random(1) + 1; 
	vec_set(p.vel_x,temp); 
	p.bmap = laser_tga;//misty_tga
	p.size = 200;
	p.lifespan = 50; 
	set(p,BRIGHT);
	set(p,MOVE);
	p.gravity = 0; 
	p.alpha = 5; 
	p.event = fade_mist; 
}





function Kick()
{
	VECTOR vKick;
	vKick.x = 150; vKick.y = 0; vKick.z = 0;
	vec_rotate(vKick,camera.pan);
	//vKick.z = 75;
	phent_addvelcentral(my,vKick);
	
}

function Kick2()
{
	VECTOR vKick;
	vKick.x = 1050; vKick.y = 0; vKick.z = 0;
	vec_rotate(vKick,camera.pan);
	//vKick.z = 75;
	//vKick.x = 850;
	phent_addvelcentral(hold_ent,vKick);
	
}
var mouse;

void mouse_up()
{


	mouse_pos.x = (screen_size.x /2); 
	mouse_pos.y = (screen_size.y /2);

	

	
	
}



function ph_event()
{



	if (event_type == EVENT_SCAN)
	{
		if(gravgun!=1)
		{
			mouse_up();
			mouse_mode=4;
			mouse_map=icon;
			wait(1);	
		}
		


		
		if(mouse_left==1)
		{
			Kick();
		}
		
		
	}
	mouse_mode=0;




	if(event_type==EVENT_IMPACT)
	{
	
		
		if (my.skill28 < total_frames) {
			my.skill28 = total_frames + SOUND_IMPACT_DELAY;
			ent_playsound(me,wood_k,100);
		}
	}

	if(event_type==EVENT_FRICTION)
	{
		
		if(you!=player)
		{
			
			
			wait(1);
			if is(my,wood)
			{
				
				
				if (my.skill28 < total_frames) {
					my.skill28 = total_frames + SOUND_IMPACT_DELAY;
					ent_playsound(me,wood_k,100);
				}	
				
				
				
			}
			
			
			
			if is(my,metal)
			{
				
				
				if (my.skill28 < total_frames) {
					my.skill28 = total_frames + SOUND_IMPACT_DELAY;
					ent_playsound(me,metal_k,100);
				}
				
				
				
			}
			if is(my,pillow)
			{
				
				
				if (my.skill28 < total_frames) {
					my.skill28 = total_frames + SOUND_IMPACT_DELAY;
					ent_playsound(me,pillow_k,100);
				}
				
			}
			if is(my,stone)
			{
				
				
				if (my.skill28 < total_frames) {
					my.skill28 = total_frames + SOUND_IMPACT_DELAY;
					ent_playsound(me,stone_k,100);
				}
				
			}
			if is(my,cardboard)
			{
				if (my.skill28 < total_frames) {
					my.skill28 = total_frames + SOUND_IMPACT_DELAY;
					ent_playsound(me,pillow_k,100);
				}
				
				
			}
		}
	}
}



STRING* err_str = "1234567891234567890";
STRING* errnum_str = "1234567891234567890";
function error_r()
{
	str_for_entfile(err_str,my);
	if(my.bounciness>100)
	{
		error("bounciness number mistake [ >100 ]\nvalue between 0..100,\nindicating how much colliding object\nbounce off each other");
		error(err_str);
		error("your number=");
		str_for_num(errnum_str,my.bounciness);
		error(errnum_str);
		
	}
	if(my.bounciness<0)
	{
		error("bounciness number mistake [ <0 ]\nvalue between 0..100,\nindicating how much colliding object\nbounce off each other");
		error(err_str);
		error("your number=");
		str_for_num(errnum_str,my.bounciness);
		error(errnum_str);
		
	}
	if(my.minSpeed>100)
	{
		error("minSpeed number mistake (minSpeed)[ >100 ]");
		error(err_str);
		error("your number=");
		str_for_num(errnum_str,my.minSpeed);
		error(errnum_str);
		
	}
	if(my.minSpeed<0)
	{
		error("minSpeed number mistake---> [ <0 ]");
		error(err_str);
		error("your number=");
		str_for_num(errnum_str,my.minSpeed);
		error(errnum_str);
		
	}
	if(my.linear>100)
	{
		error("linear number mistake [ >100 ]\namount of linear damping,\n between 0.0 and 100.0");
		error(err_str);
		error("your number=");
		str_for_num(errnum_str,my.linear);
		error(errnum_str);
		
	}
	if(my.linear<0)
	{
		error("linear number mistake [ <0 ]\namount of linear damping,\n between 0.0 and 100.0");
		error(err_str);
		error("your number=");
		str_for_num(errnum_str,my.linear);
		error(errnum_str);
		
	}
	if(my.angular>100)
	{
		error("angular number mistake [ >100 ]\namount of angular damping,\n between 0.0 and 100.0");
		error(err_str);
		error("your number=");
		str_for_num(errnum_str,my.angular);
		error(errnum_str);
		
	}
	if(my.angular<0)
	{
		error("angular number mistake [ <0 ]\namount of angular damping,\n between 0.0 and 100.0");
		error(err_str);
		error("your number=");
		str_for_num(errnum_str,my.angular);
		error(errnum_str);
		
	}
}

var var_diag;
void d_func()
{
	
	//section:DIAG
	//image:diag.bmp
	//enable:Diag?
	var_diag=1;

}
// uses: mass,friction,bounciness,minSpeed,linear,angular,sensitive,box,sphere,stone,wood,metal,pillow,cardboard,holding;
action Physics_act()
{

	if is(my,box)
	{
		phent_settype(my,PH_RIGID,PH_BOX);
		phent_setmass(my,my.mass,PH_BOX);
	}
	if is(my,sphere)
	{
		phent_settype(my,PH_RIGID,PH_SPHERE);
		phent_setmass(my,my.mass,PH_SPHERE);
	}
	
	phent_setfriction(my,my.friction);
	phent_setelasticity(my,my.bounciness,my.minSpeed);  
	phent_setdamping(my,my.linear,my.angular);   
	error_r();
	ph_setgravity(vector(NULL,NULL,-800));
	my.emask |=(ENABLE_FRICTION | ENABLE_SCAN | ENABLE_CLICK | ENABLE_SONAR); 
	my.event=ph_event;
	if(gravgun==1)
	{
		my.material = highlighted0;
	}
	d_func();
	
	
	
	if(var_diag==1)
	{

		STRING* d_type = "";
		STRING* who = "123465789132465798";
		STRING* d_mass = "";
		STRING* d_fric = "";
		STRING* d_bounciness = "";
		STRING* d_minSpeed = "";
		if is(my,box){d_type="box";}
		if is(my,sphere){d_type="sphere";}
		str_for_num(d_mass,my.mass);
		str_for_num(d_fric,my.friction);
		str_for_num(d_bounciness,my.bounciness);
		str_for_num(d_minSpeed,my.minSpeed);
		str_for_entfile(who,my); 
		diag("\n<-entity physics creation->");
		diag("\n------->");
		diag(who);
		diag("<-------");
		diag("\nType = ");diag(d_type);
		diag("\nmass = ");diag(d_mass);
		diag("\nfriction = ");diag(d_fric);
		diag("\nbounciness = ");diag(d_bounciness);
		diag("\nminSpeed = ");diag(d_minSpeed);
		diag("\nentity physics creation completed\n");
		diag("----------------------------------\n\n");
	}

}
ENTITY* cube_board_ent;
ENTITY* cube_board_cover_ent;
var HINGE_ID;
var HINGE2_ID;
action cube_board_act()//Hinge Sample
{
	cube_board_ent=me;
	//my.sensitive=1;
	my.mass=10;
	my.bounciness=50;
	my.minSpeed=50;
	my.friction=50;
	phent_settype(my,PH_RIGID,PH_BOX);
	phent_setmass(my,my.mass,PH_POLY);	
	phent_setfriction(my,my.friction);
	phent_setdamping(my,10,10);
	phent_setelasticity(my,my.bounciness,my.minSpeed);
	my.emask |=(ENABLE_FRICTION | ENABLE_SCAN | ENABLE_IMPACT); 

	my.event=ph_event;
	if(gravgun==1)
	{
		my.material = highlighted0;
	}
	
}
action cube_boardcover_act()//Hinge Sample
{
	
	my.sensitive=1;
	cube_board_cover_ent=me;

	phent_settype(my,PH_RIGID,PH_BOX);

	my.mass=1;
	my.bounciness=1;
	my.minSpeed=1;
	my.friction=100;

	phent_setmass(my,1,PH_POLY);	
	phent_setfriction(my,100);
	phent_setelasticity(my,1,1);
	HINGE_ID = phcon_add(PH_HINGE, my, cube_board_ent);
	phcon_setparams1(HINGE_ID, vector(my.x,my.y+23,my.z+22), vector(0,0,1), nullvector);
	phcon_setparams2(HINGE_ID, vector(0,-180,0), nullvector, nullvector);
	HINGE2_ID = phcon_add(PH_HINGE, my, cube_board_ent);
	phcon_setparams1(HINGE2_ID, vector(my.x,my.y+23,my.z-18), vector(0,0,1), vector(0,0,0));
	phcon_setparams2(HINGE2_ID, vector(0,-180,0), nullvector, vector(0,0,0));
	my.emask |=(ENABLE_SCAN | ENABLE_IMPACT); 
	my.event=ph_event;
	if(gravgun==1)
	{
		my.material = highlighted0;
	}
}





var wavehandle;
var wavehandle2;
//section:Gravitation Gun
//entry:Distance Open? 1-Open 0-Close
var distance_open=1;
//entry:Distance Speed
//Help:no comment
var distance_speed=16;
//entry:Distance key
STRING* ky1="1";
//entry:Distance key2
STRING* ky2="2";
//entry:GravGun Sound 1 Volume
var gsound_vol_1=100;
//entry:GravGun Sound 2 Volume
var gsound_vol_2=100;

function hold_object()
{
	VECTOR grav_target;

	VECTOR gunforce;
	var distance;
	hold_ent=you;
	var forcescale;
	var damp_copy1;
	var damp_copy2;
	distance=vec_dist(camera.x,hold_ent.x);
	var hold=1;
	damp_copy1=hold_ent.linear;
	damp_copy2=hold_ent.angular;
	if is(hold_ent,FLAG8)
	{
		
		if(gravgun==1)
		{
			set(hold_ent,BRIGHT|LIGHT|TRANSLUCENT);
			hold_ent.material=highlighted;
		}
		

		

		
		
		if(gravgun==1)
		{
			wavehandle=snd_loop(noise1,gsound_vol_1,NULL);
			wavehandle2=snd_loop(noise2,gsound_vol_1,NULL);
		}
		
		
		while(mouse_right&&hold==1)
		{	
			
			if(gravgun==1)
			{
				effect(physic_part_eff, 1, hold_ent.x, nullvector);
			}
			

			
			
			if(distance_open==1&&gravgun==1)
			{

				if(key_pressed(key_for_str(ky1)) == 1)
				{
					distance+=distance_speed*time_step;
				}
				if(key_pressed(key_for_str(ky2)) == 1)
				{
					distance-=distance_speed*time_step;
				}
			}
			//          var anm;
			//			ent_animate(gun_entity,"walk",anm,ANM_CYCLE);
			//			anm+=1*time;
			//maybe you use a gravgun model end animation
			if(mouse_left==1)
			{
				Kick2();
				hold=0;

			}
			else
			{
				phent_setdamping(hold_ent,100,100); 
				phent_addcentralforce(hold_ent,vector(1*gunforce.x,1*gunforce.y,1*gunforce.z));
				
				
				grav_target.x=camera.x+cos(camera.pan)*cos(camera.tilt)*distance;
				grav_target.y=camera.y+sin(camera.pan)*cos(camera.tilt)*distance;
				grav_target.z=camera.z+sin(camera.tilt)*distance;
				vec_set(gunforce,grav_target);
				vec_sub(gunforce,hold_ent.x);
				if(hold_ent.sensitive==1)
				{
					vec_scale(gunforce,150);
					forcescale=150;	
				}
				else
				{
					vec_scale(gunforce,500);
					forcescale=500;
				}
				
				
			}
			
			
			wait(1);	
			

		}	
		
		if(gravgun==1)
		{
			reset(hold_ent,LIGHT);
			reset(hold_ent,BRIGHT);
			reset(hold_ent,TRANSLUCENT);
			hold_ent.material=highlighted0;
		}
		
		
		
		phent_setdamping(hold_ent,damp_copy1,damp_copy2); 
		


		
		
		

		
	}
	mouse_mode=0;

	snd_stop(wavehandle);
	snd_stop(wavehandle2);


}




function gravitation_gun()
{
	VECTOR temp_2;
	var gunrange=100000;
	me=player;

	if(gravgun==1)
	{
		while(mouse_right&&you==NULL)
		{

			temp_2.x=camera.x+cos(camera.pan)*cos(camera.tilt)*gunrange;
			temp_2.y=camera.y+sin(camera.pan)*cos(camera.tilt)*gunrange;
			temp_2.z=camera.z+sin(camera.tilt)*gunrange;
			c_trace(camera.x,temp_2, IGNORE_ME | IGNORE_PASSABLE);//|ignore_passents|use_box|use_polygon);//passents,box ve poly eklendi
			wait(1);
		}
	}
	if(gravgun!=1)
	{
		while(mouse_right&&you==NULL&&mouse_mode==4)
		{

			temp_2.x=camera.x+cos(camera.pan)*cos(camera.tilt)*gunrange;
			temp_2.y=camera.y+sin(camera.pan)*cos(camera.tilt)*gunrange;
			temp_2.z=camera.z+sin(camera.tilt)*gunrange;
			c_trace(camera.x,temp_2, IGNORE_ME | IGNORE_PASSABLE);//|ignore_passents|use_box|use_polygon);//passents,box ve poly eklendi
			wait(1);
		}
	}
	


	if (you!=NULL)
	{
		if is(you,FLAG8)
		{
			hold_object();	
		}

	}



}

void gun_station_startup()
{


	//enable:Gravitation Gun
	//help:if true; right_click=gravity gun else;nogun
//			gravgun=1;
	
	//enable:Holding?
	on_mouse_right=gravitation_gun; 


}


































