/* Free DLL.wdl programed by TripleX aka Timo Stark. 

   You use this dll on your own risk.
   
   How to use:
   only include this dll in your project, by writing 
   include <Freedll.wdl>;
   into your main script.
   Don't forget to copy the dll into your work folder.
*/

/* IMPORTANT INSTRUCTION:
   
   
   1. ALL PATHS ARE WRITTEN IN THE FOLLOWING WAY:
   
   
   Harddisk:\\Folder1\\Folder2  (e.g. T:\\Temp")   --  absolut paths
   
   
   THE NORMAL RELATIV PATH IS SEPERATED IN 2 PATH TYPES: 
   
   1. Folder1\\Folder2\\Folder3 is used in the most instructions
   2. \\Folder1\\Folder2\\Folder3 is used in:
      - DllOpenFileLocal
      - DllScreenshot (the filename)
      - DllCopyFileRelToAbs (the Relative string)
      - DllCopyFileRelToRel (the Relative strings)
      - DllCopyFileAbsToRel (the Relative string)
      
   REGISTRY PATH:  Folder1\\Folder2\\Folder3
   
   
   
   2. ALL FUNCTIONS RETURN -1 IF THEY FAIL AND A VALUE != -1 IF THEY SUCCEEDED  
   
   
   
   3. DON'T FORGET TO END THE DLL BEFORE THE EXIT INSTRUCTION.
   ( dll_close(DllHandle); )
   
   
   4. DON'T USE THE DLL IN THE FIRST FRAME OF THE ENGINE (in the main function or in a starter, without a wait(1) before an instruction).
*/
   
   

/***********************************
  All Defines
***********************************/

//Defines, used in Message Boxes
DEFINE MB_OK,0;   // OK button 
DEFINE MB_OKCANCEL,1; //CANCEL button
DEFINE MB_RETRYCANCEL,2; //RETRY and CANCEL buttons
DEFINE MB_YESNO,3;  //YES and NO buttons
DEFINE MB_YESNOCANCEL,4; //YES, NO and CANCEL  buttons.


DEFINE MB_ICONEXCLAMATION,0; //and exclamation mark
DEFINE MB_ICONWARNING,1; //a warning box
DEFINE MB_ICONINFORMATION,2; //information box
DEFINE MB_ICONASTERISK,3;
DEFINE MB_ICONQUESTION,4; //question mark
DEFINE MB_ICONSTOP,5; //stop 
DEFINE MB_ICONERROR,6; //error box
DEFINE MB_ICONHAND,7;

DEFINE ID_ABORT,1;  //user clicked on ABORT
DEFINE ID_CANCEL,2;//user clicked on CANEL
DEFINE ID_IGNORE,4;//user clicked on IGNORE
DEFINE ID_NO,5;//user clicked on NO
DEFINE ID_OK,6;//user clicked on OK
DEFINE ID_RETRY,7;//user clicked on RETRY
DEFINE ID_YES,9;//user clicked on YES


//Defines used by DllScreenshot
DEFINE D3DX_BMP,0;  //A BMP file
DEFINE D3DX_DDS,4;  //A DDS file
DEFINE D3DX_DIB,6;  // A DIB file


//Defines used by Registry instructions
DEFINE HKEY_CURRENT_USER,0; //switch to HKEY_CURRENT_USER
DEFINE HKEY_CLASSES_ROOT,1;//switch to HKEY_CLASSES_ROOT
DEFINE HKEY_LOCAL_MACHINE,2;//switch to HKEY_LOCAL_MACHINE
DEFINE HKEY_USERS,3;//switch to HKEY_USERS


//Defines used by file instructions
DEFINE FILE_ATTRIBUTE_NORMAL,0; //change to normal file
DEFINE FILE_ATTRIBUTE_HIDDEN,1; //change to hidden file
DEFINE FILE_ATTRIBUTE_READONLY,2; //change to read-only file
DEFINE FILE_ATTRIBUTE_SYSTEM,3; //change to system file










/***********************************
  Function prototypes and  explanations
***********************************/









/* DllMessageBox creates a Windows Message Box. 
 
   Parameters:
   inhalt_ = The Message of the Message box
   title_ = the title of the Message box
   Style = The Style of the Message box. See MB_ICONEXCLAMATION until MB_ICONHAND
   Art = The button(s) of the Message box. See MB_OK until MB_YESNOCANCLE 
   
   Return Values:
   See defines (ID_ABORD until ID_YES)
   -1 if failed
   
   Example:
	c = DllMessageBox("The pointer player\nis null","Pointer error",MB_ICONEXCLAMATION,MB_OK);
   */
dllfunction DllMessageBox(inhalt_,title_,Style,Art); 


/* DllCreateDirectory creates a directory.
  
   Parameters:
   directoryname: The name of the dirctory (or an aboslute path to a directory */
dllfunction DllCreateDirectory(directoryname);  


/* DllRemoveDirectory removes a directory+

   Parameters:
   directoryname: The name of the dirctory (or an aboslute path to a directory
   
   ATTENION: The directory must be empty (for total deleteing use DllRemoveDirectoryComplete(directory)*/
dllfunction DllRemoveDirectory(directoryname); 


/* DllGetImageWidth returns the Image Width of an Image with the help of a filename
   
   Parameters:
   filename: The name of the image, or an absolute path to an image.
   
   Returnvalue:
   The width of the image */
dllfunction DllGetImageWidth(filename); 


/* DllGetImageHeight returns the Image Height of an Image with the help of a filename
   
   Parameters:
   filename: The name of the image, or an absolute path to an image.
   
   Returnvalue:
   The height of the image */
dllfunction DllGetImageHeight(filename); 


/* DllGetImageMipLevels returns the number of MipMaps of an Image with the help of a filename
   
   Parameters:
   filename: The name of the image, or an absolute path to an image.
   
   Returnvalue:
   The number of mip maps of the image */
dllfunction DllGetImageMipLevels(filename);


/* DllGetImageFormat returns the format of an Image with the help of a filename
   
   Parameters:
   filename: The name of the image, or an absolute path to an image.
   
   Returnvalue:
   The format of the image 
   
   See: http://msdn.microsoft.com/library/default.asp?url=/library/en-us/directx9_c/directx/graphics/reference/d3d/enums/d3dformat.asp */
dllfunction DllGetImageFormat(filename); 


/*  with the help of DllSetFullscreenDialog you can indicate if the MessageBoxes are visible in Fullscreen or not.

    Parameters:
    on_off:  1=allows fullscreenmessageboxes, 0 don't allow them 
    
    Remarks:
    Don't try to show message boxes in fullscreen mode, without calling this function before.*/
dllfunction DllEnableFullscreenDialog(on_off);


/*  with the help of DllGetPath(); you can receive the absolute path of the game exe file. 
    
    Returnvalues:
    DllGetPath(); changes the string DllReceiveStr1 to the absolute path of the game exe file. */
dllfunction DllGetPath();


/*  with the help of DllOpenInternetExplorer you can open the Internet explorer with an specific homepage.
    
    Parameters:
    website: This string indicates the website, the function opens */
dllfunction DllOpenInternetExplorer(website);


/*  DllOpenInternet is the same as DllOpenInternetExplorer. It only opens the Default browser, and is not forced to open IE

    Parameters:
    website: This string indicates the website, the function opens */
dllfunction DllOpenInternet(website);




/*   DllCopyIntoClipboard copys a string into the Clipboard. This String can be used with DllPasteFromClipboard(); or in other text programs 
     The 1. parameter is the string you want to copy into the clipboard.*/
dllfunction DllCopyIntoClipboard(str);

/*   DllPasteFromClipboard pastes the text in the clipboard ( if available ) into the DllReceiveStr1 String. */
dllfunction DllPasteFromClipboard();


/*   With the help of DllEmptyClipboard(); you can clear the Clipboard. */
dllfunction DllEmptyClipboard();


/*   With the help of DllRemoveDirectoryComplete you can delete a directory and all files / sub folders in it. 
     The 1. parameter contains the directory name */
dllfunction DllRemoveDirectoryComplete(directory);


/*   This function returns the CPU speed in MHZ */
dllfunction DllGetCpuSpeed();


/*   This function returns the HOST name of the current computer */
dllfunction DllGetHostName();

/*   With the help of this function you can Repositionate the acknex window */
dllfunction DllRepositionWindow(posx,posy);


/*   This function returns the max Texture width of the adapter (normaly 4096) */
dllfunction DllGetMaxTextureWidth();


/*   This function returns the max Texture height of the adapter (normaly 4096) */
dllfunction DllGetMaxTextureHeight();



/*   This function returns the max anisotrohpy of the adapter (normaly 0 - 8) */
dllfunction DllGetMaxAnisotrophy();


/*   This function returns 1 if the string is written in lowercase and 0 if written in uppercase. 
     The 1.st parameter is the string, to be checked (must contain only ONE character) */
dllfunction DllIsStringLower(str);


/*   This function returns 0 if the string is written in lowercase and 1 if written in uppercase. 
     The 1.st parameter is the string, to be checked (must contain only ONE character) */
dllfunction DllIsStringUpper(str);


/*   This function returns 1 if the 1.st character of the string is an alphabetic chracter. 
     The 1.st parameter is the string, to be checked (must contain only ONE character) */
dllfunction DllIsStringAlpha(str);


/*   This function returns 1 if the 1.st character of the string is an alphabetic character or a numeric character. 
     The 1.st parameter is the string, to be checked (must contain only ONE character) */
dllfunction DllIsStringAlphaNum(str);


/*  DllOpenFileLocal opens a file with the Default program.

    Parameters:
    filename: A LOCAL filename.
    
    Remarks: DON'T try to open files, of that you don't know if the users of your product can open them!!! */
dllfunction DllOpenFileLocal(filename);


/*  DllOpenFileAbsolut opens a file with the Default program.

    Parameters:
    filename: A ABSOLUTE filename.
    
    Remarks: DON'T try to open files, of that you don't know if the users of your product can open them!!! */
dllfunction DllOpenFileAbsolut(filename);



/*  with the help of DllMinimizeWindow() you can minimize the acknex window */
dllfunction DllMinimizeWindow();


/* with the help of DllSetTitle you can change the title of the acknex window.

   parameters:
   str: A string, containing the new title */
dllfunction DllSetTitle(str);



/*  DllGetTitle fills DllReceiveStr1 with the title of the acknex window */
dllfunction DllGetTitle();


/*  DllDeleteFile deletes a specific file.

    Parameters:
    filename: indicates the file, the function will delete. Can be relative and absolute. */
dllfunction DllDeleteFile(filename);


/*  With the help of DllGetRefreshRate you can get the refresh rate of the monitor (in HZ). */
dllfunction DllGetRefreshRate();


/*  DllOpenFile opens a Windows Open Dialog. 
    
    parameters:
    title_str: a string that must be filled with the title of the dialog
    types: a string, that must be filled with the types the dialog box can open. 
           example: Effect Files (*.ep3)|*.ep3|. The string is seperated in 2 parts:  
           Name|*.filesort|Name|*.filesort  etc. 
    FirstDirectory: a string that can be filled the firstdirectory, the Dialog displays 
    
    
    Modifications:
    DllReceiveStr1 contains the filename of the selected file, after this instruction.
    DllReceiveStr2 contains the absolute path of the selected file. */
dllfunction DllOpenFile(title_str,types_str,FirstDirectory);



/*  DllOpenFile opens a Windows Save Dialog. 
    
    parameters:
    title_str: a string that must be filled with the title of the dialog
    types: a string, that must be filled with the types the dialog box can save. 
           example: Effect Files (*.ep3)|*.ep3|. The string is seperated in 2 parts:  
           Name|*.filesort|
    FirstDirectory: a string that can be filled the firstdirectory, the Dialog displays 
    filesort must contain the file extension (example: "tga") without a point.
    
    Modifications:
    DllReceiveStr1 contains the filename of the selected file, after this instruction.
    DllReceiveStr2 contains the absolute path of the selected file. */
dllfunction DllSaveFile(title_str,types_str,FirstDirectory,filesort);


/*  with the help of DllScreenshotSetData you can set the propties of the next screenshot, taken with DllScreenshot.

    parameters:
    pos1 contains the X start position of the screenshot.
    pos2 contains the Y start position of the screenshot.
    sizex contains the X width of the screenshot
    sizey contains the Y with of the screenshot */
dllfunction DllScreenshotSetData(pos1,pos2,sizex,sizey);


/*  with the help of DllScreenshot you can take a screenshot, of a part of the screen. NEVER USE THIS INSTRUCTION WITHOUT CALLING DllScreenshotSetData BEFORE!!!

    parameters:
    Filename: This string must be filled with the filename of the file that will be saved. Correct file  extensions are bmp (my suggestion), dds and dib.
    type_: the file type. Possible: D3DX_BMP (*.bmp), D3DX_DDS (*.dds) D3DX_DIB (*.dib) */
dllfunction DllScreenshot(Filename,type_);


/*  with the help of DllGetAdapterName you can get the graficcard name.
     
    this function modificates the string DllReceiveStr1 with the name of the adapter. */
dllfunction DllGetAdapterName();


/*   with the help of DllDownloadFileTo you can download a file out of the internet.

     parameters: 
     homepage: the web adress of the file.
     to: where you want to save the file (WITH the filename)
     
     Example:
     
     DllDownloadFileTo("http://www.hawkgames.de/index.php","index.php"); //saves the php site in the game folder under the filename "index.php"
     
     Remarks: You can not download more than 1 file at the same time. This possibilty will be implemented in further updates.*/
dllfunction DllDownloadFileTo(homepage,to);


/*   with the help of DllStopDownload you can stop a file downloading at the moment. You can NOT resume the download */
dllfunction DllStopDownload();


/*  DllDownloadGetProgress() returns the number of bytes downloaded with the DllDownloadFileTo instruction or -1 if the file is downloaded. */
dllfunction DllDownloadGetProgress();


/*  DllDownloadGetProgress() returns the number of bytes that WILL BE loaded with the DllDownloadFileTo instruction 

    Remarks: You can calculate the percentage, downloaded with: 
    var per_cent;
    per_cent = DllDownloadGetProgress() / DllDownloadGetMaxProgress() * 100; */
dllfunction DllDownloadGetMaxProgress();


/*  DllGetWindowsDirectory fills the string DllReceiveStr1 with the path of the windows directory */
dllfunction DllGetWindowsDirectory();


/*   DllGetWindowsVersion returns the windows version. 
     
     return Values:
     5 = Windows XP / Server 2003 / Windows 2000
     4 = Windows NT / Windows 98 / Windows Me
     3 = Windows 95 and older */
dllfunction DllGetWindowsVersion();


/* with the help of DllCopyFileRelToAbs you can copy a file from the game folder to the harddisk.

   parameters:
   source: filename of the source file (relative)
   target_: filename of the target file (absolut)
   
   example:
	DllCopyFileRelToAbs("thompson.mdl","T:\\thompson.mdl"); */
dllfunction DllCopyFileRelToAbs(source,target_);



/* with the help of DllCopyFileAbsToAbs you can copy a file

   parameters:
   source: filename of the source file (absolut)
   target_: filename of the target file (absolut)
   
   example:
	DllCopyFileRelToAbs("T:\\test\\thompson.mdl","T:\\thompson.mdl"); */
dllfunction DllCopyFileAbsToAbs(source,target_);



/* with the help of DllCopyFileAbsToAbs you can copy a file from the harddisk into the gamefolder.

   parameters:
   source: filename of the source file (absolut)
   target_: filename of the target file (absolut)
   
   example:
	DllCopyFileRelToAbs("T:\\test\\thompson.mdl","thompson.mdl"); */
dllfunction DllCopyFileAbsToRel(source,target_);


/* with the help of DllCopyFileAbsToAbs you can copy a file in the gamefolder

   parameters:
   source: filename of the source file (absolut)
   target_: filename of the target file (absolut)
   
   example:
	DllCopyFileRelToAbs("thompson.mdl","\\test\\thompson.mdl"); */
dllfunction DllCopyFileRelToRel(source,target_);



/*   DllSetFileAttributes changes the attributes of a file.

     parameters:
     filename: the file that shall be changed (relative or absolute path)
     filetype: the new file attribute. Valid values are:
               FILE_ATTRIBUTE_NORMAL : normal file
               FILE_ATTRIBUTE_HIDDEN : hidden file
               FILE_ATTRIBUTE_READONLY : the file is set read only
               FILE_ATTRIBUTE_SYSTEM : the file is marked as system file */
dllfunction DllSetFileAttributes(filename,filetype);


/*   with the help of DllGetFileAttributes you can get the attributes of a file. */
dllfunction DllGetFileAttributes(filename);




/*   DllListFiles fills DllReceiveStr1 with the list of all files in the folder "folder".

     parameters:
     folder - The folder, which sould be searched for files. THE STRING HAS TO EXIT WITH "\\*" !!!! 
              Example:  E:\\Hawkgames\\*  if you want to list all files in the E:\\Hawkgames folder.
              or "*" if you want to ist all folders in the game folder!
     
     Modificates the string DllReceiveStr1.
     Example of the string, after this instruction:
     
     file1|
     file2|
     file3|
     
     The "|" is the endmark of a name. */
dllfunction DllListFiles(folder);



/*   DllListFolders fills DllReceiveStr1 with the list of all subfolders in the folder "folder".THE STRING HAS TO EXIT WITH "\\*" !!!! 
              Example:  E:\\Hawkgames\\*  if you want to list all subfolders in the E:\\Hawkgames folder.
              or "*" if you want to ist all subfolders in the game folder!

     parameters:
     folder - The folder, which sould be searched for subfolders.
     
     Modificates the string DllReceiveStr1.
     Example of the string, after this instruction:
     
     SubFolder1|
     SubFolder2|
     SubFolder3|
     
     The "|" is the endmark of a name. */
dllfunction DllListFolders(folder);



/*  DllGetIpAdress fills DllReceiveStr1 with the IP address of the curret computer */
dllfunction DllGetIpAdress();








/*******************************************************************************
    Registry functions
********************************************************************************/



////
//File System Return Values:
//
//1 = function succeded
//negative values = function failed
//-1 = no valid ID or no valid pointer
//-2 = unknown error.. please contact me under suppor@EasyParticle.de or ICQ ( 170911701 )
//-3 = if a read instruction returns "-3" the end of file was reached.



/*  with the help of DllCreateRegKey you can create a registry key. If this key already exists, it will be opened.
    This dll can open only ONE key at the same time. You have to close it via DllCloseRegKey();  after you've used it.
    
    parameters:
    RegKey: A string containing the Key you want to create/open.
    
    example:
    DllCreateRegKey("Software\\easy Particle 3");
    
    remarks:
    You can only create one subkey per call. example:
    DllCreateRegKey("Software\\easy Particle 3\\Data");
    is not valid, if the subkey "Software\\easy Particle 3" don't exists */
dllfunction DllCreateRegKey(RegKey);



/*  with the help of DllCreateRegValueStr you can write a string into a key. If no key had been opened, the function will fail.
    If the name of the value already exists, the old value will be overwritten.
    
    parameters:
    name: a string, containing the name of the value.
    val_str: a string containg the value. 
    
    example:
    DllCreateRegValueStr("Licence","1234-1234-1234");*/
dllfunction DllCreateRegValueStr(name,val_str);




/*  with the help of DllCreateRegValueStr you can write a var into a key. If no key had been opened, the function will fail.
    If the name of the value already exists, the old value will be overwritten.
    
    parameters:
    name: a string, containing the name of the value.
    val_str: a var containg the value. 
    
    example:
    DllCreateRegValueVar("Times started",55);*/
dllfunction DllCreateRegValueVar(name,value);




/*  with the help of DllGetRegValueVar you can receive the value of a value written in the registry. If no key had been opened, the function will fail.
    If the name of the Value don't exists, the function will return -1.
    
    Parameters:
    name: you have to insert the name of the value here.
    
    Return value:
    -1 if the function fails (name don't exist etc.) or the value, if the function succed.
    
    example:
    var c;
    c = DllGetRegValueVar("Times started"); */
dllfunction DllGetRegValueVar(name);





/*  with the help of DllGetRegValueStr you can receive the value of a string written in the registry. If no key had been opened, the function will fail.
    If the name of the Value don't exists, the function will return -1.
    
    Parameters:
    name: you have to insert the name of the value here.
    
    Return value:
    -1 if the function fails (name don't exist etc.).
    
    Modifications:
    if the function succeds DllReceiveStr1 will contain the value of the string.
    
    example:
    
    DllGetRegValueVar("Licence"); */
dllfunction DllGetRegValueStr(name);




/*  with the help of DllCloseRegKey() you can close the, with DllOpenRegKey or DllCreateRegKey, opened key. After this instruction you can create/open a new key. */
dllfunction DllCloseRegKey();



/*  with the help of DllRemoveRegKey you can remove a key from the registry.
    
    parmeters: 
    name: a string, that must be filled with the name of the key.
    
    example:
    
    DllRemoveRegKey("Software\\easy Particle 3\\Data"); */
dllfunction DllRemoveRegKey(name);




/*  with the help of DllRemoveRegValue you can remove a value from the registry. A key must be opend.
    
    parmeters: 
    name: a string, that must be filled with the name of the value.
    
    example:
    
    DllRemoveRegValue("Resolution"); */ 
dllfunction DllRemoveRegValue(name);



/*   same as DllCreateRegKey. This function don't creates a key, if the key "name" don't exists.

     parameters:
     name: Name of the key, you want to open. */
dllfunction DllOpenRegKey(name);



/*   with the help of DllRegChangeRegion you can change the "region" you want to change the registry keys. 
     
     parameters:
     region: the new region of the registry keys.
             Valid parameters are:
               HKEY_CURRENT_USER (default)
               HKEY_CLASSES_ROOT
               HKEY_LOCAL_MACHINE
               HKEY_USERS 
     
     
     example:
     DllRegChangeRegion(HKEY_LOCAL_MACHINE); */
dllfunction DllRegChangeRegion(region);




/*   with the help of DllRegEnumValues you can enumerate all Values, which are in a key. 

     Modficates:
     DllReceiveStr1 will contain the name of all values after this instruction. Example of the string:
     
     Value1|
     Value2|
     Value3|
     
     the "|" is the end mark of the name */
dllfunction DllRegEnumValues();



/*   with the help of DllRegEnumValues you can enumerate all subkeys, which are in a key. 

     Modficates:
     DllReceiveStr1 will contain the name of all subkeys after this instruction. Example of the string:
     
     subkey1|
     subkey2|
     subkey3|
     
     the "|" is the end mark of the name */
dllfunction DllRegEnumKeys();


/* Saves a changed Bitmap.
   Bmp is a string which contains the image name in 3DGS (bmap NAME = <...>;)
   Str contains the string of the created file.
   
   Remarks:
   You can only create *.bmp *.dib and *.dds filetyps.
   You have to show or preload (bmap_preload) the bitmap before using this instruction */
dllfunction DllSaveBitmap(bmp,str);


//////FILE FUNCTIONS


/*  DllFOpen opens a File. 
    Str1 Contains the Filename of the File
    OpenMode a variable containing the mode, you open the file. THe following modes are available:

    DLLMODE_READ
	 Open a file for reading. The file must exist.
    DLLMODE_WRITE
	 Create an empty file for writing. If a file with the same name already exists its content is erased.
    DLLMODE_APPEND
	 Append to a file. Writing operations append data at the end of the file. The file is created if it doesn't exist.
    DLLMODE_READ_WRITE
	 Open a file for reading and writing. The file must exist.
    DLLMODE_WRITE_READ
	 Create an empty file for reading and writing. If a file with the same name already exists its content is erased before it is opened.
    DLLMODE_APPEND_READ
	  Open a file for reading and appending. All writing operations are done at the end of the file protecting the previous content to be overwritten. You can reposition (fseek, rewind) the pointer to anywhere in the file for reading, but writing operations will move back to the end of file. The file is created if it doesn't exist.
     The next parameter serves to specify whether we want to open the file as text or binary, 
    DLLMODE_TEXT
	 Text mode. In text mode the end of file is assumed to be at first Ctrl-Z character. Some conversions can occur reading and writing with End Of Line / Feedback characters depending on your compiler and your Operating System.
    DLLMODE_BINARY
	 Binary mode. End of file is reached at last byte of the file. No conversions.
	 
	 If you are not sure what to insert at the last parameter overgive NULL.
	 
	 
	 The function returns an ID, with that you can write into the file.
	 Example:
    var id;	 
	 id = DllFopen("Test.txt",DLLMODE_WRITE,DLLMODE_BINARY); */
dllfunction DllFOpen(str1,writemode,mode_); 


/*  DllFClose closes an open file. As a parameter it expects the id of an open file.
    
    Example:
    
    DllFClose(id); */
dllfunction DllFClose(id);


/*  DllWriteLong writes a LONG File typ (binary) into the open file. 
    The long filetyp has a size of 4 bytes and can contain floating point number 
    
    Example:
    
    DllWriteLong(id,22.12); */
dllfunction DllWriteLong(id,long);

/*  DllReadLong reads a LONG file typ from the open file.
    
    Example:
    
    var long;
    long = DllReadLong(id); */
dllfunction DllReadLong(id);


/*  DllWriteLong writes a FLOAT File typ (binary) into the open file. 
    The float filetyp has a size of 4 bytes and can contain floating point number 
    
    Example:
    
    DllWriteFloat(id,22.12); */
dllfunction DllWriteFloat(id,float);


/*  DllReadFloat reads a FLOAT file typ from the open file.
    
    Example:
    
    var float;
    float = DllReadFloat(id); */
dllfunction DllReadFloat(id);



/*  DllWriteLong writes a DOUBLE File typ (binary) into the open file. 
    The double filetyp has a size of 8 bytes and can contain floating point number 
    
    Example:
    
    DllWriteDouble(id,22.12); */
dllfunction DllWriteDouble(id,float);


/*  DllReadDouble reads a DOUBLE file typ from the open file.
    
    Example:
    
    var double;
    double = DllReadDouble(id); */
dllfunction DllReadDouble(id);



/*  DllWriteInt writes a INT File typ (binary) into the open file. 
    The int filetyp has a size of 4 bytes and can NOT contain floating point number 
    
    Example:
    
    DllWriteInt(id,40); */
dllfunction DllWriteInt(id,int_);



/*  DllReadInt reads a INT file typ from the open file.
    
    Example:
    
    var int;
    int = DllReadInt(id); */
dllfunction DllReadInt(id);




/*  DllWriteInt writes a BOOL File typ (binary) into the open file. 
    The bool filetyp has a size of 1 byte and can only contain the values 1 (true) and 0 (false)
    
    Example:
    
    DllWriteInt(id,40); */
dllfunction DllWriteBool(id,bool_);



/*  DllReadBool reads a BOOL file typ from the open file.
    
    Example:
    
    var bool;
    bool = DllReadBool(id); */
dllfunction DllReadBool(id);



/*  DllWriteShort writes a SHORT File typ (binary) into the open file. 
    The short filetyp has a size of 2 byte and can only contain the -32000 ... +32000
    
    Example:
    
    DllWriteShort(id,40); */
dllfunction DllWriteShort(id,short_);



/*  DllReadShort reads a short file typ from the open file.
    
    Example:
    
    var short;
    short = DllReadShort(id); */
dllfunction DllReadShort(id); //-32768...+32768


/*  DllWriteString writes a normal string into an open file
    
    Example:
    
    DllWriteString(id,"Hello"); */
dllfunction DllWriteString(id,char);


/*  DllReadSting reads a number of characters out of an open file into a string

    Example:
    
    DllReadString(id,5,temp_str); //copy the next 5 characters into the string temp_str
    DllReadString(id,4,NULL); //copy the next 4 characters into the DllReceive1 string! */
dllfunction DllReadString(id,num,str); 


//dllfunction DllReadStringTo(id,tostr,str);//ToDo bergebe string zum einlesen; Lese bis zu einem bestimmten ascii zeichen


/*  DllWriteLongPos (over)writes a long filetyp at a specific byte position in an open file.
    
    Example:
    
    DllWriteLongPos(400,20,0,"Test.txt"); //writes the number 20 after the 400 byte in the file Test.txt. Overwrite 0 bytes after the 400 byte
    DllWriteLongPos(20,5.2,4,"Test.txt"); //writes the number 5.2 after the 20 byte in the file Test.txt. Overwrite the bytes 20 - 24 (overwrite value is 4) */
dllfunction DllWriteLongPos(pos,long,overwrite,file);



/*  DllWriteStringPos (over)writes a string at a specific byte position in an open file.
    
    Example:
    
    DllWriteStringPos(400,"hello",0,"Test.txt"); //writes the string "Hellp" after the 400 byte in the file Test.txt. Overwrite 0 bytes after the 400 byte
    DllWriteStringPos(20,"hey ho",4,"Test.txt"); //writes the string "hey ho" after the 20 byte in the file Test.txt. Overwrite the bytes 20 - 24 (overwrite value is 4) */
dllfunction DllWriteStringPos(pos,char,overwrite,file);



/*  DllWriteFloatPos (over)writes a float filetyp at a specific byte position in an open file.
    
    Example:
    
    DllWriteFloatPos(400,20,0,"Test.txt"); //writes the number 20 after the 400 byte in the file Test.txt. Overwrite 0 bytes after the 400 byte
    DllWriteFloatPos(20,5.2,4,"Test.txt"); //writes the number 5.2 after the 20 byte in the file Test.txt. Overwrite the bytes 20 - 24 (overwrite value is 4) */
dllfunction DllWriteFloatPos(pos,float,overwrite,file);



/*  DllWriteDoublePos (over)writes a double filetyp at a specific byte position in an open file.
    
    Example:
    
    DllWriteDoublePos(400,20,0,"Test.txt"); //writes the number 20 after the 400 byte in the file Test.txt. Overwrite 0 bytes after the 400 byte
    DllWriteDoublePos(20,5.2,4,"Test.txt"); //writes the number 5.2 after the 20 byte in the file Test.txt. Overwrite the bytes 20 - 24 (overwrite value is 4) */
dllfunction DllWriteDoublePos(pos,float,overwrite,file);



/*  DllWriteIntPos (over)writes an int filetyp at a specific byte position in an open file.
    
    Example:
    
    DllWriteIntPos(400,20,0,"Test.txt"); //writes the number 20 after the 400 byte in the file Test.txt. Overwrite 0 bytes after the 400 byte
    DllWriteIntPos(20,5,4,"Test.txt"); //writes the number 5 after the 20 byte in the file Test.txt. Overwrite the bytes 20 - 24 (overwrite value is 4) */
dllfunction DllWriteIntPos(pos,float,overwrite,file);


/*  DllWriteShortPos (over)writes an int filetyp at a specific byte position in an open file.
    
    Example:
    
    DllWriteShortPos(400,20,0,"Test.txt"); //writes the number 20 after the 400 byte in the file Test.txt. Overwrite 0 bytes after the 400 byte
    DllWriteShortPos(20,5,4,"Test.txt"); //writes the number 5 after the 20 byte in the file Test.txt. Overwrite the bytes 20 - 24 (overwrite value is 4) */
dllfunction DllWriteShortPos(pos,float,overwrite,file);



/*  DllWriteBoolPos (over)writes an int filetyp at a specific byte position in an open file.
    
    Example:
    
    DllWriteBoolPos(400,1,0,"Test.txt"); //writes the number 1 after the 400 byte in the file Test.txt. Overwrite 0 bytes after the 400 byte
    DllWriteBoolPos(20,0,4,"Test.txt"); //writes the number 0 after the 20 byte in the file Test.txt. Overwrite the bytes 20 - 24 (overwrite value is 4) */
dllfunction DllWriteBoolPos(pos,float,overwrite,file);



/*   DllEreaseBytes deletes specific Bytes out of a file.

     Example:
     
     DllEreaseBytes(400,20,"Test.txt"); //delete bytes 400-420 out of the file Test.txt */
dllfunction DllEreaseBytes(pos,num,file);


/*   The function DllGetLengthFromFile returns the size in bytes of a specific file given by the "file" parameter.
     
     Example:
     
     var a;
     a = DllGetLengthFromFile("Test.txt"); */
dllfunction DllGetLengthFromFile(file);


/*   Same as DllGetLengthFromFile, only returns the file size with an id */
dllfunction DllGetLengthFromId(id);

/*   With the help of the function DllFileSeekFromCursor you can move the file pointer forward/backward. The origin is the curret Pointer position. Example:
     
     DllFileSeekFromCursor(id,20); //move the file pointer 20 bytes forward (jump over 20 bytes)
     DllFileSeekFromCursor(id,-15); //move the file pointer 15 bytes backward */
dllfunction DllFileSeekFromCursor(id,offset);


/*   With the help of the function DllFileSeekFromStart you can move the file pointer forward/backward. The origin is the 1st Byte. Example:
     
     DllFileSeekFromStart(id,20); //set the file pointer to the 20th byte */
dllfunction DllFileSeekFromStart(id,offset);


/*   With the help of the function DllFileSeekFromEnd you can move the file pointer forward/backward. The origin is the last Byte. Example:
     
     DllFileSeekFromStart(id,0); //set the file pointer to the last byte 
     DllFileSeekFromStart(id,-1); //set the file pointer to the last but one byte */
dllfunction DllFileSeekFromEnd(id,offset);


/*   DllGetFileCursor returns the curret File Pointer (cursor) position in bytes */
dllfunction DllGetFileCursor(id);


/*   Checks if the FileCursor reachs the end of the file */
dllfunction DllFileEnd(id); 

DEFINE true,1;
DEFINE false,0;

DEFINE DLLMODE_WRITE,1;
DEFINE DLLMODE_WRITE_READ,2;
DEFINE DLLMODE_APPEND,3;
DEFINE DLLMODE_APPEND_READ,4;
DEFINE DLLMODE_READ,5;
DEFINE DLLMODE_READ_WRITE,6;

DEFINE DLLMODE_BINARY,1;
DEFINE DLLMODE_TEXT,2;



//////////////////////////////////////////
////Mp3 Features
//////////////////////////////////////////

/* MP3/Ogg/Wma/Midi etc. Player for all editions  
   Programmed by TripleX */
   
/* How to use:
   Include the mp3.wdl and the mp3.dll into your main folder of the project and include the
   mp3.wdl into your main script (include <mp3.wdl>; ).
   Now you can call all mp3 functions. */

dllfunction dll_mp3init(filename);  /* This is the first function you have to call. It initialize an mp3 file and returns an ID YOU NEED FOR 
                                       ALL INSTRUCTIONS!!! 
                                       
                                       Example:
                                       
                                       var id;
                                       id = dll_mp3init("Ausbilder Schmidt - Morgen Ihr Luschen.ogg"); */
                                    

dllfunction dll_mp3play(id);     /* Starts the mp3/ogg usw. file. 
                                    Example:
                                    
                                    var id;
                                    id = dll_mp3init("Ausbilder Schmidt - Morgen Ihr Luschen.ogg"); //init the song
                                    dll_mp3play(id); //play it */
                                   
dllfunction dll_mp3playloop(id);  /* not usable. FOR LOOPING A SONG USE dll_mp3loopplay(id); */
dllfunction dll_mp3stop(id);      /* Stops a song
                                     Example:
                                     
                                     var id;
                                     id = dll_mp3init("Ausbilder Schmidt - Morgen Ihr Luschen.ogg"); //init the song
                                     dll_mp3play(id);
                                     sleep(5);
                                     dll_mp3stop(id); */
dllfunction dll_mp3pause(id);     /* Pauses a song.. same syntax as dll_mp3stop(id). The song can be resumed with dll_mp3resume(id). */
dllfunction dll_mp3resume(id);    /*Resumes a paused song */
dllfunction dll_mp3getposition(id);  /* Returns the Position of the song (in seconds) */
dllfunction dll_mp3setposition(id,zeit);  /* Sets the Position of the song (in seconds. 
                                             
                                             Example:
                                             var id;
                                             id = dll_mp3init("Ausbilder Schmidt - Morgen Ihr Luschen.ogg"); //init the song
                                             dll_mp3play(id);
                                             dll_mp3setposition(id,10); //jumps to 10 seconds! */
dllfunction dll_mp3getplayback(id); /* Returns the speed of the song */
dllfunction dll_mp3setplayback(id,plaback); /* Set the speed of a song. MUST NOT BE ZERO */
FUNCTION dll_mp3setvolume(id,vol); /* Sets the volume of a song. Maximum volume = 1000. Minimum volume = 0 
                                         Example:
                                         var id;
                                         id = dll_mp3init("Ausbilder Schmidt - Morgen Ihr Luschen.ogg"); //init the song
                                         dll_mp3play(id);
                                         dll_mp3setvolume(id,-1000); */
FUNCTION dll_mp3getvolume(id);  /* gets the volume of an id */

dllfunction dll_mp3setbalance(id,vol); /* Sets the Balance. The value can range from -10,000 to 10,000. 
                                          The value -10,000 means the right channel is attenuated by 100 dB and is effectively silent. 
                                          The value 10,000 means the left channel is silent. The neutral value is 0, which means that both channels 
                                          are at full volume. When one channel is attenuated, the other remains at full volume. */
dllfunction dll_mp3getlength(id);    /* Returns the duration of a song (in seconds */
dllfunction dll_mp3tune(id,vol,pan,loop); /* Tunes the volume, balance(pan), and looping. If you don't want to change 1 parameter,
                                             write -1. */

dllfunction dll_mp3state(id);    /* Returns the state of the song.
                                    1 for playing
                                    2 for not playing
                                    3 for pause */
dllfunction dll_mp3remove(id);  /* VERY IMPORTANT: Removes the song from the memory. Call this function if you don't need the song anymore */


FUNCTION dll_mp3mastervol(volume); /* Changes the Volume of ALL songs. */

FUNCTION dll_mp3loopplay(id); /* Same as dll_mp3play(id). Only loops the track */

dllfunction dll_mp3inited(id); /* checks if the id exists */

FUNCTION dll_mp3mass(COMMAND,INDEX); /* changes the status of all songs. following Commands and Indexes are possible:
                                       
                                        Command           Index
                                        MP3_PLAY          NULL
                                        MP3_PAUSE         NULL
                                        MP3_RESUME        NULL
                                        MP3_REMOVE        NULL
                                        MP3_STOP          NULL
                                        MP3_BALANCE       The balance value
                                        MP3_POSITION      The new position of all tracks */
                                        
dllfunction dll_mp3getinfo(id);   /* gets the ID3 (version1) infos of an MP3 (ONLY MP3!! DONT USE OTHER FILE FORMATS FOR THIS FUNCTIONS
                                     dll_mp3getinfo saves all informations into strings. 
                                     
                                     List:
                                     
                                       Information      Stringname
                                       Title            dll_mp3TITLE
                                       Artist           dll_mp3ARTIST
                                       Comment          dll_mp3COMMENT
                                       Year             dll_mp3YEAR
                                       Album            dll_mp3ALBUM 
                                       
                                     The return values of the functions:
                                     
                                     -1 The mp3 file don't contain an ID3 tag. Give the mp3 file an Id3 tag with programms like winamp, or for all german users: http://www.mp3tag.de/ !
                                     1  Succsessful.
                                     0  The mp3 don't exists */


//Dont use following functions
dllfunction dll_mp3setvol(id,vol); /* DONT USE THIS FUNCTION */
dllfunction dll_mp3getvol(id); /* DONT USE THIS FUNCTION */
dllfunction dll_mp3looper(id);  /* RESERVED!!! for looping */

VAR dll_mp3initvar; //1 if the mp3 is inited. DON'T USE DLLFUNCTIONS BEFORE THIS VAR ISN'T 1!!
VAR dll_mastervolume = 1000; //VOLUME in per cent of ALL songs. Example: Set this var to 500, and all songs will get 50% more quite.. (woaa what an english :D )
VAR dll_mastervolume_0percent = -4000; /* The 0 Percent mark for the mastervolume and the normal volume 
                                          As higher, as louder is the sound. As lower, as more quiete is the sound */

STRING dll_mp3TITLE[30]; //Contains the title of a track, after executing dll_mp3getinfo(id);
STRING dll_mp3ARTIST[30]; //Contains the title of a track, after executing dll_mp3getinfo(id);
STRING dll_mp3COMMENT[30]; //Contains the title of a track, after executing dll_mp3getinfo(id);
STRING dll_mp3YEAR[4]; //Contains the title of a track, after executing dll_mp3getinfo(id);
STRING dll_mp3ALBUM[30]; //Contains the title of a track, after executing dll_mp3getinfo(id);


VAR dll_mp3orginalvolume[128]; //reserved

//Defines
DEFINE MP3_PLAY,0;
DEFINE MP3_PAUSE,1;
DEFINE MP3_RESUME,2;
DEFINE MP3_REMOVE,3;
DEFINE MP3_BALANCE,4;
DEFINE MP3_POSITION,5;
DEFINE MP3_STOP,6;


//Starts the mp3 dll
STARTER dll_mp3starter()
{
	wait(2);
	var volume;
	var a;
   while(a < 127) { dll_mp3orginalvolume[a] = 0; a += 1; }
   dll_mp3initvar = 1;
	volume = dll_mastervolume;
	
	while(1)
	{
	   if(dll_mastervolume != volume) { volume = dll_mastervolume; dll_mp3mastervol(dll_mastervolume); }
		dll_mp3inited(0);
	   sleep(1);
   }
}


//Loop function
FUNCTION dll_mp3loopplay(id)
{
	dll_mp3playloop(id);
	while(dll_mp3state(id) > 0)
	{
		dll_mp3looper(id);
		sleep(1);
	}
}

//Changes the master volume
FUNCTION dll_mp3mastervol(volume)
{
	var a;
	var b;
	while(a < 127)
	{
		if(dll_mp3inited(a) == 1)
		{
			volume=volume;
			dll_mp3setvolume(a,volume);
		}
		a+=1;
	}
}

//Sets the volume for all tracks
FUNCTION dll_mp3setallvol(volume)
{
	var a;
	var b;
	while(a < 127)
	{
		if(dll_mp3inited(a) == 1)
		{
	      b = dll_mastervolume_0percent + (volume/1000)*(abs(dll_mastervolume_0percent));
			dll_mp3orginalvolume[a] = b;
			temp = dll_mp3setvol(a,b);
		}
		a+=1;
	}
}

//Change the status of all tracks
FUNCTION dll_mp3mass(COMMAND,INDEX)
{
	var a;
	var b;
	while(a < 127)
	{
		if(dll_mp3inited(a) == 1)
		{
		   IF( COMMAND == MP3_PLAY ) { dll_mp3play(a); }
		   IF( COMMAND == MP3_PAUSE ) { dll_mp3pause(a); }
		   IF( COMMAND == MP3_RESUME ) { dll_mp3resume(a); }
		   IF( COMMAND == MP3_STOP ) { dll_mp3stop(a); }
		   IF( COMMAND == MP3_BALANCE ) { dll_mp3setbalance(a,INDEX); }
		   IF( COMMAND == MP3_POSITION ) { dll_mp3setposition(a,INDEX); }
	   }
	   a+=1;
	}
}


//sets the volume for one single track
FUNCTION dll_mp3setvolume(id,volume)
{
	var b; 
	volume=volume;
	b = dll_mastervolume_0percent + (volume/1000)*(abs(dll_mastervolume_0percent));
	dll_mp3orginalvolume[id] = b;
	dll_mp3setvol(id,b);
}

FUNCTION dll_mp3getvolume(id)
{
	var x;
	x = int(1000 - (dll_mp3getvol(id) / dll_mastervolume_0percent) * 1000 + 0.5);
   return(x);
}


/***********************************/



//TODO:
/***********************************
  Strings Vars and Starter
***********************************/

STRING DllReceiveStr1[4096];
STRING DllReceiveStr2[512];
VAR_NSAVE DllHandle; //DONT FORGET TO CLOSE THE DLL


STARTER DllOpen
{
	DllHandle = dll_open("Bigdll.dll");
}