#ifndef CameraMovement_c
#define CameraMovement_c

#include "Euler.c"

function CameraMovement(VIEW* cam);
function GetRelativeViewPosition(VIEW* cam, VECTOR* rel_pos);
function MoveConnectedView(VIEW* cam, ANGLE* rot, VECTOR* orbit_pos, ANGLE* rel_rot, VECTOR* rel_pos);
function ConnectViewToOrbitPoint(VIEW* cam, ANGLE* orbit_rot, VECTOR* orbit_pos, ANGLE* rel_rot, VECTOR* rel_pos);

var camera_rotation_speed = 50;
var camera_translation_speed = 50;
VECTOR orbitcam_center;
	
function CameraMovement(VIEW* cam){
	static VECTOR camera_relpos; 
	static VECTOR orbitcam_offsetpos;
	static ANGLE camera_relang, orbitcam_relang, orbitcam_ang, orbitcam_offsetang;
	static var orbit_flag = OFF;
	var rot_speed = camera_rotation_speed/20;
	var trans_speed = camera_translation_speed/10;
	
	GetRelativeViewPosition(camera, camera_relpos);
	if(key_alt){
		orbit_flag = OFF;
		camera_relpos.x+=mickey.z*.1*time_step*trans_speed;
		camera_relpos.y+=mickey.x*time_step*trans_speed;
		camera_relpos.z+=mickey.y*time_step*trans_speed;
		vec_set(cam.x, camera_relpos.x);
		vec_rotate(cam.x, cam.pan);
	}
	if(key_ctrl){
		orbit_flag = OFF;
		camera_relang.roll=mickey.z*.1*time_step*rot_speed;
		camera_relang.pan=mickey.x*time_step*rot_speed;
		camera_relang.tilt=mickey.y*time_step*rot_speed;
		ang_rotate(cam.pan, camera_relang.pan);
	}
	if(key_shift){
		if(!orbit_flag){
			vec_set(orbitcam_ang, cam.pan);
			ConnectViewToOrbitPoint(cam, orbitcam_ang, orbitcam_center, orbitcam_offsetang, orbitcam_offsetpos);
			orbit_flag=ON;
		}
		orbitcam_relang.roll = -mickey.z*.1*time_step*rot_speed;
		orbitcam_relang.pan = -mickey.x*time_step*rot_speed;
		orbitcam_relang.tilt = -mickey.y*time_step*rot_speed;
		ang_rotate(orbitcam_ang, orbitcam_relang);
	  	
		MoveConnectedView(cam, orbitcam_ang, orbitcam_center, orbitcam_offsetang, orbitcam_offsetpos);
	}

}



function ConnectViewToOrbitPoint(VIEW* cam, ANGLE* orbit_rot, VECTOR* orbit_pos, ANGLE* rel_rot, VECTOR* rel_pos){
	//This function takes in the orientations of an orbit "point" and a camera and outputs the relative
	//orientation of the second w.r.t the first.  The relative orientation can then used
	//by MoveConnectedView to move the view relative to the orbitpoint.
	//Euler Angles
	ANGLE  orbit_unrot; //inverse rotation for the orbit point
	
	vec_set(orbit_unrot, orbit_rot);
	ang_invert(orbit_unrot);
	//Get the relative rotation between the orbit point and the camera
	vec_set(rel_rot, orbit_unrot);
	ang_rotate(rel_rot, cam.pan);
	//Get the vector between the camera position and the orbit position
	vec_diff(rel_pos, cam.x, orbit_pos);  
	//Rotate the vector to the global coordinate system
	vec_rotate(rel_pos, orbit_unrot); 
}

function MoveConnectedView(VIEW* cam, ANGLE* orbit_rot, VECTOR* orbit_pos, ANGLE* rel_rot, VECTOR* rel_pos){
	//This function sets the orientation of a the view relative to the orbit point given the
	//relative orientation.  Call ConnectViewToOrbitPoint before calling this function to obtain
	//the relative orientation. 
	VECTOR temp_vec;
	//Determine the relative rotation of the camera w.r.t the orbit point
	vec_set(temp_vec, orbit_rot);
	ang_rotate(temp_vec, rel_rot);
	vec_set(cam.pan, temp_vec);
	
	//Determine the relative position of the camera w.r.t the orbit point
 	vec_set(temp_vec, rel_pos);
 	vec_rotate(temp_vec, orbit_rot);
 	vec_add(temp_vec, orbit_pos); 
  	vec_set(cam.x, temp_vec);
  	
  	//Now you can get the camera's rotation by taking the relative rotation 
	//and rotating it by the orbit point's rotation.  
	//You can get the camera's position by taking the relative position vector,
	//rotating it by the orbit point's rotation, and then adding the rotated
	//relative position vector to the orbit point's position.
}



function GetRelativeViewPosition(VIEW* cam, VECTOR* rel_pos){
	//This function converts an x, y, z view position definition into a 
	//relative in-out, left-right, up-down position definition 
	//Euler Angles
	ANGLE cam_unrot;
	vec_set(cam_unrot, cam.pan);
	ang_invert(cam_unrot);
	
	vec_set(rel_pos, cam.x); 
	vec_rotate(rel_pos, cam_unrot);
}

#endif

