//Joris Lambrecht
//1/8/2008
//EntityConnectDemo.c

//This example code shows how to attach two entities, such that the second 
//entity's orientation is always relative to the first.  This is useful for 
//picking up objects with arbitrary rotations.  You must have Euler.c in the 
//same folder to generate the required rotation matrices.  The demo also shows
//The use of the same concept with camera movement

#include <acknex.h>
#include <default.c>
#include "EntityConnect.c"
#include "CameraMovement.c"

ENTITY* block1_ent;
ENTITY* block2_ent;

ANGLE relative_rot;
VECTOR relative_pos;

var connect;
	
action block1(){
	block1_ent = me;
}

action block2(){
	block2_ent = me;
}

TEXT* help = {
	string = "To Move Blocks hold down '1' or '2' and move mouse, use arrow keys and pg_up/pg_dn
To connect/disconnect Block2 to Block1 press space (Now Block2 will move with Block1)
To move the camera:
Alt+Mouse: Camera Translation
Ctrl+Mouse: Camera Rotation
Shift+Mouse: Camera Orbit";
	red = 255; green=255; blue=255;
	flags=VISIBLE;
}

function main(){
	fps_max=60;
	wait(1);
	
	connect=OFF;

	//Load the Environment
	level_load("world.wmb");
	wait(3);
	
	//Initialize values
	vec_set(block1_ent.x, vector(-300,0,0));
	vec_set(block1_ent.pan, vector(5,40,-37));
	vec_set(block2_ent.x, vector(0,20,0));
	vec_set(block2_ent.pan, vector(-45,2,3));
	
	vec_set(orbitcam_center, nullvector); //orbit around world origin
	
	while(1){
		
		//Connect/disconnect entities when user presses space 
		if(key_space){
			while(key_space) wait(1); //wait for key release
			if(connect)
				connect=OFF;
			else{
				ConnectEntities(block1_ent, block2_ent, relative_rot, relative_pos);
				connect=ON;
			}	
		}
		CameraMovement(camera);
		wait(1);
	}
}

function MoveEntities_startup(){
	VECTOR temp_vec;
	while(1){
		if(key_1){
			block1_ent.x+=mickey.x*time_step*10;
			block1_ent.y+=mickey.y*time_step*10;
			block1_ent.z+=mickey.z*time_step;
			block1_ent.pan+=key_force.x*time_step;
			block1_ent.tilt+=key_force.y*time_step;
			block1_ent.roll+=0;
			if(key_pgup) block1_ent.roll+=10*time_step; 
			if(key_pgdn) block1_ent.roll+=-10*time_step;
		}
		if(key_2 && !connect){
			block2_ent.x+=mickey.x*time_step*10;
			block2_ent.y+=mickey.y*time_step*10;
			block2_ent.z+=mickey.z*time_step;
			block2_ent.pan+=key_force.x*time_step;
			block2_ent.tilt+=key_force.y*time_step;
			block2_ent.roll+=0;
			if(key_pgup) block2_ent.roll+=10*time_step; 
			if(key_pgdn) block2_ent.roll+=-10*time_step;
		}
		if(connect){
			MoveConnectedEntity(block1_ent, block2_ent, relative_rot, relative_pos);
		}
		wait(1);
	}	
}

