#ifndef EntityConnect_c
#define EntityConnect_c

#include "Euler.c"

function ConnectEntities(ENTITY* ent1, ENTITY* ent2, ANGLE* rel_rot, VECTOR* rel_pos);
function MoveConnectedEntity(ENTITY* ent1, ENTITY* ent2, ANGLE* rel_rot, VECTOR* rel_pos);

function ConnectEntities(ENTITY* ent1, ENTITY* ent2, ANGLE* rel_rot, VECTOR* rel_pos){
	//This function takes in the orientations of two entities and outputs the relative
	//orientation of the second w.r.t the first.  The relative orientation can then used
	//by MoveConnectedEntity to move the second entity relative to the first.
	//Euler Angles
	ANGLE  ent1_unrot; //inverse rotation for first entity
	
	vec_set(ent1_unrot, ent1.pan);
	ang_invert(ent1_unrot);
	//Get the relative rotation between the first and second entity
	vec_set(rel_rot, ent1_unrot);
	ang_rotate(rel_rot, ent2.pan);
	//Get the vector between the two entities origins
	vec_diff(rel_pos, ent2.x, ent1.x);  
	//Rotate the vector to the global coordinate system
	vec_rotate(rel_pos, ent1_unrot); 
	
	//Now you can get the second entity's rotation by taking the relative rotation 
	//and rotating it by the first entity's rotation.  
	//You can get the second entity's position by taking the relative position vector,
	//rotating it by the first entity's rotation, and then adding the rotated
	//relative position vector to the first entity's position.
}

function MoveConnectedEntity(ENTITY* ent1, ENTITY* ent2, ANGLE* rel_rot, VECTOR* rel_pos){
	//This function sets the orientation of a second entity relative to the first given the
	//relative orientation.  Call ConnectEntities before calling this function to obtain
	//the relative orientation. 
	VECTOR temp_vec;
	//Determine the relative rotation of the second entity w.r.t the first 
	vec_set(temp_vec, ent1.pan);
	ang_rotate(temp_vec, rel_rot);
	vec_set(ent2.pan, temp_vec);
	
	//Determine the relative position of the second entity w.r.t the first
 	vec_set(temp_vec, rel_pos);
 	vec_rotate(temp_vec, ent1.pan);
 	vec_add(temp_vec, ent1.x); 
  	vec_set(ent2.x, temp_vec);
}
#endif