#ifndef Euler_c
#define Euler_c

#define PI 3.14159265358979323846

function rotz(double th, double* Rz);
function roty(double th, double* Ry);
function rotx(double th, double* Rx);
function rotzyx(double* angle, double* R);
function eulerzyx(double* R, double* angle);
function matrixmult(double* A, double* B, double* C);
function matrixtranspose(double* M, double* Mtranspose);
function ang_unrotate(ANGLE* angle1,  ANGLE* angle2);
function ang_invert(ANGLE* angle);

function ang_invert(ANGLE* angle){
	double eulerang[3];  //rotation euler angle
	double eulerang_[3]; //inverse rotation euler angle
	
	//Rotation Matrices
	double R[9];  //rotation matrix
	double R_[9]; //inverse rotation matrix
	
	//Set the euler angle vectors	
	eulerang[0]= angle.pan;
	eulerang[1]=-angle.tilt;
	eulerang[2]= angle.roll;
	//Convert the euler angles into rotation matrices
	rotzyx(eulerang,R); 
	//Get the inverse (transpose) of the rotation matrix
	matrixtranspose(R, R_); 
	//Convert the inverse rotation matrix to euler angles
	eulerzyx(R_, eulerang_);
	angle.pan = eulerang_[0];
	angle.tilt=-eulerang_[1];
	angle.roll= eulerang_[2];
}

function ang_unrotate(ANGLE* angle1,  ANGLE* angle2){
	//This function behaves like ang_rotate, except that it first takes the inverse
	//rotation of angle2.  Therefore, the result (stored in angle1) is the relative 
	//rotation between angle1 and angle2 
	ANGLE angle2_;
	
	vec_set(angle2_, angle2);
	ang_invert(angle2_);	
	ang_rotate(angle1, angle2_);
}

function rotz(double th, double* Rz){
//calculates the rotation matrix
//for rotations of th radians around the z axis
	Rz[0*3+0]=cos(th);
	Rz[0*3+1]=-sin(th);
	Rz[0*3+2]=0;
	Rz[1*3+0]= sin(th);
	Rz[1*3+1]= cos(th);
	Rz[1*3+2]=0;
	Rz[2*3+0]=0;
	Rz[2*3+1]=0;
	Rz[2*3+2]=1;
}

function roty(double th, double* Ry){
//creates rotation matrix
//for rotations or th radians around the y axis
	Ry[0*3+0]=cos(th);
	Ry[0*3+1]=0;
	Ry[0*3+2]=sin(th);
	Ry[1*3+0]=0;
	Ry[1*3+1]=1;
	Ry[1*3+2]=0;
	Ry[2*3+0]=-sin(th);
	Ry[2*3+1]=0;
	Ry[2*3+2]= cos(th);
}

function rotx(double th, double* Rx){
//creates rotation matrix 
//for rotation of th radians around the x axis
	Rx[0*3+0]=1;
	Rx[0*3+1]=0;
	Rx[0*3+2]=0;
	Rx[1*3+0]=0;
	Rx[1*3+1]=cos(th);
	Rx[1*3+2]=-sin(th);
	Rx[2*3+0]=0;
	Rx[2*3+1]= sin(th);
	Rx[2*3+2]= cos(th);
}

function rotzyx(double* angle, double* Rzyx){
//creates rotation matrix from euler angle by 
//multiplying together matrices		
	int i, j, k;

	double Rz[9];
	double Ry[9];
	double Rx[9];
	double Ryx[9];
	
	rotz(angle[0]*PI/180, Rz);
	//for(i=0; i<9; i++) 	Rzv[i]=Rz[i];
	roty(angle[1]*PI/180, Ry);
	//for(i=0; i<9; i++)	Ryv[i]=Ry[i];
	rotx(angle[2]*PI/180, Rx);
	//for(i=0; i<9; i++)	Rxv[i]=Rx[i];
	matrixmult(Ry, Rx, Ryx);
	//for(i=0; i<9; i++)	Ryxv[i]=Ryx[i];
	matrixmult(Rz, Ryx, Rzyx);
	//for(i=0; i<9; i++)	Rzyxv[i]=Rzyx[i];
}

function eulerzyx(double* Rzyx, double* angle){
//calculates the Euler angles around the z,y, and x axes
//from the rotation matrix Rzyx
	double x1, y1, z1, x2, y2, z2;
	double sx, cx, sz, cz;
	
	y1 = asin(-Rzyx[2*3+0]);
	sx = Rzyx[2*3+1]/cos(y1);
	cx = Rzyx[2*3+2]/cos(y1);
	x1 = atan2(sx,cx);
	sz = Rzyx[1*3+0]/cos(y1);
	cz = Rzyx[0*3+0]/cos(y1);
	z1 = atan2(sz,cz);
	if(y1 >= 0)  
		y2 = PI - y1;
	else  
		y2 = -PI - y1;
	
	sx = Rzyx[2*3+1]/cos(y2);
	cx = Rzyx[2*3+2]/cos(y2);
	x2 = atan2(sx,cx);
	sz = Rzyx[1*3+0]/cos(y2);
	cz = Rzyx[0*3+0]/cos(y2);
	z2 = atan2(sz,cz);
	if (-PI/2 <= y1 & y1 <= PI/2){
		angle[0]=z1*180/PI;
		angle[1]=y1*180/PI;
		angle[2]=x1*180/PI;
	}
	else{
		angle[0]=z2*180/PI;
		angle[1]=y2*180/PI;
		angle[2]=x2*180/PI;
	}
}

function matrixmult(double* A, double* B, double* C){
//C=A*B
   int i, j, k;
   double sum;
   for(i=0; i<3; i++){
	 	for(j=0; j<3; j++){
	 		sum=0;
			for(k=0; k<3; k++){
		  		sum += A[i*3+k] * B[k*3+j];
 	 		}
 	 		C[i*3+j] = sum;
		}
   }
}


function matrixtranspose(double* M, double* Mtranspose){
//Mtranspose=M' (equivalent to inverse of M for rotation matrices)
	int i, j;
	for(i=0; i<3; i++){
	 	for(j=0; j<3; j++){
 			Mtranspose[i*3+j]=M[j*3+i];
 		}	
 	}
}
#endif