/////////////////////////////////////////////////////
// RPG/Adv. Temp 2.0
// HUD (Head-Up Display) Module
//
// (C) 2006 by Claus N.
// www.nighthawk.dk
/////////////////////////////////////////////////////
// We are using the HUD "Core"
define USE_CORE_BASICHUD;
/////////////////////////////////////////////////////
// We need the Defines "sub-core"
ifndef USE_SUBCORE_DEFINES;
	include <NHASC_defines.wdl>;
endif;
/////////////////////////////////////////////////////
// Bmaps
bmap NHAC_HUDPAN_BG = <NHAC_bottom_HUD.bmp>;
bmap NHAC_CSPELL_PREV = <NHAC_CSPELL_PREV.tga>;
bmap NHAC_CSPELL_PREV_HOVER = <NHAC_CSPELL_PREV_HOVER.tga>;
bmap NHAC_CSPELL_PREV_ACTIVE = <NHAC_CSPELL_PREV_ACTIVE.tga>;
bmap NHAC_CSPELL_NEXT = <NHAC_CSPELL_NEXT.tga>;
bmap NHAC_CSPELL_NEXT_HOVER = <NHAC_CSPELL_NEXT_HOVER.tga>;
bmap NHAC_CSPELL_NEXT_ACTIVE = <NHAC_CSPELL_NEXT_ACTIVE.tga>;
/////////////////////////////////////////////////////
// The panel at the bottom of the screen, showing
// health, mana and the current spell
panel NHAC_HUDPAN
{
	bmap = NHAC_HUDPAN_BG;
	flags = refresh;
	layer = 6;
	window = 6,25,200,20,NHAC_HPBAR,pl_HUDC_health,0;
	window = 6,71,200,20,NHAC_MANABAR,pl_HUDC_mana,0;
	button = 229,44,NHAC_CSPELL_PREV_ACTIVE,NHAC_CSPELL_PREV,NHAC_CSPELL_PREV_HOVER,NHAC_HUDSPELL_TOGGLE,null,null;
	button = 448,44,NHAC_CSPELL_NEXT_ACTIVE,NHAC_CSPELL_NEXT,NHAC_CSPELL_NEXT_HOVER,NHAC_HUDSPELL_TOGGLE,null,null;
}
/////////////////////////////////////////////////////
// The text showing the currently used spell
text NHAC_HUDSPELL_TXT
{
	layer = 7;
	string = NHAC_HUDSPELL_STR;
	font = NHAC_HUDSPELL_FNT;
}
/////////////////////////////////////////////////////
// Positions and shows the panel
function NHAC_HUDPAN_SHOW()
{
	// Position the panel
	NHAC_HUDPAN.pos_x = 0;
	NHAC_HUDPAN.pos_y = screen_size.y - bmap_height(NHAC_HUDPAN_BG);
	NHAC_HUDPAN.visible = true;
	
	// Set some variables, which are necessary for not setting
	// a walkpoint, when you click on the panel
	NHAC_CHUD_POSX = NHAC_HUDPAN.pos_x;
	NHAC_CHUD_POSY = NHAC_HUDPAN.pos_y;
	NHAC_CHUD_BMAPWIDTH = bmap_width(NHAC_HUDPAN.bmap);
	NHAC_CHUD_BMAPHEIGHT = bmap_height(NHAC_HUDPAN.bmap);
	NHAC_CHUD_VISIBLE = true;
	
	// If the spells are loaded, set the "spell-txt", and string
	if(NHAC_CSPELLS_LOADED && NHASC_CSPELL_NAME[NHAC_CURSPELL] != 0)
	{
		NHAC_HUDSPELL_TXT.pos_x = NHAC_HUDPAN.pos_x + 270;
		NHAC_HUDSPELL_TXT.pos_y = NHAC_HUDPAN.pos_y + 51;
		if(NHAC_CSPELL_OWNED[NHAC_CURSPELL])
		{
			str_cpy(NHAC_HUDSPELL_STR,ptr_for_handle(NHASC_CSPELL_NAME[NHAC_CURSPELL]));
		}
		NHAC_HUDSPELL_TXT.visible = true;
	}
}
/////////////////////////////////////////////////////
// Hides the HUD panel
function NHAC_HUDPAN_HIDE()
{
	NHAC_HUDPAN.visible = false;
	NHAC_CHUD_VISIBLE = false;
}
/////////////////////////////////////////////////////
// Toggles the HUD pan
function NHAC_HUDPAN_TOGGLE()
{
	if(NHAC_HUDPAN.visible == true) {NHAC_HUDPAN_HIDE();}
	else {NHAC_HUDPAN_SHOW();}
}
/////////////////////////////////////////////////////
function NHAC_HUDSPELL_TOGGLE(but,pan)
{
	// local vars
	var cycler;
	var tmp;
	var tmpSpell;
	
	// Which way to go?
	if(but == 1)
	{
		cycler = -1;
	}
	else
	{
		cycler = 1;
	}
	
	// Init. vars
	tmp = NHAC_MAX_SPELLS + 1;
	tmpSpell = NHAC_CURSPELL;
	
	// Tmp is only used, to ensure the loop won't be endless
	while(tmp > 0)
	{
		// Cycle through the spells
		tmpSpell += cycler;
		if(tmpSpell < 0) {tmpSpell = NHAC_MAX_SPELLS - 1;}
		tmpSpell %= NHAC_MAX_SPELLS;
		
		// If we found an owned spell
		if(NHAC_CSPELL_OWNED[tmpSpell])
		{
			// Make it the used spell
			NHAC_CURSPELL = tmpSpell;
			
			// Break out of the loop
			break;
		}
		
		tmp -= 1;
	}
	
	// Show the new spell in the spell txt
	if(NHAC_CSPELL_OWNED[NHAC_CURSPELL])
	{
		str_cpy(NHAC_HUDSPELL_STR,ptr_for_handle(NHASC_CSPELL_NAME[NHAC_CURSPELL]));
	}
}
/////////////////////////////////////////////////////