/////////////////////////////////////////////////////
// RPG/Adv. Temp 2.0
// Level-up system and character panel
//
// (C) 2006 by Claus N.
// www.nighthawk.dk
//
// -- UPDATES --
//	Juli 11th 2006:
// Upgraded from A6.31.4 to A6.40.5
// 	- Changed "remove me;" to "ent_remove(me);"
// 
// July 13th 2006:
// -When spending a point on health, now player.health also will 'grow'
// -Fixed bug in level-up
/////////////////////////////////////////////////////
// We are using the level system "Core"
define USE_CORE_LEVELSYS;
/////////////////////////////////////////////////////
// We need the Defines "sub-core"
ifndef USE_SUBCORE_DEFINES;
	include <NHASC_defines.wdl>;
endif;
/////////////////////////////////////////////////////
// Use the particle effects subcore
ifndef USE_SUBCORE_PARTICLEFUNCS;
	include <NHASC_partfuncs.wdl>;
endif;
/////////////////////////////////////////////////////
// Character panel background bmap
bmap NHAC_charpan_bg = <NHAC_charpan_bg.bmp>;
bmap NHAC_statup_but = <NHAC_statup_but.bmp>;
/////////////////////////////////////////////////////
// Used in the lvlup FX function
string NHAC_CMODEL_LVLUP_FX = <kugle.mdl>;

string NHAC_LVLSYS_TMPSTR[8];	// Temp. string
/////////////////////////////////////////////////////
function NHAC_charpan_close();
function NHAC_charbut_click();
/////////////////////////////////////////////////////
// The character/status panel
panel NHAC_charpan
{
	bmap = NHAC_charpan_bg;
	layer = 2;
	flags = refresh;
	button = 140,470,NHAC_closebut_hover,NHAC_closebut_normal,NHAC_closebut_hover,NHAC_charpan_close,null,null;
}
/////////////////////////////////////////////////////
// panel with the buttons to spend character points
panel NHAC_charpan_buts
{
	flags = refresh;
	layer = 4;
	button = 150,23,NHAC_statup_but,NHAC_statup_but,NHAC_statup_but,NHAC_charbut_click,null,null;
	button = 150,43,NHAC_statup_but,NHAC_statup_but,NHAC_statup_but,NHAC_charbut_click,null,null;
	button = 150,64,NHAC_statup_but,NHAC_statup_but,NHAC_statup_but,NHAC_charbut_click,null,null;
	button = 150,84,NHAC_statup_but,NHAC_statup_but,NHAC_statup_but,NHAC_charbut_click,null,null;
}
/////////////////////////////////////////////////////
// The text on the character panel
text NHAC_charpan_txt
{
	font = NHAC_charpan_fnt;
	layer = 3;
	strings = 9;
	string = NHAC_charpan_str_hlt,
				NHAC_charpan_str_man,
				NHAC_charpan_str_dmg,
				NHAC_charpan_str_dfs,
				" ",
				NHAC_charpan_str_lvl,
				NHAC_charpan_str_exp,
				NHAC_charpan_str_nxt,
				NHAC_charpan_str_stp;
	flags = outline;
}
/////////////////////////////////////////////////////
function NHAC_charbut_click(but,pan)
{
	// Player must exist
	if(!player) {return;}
	
	// Player must have some points to spend
	if(NHAC_plStatPoints <= 0) {return;}
	
	// Find out which button has been clicked, and add to players properties
	if(but == 1) {player.max_health += NHAC_statAddPerPoint;player.health += NHAC_statAddPerPoint;}
	if(but == 2) {player.max_mana += NHAC_statAddPerPoint;player.mana += NHAC_statAddPerPoint;}
	if(but == 3) {player.damage += NHAC_statAddPerPoint;}
	if(but == 4) {player.defense += NHAC_statAddPerPoint;}
	
	// Subtract a statpoint
	NHAC_plStatPoints -= 1;
	
	// If we got no more statpoints left
	if(NHAC_plStatPoints <= 0)
	{
		// Hide the buttons
		NHAC_charpan_buts.visible = false;
	}
}
/////////////////////////////////////////////////////
// Closes the character panel
function NHAC_charpan_close()
{
	// Hide the panel
	NHAC_charpan.visible = false;
	NHAC_charpan_txt.visible = false;
	NHAC_charpan_buts.visible = false;
	
	// Tell other modules that we are hidden
	NHAC_CCHR_VISIBLE = false;
}
/////////////////////////////////////////////////////
// Displays the character panel
function NHAC_charpan_show()
{
	// Show the panel
	NHAC_charpan.visible = true;
	NHAC_charpan_txt.visible = true;
	
	// Position the text
	NHAC_charpan_txt.pos_x = NHAC_charpan.pos_x + 10;
	NHAC_charpan_txt.pos_y = NHAC_charpan.pos_y + 20;
	
	// Vars used by other modules
	NHAC_CCHR_POSX = NHAC_charpan.pos_x;
	NHAC_CCHR_POSY = NHAC_charpan.pos_y;
	NHAC_CCHR_BMAPWIDTH = bmap_width(NHAC_charpan.bmap);
	NHAC_CCHR_BMAPHEIGHT = bmap_height(NHAC_charpan.bmap);
	NHAC_CCHR_VISIBLE = true;
}
/////////////////////////////////////////////////////
// Toggle function
function NHAC_charpan_toggle()
{
	if(NHAC_charpan.visible) {NHAC_charpan_close();}
	else {NHAC_charpan_show();}
}
// Toggle the character panel on c
on_c = NHAC_charpan_toggle;
/////////////////////////////////////////////////////
// Uses a Vertex-based particle effect
function NHAC_LVLUP_FX()
{
	// Initialize me
	my.passable = true;
	my.invisible = true;
	my.skill1 = 20;
	
	vec_scale(my.scale_x,22);
	
	// Main loop
	while(my.skill1 > 0)
	{
		// Decrease "lifetime"
		my.skill1 -= 1 * time;
		
		// Player must exist
		if(!player) {break;}
		
		// Set me at player's pos
		vec_set(my.x,player.x);
		
		// Attach particles
		NHAC_VBEFFECT_ATTACH(handle(NHAC_VBEFFECT_BLUE2),my);
		
		// Rotate me
		my.pan += random(100) * time;
		my.tilt += random(100) * time;
		
		wait(1);	// Avoid endless loops
	}
	
	// Remove the ent again
	wait(1);
	ent_remove(me);
}
/////////////////////////////////////////////////////
// Level-up FX
function NHAC_playerLevelUp()
{
	// Player must exist
	if(!player) {return;}
	
	// Show level-up string
	NHA_CORE_SHOWMSG(NHAC_LVLUP_STR,10);
	
	// Create the model
	ent_create(NHAC_CMODEL_LVLUP_FX,player.x,NHAC_LVLUP_FX);
}
/////////////////////////////////////////////////////
// Level system
function NHAC_init_levelsys()
{
	// Only one instance
	proc_kill(4);
	
	// We are using the character panel
	NHAC_CVAR_USE_CCHR = true;
	
	// Main loop
	while(1)
	{
		// If we got enough exp for a new level, and we aren't at the highest level
		if(NHAC_plExp >= int(pow(NHAC_plLevel,2) * 10 * NHAC_plNextLevelMultiplier)
			&& NHAC_plLevel < NHAC_MAX_CHARLEVEL)
		{
			// Increase level an stat points
			NHAC_plLevel += 1;
			NHAC_plStatPoints += NHAC_plStatPointsPerLevel;
			
			// Level-up FX
			NHAC_playerLevelUp();
			
			// If player exists
			if(player && NHAC_RECOVER_ON_LVLUP)
			{
				// Give health and mana
				player.health = player.max_health + NHAC_ITM_GET_HLT();
				player.mana = player.max_mana + NHAC_ITM_GET_MAN();
			}
		}
		
		// If the character text is shown and the player exists
		if(NHAC_charpan.visible == true && player)
		{
			// If player got character points, let him spend 'em ;)
			if(NHAC_plStatPoints > 0)
			{
				NHAC_charpan_buts.visible = true;
			}
			
			// Update health string
			str_cpy(NHAC_charpan_str_hlt,"Health: ");
			str_for_num(NHAC_LVLSYS_TMPSTR,int(player.health));
			str_cat(NHAC_charpan_str_hlt,NHAC_LVLSYS_TMPSTR);
			str_cat(NHAC_charpan_str_hlt,"/");
			str_for_num(NHAC_LVLSYS_TMPSTR,int(player.max_health + NHAC_ITM_GET_HLT()));
			str_cat(NHAC_charpan_str_hlt,NHAC_LVLSYS_TMPSTR);
			
			// Update mana string
			str_cpy(NHAC_charpan_str_man,"Mana: ");
			str_for_num(NHAC_LVLSYS_TMPSTR,int(player.mana));
			str_cat(NHAC_charpan_str_man,NHAC_LVLSYS_TMPSTR);
			str_cat(NHAC_charpan_str_man,"/");
			str_for_num(NHAC_LVLSYS_TMPSTR,int(player.max_mana + NHAC_ITM_GET_MAN()));
			str_cat(NHAC_charpan_str_man,NHAC_LVLSYS_TMPSTR);
			
			// Update damage string
			str_cpy(NHAC_charpan_str_dmg,"Damage: ");
			str_for_num(NHAC_LVLSYS_TMPSTR,int(player.damage + NHAC_ITM_GET_DMG()));
			str_cat(NHAC_charpan_str_dmg,NHAC_LVLSYS_TMPSTR);
			
			// Update defense string
			str_cpy(NHAC_charpan_str_dfs,"Defense: ");
			str_for_num(NHAC_LVLSYS_TMPSTR,int(player.defense + NHAC_ITM_GET_DFS()));
			str_cat(NHAC_charpan_str_dfs,NHAC_LVLSYS_TMPSTR);
			
			// Update level string
			str_cpy(NHAC_charpan_str_lvl,"Level: ");
			str_for_num(NHAC_LVLSYS_TMPSTR,int(NHAC_plLevel));
			str_cat(NHAC_charpan_str_lvl,NHAC_LVLSYS_TMPSTR);
			
			// Update experience string
			str_cpy(NHAC_charpan_str_exp,"Experience: ");
			str_for_num(NHAC_LVLSYS_TMPSTR,int(NHAC_plExp));
			str_cat(NHAC_charpan_str_exp,NHAC_LVLSYS_TMPSTR);
			
			// Update next level string
			str_cpy(NHAC_charpan_str_nxt,"Next Level: ");
			str_for_num(NHAC_LVLSYS_TMPSTR,int(pow(NHAC_plLevel,2) * 10 * NHAC_plNextLevelMultiplier));
			str_cat(NHAC_charpan_str_nxt,NHAC_LVLSYS_TMPSTR);
			
			// Update stat points string
			str_cpy(NHAC_charpan_str_stp,"Status points: ");
			str_for_num(NHAC_LVLSYS_TMPSTR,int(NHAC_plStatPoints));
			str_cat(NHAC_charpan_str_stp,NHAC_LVLSYS_TMPSTR);
		}
		
		// Don't let the character panel block the msg
		NHA_CORE_CHECK_SHOWMSG();
		
		wait(1);	// avoid endless loops
	}
}
/////////////////////////////////////////////////////