/////////////////////////////////////////////////////
// RPG/Adv. Temp 2.0
// Game main menu
//
// (C) 2006 by Claus N.
// www.nighthawk.dk
//
// -- UPDATES --
// July 16th 2006:
// -Added save/load panels to the menu
// 
// July 17th 2006:
// -Removed 'beep' sound from function NHAC_GameLoad. It's played automatically
// -Added sound when a button is touched by the mouse (function NHAC_buttonHOver)
/////////////////////////////////////////////////////
// We are using the main menu "Core"
define USE_CORE_MAINMENU;
/////////////////////////////////////////////////////
// We need the Defines "sub-core"
ifndef USE_SUBCORE_DEFINES;
	include <NHASC_defines.wdl>;
endif;
/////////////////////////////////////////////////////
// Seleted slot in the save/load menu
var NHASC_SELECTED_SLOT;
var NHASC_SAVESLOT_BMAPS[6];
var NHASC_SAVESLOT_BMAPS_INIT = false;
/////////////////////////////////////////////////////
string NHASC_saveSlot_name = "rpgtmp";
string NHASC_savedPicturesFile = "rpgtempsaves";
/////////////////////////////////////////////////////
// Menu background bmaps
bmap NHAC_mainMenu_bg = <NHAC_mainMenu_bg.tga>;
bmap NHAC_optionsMainMenu_bg = <NHAC_optionsMainMenu_bg.tga>;	// Sliders on this one
bmap NHAC_creditsMainMenu_bg = <NHAC_creditsMainMenu_bg.tga>;
bmap NHAC_saveLoadMenu_bg = <NHAC_creditsMainMenu_bg.tga>;

// Selected save/load bmap 'border'
bmap NHAC_saveLoad_selected_map = <NHAC_saveLoad_selected_map.tga>;

// Save/Load slots
bmap NHAC_saveLoadSlot_1 = <NHAC_saveLoad_slot.pcx>;
bmap NHAC_saveLoadSlot_2 = <NHAC_saveLoad_slot.pcx>;
bmap NHAC_saveLoadSlot_3 = <NHAC_saveLoad_slot.pcx>;
bmap NHAC_saveLoadSlot_4 = <NHAC_saveLoad_slot.pcx>;
bmap NHAC_saveLoadSlot_5 = <NHAC_saveLoad_slot.pcx>;
bmap NHAC_saveLoadSlot_6 = <NHAC_saveLoad_slot.pcx>;

// Slider bmap, used in the options menu
bmap NHAC_slider = <NHAC_slider.tga>;

// Buttons
bmap NHAC_butnormal_continue = <NHAC_butnormal_continue.tga>;
bmap NHAC_butnormal_newgame = <NHAC_butnormal_newgame.tga>;
bmap NHAC_butnormal_options = <NHAC_butnormal_options.tga>;
bmap NHAC_butnormal_credits = <NHAC_butnormal_credits.tga>;
bmap NHAC_butnormal_exit = <NHAC_butnormal_exit.tga>;
bmap NHAC_butnormal_yes = <NHAC_butnormal_yes.tga>;
bmap NHAC_butnormal_no = <NHAC_butnormal_no.tga>;
bmap NHAC_butnormal_ok = <NHAC_butnormal_ok.tga>;
bmap NHAC_butnormal_cancel = <NHAC_butnormal_cancel.tga>;
bmap NHAC_butnormal_savegame = <NHAC_butnormal_savegame.tga>;
bmap NHAC_butnormal_loadgame = <NHAC_butnormal_loadgame.tga>;
bmap NHAC_buthover_continue = <NHAC_buthover_continue.tga>;
bmap NHAC_buthover_newgame = <NHAC_buthover_newgame.tga>;
bmap NHAC_buthover_options = <NHAC_buthover_options.tga>;
bmap NHAC_buthover_credits = <NHAC_buthover_credits.tga>;
bmap NHAC_buthover_exit = <NHAC_buthover_exit.tga>;
bmap NHAC_buthover_yes = <NHAC_buthover_yes.tga>;
bmap NHAC_buthover_no = <NHAC_buthover_no.tga>;
bmap NHAC_buthover_ok = <NHAC_buthover_ok.tga>;
bmap NHAC_buthover_cancel = <NHAC_buthover_cancel.tga>;
bmap NHAC_buthover_savegame = <NHAC_buthover_savegame.tga>;
bmap NHAC_buthover_loadgame = <NHAC_buthover_loadgame.tga>;
/////////////////////////////////////////////////////
// Prototypes
function game_exit();
function NHAC_mainMenu_hide();
function quit();
function NHAC_Menu_options();
function NHAC_apply_options();
function NHAC_NewGame();
function NHAC_credits_show();
function NHAC_save_show();
function NHAC_load_show();
function NHASC_SELECT_SLOT(but,pan);
function NHAC_GameSave(slot,pan);
function NHAC_GameLoad(slot,pan);
function NHAC_buttonHOver();
/////////////////////////////////////////////////////
// The main menu panel
panel NHAC_mainmenu_pan
{
	bmap = NHAC_mainMenu_bg;
	flags = refresh;
	layer = 20;
	button = 25,28,NHAC_buthover_continue,NHAC_butnormal_continue,NHAC_buthover_continue,NHAC_mainMenu_hide,null,NHAC_buttonHOver;
	button = 25,63,NHAC_buthover_savegame,NHAC_butnormal_savegame,NHAC_buthover_savegame,NHAC_save_show,null,NHAC_buttonHOver;
	button = 25,98,NHAC_buthover_loadgame,NHAC_butnormal_loadgame,NHAC_buthover_loadgame,NHAC_load_show,null,NHAC_buttonHOver;
	button = 25,133,NHAC_buthover_newgame,NHAC_butnormal_newgame,NHAC_buthover_newgame,NHAC_ngame_dialog,null,NHAC_buttonHOver;
	button = 25,168,NHAC_buthover_options,NHAC_butnormal_options,NHAC_buthover_options,NHAC_Menu_options,null,NHAC_buttonHOver;
	button = 25,203,NHAC_buthover_credits,NHAC_butnormal_credits,NHAC_buthover_credits,NHAC_credits_show,null,NHAC_buttonHOver;
	button = 25,238,NHAC_buthover_exit,NHAC_butnormal_exit,NHAC_buthover_exit,game_exit,null,NHAC_buttonHOver;
}
/////////////////////////////////////////////////////
// "Exit game?" message with Yes/No buttons
panel NHAC_mainmenu_exit_pan
{
	bmap = NHAC_mainMenu_bg;
	flags = refresh;
	layer = 21;
	button = 25,95,NHAC_buthover_yes,NHAC_butnormal_yes,NHAC_buthover_yes,quit,null,NHAC_buttonHOver;
	button = 25,130,NHAC_buthover_no,NHAC_butnormal_no,NHAC_buthover_no,NHAC_mainMenu_show,null,NHAC_buttonHOver;
}
// The text that belongs to the panel
text NHAC_mainmenu_exit_txt
{
	font = NHAC_mainMenu_fnt;
	string = "Exit game?";
	layer = 22;
	flags = outline,center_x;
}
/////////////////////////////////////////////////////
// "New game?" message with Yes/No buttons
panel NHAC_mainmenu_ngame_pan
{
	bmap = NHAC_mainMenu_bg;
	flags = refresh;
	layer = 21;
	button = 25,95,NHAC_buthover_yes,NHAC_butnormal_yes,NHAC_buthover_yes,NHAC_NewGame,null,NHAC_buttonHOver;
	button = 25,130,NHAC_buthover_no,NHAC_butnormal_no,NHAC_buthover_no,NHAC_mainMenu_show,null,NHAC_buttonHOver;
}
// The text that belongs to the panel
text NHAC_mainmenu_ngame_txt
{
	font = NHAC_mainMenu_fnt;
	string = "New game?";
	layer = 22;
	flags = outline,center_x;
}
/////////////////////////////////////////////////////
// Options panel
panel NHAC_mainmenu_options_pan
{
	bmap = NHAC_optionsMainMenu_bg;
	flags = refresh;
	layer = 21;
	hslider = 20,50,157,NHAC_slider,0,100,NHAC_SLI_BRI;
	hslider = 20,89,157,NHAC_slider,6,9.1,NHAC_SLI_RES;
	button = 25,130,NHAC_buthover_ok,NHAC_butnormal_ok,NHAC_buthover_ok,NHAC_apply_options,null,NHAC_buttonHOver;
	button = 25,165,NHAC_buthover_cancel,NHAC_butnormal_cancel,NHAC_buthover_cancel,NHAC_mainMenu_show,null,NHAC_buttonHOver;
}
// The text that belongs to the panel
text NHAC_mainmenu_options_txt
{
	font = NHAC_mainMenu_fnt;
	strings = 3;
	string = "Brightness:"," ","Resolution:";
	layer = 22;
	flags = outline,center_x;
}
/////////////////////////////////////////////////////
// Credits panel
panel NHAC_mainmenu_credits_pan
{
	bmap = NHAC_creditsMainMenu_bg;
	flags = refresh;
	layer = 21;
	button = 230,250,NHAC_buthover_ok,NHAC_butnormal_ok,NHAC_buthover_ok,NHAC_mainMenu_show,null,NHAC_buttonHOver;
}
// The text that belongs to the panel
text NHAC_mainmenu_credits_txt
{
	font = NHAC_mainMenu_fnt;
	string = NHAC_CREDITS_STR;
	layer = 22;
	flags = outline;
}
/////////////////////////////////////////////////////
// Save panel
panel NHAC_mainmenu_save_pan
{
	bmap = NHAC_saveLoadMenu_bg;
	flags = refresh;
	layer = 21;
	button = 230,250,NHAC_buthover_cancel,NHAC_butnormal_cancel,NHAC_buthover_cancel,NHAC_mainMenu_show,null,NHAC_buttonHOver;
	button = 70,250,NHAC_buthover_savegame,NHAC_butnormal_savegame,NHAC_buthover_savegame,NHAC_GameSave,null,NHAC_buttonHOver;
	// Pictures
	button = 30,45,NHAC_saveLoadSlot_1,NHAC_saveLoadSlot_1,NHAC_saveLoadSlot_1,NHASC_SELECT_SLOT,null,null;
	button = 150,45,NHAC_saveLoadSlot_2,NHAC_saveLoadSlot_2,NHAC_saveLoadSlot_2,NHASC_SELECT_SLOT,null,null;
	button = 270,45,NHAC_saveLoadSlot_3,NHAC_saveLoadSlot_3,NHAC_saveLoadSlot_3,NHASC_SELECT_SLOT,null,null;
	button = 30,140,NHAC_saveLoadSlot_4,NHAC_saveLoadSlot_4,NHAC_saveLoadSlot_4,NHASC_SELECT_SLOT,null,null;
	button = 150,140,NHAC_saveLoadSlot_5,NHAC_saveLoadSlot_5,NHAC_saveLoadSlot_5,NHASC_SELECT_SLOT,null,null;
	button = 270,140,NHAC_saveLoadSlot_6,NHAC_saveLoadSlot_6,NHAC_saveLoadSlot_6,NHASC_SELECT_SLOT,null,null;
}
/////////////////////////////////////////////////////
// Load panel
panel NHAC_mainmenu_load_pan
{
	bmap = NHAC_saveLoadMenu_bg;
	flags = refresh;
	layer = 21;
	button = 230,250,NHAC_buthover_cancel,NHAC_butnormal_cancel,NHAC_buthover_cancel,NHAC_mainMenu_show,null,NHAC_buttonHOver;
	button = 70,250,NHAC_buthover_loadgame,NHAC_butnormal_loadgame,NHAC_buthover_loadgame,NHAC_GameLoad,null,NHAC_buttonHOver;
	// Pictures
	button = 30,45,NHAC_saveLoadSlot_1,NHAC_saveLoadSlot_1,NHAC_saveLoadSlot_1,NHASC_SELECT_SLOT,null,null;
	button = 150,45,NHAC_saveLoadSlot_2,NHAC_saveLoadSlot_2,NHAC_saveLoadSlot_2,NHASC_SELECT_SLOT,null,null;
	button = 270,45,NHAC_saveLoadSlot_3,NHAC_saveLoadSlot_3,NHAC_saveLoadSlot_3,NHASC_SELECT_SLOT,null,null;
	button = 30,140,NHAC_saveLoadSlot_4,NHAC_saveLoadSlot_4,NHAC_saveLoadSlot_4,NHASC_SELECT_SLOT,null,null;
	button = 150,140,NHAC_saveLoadSlot_5,NHAC_saveLoadSlot_5,NHAC_saveLoadSlot_5,NHASC_SELECT_SLOT,null,null;
	button = 270,140,NHAC_saveLoadSlot_6,NHAC_saveLoadSlot_6,NHAC_saveLoadSlot_6,NHASC_SELECT_SLOT,null,null;
}
/////////////////////////////////////////////////////
// Load panel
panel NHAC_saveLoad_selected_pan
{
	bmap = NHAC_saveLoad_selected_map;
	flags = refresh;
	layer = 22;
}
/////////////////////////////////////////////////////
// Displays the menu
function NHAC_mainMenu_show()
{
	// Freeze the game
	freeze_mode = 1;
	
	// Position the menu
	NHAC_mainmenu_pan.pos_x = max(1,screen_size.x - bmap_width(NHAC_mainmenu_pan.bmap)) / 2;
	NHAC_mainmenu_pan.pos_y = max(1,screen_size.y - bmap_height(NHAC_mainmenu_pan.bmap)) / 2;
	
	// Show the menu
	NHAC_mainmenu_pan.visible = true;
	
	// Close other menu panels
	NHAC_mainmenu_save_pan.visible = false;
	NHAC_mainmenu_load_pan.visible = false;
	NHAC_mainmenu_exit_pan.visible = false;
	NHAC_mainmenu_exit_txt.visible = false;
	NHAC_mainmenu_credits_pan.visible = false;
	NHAC_mainmenu_credits_txt.visible = false;
	NHAC_mainmenu_ngame_pan.visible = false;
	NHAC_mainmenu_ngame_txt.visible = false;
	NHAC_mainmenu_options_pan.visible = false;
	NHAC_mainmenu_options_txt.visible = false;
}
/////////////////////////////////////////////////////
// Hides the menu and "un-pauses" the game
function NHAC_mainMenu_hide()
{
	// Un-freeze the game
	freeze_mode = 0;
	
	// Hide the menu
	NHAC_mainmenu_pan.visible = false;
	
	// Close other menu panels
	NHAC_mainmenu_save_pan.visible = false;
	NHAC_mainmenu_load_pan.visible = false;
	NHAC_mainmenu_exit_pan.visible = false;
	NHAC_mainmenu_exit_txt.visible = false;
	NHAC_mainmenu_credits_pan.visible = false;
	NHAC_mainmenu_credits_txt.visible = false;
	NHAC_mainmenu_ngame_pan.visible = false;
	NHAC_mainmenu_ngame_txt.visible = false;
	NHAC_mainmenu_options_pan.visible = false;
	NHAC_mainmenu_options_txt.visible = false;
}
/////////////////////////////////////////////////////
// Toggle the menu
function NHAC_mainMenu_toggle()
{
	if(NHAC_mainmenu_pan.visible) {NHAC_mainMenu_hide();}
	else {NHAC_mainMenu_show();}
}
// Toggle the menu on escape
on_esc = NHAC_mainMenu_toggle;
/////////////////////////////////////////////////////
// Shows the "Exit game?" dialog
function game_exit()
{
	// Freeze the game
	freeze_mode = 1;
	
	// Position the panel
	NHAC_mainmenu_exit_pan.pos_x = max(1,screen_size.x - bmap_width(NHAC_mainmenu_exit_pan.bmap)) / 2;
	NHAC_mainmenu_exit_pan.pos_y = max(1,screen_size.y - bmap_height(NHAC_mainmenu_exit_pan.bmap)) / 2;
	
	// And the text
	NHAC_mainmenu_exit_txt.pos_x = NHAC_mainmenu_exit_pan.pos_x + bmap_width(NHAC_mainmenu_exit_pan.bmap) / 2;
	NHAC_mainmenu_exit_txt.pos_y = NHAC_mainmenu_exit_pan.pos_y + 50;
	
	// Display it
	NHAC_mainmenu_exit_pan.visible = true;
	NHAC_mainmenu_exit_txt.visible = true;
	
	// Close other menu panels
	NHAC_mainmenu_save_pan.visible = false;
	NHAC_mainmenu_load_pan.visible = false;
	NHAC_mainmenu_credits_pan.visible = false;
	NHAC_mainmenu_credits_txt.visible = false;
	NHAC_mainmenu_options_pan.visible = false;
	NHAC_mainmenu_options_txt.visible = false;
	NHAC_mainmenu_ngame_pan.visible = false;
	NHAC_mainmenu_ngame_txt.visible = false;
	NHAC_mainmenu_pan.visible = false;
}
// Also exit on F10
on_f10 = game_exit;
/////////////////////////////////////////////////////
// Shows the "New game?" dialog
function NHAC_ngame_dialog()
{
	// Freeze the game
	freeze_mode = 1;
	
	// Position the panel
	NHAC_mainmenu_ngame_pan.pos_x = max(1,screen_size.x - bmap_width(NHAC_mainmenu_ngame_pan.bmap)) / 2;
	NHAC_mainmenu_ngame_pan.pos_y = max(1,screen_size.y - bmap_height(NHAC_mainmenu_ngame_pan.bmap)) / 2;
	
	// And the text
	NHAC_mainmenu_ngame_txt.pos_x = NHAC_mainmenu_ngame_pan.pos_x + bmap_width(NHAC_mainmenu_ngame_pan.bmap) / 2;
	NHAC_mainmenu_ngame_txt.pos_y = NHAC_mainmenu_ngame_pan.pos_y + 50;
	
	// Display it
	NHAC_mainmenu_ngame_pan.visible = true;
	NHAC_mainmenu_ngame_txt.visible = true;
	
	// Close other menu panels
	NHAC_mainmenu_save_pan.visible = false;
	NHAC_mainmenu_load_pan.visible = false;
	NHAC_mainmenu_exit_pan.visible = false;
	NHAC_mainmenu_exit_txt.visible = false;
	NHAC_mainmenu_credits_pan.visible = false;
	NHAC_mainmenu_credits_txt.visible = false;
	NHAC_mainmenu_options_pan.visible = false;
	NHAC_mainmenu_options_txt.visible = false;
	NHAC_mainmenu_pan.visible = false;
}
/////////////////////////////////////////////////////
// Exits the game
function quit()
{
	exit;
}
/////////////////////////////////////////////////////
// Displays the options panel
function NHAC_Menu_options()
{
	// Freeze the game
	freeze_mode = 1;
	
	// Set the sliders to the right values
	NHAC_SLI_RES = video_mode;
	
	// Position the panel
	NHAC_mainmenu_options_pan.pos_x = max(1,screen_size.x - bmap_width(NHAC_mainmenu_options_pan.bmap)) / 2;
	NHAC_mainmenu_options_pan.pos_y = max(1,screen_size.y - bmap_height(NHAC_mainmenu_options_pan.bmap)) / 2;
	
	// And the text
	NHAC_mainmenu_options_txt.pos_x = NHAC_mainmenu_options_pan.pos_x + bmap_width(NHAC_mainmenu_options_pan.bmap) / 2;
	NHAC_mainmenu_options_txt.pos_y = NHAC_mainmenu_options_pan.pos_y + 30;
	
	// Display it
	NHAC_mainmenu_options_pan.visible = true;
	NHAC_mainmenu_options_txt.visible = true;
	
	// Close other menu panels
	NHAC_mainmenu_save_pan.visible = false;
	NHAC_mainmenu_load_pan.visible = false;
	NHAC_mainmenu_exit_pan.visible = false;
	NHAC_mainmenu_exit_txt.visible = false;
	NHAC_mainmenu_credits_pan.visible = false;
	NHAC_mainmenu_credits_txt.visible = false;
	NHAC_mainmenu_ngame_pan.visible = false;
	NHAC_mainmenu_ngame_txt.visible = false;
	NHAC_mainmenu_pan.visible = false;
}
/////////////////////////////////////////////////////
// Displays the credits panel
function NHAC_credits_show()
{
	// Freeze the game
	freeze_mode = 1;
	
	// Position the panel
	NHAC_mainmenu_credits_pan.pos_x = max(1,screen_size.x - bmap_width(NHAC_mainmenu_credits_pan.bmap)) / 2;
	NHAC_mainmenu_credits_pan.pos_y = max(1,screen_size.y - bmap_height(NHAC_mainmenu_credits_pan.bmap)) / 2;
	
	// And the text
	NHAC_mainmenu_credits_txt.pos_x = NHAC_mainmenu_credits_pan.pos_x + 20;
	NHAC_mainmenu_credits_txt.pos_y = NHAC_mainmenu_credits_pan.pos_y + 20;
	
	// Display it
	NHAC_mainmenu_credits_pan.visible = true;
	NHAC_mainmenu_credits_txt.visible = true;
	
	// Close other menu panels
	NHAC_mainmenu_save_pan.visible = false;
	NHAC_mainmenu_load_pan.visible = false;
	NHAC_mainmenu_exit_pan.visible = false;
	NHAC_mainmenu_exit_txt.visible = false;
	NHAC_mainmenu_options_pan.visible = false;
	NHAC_mainmenu_options_txt.visible = false;
	NHAC_mainmenu_ngame_pan.visible = false;
	NHAC_mainmenu_ngame_txt.visible = false;
	NHAC_mainmenu_pan.visible = false;
}
/////////////////////////////////////////////////////
// Displays the save panel
function NHAC_save_show()
{
	// No slot is selected by default
	NHASC_SELECTED_SLOT = 0;
	
	// Freeze the game
	freeze_mode = 1;
	
	// Position the panel
	NHAC_mainmenu_save_pan.pos_x = max(1,screen_size.x - bmap_width(NHAC_mainmenu_save_pan.bmap)) / 2;
	NHAC_mainmenu_save_pan.pos_y = max(1,screen_size.y - bmap_height(NHAC_mainmenu_save_pan.bmap)) / 2;
	
	// Display it
	NHAC_mainmenu_save_pan.visible = true;
	
	// Close other menu panels
	NHAC_mainmenu_load_pan.visible = false;
	NHAC_mainmenu_exit_pan.visible = false;
	NHAC_mainmenu_exit_txt.visible = false;
	NHAC_mainmenu_options_pan.visible = false;
	NHAC_mainmenu_options_txt.visible = false;
	NHAC_mainmenu_credits_pan.visible = false;
	NHAC_mainmenu_credits_txt.visible = false;
	NHAC_mainmenu_ngame_pan.visible = false;
	NHAC_mainmenu_ngame_txt.visible = false;
	NHAC_mainmenu_pan.visible = false;
}
/////////////////////////////////////////////////////
// Displays the load panel
function NHAC_load_show()
{
	// No slot is selected by default
	NHASC_SELECTED_SLOT = 0;
	
	// Freeze the game
	freeze_mode = 1;
	
	// Position the panel
	NHAC_mainmenu_load_pan.pos_x = max(1,screen_size.x - bmap_width(NHAC_mainmenu_load_pan.bmap)) / 2;
	NHAC_mainmenu_load_pan.pos_y = max(1,screen_size.y - bmap_height(NHAC_mainmenu_load_pan.bmap)) / 2;
	
	// Display it
	NHAC_mainmenu_load_pan.visible = true;
	
	// Close other menu panels
	NHAC_mainmenu_save_pan.visible = false;
	NHAC_mainmenu_exit_pan.visible = false;
	NHAC_mainmenu_exit_txt.visible = false;
	NHAC_mainmenu_options_pan.visible = false;
	NHAC_mainmenu_options_txt.visible = false;
	NHAC_mainmenu_credits_pan.visible = false;
	NHAC_mainmenu_credits_txt.visible = false;
	NHAC_mainmenu_ngame_pan.visible = false;
	NHAC_mainmenu_ngame_txt.visible = false;
	NHAC_mainmenu_pan.visible = false;
}
/////////////////////////////////////////////////////
// User clicked the "OK" button in the options panel
function NHAC_apply_options()
{
	// Show the main menu again
	NHAC_mainMenu_show();
	
	// No decimals
	NHAC_SLI_RES = int(NHAC_SLI_RES);
	
	// If it's not the current resolution
	if(NHAC_SLI_RES != video_mode)
	{
		// Change resolution
		video_switch(NHAC_SLI_RES,0,0);
		
		// Readjust panels
		NHA_CORE_READJUST_PANELS();
	}
}
/////////////////////////////////////////////////////
// Select a save/load slot
function NHASC_SELECT_SLOT(but,pan)
{
	// There are 2 other buttons defined first
	but -= 2;
	
	// Select slot
	NHASC_SELECTED_SLOT = but;
}
/////////////////////////////////////////////////////
// Puts the save/load slot bmap handles into an array
// Also loads the bmaps already at the slots
function NHAC_init_slots()
{
	// Set bmap handles
	NHASC_SAVESLOT_BMAPS[0] = handle(NHAC_saveLoadSlot_1);
	NHASC_SAVESLOT_BMAPS[1] = handle(NHAC_saveLoadSlot_2);
	NHASC_SAVESLOT_BMAPS[2] = handle(NHAC_saveLoadSlot_3);
	NHASC_SAVESLOT_BMAPS[3] = handle(NHAC_saveLoadSlot_4);
	NHASC_SAVESLOT_BMAPS[4] = handle(NHAC_saveLoadSlot_5);
	NHASC_SAVESLOT_BMAPS[5] = handle(NHAC_saveLoadSlot_6);
	
	// Bmaps initialized
	NHASC_SAVESLOT_BMAPS_INIT = true;
	
	// Load bmaps
	game_load(NHASC_savedPicturesFile,0);
}
/////////////////////////////////////////////////////
// Saves the game
function NHAC_GameSave(slot,pan)
{
	// Get the saving slot
	slot = NHASC_SELECTED_SLOT - 1;
	
	// Load the handles, if not done yet
	if(!NHASC_SAVESLOT_BMAPS_INIT) {NHAC_init_slots();}
	
	// Hide visible panels
	NHAC_mainmenu_save_pan.visible = false;
	NHAC_saveLoad_selected_pan.visible = false;
	
	// Take the screenshot
	bmap_for_screen(ptr_for_handle(NHASC_SAVESLOT_BMAPS[slot]),1,0);
	wait(3);
	
	// Save the screen shot, return if it fails
	if(!game_save(NHASC_savedPicturesFile,0,SV_INFO + SV_BMAPS)) {return;}
	wait(1);
	
	// And now save the game
	if(game_save(NHASC_saveSlot_name,slot,SV_ALL - SV_INFO))
	{
		// Play a "beep" sound, if successfull
		snd_play(beep_snd,100,10);
	}
	
	// Show main game menu
	NHAC_mainMenu_show();
}
/////////////////////////////////////////////////////
// Load a game
function NHAC_GameLoad(slot,pan)
{
	// Get the loading slot
	slot = NHASC_SELECTED_SLOT - 1;
	
	// Load the handles, if not done yet
	if(!NHASC_SAVESLOT_BMAPS_INIT) {NHAC_init_slots();}
	
	// Load the game
	if(game_load(NHASC_saveSlot_name,slot))
	{
		// Play a "beep" sound, if successfull
		//snd_play(beep_snd,100,10);
	}
	
	// Redraw the inventory, as the inventory cell bmaps aren't saved
	wait(1);
	NHA_CORE_INVENTORY_REDRAW();
	
	// Hide the main menu
	NHAC_mainMenu_hide();
}
/////////////////////////////////////////////////////
// Restarts the game/level
function NHAC_NewGame()
{
	// Freeze the game
	freeze_mode = 1;
	
	// Load the level
	level_load(level_str);
	
	// Wait for the level to be loaded
	wait(3);
	
	// Un-freeze the game
	freeze_mode = 0;
	
	// Set the background color to black
	bg_color.red = 1;
	bg_color.green = 1;
	bg_color.blue = 1;
	
	// Initialize game (variables etc.)
	init_game();
	
	// If the isometric camera module is included
	ifdef USE_CORE_ISOCAMERA;
		// Use the isometric camera
		NHAC_ISOC();
	endif;
	
	// Hide the menu
	NHAC_mainMenu_hide();
}
/////////////////////////////////////////////////////
// Called when mouse touches a button
function NHAC_buttonHOver()
{
	// Stop playing any sound in that handle
	if(snd_playing(snd_handle)) {snd_stop(snd_handle);}
	
	// Play the 'hit' sound
	snd_play(hit_snd,40,10);
}
/////////////////////////////////////////////////////
// Main menu initialization
function NHAC_init_mainMenu()
{
	// Load bmap handles into the bmap array
	NHAC_init_slots();
	
	// Main loop
	while(1)
	{
		// Round the var (no decimals)
		if(frc(NHAC_SLI_RES) >= 0.5)
		{
			NHAC_SLI_RES = int(NHAC_SLI_RES + 1);
		}
		else
		{
			NHAC_SLI_RES = int(NHAC_SLI_RES);
		}
		
		// Set brightness
		camera.ambient = NHAC_SLI_BRI;
		
		// If the save/load panel is visible, and a slot is selected
		if((NHAC_mainmenu_save_pan.visible || NHAC_mainmenu_load_pan.visible) && NHASC_SELECTED_SLOT)
		{
			// Position the seleted-slot-border-panel
			NHAC_saveLoad_selected_pan.pos_x = ((NHASC_SELECTED_SLOT - 1) % 3) * 120 + 27;
			NHAC_saveLoad_selected_pan.pos_y = (1 - (NHASC_SELECTED_SLOT <= 3)) * 95 + 42;
			
			// Add the position of the save/load panel
			if(NHAC_mainmenu_save_pan.visible)
			{
				NHAC_saveLoad_selected_pan.pos_x += NHAC_mainmenu_save_pan.pos_x;
				NHAC_saveLoad_selected_pan.pos_y += NHAC_mainmenu_save_pan.pos_y;
			}
			else
			{
				if(NHAC_mainmenu_load_pan.visible)
				{
					NHAC_saveLoad_selected_pan.pos_x += NHAC_mainmenu_load_pan.pos_x;
					NHAC_saveLoad_selected_pan.pos_y += NHAC_mainmenu_load_pan.pos_y;
				}
			}
			
			// ...and display it
			NHAC_saveLoad_selected_pan.visible = true;
		}
		else
		{
			// Otherwise, hide it
			NHAC_saveLoad_selected_pan.visible = false;
		}
		
		// Avoid endless loops
		wait(1);
	}
}
/////////////////////////////////////////////////////