/////////////////////////////////////////////////////
// RPG/Adv. Temp 2.0
// Misc. messaging Module
//
// (C) 2006 by Claus N.
// www.nighthawk.dk
/////////////////////////////////////////////////////
// We are using the Misc. msg. "Core"
define USE_CORE_MISCMSG;
/////////////////////////////////////////////////////
// We need the Defines "sub-core"
ifndef USE_SUBCORE_DEFINES;
	include <NHASC_defines.wdl>;
endif;
/////////////////////////////////////////////////////
// The text object used for msg_show
text NHAC_MSGSHOW_TXT
{
	pos_x = 5;
	pos_y = 5;
	flags = visible;
	string = NHASC_MSGSHOW_STR;
}
/////////////////////////////////////////////////////
// Like the msg_show function in the A5 templates
function msg_show(msg,msg_time)
{
	// Kill all other running instances of this function
	proc_kill(4);
	
	// Set the string/show the message
	str_cpy(NHASC_MSGSHOW_STR,msg);
	
	// Wait msg_time in seconds, before hiding the message
	sleep(msg_time);
	
	// Hide the message
	str_cpy(NHASC_MSGSHOW_STR,"");
}
/////////////////////////////////////////////////////
// A function used in development, for quick testing variables
function test_var(num)
{
	ifdef DEVELOP;
		str_for_num(NHASC_MSGSHOW_STR,num);
	endif;
	
	// If not in development mode, we won't have an "empty function"
	wait(1);
}
/////////////////////////////////////////////////////
// A function used in development, for quick testing strings
function test_str(str)
{
	ifdef DEVELOP;
		str_cpy(NHASC_MSGSHOW_STR,str);
	endif;
	
	// If not in development mode, we won't have an "empty function"
	wait(1);
}
/////////////////////////////////////////////////////