/////////////////////////////////////////////////////
// RPG/Adv. Temp 2.0
// Mouse Module
//
// (C) 2006 by Claus N.
// www.nighthawk.dk
/////////////////////////////////////////////////////
// We are using the Mouse "Core"
define USE_CORE_MOUSEFUNC;
/////////////////////////////////////////////////////
// We need the Defines "sub-core"
ifndef USE_SUBCORE_DEFINES;
	include <NHASC_defines.wdl>;
endif;
/////////////////////////////////////////////////////
// "Temporary" strings, used in execute statements
string NHAC_CMOUSE_TMPSTR01[256];
string NHAC_CMOUSE_TMPSTR02[256];
/////////////////////////////////////////////////////
function setMouseOn(setMouseMap)
{
	// Set a high mouse range
	mouse_range = 5000;
	
	// If we should set the mouse_map
	if(setMouseMap)
	{
		// Set the mouse map to the default mouse cursor
		mouse_map = def_mouse_map;
	}
	
	// Show the mouse
	mouse_mode = 2;
	
	// While the mouse is shown
	while(mouse_mode == 2)
	{
		// Set the right mouse coordinates
		mouse_pos.x = pointer.x;
		mouse_pos.y = pointer.y;
		
		// Use this variable as a read-only; DO NOT MODIFY!!!
		if(NHAC_CVAR_USE_CINVENTORY)
		{
			// If no item is attached to the mouse
			if(!NHAC_MOUSEITEM)
			{
				// Set mouse_map to the default mouse bmap
				mouse_map = def_mouse_map;
				
				// Reset the mouse_spot variable
				mouse_spot.x = 0;
				mouse_spot.y = 0;
			}
			else
			{
				// Create a command to set the right mouse bmap
				str_cpy(NHAC_CMOUSE_TMPSTR01,"mouse_map = NHAC_CITEM_ITMBMAP_");
				str_for_num(NHAC_CMOUSE_TMPSTR02,NHAC_CITEM_BMAP[NHAC_MOUSEITEM - 1]);
				if(NHAC_CITEM_BMAP[NHAC_MOUSEITEM - 1] < 100) {str_cat(NHAC_CMOUSE_TMPSTR01,"0");}
				if(NHAC_CITEM_BMAP[NHAC_MOUSEITEM - 1] < 10) {str_cat(NHAC_CMOUSE_TMPSTR01,"0");}
				str_cat(NHAC_CMOUSE_TMPSTR01,NHAC_CMOUSE_TMPSTR02);
				str_cat(NHAC_CMOUSE_TMPSTR01,";");
				
				// Execute the command
				execute(NHAC_CMOUSE_TMPSTR01);
				
				// Set the mouse_spot variable
				mouse_spot.x = 10;
				mouse_spot.y = 10;
			}
		}
		
		// Avoid endless loops
		wait(1);
	}
}
/////////////////////////////////////////////////////