/////////////////////////////////////////////////////
// RPG/Adv. Temp 2.0
// Particle functions
//
// (C) 2006 by Claus N.
// www.nighthawk.dk
/////////////////////////////////////////////////////
// If we are using this file, don't include it twice
define USE_SUBCORE_PARTICLEFUNCS;
/////////////////////////////////////////////////////
// We need the Defines "sub-core"
ifndef USE_SUBCORE_DEFINES;
	include <NHASC_defines.wdl>;
endif;
/////////////////////////////////////////////////////
// Bmap defines
bmap NHAC_CPARTICLE_WHITE1 = <flare_default.tga>;
bmap NHAC_CPARTICLE_RED1 = <flare_red.tga>;
bmap NHAC_CPARTICLE_YELLOW1 = <flare_yellow.tga>;
bmap NHAC_CPARTICLE_BLUE1 = <flare_blue.tga>;
/////////////////////////////////////////////////////
// function pointer
function* NHASC_CPARTFUNC_PTR;
/////////////////////////////////////////////////////
// Function to attach a particle effect to every
// vertex on the model
function NHAC_VBEFFECT_ATTACH(func,ent)
{
	// Create a local variable, and use it to store
	// the number of vertices in the model
	var vex;
	vex = ent_vertices(ent);
	
	// While there are still vertices left
	while(vex > 0)
	{
		// Get the position of the vertex
		vec_for_vertex(temp,ent,vex);
		
		// Get the function from a handle
		NHASC_CPARTFUNC_PTR = ptr_for_handle(func);
		
		// Create a particle at the vertex position
		effect(NHASC_CPARTFUNC_PTR,1,temp,nullvector);
		
		// Move on to next vertex
		vex -= 1;
		
		// 'wait' would be very bad here, but could be necessary
		if(vex >= max_loops) {wait(1);}
	}
}
/////////////////////////////////////////////////////
// Vertex-Based Effects fadeout function
function NHAC_VBEFFECT_FADEOUT()
{
	// Decrease opacity
	my.alpha -= 10 * time;
	
	// If I'm fully invisible, remove me
	if(my.alpha <= 0) {my.lifespan = 0;}
}
/////////////////////////////////////////////////////
// Vertex-Based Effects fadeout function
// Slower version
function NHAC_VBEFFECT_FADEOUT_SLOW()
{
	// Decrease opacity
	my.alpha -= 0.2 * time;
	
	// If I'm fully invisible, remove me
	if(my.alpha <= 0) {my.lifespan = 0;}
}
/////////////////////////////////////////////////////
// Vertex-Based Effect, using the white particle bmap
function NHAC_VBEFFECT_WHITE1()
{
	my.bmap = NHAC_CPARTICLE_WHITE1;
	my.vel_x = random(2) - random(2);
	my.vel_y = random(2) - random(2);
	my.vel_z = random(2) - random(2);
	my.move = true;
	my.bright = true;
	my.flare = true;
	my.beam = true;
	my.streak = true;
	my.alpha = 10;
	my.size = 1;
	my.lifespan = 80;
	my.function = NHAC_VBEFFECT_FADEOUT;
}
/////////////////////////////////////////////////////
// Vertex-Based Effect, using the white particle bmap
function NHAC_VBEFFECT_WHITE2()
{
	my.bmap = NHAC_CPARTICLE_WHITE1;
	my.bright = true;
	my.flare = true;
	my.beam = true;
	my.streak = true;
	my.alpha = 3;
	my.size = 6;
	my.lifespan = 80;
	my.function = NHAC_VBEFFECT_FADEOUT_SLOW;
}
/////////////////////////////////////////////////////
// Vertex-Based Effect, using the red particle bmap
function NHAC_VBEFFECT_RED1()
{
	my.bmap = NHAC_CPARTICLE_RED1;
	my.bright = true;
	my.flare = true;
	my.beam = true;
	my.streak = true;
	my.alpha = 5;
	my.size = 10;
	my.lifespan = 50;
	my.function = NHAC_VBEFFECT_FADEOUT_SLOW;
}
/////////////////////////////////////////////////////
// Vertex-Based Effect, using the yellow particle bmap
function NHAC_VBEFFECT_YELLOW1()
{
	my.bmap = NHAC_CPARTICLE_YELLOW1;
	my.vel_x = random(1) - random(1);
	my.vel_y = random(1) - random(1);
	my.vel_z = random(2);
	my.move = true;
	my.bright = true;
	my.flare = true;
	my.beam = true;
	my.streak = true;
	my.alpha = 50;
	my.size = 4;
	my.lifespan = 50;
	my.function = NHAC_VBEFFECT_FADEOUT;
}
/////////////////////////////////////////////////////
// Vertex-Based Effect, using the blue particle bmap
function NHAC_VBEFFECT_BLUE1()
{
	my.bmap = NHAC_CPARTICLE_BLUE1;
	my.bright = true;
	my.flare = true;
	my.beam = true;
	my.streak = true;
	my.alpha = 2;
	my.size = 6;
	my.lifespan = 50;
	my.function = NHAC_VBEFFECT_FADEOUT_SLOW;
}
/////////////////////////////////////////////////////
// Vertex-Based Effect, using the blue particle bmap
function NHAC_VBEFFECT_BLUE2()
{
	my.bmap = NHAC_CPARTICLE_BLUE1;
	my.bright = true;
	my.flare = true;
	my.beam = true;
	my.streak = true;
	my.alpha = 6;
	my.size = 6;
	my.lifespan = 50;
	my.function = NHAC_VBEFFECT_FADEOUT_SLOW;
}
/////////////////////////////////////////////////////