/////////////////////////////////////////////////////
// RPG/Adv. Temp 2.0
// Default spell functions
//
// (C) 2006 by Claus N.
// www.nighthawk.dk
//
// -- UPDATES --
//	July 11th 2006:
// Upgraded from A6.31.4 to A6.40.5
// 	- Changed "remove me;" to "ent_remove(me);"
// 
// July 13th 2006:
// -Only 25% of the defense is subtracted from spell damage, when hit
// -Fixed spell event-- Now player also gets exp. when killing with a spell
/////////////////////////////////////////////////////
// If we are using this file, don't include it twice
define USE_SUBCORE_SPELLFUNCS;
/////////////////////////////////////////////////////
// We need the Defines "sub-core"
ifndef USE_SUBCORE_DEFINES;
	include <NHASC_defines.wdl>;
endif;
/////////////////////////////////////////////////////
// Models used in the spells
string NHAC_CMODEL_SPELLBALL = <kugle.mdl>;
/////////////////////////////////////////////////////
// Function prototypes
function NHAC_healthball_drain();
function NHAC_spellball_fly();
function NHAC_spellball_event();
/////////////////////////////////////////////////////
// Fireball spell
// Entry1: Damage
// Entry2: Speed
// Entry3: Scale (x/y/z)
function NHAC_fireball(spellNum)
{
	// compute the position
	temp.x = my.x + fcos(my.pan,20);
	temp.y = my.y + fsin(my.pan,20);
	temp.z = my.z;
	
	// Create the ball
	you = ent_create(NHAC_CMODEL_SPELLBALL,temp,NHAC_spellball_fly);
	
	// Should always be true, but checking is safest
	if(you)
	{
		you.particle_func = handle(NHAC_VBEFFECT_YELLOW1);	// Fire particle effect
		you.spellType = spellNum;									// Spell type
		you.pan = my.pan;												// Set pan angle
		you.scale_x = NHASC_CSPELL_SKILL3[spellNum];			// Scaling
		you.scale_y = NHASC_CSPELL_SKILL3[spellNum];
		you.scale_z	= NHASC_CSPELL_SKILL3[spellNum];
		you.invisible = true;										// Invisible
		you.enemy = handle(my);										// Not an 'enemy' of the spell.. Just to store the caster
		
		// Spell initialized, let's go!
		you.run = true;
	}
}
/////////////////////////////////////////////////////
// Iceball spell
// Entry1: Damage
// Entry2: Speed
// Entry3: Scale (x/y/z)
function NHAC_iceball(spellNum)
{
	// compute the position
	temp.x = my.x + fcos(my.pan,20);
	temp.y = my.y + fsin(my.pan,20);
	temp.z = my.z;
	
	// Create the ball
	you = ent_create(NHAC_CMODEL_SPELLBALL,temp,NHAC_spellball_fly);
	
	// Should always be true, but checking is safest
	if(you)
	{
		you.particle_func = handle(NHAC_VBEFFECT_BLUE1);	// Ice particle effect
		you.spellType = spellNum;									// Spell type
		you.pan = my.pan;												// Set pan angle
		you.scale_x = NHASC_CSPELL_SKILL3[spellNum];			// Scaling
		you.scale_y = NHASC_CSPELL_SKILL3[spellNum];
		you.scale_z	= NHASC_CSPELL_SKILL3[spellNum];
		you.invisible = true;										// Invisible
		you.enemy = handle(my);										// Not an 'enemy' of the spell.. Just to store the caster
		
		// Spell initialized, let's go!
		you.run = true;
	}
}
/////////////////////////////////////////////////////
// Lightning ball spell
// Entry1: Damage
// Entry2: Speed
// Entry3: Scale (x/y/z)
function NHAC_lightningballspell(spellNum)
{
	// compute the position
	temp.x = my.x + fcos(my.pan,20);
	temp.y = my.y + fsin(my.pan,20);
	temp.z = my.z;
	
	// Create the ball
	you = ent_create(NHAC_CMODEL_SPELLBALL,temp,NHAC_spellball_fly);
	
	// Should always be true, but checking is safest
	if(you)
	{
		you.particle_func = handle(NHAC_VBEFFECT_WHITE1);	// Lightning particle effect
		you.spellType = spellNum;									// Spell type
		you.pan = my.pan;												// Set pan angle
		you.scale_x = NHASC_CSPELL_SKILL3[spellNum];			// Scaling
		you.scale_y = NHASC_CSPELL_SKILL3[spellNum];
		you.scale_z	= NHASC_CSPELL_SKILL3[spellNum];
		you.invisible = true;										// Invisible
		you.enemy = handle(my);										// Not an 'enemy' of the spell.. Just to store the caster
		
		// Spell initialized, let's go!
		you.run = true;
	}
}
/////////////////////////////////////////////////////
// Charged bolts spell (3 lightning balls)
// Entry1: Damage
// Entry2: Speed
// Entry3: Scale (x/y/z)
function NHAC_chargedboltsspell(spellNum)
{
	var i = 3;
	while(i > 0)
	{
		// compute the position
		temp.x = my.x + fcos(my.pan + ((i - 2) * 60),20);
		temp.y = my.y + fsin(my.pan + ((i - 2) * 60),20);
		temp.z = my.z;
		
		// Create the ball
		you = ent_create(NHAC_CMODEL_SPELLBALL,temp,NHAC_spellball_fly);
		
		// Should always be true, but checking is safest
		if(you)
		{
			you.particle_func = handle(NHAC_VBEFFECT_WHITE1);	// Lightning particle effect
			you.spellType = spellNum;									// Spell type
			you.pan = my.pan + (i - 2) * 10;												// Set pan angle
			you.scale_x = NHASC_CSPELL_SKILL3[spellNum];			// Scaling
			you.scale_y = NHASC_CSPELL_SKILL3[spellNum];
			you.scale_z	= NHASC_CSPELL_SKILL3[spellNum];
			you.invisible = true;										// Invisible
			you.enemy = handle(my);										// Not an 'enemy' of the spell.. Just to store the caster
			
			// Spell initialized, let's go!
			you.run = true;
		}
		
		i -= 1;
	}
}
/////////////////////////////////////////////////////
// Lightning spell
// Entry1: Damage
// Entry2: Speed
// Entry3: Scale (x/y/z)
function NHAC_lightningspell(spellNum)
{
	// compute the position
	temp.x = my.x + fcos(my.pan,20);
	temp.y = my.y + fsin(my.pan,20);
	temp.z = my.z;
	
	// Create the ball
	you = ent_create(NHAC_CMODEL_SPELLBALL,temp,NHAC_spellball_fly);
	
	// Should always be true, but checking is safest
	if(you)
	{
		you.particle_func = handle(NHAC_VBEFFECT_WHITE2);	// Lightning particle effect
		you.spellType = spellNum;									// Spell type
		you.pan = my.pan;												// Set pan angle
		you.scale_x = NHASC_CSPELL_SKILL3[spellNum];			// Scaling
		you.scale_y = NHASC_CSPELL_SKILL3[spellNum];
		you.scale_z	= NHASC_CSPELL_SKILL3[spellNum];
		you.invisible = true;										// Invisible
		you.enemy = handle(my);										// Not an 'enemy' of the spell.. Just to store the caster
		
		// Spell initialized, let's go!
		you.run = true;
	}
}
/////////////////////////////////////////////////////
// Healing spell
// Entry1: Amount (of health)
// Entry2: Scale (x/y/z)
// Entry3: Not used
function NHAC_healingspell(spellNum)
{
	// Create a ball
	you = ent_create(NHAC_CMODEL_SPELLBALL,my.x,NHAC_healthball_drain);
	
	// Should always be true, but checking is safest
	if(you)
	{
		you.particle_func = handle(NHAC_VBEFFECT_RED1);		// Healing particle effect
		you.spellType = spellNum;									// Spell type
		you.scale_x = NHASC_CSPELL_SKILL2[spellNum];			// Scaling
		you.scale_y = NHASC_CSPELL_SKILL2[spellNum];
		you.scale_z	= NHASC_CSPELL_SKILL2[spellNum];
		you.invisible = true;										// Invisible
		
		// Spell initialized, let's go!
		you.run = true;
	}
}
/////////////////////////////////////////////////////
// Function attached to the healing spell ball
function NHAC_healthball_drain()
{
	// Make us passable
	my.passable = on;
	
	// Wait 3 frames for initialization
	wait(3);
	
	// If I'm not initialized yet, you'd been too slow :p
	if(my.run == false) {wait(1);ent_remove(me);return;}
	
	// local var
	var percentage = 0;
	
	// While we aren't healed 100% of the amount
	while(percentage < 100)
	{
		// Make me smaller
		vec_scale(my.scale_x,0.95);
		
		my.scale_x = max(my.scale_x,1);
		my.scale_y = max(my.scale_y,1);
		my.scale_z = max(my.scale_z,1);
		
		// Healing particle effect
		NHAC_VBEFFECT_ATTACH(my.particle_func,my);
		
		// Rotate me
		my.pan += 15 * time;
		my.tilt += 10 * time;
		my.roll += 5 * time;
		
		// If the "you" ent exists
		if(you)
		{
			// If you are the player
			if(you == player)
			{
				// Heal player
				you.health = min((you.max_health + NHAC_ITM_GET_HLT()),you.health + (NHASC_CSPELL_SKILL1[my.spellType] * 0.05 * time));
			}
			else
			{
				// Heal you
				you.health = min(you.max_health,you.health + (NHASC_CSPELL_SKILL1[my.spellType] * 0.05 * time));
			}
			
			// Set me at your pos
			vec_set(my.x,you.x);
		}
		
		// loop
		percentage += 5 * time;
		
		wait(1);
	}
}
/////////////////////////////////////////////////////
// Function attached to a 'spellball'
function NHAC_spellball_fly()
{
	// Can't be touched by the mouse
	my.untouchable = true;
	
	// Wait 3 frames for initialization
	wait(3);
	
	// If I'm not initialized yet, you'd been too slow :p
	if(my.run == false) {wait(1);ent_remove(me);return;}
	
	// Set the event and event types
	my.enable_block = true;
	my.enable_entity = true;
	my.event = NHAC_spellball_event;
	
	// Use an unused skill for "life-time"
	my.skill70 = 100;
	
	// Main loop
	while(my.run)
	{
		// Decrease "life time"
		my.skill70 -= 1 * time;
		
		// If our time has run out, remove me
		if(my.skill70 <= 0) {my.run = false;}
		
		// Attach particles
		NHAC_VBEFFECT_ATTACH(my.particle_func,my);
		
		// Move it
		c_move(my,vector(NHASC_CSPELL_SKILL2[my.spellType] * time,0,0),nullvector,ignore_passable + ignore_you + ignore_me);
		
		// Avoid endless loops
		wait(1);
	}
	
	// Particle effect 'on hit'
	vec_scale(my.scale_x,2);
	NHAC_VBEFFECT_ATTACH(my.particle_func,my);
	
	// Remove the entity
	wait(5);
	ent_remove(me);
}
/////////////////////////////////////////////////////
// Spellball event
function NHAC_spellball_event()
{
	// Did we hit the level geometry?
	if(event_type == event_block)
	{
		// Only trigger the event once
		my.event = null;
		
		// Then remove me...
		my.run = false;
	}
	
	// Or did we hit an entity?
	if(event_type == event_entity)
	{
		// Only trigger the event once
		my.event = null;
		
		// Ensure the pointer is valid
		if(you)
		{
			// Decrease your health!
			// Note: A high defense can make you immune
			you.health -= max(NHASC_CSPELL_SKILL1[my.spellType] - (you.defense*0.25),0);
			
			// If the player exists
			if(player)
			{
				// If player is the caster, you're death, you have been alive and we are not on the same team
				if(handle(player) == my.enemy && you.health <= 0 && you.max_health && you.team != player.team)
				{
					// Give exp points
					NHAC_plExp += max(1,(you.max_health * you.damage * you.defense)*0.5) / NHAC_plExpDivider;
				}
			}
		}
		
		// And tell me, to remove me..
		my.run = false;
	}
}
/////////////////////////////////////////////////////