/////////////////////////////////////////////////////
// Nighthawk Arts RPG/Adventure Templates 2
//
// The second RPG/Adventure templates from NHA.
// (C) 2006 by Claus N.
// Site: www.nighthawk.dk
/////////////////////////////////////////////////////
// Local Project Pathes
path "scripts";
path "models";
path "graphics";
path "media";
// Path to the NHA RPG/Adv. temp 2.0
path "%WEDPATH%\\RPGTemp2_0";
/////////////////////////////////////////////////////
// Variables
var video_mode = 7;		// 800x600 resolution
var video_depth = 32;	// 32 bit colors

// Windowed mode if we are in development mode
// Fullscreen in published version
ifdef DEVELOP;
	var video_screen = 2;
ifelse;
	var video_screen = 1;
endif;

// Dialogue strings in english
// Check out NHASC_dialogueStrings.wdl
define language_english;

// Comment this line out, if you would disable MODs
define AllowMODs;
// If MODs are allowed
ifdef AllowMODs;
	// Then create a variable, that will be
	// set to true (1) when the MODs are ready
	// to be initialized (when the world is ready)
	var InitMODs = 0;
endif;
/////////////////////////////////////////////////////
// Strings
string level_str = <%NAME%.wmb>;	// The level's WMB file

/////////////////////////////////////////////////////
// Includes
include <NHAC_player.wdl>;			// Player module
include <NHAC_mouse.wdl>;			// Mouse module
include <NHAC_isocamera.wdl>;		// Isometric camera module
include <NHAC_miscmsg.wdl>;		// Misc. messaging functions
include <NHAC_inventory.wdl>;		// Inventory system
include <NHAC_basicspells.wdl>;	// Spell system
include <NHAC_basicHUD.wdl>;		// Head-Up Displays
include <NHAC_enemyAI.wdl>;		// Enemy AI script
include <NHAC_npcAI.wdl>;			// NPC AI script
include <NHAC_levelSystem.wdl>;	// Level system
include <NHAC_mainMenu.wdl>;		// Menu module
include <NHAC_splashScreen.wdl>;	// Splashscreen (required for some editions)
include <NHAC_miscActors.wdl>;	// Misc. actions

/////////////////////////////////////////////////////
// Include EnemyAI and NPCAI actions here (created
// with the NHA RPG Template Tool)
// Example:
// include <myEnemies.wdl>;

/////////////////////////////////////////////////////
// MODs ("non-core" includes):

/////////////////////////////////////////////////////
// The main function
function main()
{
	// Freeze the game
	freeze_mode = 1;
	
	// If we should display the splashscreen
	ifdef USE_CORE_SPLASH;
		// Display it
		NHAC_splash_show();
	endif;
	
	// Load the level
	level_load(level_str);
	
	// Wait for the level to be loaded
	wait(3);
	
	// Un-freeze the game
	freeze_mode = 0;
	
	// Set the background color to black
	bg_color.red = 1;
	bg_color.green = 1;
	bg_color.blue = 1;
	
	// Seed 'random' with random numbers
	randomize();
	
	// Initialize game (variables etc.)
	init_game();
	
	ifdef USE_CORE_INVENTORY;
		// DO NOT MODIFY THIS VARIABLE YOURSELF!!!
		// Used where USE_CORE_INVENTORY isn't enough
		NHAC_CVAR_USE_CINVENTORY = true;
	endif;
	
	// If the mouse module is included
	ifdef USE_CORE_MOUSEFUNC;
		// Use the mouse, and set the default mouse map
		setMouseOn(true);
	endif;
	
	// If the isometric camera module is included
	ifdef USE_CORE_ISOCAMERA;
		// Use the isometric camera
		NHAC_ISOC();
	endif;
	
	// If the sub-core file "NHASC_invitems" is included (included from the inventory module)
	ifdef USE_SUBCORE_INVITEMS;
		// Load the items.
		// NHAC_CITEMFILE can be found in NHASC_defines.wdl,
		// the default is items.ilf
		if(!NHAC_CITEMS_READ) {NHAC_CITEM_FROMFILE(NHAC_CITEMFILE);}
		
		// If the string handles isn't set yet, do it now
		if(CITEM_handlesInit != true) {NHASC_setStrHandles();}
		
		// Set handles for the strings containing the item models
		NHASC_CITMMODEL_INIT();
	endif;
	
	// If the spell module is included
	ifdef USE_CORE_BSPELLS;
		// Load the spells
		if(!NHAC_CSPELLS_LOADED) {NHASC_CSPELLS_LOAD();}
	endif;
	
	// HUD module
	ifdef USE_CORE_BASICHUD;
		// Show the HUD pan in the bottom of the screen
		NHAC_HUDPAN_SHOW();
		// DO NOT MODIFY THIS VARIABLE YOURSELF!!!
		// Used where USE_CORE_BASICHUD isn't enough
		NHAC_CVAR_USE_CHUD = true;
	endif;
	
	// NPC and dialogue module
	ifdef USE_CORE_NPCAI;
		// DO NOT MODIFY THIS VARIABLE YOURSELF!!!
		// Used where USE_CORE_NPCAI isn't enough
		NHAC_CVAR_USE_CDIA = true;
	endif;
	
	// Level System
	ifdef USE_CORE_LEVELSYS;
		// Activate level system
		NHAC_init_levelsys();
	endif;
	
	// Main Menu
	ifdef USE_CORE_MAINMENU;
		NHAC_init_mainMenu();
	endif;
	
	// Game initialized, so let's wait a sec. and hide the splash
	ifdef USE_CORE_SPLASH;
		sleep(1);
		NHAC_splash_hide();
	endif;
	
	// If we are allowed to use MODs
	ifdef AllowMods;
		// Initialize MODs
		InitMODs = 1;
	endif;
}
/////////////////////////////////////////////////////
function init_spells();
/////////////////////////////////////////////////////
// Game initialization. Called from main, and when
// you press "New Game" on the menu.
function init_game()
{
	// The defines subcore must have been included (most core files does that)
	ifdef USE_SUBCORE_DEFINES;
	
		// Camera
		NHAC_CMODE = CMODE_ISOC;				// Enable isometric camera
		NHAC_CFLAGS = CFLAG_BOTH;				// Zooming and rotating allowed
		
		// Inventory
		NHAC_MOUSEITEM = 0;						// Reset mouse item
		
		// Spells
		NHAC_CURSPELL = 0;						// No spell selected
		// Give spells here...
		
		// Player/AI
		NHAC_PLAYER_STANDSTILL = false;		// Player can move
		NHAC_PAUSEAI = false;					// Enable AIs
		NHAC_MOUSEENT_PTR = 0;					// Mouse isn't touching an entity
		
		// Level system
		NHAC_plExp = 0;							// Reset experience
		NHAC_plLevel = 1;							// Reset level
		NHAC_plStatPoints = 0;					// Reset statpoints
		
		// Reset msg_show string
		str_cpy(NHASC_MSGSHOW_STR,"");
		
	endif;
	
	// Functions from the inventory core
	ifdef USE_CORE_INVENTORY;
		NHAC_CINV_RESET();						// Reset inventory
	endif;
	
	// Functions from the spell core
	ifdef USE_CORE_BSPELLS;
		NHAC_CSPELL_RESET_ALL();				// Reset spells
	endif;
	
	// If we are using the level system
	ifdef USE_CORE_LEVELSYS;
		NHAC_charpan_close();					// Hide the character stat panel
	endif;
	
	init_spells();	// Initialize spells
}
/////////////////////////////////////////////////////
// Initialize spells
function init_spells()
{
	// Wait for the NSF file to be loaded
	while(!NHAC_CSPELLS_LOADED) {wait(1);}
	
	// Give start spells
	// Example:
	// NHAC_CSPELL_OWNED[spellFromName("Fire Bolt")] = 1;
}
/////////////////////////////////////////////////////
// Always include this below the core (NHAC) includes
include <NHAC_mcrits.wdl>;
/////////////////////////////////////////////////////